/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeProvider;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    private final NotificationAction ABORT_ACTION = NotificationAction.create((String)"Abort", (event, notification) -> {
        this.abort();
        notification.expire();
    });
    private final NotificationAction CONTINUE_ACTION = NotificationAction.create((String)"Continue", (event, notification) -> {
        this.retry("Continue Rebase Process...");
        notification.expire();
    });
    private final NotificationAction RETRY_ACTION = NotificationAction.create((String)"Retry", (event, notification) -> {
        this.retry("Retry Rebase Process...");
        notification.expire();
    });
    private final NotificationAction VIEW_STASH_ACTION = new NotificationAction("View Stash..."){

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            GitRebaseProcess.this.mySaver.showSavedChanges();
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitRebaseSpec myRebaseSpec;
    @Nullable
    private final GitRebaseResumeMode myCustomMode;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final ProgressManager myProgressManager;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public GitRebaseProcess(@NotNull Project project, @NotNull GitRebaseSpec rebaseSpec, @Nullable GitRebaseResumeMode customMode) {
        this.myProject = project;
        this.myRebaseSpec = rebaseSpec;
        this.myCustomMode = customMode;
        this.mySaver = rebaseSpec.getSaver();
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myProgressManager = ProgressManager.getInstance();
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
    }

    public void rebase() {
        new GitFreezingProcess(this.myProject, "rebase", this::doRebase).execute();
    }

    private void doRebase() {
        LOG.info("Started rebase");
        LOG.debug("Started rebase with the following spec: " + this.myRebaseSpec);
        LinkedHashMap statuses = ContainerUtil.newLinkedHashMap(this.myRebaseSpec.getStatuses());
        List<GitRepository> repositoriesToRebase = this.myRepositoryManager.sortByDependency(this.myRebaseSpec.getIncompleteRepositories());
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"Rebase");){
            GitRebaseStatus.Type latestStatus;
            if (!this.saveDirtyRootsInitially(repositoriesToRebase)) {
                return;
            }
            GitRepository latestRepository = null;
            for (GitRepository repository : repositoriesToRebase) {
                GitRebaseResumeMode customMode = null;
                if (repository == this.myRebaseSpec.getOngoingRebase()) {
                    customMode = this.myCustomMode == null ? GitRebaseResumeMode.CONTINUE : this.myCustomMode;
                }
                Collection<Change> changes = this.collectFutureChanges(repository);
                GitRebaseStatus rebaseStatus = this.rebaseSingleRoot(repository, customMode, GitRebaseProcess.getSuccessfulRepositories(statuses));
                repository.update();
                if (customMode == GitRebaseResumeMode.CONTINUE) {
                    this.myDirtyScopeManager.dirDirtyRecursively(repository.getRoot());
                }
                latestRepository = repository;
                statuses.put(repository, rebaseStatus);
                if (GitRebaseProcess.shouldBeRefreshed(rebaseStatus)) {
                    GitUtil.refreshVfs(repository.getRoot(), changes);
                }
                if (rebaseStatus.getType() == GitRebaseStatus.Type.SUCCESS) continue;
                break;
            }
            if ((latestStatus = ((GitRebaseStatus)statuses.get(latestRepository)).getType()) == GitRebaseStatus.Type.SUCCESS || latestStatus == GitRebaseStatus.Type.NOT_STARTED) {
                LOG.debug("Rebase completed successfully.");
                this.mySaver.load();
            }
            if (latestStatus == GitRebaseStatus.Type.SUCCESS) {
                this.notifySuccess(GitRebaseProcess.getSuccessfulRepositories(statuses), GitRebaseProcess.getSkippedCommits(statuses));
            }
            this.saveUpdatedSpec(statuses);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
        }
    }

    @Nullable
    private Collection<Change> collectFutureChanges(@NotNull GitRepository repository) {
        String rev2;
        String rev1;
        Collection<Change> changesFromRebase;
        GitRebaseParams params = this.myRebaseSpec.getParams();
        if (params == null) {
            return null;
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        String branch = params.getBranch();
        if (branch != null) {
            Collection<Change> changesFromCheckout = GitChangeUtils.getDiff(repository, "HEAD", branch, false);
            if (changesFromCheckout == null) {
                return null;
            }
            changes.addAll(changesFromCheckout);
        }
        if ((changesFromRebase = GitChangeUtils.getDiff(repository, rev1 = (String)ObjectUtils.coalesce((Object)params.getNewBase(), (Object)branch, (Object)"HEAD"), rev2 = params.getUpstream(), false)) == null) {
            return null;
        }
        changes.addAll(changesFromRebase);
        return changes;
    }

    private void saveUpdatedSpec(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (this.myRebaseSpec.shouldBeSaved()) {
            GitRebaseSpec newRebaseInfo = this.myRebaseSpec.cloneWithNewStatuses(statuses);
            this.myRepositoryManager.setOngoingRebaseSpec(newRebaseInfo);
        } else {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
        }
    }

    @NotNull
    private GitRebaseStatus rebaseSingleRoot(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode customMode, @NotNull Map<GitRepository, GitSuccessfulRebase> alreadyRebased) {
        GitRebaseStatus.Type type;
        boolean somethingRebased;
        GitCommandResult result2;
        MultiMap<GitRepository, GitRebaseUtils.CommitInfo> allSkippedCommits;
        ArrayList skippedCommits;
        String repoName;
        block11: {
            ResolveConflictResult resolveResult;
            VirtualFile root = repository.getRoot();
            repoName = DvcsUtil.getShortRepositoryName((Repository)repository);
            LOG.info("Rebasing root " + repoName + ", mode: " + ObjectUtils.notNull((Object)((Object)customMode), (Object)"standard"));
            skippedCommits = ContainerUtilRt.newArrayList();
            allSkippedCommits = GitRebaseProcess.getSkippedCommits(alreadyRebased);
            boolean retryWhenDirty = false;
            while (true) {
                GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitRebaseProgressListener progressListener = new GitRebaseProgressListener();
                GitRebaseCommandResult rebaseCommandResult = this.callRebase(repository, customMode, rebaseDetector, untrackedDetector, progressListener);
                result2 = rebaseCommandResult.getCommandResult();
                boolean bl = somethingRebased = customMode != null || progressListener.currentCommit > 1;
                if (rebaseCommandResult.wasCancelledInCommitList()) {
                    return GitRebaseStatus.notStarted();
                }
                if (rebaseCommandResult.wasCancelledInCommitMessage()) {
                    this.showStoppedForEditingMessage();
                    return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
                }
                if (result2.success()) {
                    if (rebaseDetector.hasStoppedForEditing()) {
                        this.showStoppedForEditingMessage();
                        return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
                    }
                    LOG.debug("Successfully rebased " + repoName);
                    return GitSuccessfulRebase.parseFromOutput(result2.getOutput(), skippedCommits);
                }
                if (rebaseDetector.isDirtyTree() && customMode == null && !retryWhenDirty) {
                    LOG.debug("Dirty tree detected in " + repoName);
                    String saveError = this.saveLocalChanges(Collections.singleton(repository.getRoot()));
                    if (saveError == null) {
                        retryWhenDirty = true;
                        continue;
                    }
                    LOG.warn("Couldn't " + this.mySaver.getOperationName() + " root " + repository.getRoot() + ": " + saveError);
                    this.showFatalError(saveError, repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    GitRebaseStatus.Type type2 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    return new GitRebaseStatus(type2, skippedCommits);
                }
                if (untrackedDetector.wasMessageDetected()) {
                    LOG.info("Untracked files detected in " + repoName);
                    this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    return new GitRebaseStatus(type, skippedCommits);
                }
                if (rebaseDetector.isNoChangeError()) {
                    LOG.info("'No changes' situation detected in " + repoName);
                    GitRebaseUtils.CommitInfo currentRebaseCommit = GitRebaseUtils.getCurrentRebaseCommit(this.myProject, root);
                    if (currentRebaseCommit != null) {
                        skippedCommits.add(currentRebaseCommit);
                    }
                    customMode = GitRebaseResumeMode.SKIP;
                    continue;
                }
                if (!rebaseDetector.isMergeConflict()) break block11;
                LOG.info("Merge conflict in " + repoName);
                resolveResult = this.showConflictResolver(repository, false);
                if (resolveResult != ResolveConflictResult.ALL_RESOLVED) break;
                customMode = GitRebaseResumeMode.CONTINUE;
            }
            if (resolveResult == ResolveConflictResult.NOTHING_TO_MERGE) {
                LOG.info("Unmerged changes while rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
                this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                GitRebaseStatus.Type type3 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                return new GitRebaseStatus(type3, skippedCommits);
            }
            this.notifyNotAllConflictsResolved(repository, allSkippedCommits);
            return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
        }
        LOG.info("Error rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
        this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
        type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
        return new GitRebaseStatus(type, skippedCommits);
    }

    @NotNull
    private GitRebaseCommandResult callRebase(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode mode, GitLineHandlerListener ... listeners) {
        if (mode == null) {
            GitRebaseParams params = (GitRebaseParams)ObjectUtils.assertNotNull((Object)this.myRebaseSpec.getParams());
            return this.myGit.rebase(repository, params, listeners);
        }
        if (mode == GitRebaseResumeMode.SKIP) {
            return this.myGit.rebaseSkip(repository, listeners);
        }
        LOG.assertTrue(mode == GitRebaseResumeMode.CONTINUE, (Object)("Unexpected rebase mode: " + (Object)((Object)mode)));
        return this.myGit.rebaseContinue(repository, listeners);
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories) {
        return this.findRootsWithLocalChanges(repositories);
    }

    private static boolean shouldBeRefreshed(@NotNull GitRebaseStatus rebaseStatus) {
        return rebaseStatus.getType() != GitRebaseStatus.Type.SUCCESS || ((GitSuccessfulRebase)rebaseStatus).getSuccessType() != GitSuccessfulRebase.SuccessType.UP_TO_DATE;
    }

    private boolean saveDirtyRootsInitially(@NotNull List<GitRepository> repositories) {
        List repositoriesToSave = ContainerUtil.filter(repositories, repository -> !repository.equals(this.myRebaseSpec.getOngoingRebase()));
        if (repositoriesToSave.isEmpty()) {
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositoriesToSave));
        String error = this.saveLocalChanges(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError("Rebase Not Started", error);
            return false;
        }
        return true;
    }

    @Nullable
    private String saveLocalChanges(@NotNull Collection<VirtualFile> rootsToSave) {
        try {
            this.mySaver.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return "Couldn't " + this.mySaver.getSaverName() + " local uncommitted changes:<br/>" + e.getMessage();
        }
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories) {
        return ContainerUtil.filter(repositories, repository -> this.myChangeListManager.haveChangesUnder(repository.getRoot()) != ThreeState.NO);
    }

    protected void notifySuccess(@NotNull Map<GitRepository, GitSuccessfulRebase> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        String baseBranch;
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myRebaseSpec.getAllRepositories());
        List successTypes = ContainerUtil.map(successful.values(), GitSuccessfulRebase::getSuccessType);
        GitSuccessfulRebase.SuccessType commonType = GitRebaseProcess.getItemIfAllTheSame(successTypes, GitSuccessfulRebase.SuccessType.REBASED);
        GitRebaseParams params = this.myRebaseSpec.getParams();
        String string = baseBranch = params == null ? null : (String)ObjectUtils.notNull((Object)params.getNewBase(), (Object)params.getUpstream());
        if ("HEAD".equals(baseBranch)) {
            baseBranch = GitRebaseProcess.getItemIfAllTheSame(this.myRebaseSpec.getInitialBranchNames().values(), baseBranch);
        }
        String message = commonType.formatMessage(rebasedBranch, baseBranch, params != null && params.getBranch() != null);
        message = message + GitRebaseProcess.mentionSkippedCommits(skippedCommits);
        this.myNotifier.notifyMinorInfo("Rebase Successful", message, (NotificationListener)new RebaseNotificationListener(skippedCommits));
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<GitRepository> repositories) {
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories, Repository::getCurrentBranchName), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<T> collection, @Nullable T defaultItem) {
        return (T)(ContainerUtil.newHashSet(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        String description = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("Rebase Stopped Due to Conflicts", description, NotificationType.WARNING, (NotificationListener)new RebaseNotificationListener(skippedCommits));
        notification.addAction((AnAction)new ResolveAction(conflictingRepository));
        notification.addAction((AnAction)this.CONTINUE_ACTION);
        notification.addAction((AnAction)this.ABORT_ACTION);
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    @NotNull
    private ResolveConflictResult showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setMergeDialogCustomizer(new GitRebaseMergeDialogCustomizer(conflicting, this.myRebaseSpec)).setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, this.myGit, conflicting, params, calledFromNotification);
        boolean allResolved = conflictResolver.merge();
        if (conflictResolver.myWasNothingToMerge) {
            return ResolveConflictResult.NOTHING_TO_MERGE;
        }
        if (allResolved) {
            return ResolveConflictResult.ALL_RESOLVED;
        }
        return ResolveConflictResult.UNRESOLVED_REMAIN;
    }

    private void showStoppedForEditingMessage() {
        String description = "";
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("Rebase Stopped for Editing", description, NotificationType.INFORMATION, (NotificationListener)new RebaseNotificationListener((MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)MultiMap.empty()));
        notification.addAction((AnAction)this.CONTINUE_ACTION);
        notification.addAction((AnAction)this.ABORT_ACTION);
        this.myNotifier.notify(notification);
    }

    private void showFatalError(@NotNull String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        String repo = this.myRepositoryManager.moreThanOneRoot() ? DvcsUtil.getShortRepositoryName((Repository)currentRepository) + ": " : "";
        String description = repo + error + "<br/>" + GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        String title = this.myRebaseSpec.getOngoingRebase() == null ? "Rebase Failed" : "Continue Rebase Failed";
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, description, NotificationType.ERROR, (NotificationListener)new RebaseNotificationListener(skippedCommits));
        notification.addAction((AnAction)this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            notification.addAction((AnAction)this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        String message = GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        ArrayList<NotificationAction> actions = new ArrayList<NotificationAction>();
        actions.add(this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            actions.add(this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            actions.add(this.VIEW_STASH_ACTION);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, "rebase", message, (NotificationListener)new RebaseNotificationListener(skippedCommits), actions.toArray(new NotificationAction[0]));
    }

    @NotNull
    private static String mentionSkippedCommits(@NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (skippedCommits.isEmpty()) {
            return "";
        }
        String message = "<br/>";
        message = skippedCommits.values().size() == 1 ? message + "The following commit was skipped during rebase:<br/>" : message + "The following commits were skipped during rebase:<br/>";
        message = message + StringUtil.join((Collection)skippedCommits.values(), commitInfo -> {
            String commitMessage = StringUtil.shortenPathWithEllipsis((String)commitInfo.subject, (int)72, (boolean)true);
            String hash = commitInfo.revision.asString();
            String shortHash = DvcsUtil.getShortHash((String)commitInfo.revision.asString());
            return String.format("<a href='%s'>%s</a> %s", hash, shortHash, commitMessage);
        }, (String)"<br/>");
        return message;
    }

    @NotNull
    private static MultiMap<GitRepository, GitRebaseUtils.CommitInfo> getSkippedCommits(@NotNull Map<GitRepository, ? extends GitRebaseStatus> statuses) {
        MultiMap map2 = MultiMap.create();
        for (GitRepository repository : statuses.keySet()) {
            map2.put((Object)repository, statuses.get(repository).getSkippedCommits());
        }
        return map2;
    }

    @NotNull
    private static Map<GitRepository, GitSuccessfulRebase> getSuccessfulRepositories(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        LinkedHashMap map2 = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : statuses.keySet()) {
            GitRebaseStatus status = statuses.get(repository);
            if (!(status instanceof GitSuccessfulRebase)) continue;
            map2.put(repository, (GitSuccessfulRebase)status);
        }
        return map2;
    }

    private void abort() {
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, "Aborting Rebase Process..."){

            public void run(@NotNull ProgressIndicator indicator) {
                GitRebaseUtils.abort(this.myProject, indicator);
            }
        });
    }

    private void retry(@NotNull String processTitle) {
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, processTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                GitRebaseUtils.continueRebase(this.myProject);
            }
        });
    }

    private void handlePossibleCommitLinks(@NotNull String href, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        GitRepository repository = GitRebaseProcess.findRootBySkippedCommit(href, skippedCommits);
        if (repository != null) {
            GitUtil.showSubmittedFiles(this.myProject, href, repository.getRoot(), true, false);
        }
    }

    @Nullable
    private static GitRepository findRootBySkippedCommit(@NotNull String hash, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        return (GitRepository)ContainerUtil.find((Iterable)skippedCommits.keySet(), repository -> ContainerUtil.exists((Iterable)skippedCommits.get(repository), info -> info.revision.asString().equals(hash)));
    }

    private static class GitRebaseProgressListener
    implements GitLineHandlerListener {
        private static final Pattern PROGRESS = Pattern.compile("^Rebasing \\((\\d+)/(\\d+)\\)$");
        private int currentCommit;

        private GitRebaseProgressListener() {
        }

        @Override
        public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
            Matcher matcher = PROGRESS.matcher(line);
            if (matcher.matches()) {
                this.currentCommit = Integer.parseInt(matcher.group(1));
            }
        }
    }

    private class ResolveAction
    extends NotificationAction {
        @NotNull
        private final GitRepository myCurrentRepository;

        ResolveAction(GitRepository currentRepository) {
            super("Resolve...");
            this.myCurrentRepository = currentRepository;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            GitRebaseProcess.this.showConflictResolver(this.myCurrentRepository, true);
        }
    }

    private class RebaseNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final MultiMap<GitRepository, GitRebaseUtils.CommitInfo> mySkippedCommits;

        RebaseNotificationListener(MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
            this.mySkippedCommits = skippedCommits;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            GitRebaseProcess.this.handlePossibleCommitLinks(e.getDescription(), (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)this.mySkippedCommits);
        }
    }

    private static enum ResolveConflictResult {
        ALL_RESOLVED,
        NOTHING_TO_MERGE,
        UNRESOLVED_REMAIN;

    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;
        private boolean myWasNothingToMerge;

        RebaseConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, GitConflictResolver.Params params, boolean calledFromNotification) {
            super(project, git, Collections.singleton(repository.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        protected boolean proceedAfterAllMerged() {
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry("Continue Rebase Process...");
            }
            return true;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            this.myWasNothingToMerge = true;
            return true;
        }
    }

    private static class GitRebaseMergeDialogCustomizer
    extends MergeDialogCustomizer {
        @Nullable
        private String myRebasingBranch;
        @Nullable
        private String myBaseBranch;
        private boolean myOntoBranch;

        private GitRebaseMergeDialogCustomizer(@NotNull GitRepository repository, @NotNull GitRebaseSpec rebaseSpec) {
            GitRebaseParams rebaseParams = rebaseSpec.getParams();
            if (rebaseParams != null) {
                String branch;
                String currentBranchAtTheStartOfRebase = rebaseSpec.getInitialBranchNames().get(repository);
                String upstream = rebaseParams.getUpstream();
                if (upstream.equals("HEAD")) {
                    upstream = currentBranchAtTheStartOfRebase;
                }
                if ((branch = rebaseParams.getBranch()) == null) {
                    branch = currentBranchAtTheStartOfRebase;
                }
                this.myRebasingBranch = branch;
                this.myBaseBranch = upstream;
                boolean bl = this.myOntoBranch = !this.myBaseBranch.matches("[a-fA-F0-9]{40}");
                if (!this.myOntoBranch) {
                    this.myBaseBranch = VcsLogUtil.getShortHash((String)this.myBaseBranch);
                }
            }
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                return super.getMultipleFileMergeDescription(files);
            }
            return GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase(this.myRebasingBranch, this.myBaseBranch, this.myOntoBranch);
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                return super.getLeftPanelTitle(file);
            }
            return GitDefaultMergeDialogCustomizerKt.getDefaultLeftPanelTitleForBranch(this.myRebasingBranch);
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                return super.getRightPanelTitle(file, revisionNumber);
            }
            return GitDefaultMergeDialogCustomizerKt.getDefaultRightPanelTitleForBranch(this.myBaseBranch, revisionNumber, this.myOntoBranch);
        }

        @Nullable
        public List<String> getColumnNames() {
            if (this.myRebasingBranch == null || this.myBaseBranch == null) {
                return null;
            }
            return Arrays.asList(GitMergeProvider.calcColumnName(false, this.myRebasingBranch), GitMergeProvider.calcColumnName(true, this.myBaseBranch));
        }
    }
}

