/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.rebase.GitRebaseStatus;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseSpec {
    private static final Logger LOG = Logger.getInstance(GitRebaseSpec.class);
    @Nullable
    private final GitRebaseParams myParams;
    @NotNull
    private final Map<GitRepository, GitRebaseStatus> myStatuses;
    @NotNull
    private final Map<GitRepository, String> myInitialHeadPositions;
    @NotNull
    private final Map<GitRepository, String> myInitialBranchNames;
    @NotNull
    private final GitChangesSaver mySaver;
    private final boolean myShouldBeSaved;

    public GitRebaseSpec(@Nullable GitRebaseParams params, @NotNull Map<GitRepository, GitRebaseStatus> statuses, @NotNull Map<GitRepository, String> initialHeadPositions, @NotNull Map<GitRepository, String> initialBranchNames, @NotNull GitChangesSaver saver, boolean shouldBeSaved) {
        this.myParams = params;
        this.myStatuses = statuses;
        this.myInitialHeadPositions = initialHeadPositions;
        this.myInitialBranchNames = initialBranchNames;
        this.mySaver = saver;
        this.myShouldBeSaved = shouldBeSaved;
    }

    @NotNull
    public static GitRebaseSpec forNewRebase(@NotNull Project project, @NotNull GitRebaseParams params, @NotNull Collection<GitRepository> repositories, @NotNull ProgressIndicator indicator) {
        GitUtil.updateRepositories(repositories);
        Map<GitRepository, String> initialHeadPositions = GitRebaseSpec.findInitialHeadPositions(repositories, params.getBranch());
        Map<GitRepository, String> initialBranchNames = GitRebaseSpec.findInitialBranchNames(repositories);
        TreeMap<GitRepository, GitRebaseStatus> initialStatusMap = new TreeMap<GitRepository, GitRebaseStatus>(DvcsUtil.REPOSITORY_COMPARATOR);
        for (GitRepository repository : repositories) {
            initialStatusMap.put(repository, GitRebaseStatus.notStarted());
        }
        return new GitRebaseSpec(params, initialStatusMap, initialHeadPositions, initialBranchNames, GitRebaseSpec.newSaver(project, indicator), true);
    }

    @Nullable
    public static GitRebaseSpec forResumeInSingleRepository(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (!repository.isRebaseInProgress()) {
            return null;
        }
        GitRebaseStatus suspended = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, Collections.emptyList());
        return new GitRebaseSpec(null, Collections.singletonMap(repository, suspended), Collections.emptyMap(), Collections.emptyMap(), GitRebaseSpec.newSaver(project, indicator), false);
    }

    public boolean isValid() {
        return this.singleOngoingRebase() && this.rebaseStatusesMatch();
    }

    @NotNull
    public GitChangesSaver getSaver() {
        return this.mySaver;
    }

    @NotNull
    public Collection<GitRepository> getAllRepositories() {
        return this.myStatuses.keySet();
    }

    @Nullable
    public GitRepository getOngoingRebase() {
        return (GitRepository)ContainerUtil.getFirstItem(this.getOngoingRebases());
    }

    @Nullable
    public GitRebaseParams getParams() {
        return this.myParams;
    }

    @NotNull
    public Map<GitRepository, GitRebaseStatus> getStatuses() {
        return Collections.unmodifiableMap(this.myStatuses);
    }

    @NotNull
    public Map<GitRepository, String> getHeadPositionsToRollback() {
        return ContainerUtil.filter(this.myInitialHeadPositions, repository -> this.myStatuses.get(repository).getType() == GitRebaseStatus.Type.SUCCESS);
    }

    @NotNull
    public Map<GitRepository, String> getInitialBranchNames() {
        return this.myInitialBranchNames;
    }

    @NotNull
    public GitRebaseSpec cloneWithNewStatuses(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        return new GitRebaseSpec(this.myParams, statuses, this.myInitialHeadPositions, this.myInitialBranchNames, this.mySaver, true);
    }

    public boolean shouldBeSaved() {
        return this.myShouldBeSaved;
    }

    @NotNull
    public List<GitRepository> getIncompleteRepositories() {
        ArrayList incompleteRepositories = ContainerUtil.newArrayList();
        GitRepository ongoingRebase = this.getOngoingRebase();
        if (ongoingRebase != null) {
            incompleteRepositories.add(ongoingRebase);
        }
        incompleteRepositories.addAll(DvcsUtil.sortRepositories((Collection)ContainerUtil.filter(this.myStatuses.keySet(), repository -> !repository.equals(ongoingRebase) && this.myStatuses.get(repository).getType() != GitRebaseStatus.Type.SUCCESS)));
        return incompleteRepositories;
    }

    @NotNull
    private static GitStashChangesSaver newSaver(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Git git = Git.getInstance();
        return new GitStashChangesSaver(project, git, indicator, VcsBundle.message((String)"stash.changes.message", (Object[])new Object[]{"rebase"}));
    }

    @NotNull
    private static Map<GitRepository, String> findInitialHeadPositions(@NotNull Collection<GitRepository> repositories, @Nullable String branchToCheckout) {
        return ContainerUtil.map2Map(repositories, repository -> {
            String currentRevision = GitRebaseSpec.findCurrentRevision(repository, branchToCheckout);
            LOG.debug("Current revision in [" + repository.getRoot().getName() + "] is [" + currentRevision + "]");
            return Pair.create((Object)repository, (Object)currentRevision);
        });
    }

    @Nullable
    private static String findCurrentRevision(@NotNull GitRepository repository, @Nullable String branchToCheckout) {
        if (branchToCheckout != null) {
            GitLocalBranch branch = repository.getBranches().findLocalBranch(branchToCheckout);
            if (branch != null) {
                Hash hash = repository.getBranches().getHash(branch);
                if (hash != null) {
                    return hash.asString();
                }
                LOG.warn("The hash for branch [" + branchToCheckout + "] is not known!");
            } else {
                LOG.warn("The branch [" + branchToCheckout + "] is not known!");
            }
        }
        return repository.getCurrentRevision();
    }

    @NotNull
    private static Map<GitRepository, String> findInitialBranchNames(@NotNull Collection<GitRepository> repositories) {
        return ContainerUtil.map2Map(repositories, repository -> {
            String currentBranchName = repository.getCurrentBranchName();
            LOG.debug("Current branch in [" + repository.getRoot().getName() + "] is [" + currentBranchName + "]");
            return Pair.create((Object)repository, (Object)currentBranchName);
        });
    }

    @NotNull
    private Collection<GitRepository> getOngoingRebases() {
        return ContainerUtil.filter(this.myStatuses.keySet(), repository -> this.myStatuses.get(repository).getType() == GitRebaseStatus.Type.SUSPENDED);
    }

    private boolean singleOngoingRebase() {
        Collection<GitRepository> ongoingRebases = this.getOngoingRebases();
        if (ongoingRebases.size() > 1) {
            LOG.warn("Invalid rebase spec: rebase is in progress in " + DvcsUtil.getShortNames(ongoingRebases));
            return false;
        }
        return true;
    }

    private boolean rebaseStatusesMatch() {
        for (GitRepository repository : this.myStatuses.keySet()) {
            GitRebaseStatus.Type savedStatus = this.myStatuses.get(repository).getType();
            if (repository.isRebaseInProgress() && savedStatus != GitRebaseStatus.Type.SUSPENDED) {
                LOG.warn("Invalid rebase spec: rebase is in progress in " + DvcsUtil.getShortRepositoryName((Repository)repository) + ", but it is saved as " + (Object)((Object)savedStatus));
                return false;
            }
            if (repository.isRebaseInProgress() || savedStatus != GitRebaseStatus.Type.SUSPENDED) continue;
            LOG.warn("Invalid rebase spec: rebase is not in progress in " + DvcsUtil.getShortRepositoryName((Repository)repository));
            return false;
        }
        return true;
    }

    public String toString() {
        String initialHeadPositions = StringUtil.join(this.myInitialHeadPositions.keySet(), repository -> DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + this.myInitialHeadPositions.get(repository), (String)", ");
        String statuses = StringUtil.join(this.myStatuses.keySet(), repository -> DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + this.myStatuses.get(repository), (String)", ");
        return String.format("{Params: [%s].\nInitial positions: %s.\nStatuses: %s.\nSaver: %s}", this.myParams, initialHeadPositions, statuses, this.mySaver);
    }
}

