/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitProtectedBranchesKt;
import git4idea.branch.GitRebaseParams;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogUtil;
import git4idea.rebase.GitAutomaticRebaseEditor;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitRewordOperation;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0002*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0019J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\b\u0010!\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\r\u0010'\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020\u0019H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lgit4idea/rebase/GitRewordOperation;", "", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "newMessage", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "headAfterReword", "initialHeadPosition", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "rewordedCommit", "Lcom/intellij/vcs/log/Hash;", "canRewordViaAmend", "", "checkUndoPossibility", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "doUndo", "", "execute", "findNewHashOfRewordedCommit", "newHead", "injectRewordAction", "", "Lgit4idea/rebase/GitRebaseEntry;", "list", "isLatestCommit", "notifySuccess", "rewordViaAmend", "rewordViaRebase", "supplyNewMessage", "editorText", "undo", "undo$intellij_vcs_git", "undoInBackground", "RewordProcess", "UndoPossibility", "intellij.vcs.git"})
public final class GitRewordOperation {
    private final Logger LOG;
    private final Project project;
    private final VcsNotifier notifier;
    private final String initialHeadPosition;
    private String headAfterReword;
    private Hash rewordedCommit;
    private final GitRepository repository;
    private final VcsCommitMetadata commit;
    private final String newMessage;

    public final void execute() {
        boolean reworded = false;
        if (this.canRewordViaAmend()) {
            reworded = this.rewordViaAmend();
        }
        if (!reworded) {
            reworded = this.rewordViaRebase();
        }
        if (reworded) {
            String string = this.headAfterReword = this.repository.getCurrentRevision();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.rewordedCommit = this.findNewHashOfRewordedCommit(string);
            this.notifySuccess();
            ChangeListManagerImpl.getInstanceImpl((Project)this.project).replaceCommitMessage(this.commit.getFullMessage(), this.newMessage);
        }
    }

    private final boolean canRewordViaAmend() {
        return this.isLatestCommit() && GitVersionSpecialty.CAN_AMEND_WITHOUT_FILES.existsIn(this.project);
    }

    private final boolean isLatestCommit() {
        return Intrinsics.areEqual((Object)((Hash)this.commit.getId()).asString(), (Object)this.initialHeadPosition);
    }

    private final boolean rewordViaRebase() {
        GitAutomaticRebaseEditor rebaseEditor2 = new GitAutomaticRebaseEditor(this.project, this.commit.getRoot(), (Function1<? super List<GitRebaseEntry>, ? extends List<GitRebaseEntry>>)((Function1)new Function1<List<? extends GitRebaseEntry>, List<? extends GitRebaseEntry>>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final List<GitRebaseEntry> invoke(@NotNull List<GitRebaseEntry> list) {
                return GitRewordOperation.access$injectRewordAction(this.this$0, list);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final String invoke(@NotNull String editorText) {
                return GitRewordOperation.access$supplyNewMessage(this.this$0, editorText);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }));
        GitRebaseParams params = GitRebaseParams.editCommits(this.repository.getVcs().getVersion(), ((Hash)CollectionsKt.first((List)this.commit.getParents())).asString(), rebaseEditor2, true);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        GitRebaseSpec spec = GitRebaseSpec.forNewRebase(this.project, params, CollectionsKt.listOf((Object)this.repository), indicator);
        RewordProcess rewordProcess = new RewordProcess(spec);
        rewordProcess.rebase();
        return rewordProcess.getSucceeded();
    }

    private final boolean rewordViaAmend() {
        GitLineHandler handler = new GitLineHandler(this.project, this.repository.getRoot(), GitCommand.COMMIT);
        File messageFile = null;
        try {
            messageFile = GitCheckinEnvironment.createCommitMessageFile(this.project, this.repository.getRoot(), this.newMessage);
        }
        catch (IOException e) {
            this.LOG.warn("Couldn't create message file", (Throwable)e);
            return false;
        }
        handler.addParameters("--amend");
        handler.addParameters("-F", messageFile.getAbsolutePath());
        handler.addParameters("--only");
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        this.repository.update();
        if (result2.success()) {
            return true;
        }
        this.LOG.warn("Couldn't reword via amend: " + result2.getErrorOutputAsJoinedString());
        return false;
    }

    public final void undo$intellij_vcs_git() {
        UndoPossibility possibility = this.checkUndoPossibility();
        String errorTitle = "Can't Undo Reword";
        UndoPossibility undoPossibility = possibility;
        if (undoPossibility instanceof UndoPossibility.HeadMoved) {
            this.notifier.notifyError(errorTitle, "Repository has already been changed");
        } else if (undoPossibility instanceof UndoPossibility.PushedToProtectedBranch) {
            this.notifier.notifyError(errorTitle, "Commit has already been pushed to " + ((UndoPossibility.PushedToProtectedBranch)possibility).getBranch());
        } else if (undoPossibility instanceof UndoPossibility.Error) {
            this.notifier.notifyError(errorTitle, "");
        } else {
            this.doUndo();
        }
    }

    private final void doUndo() {
        GitCommandResult res = Git.getInstance().reset(this.repository, GitResetMode.KEEP, this.initialHeadPosition, new GitLineHandlerListener[0]);
        this.repository.update();
        if (!res.success()) {
            this.notifier.notifyError("Undo Reword Failed", res.getErrorOutputAsHtmlString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<GitRebaseEntry> injectRewordAction(List<GitRebaseEntry> list) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void entry;
            GitRebaseEntry gitRebaseEntry = (GitRebaseEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_10 = Intrinsics.areEqual((Object)entry.getAction(), (Object)GitRebaseEntry.Action.PICK.INSTANCE) && StringsKt.startsWith$default((String)((Hash)this.commit.getId()).asString(), (String)entry.getCommit(), (boolean)false, (int)2, null) ? new GitRebaseEntry(GitRebaseEntry.Action.REWORD.INSTANCE, entry.getCommit(), entry.getSubject()) : entry;
            collection.add(var12_10);
        }
        return (List)destination$iv$iv;
    }

    private final String supplyNewMessage(String editorText) {
        if (StringsKt.startsWith$default((String)editorText, (String)this.commit.getFullMessage(), (boolean)false, (int)2, null)) {
            return this.newMessage;
        }
        this.LOG.error("Unexpected editor content. Charset: " + GitConfigUtil.getCommitEncoding(this.project, this.commit.getRoot()), new Attachment[]{new Attachment("actual.txt", editorText), new Attachment("expected.txt", this.commit.getFullMessage())});
        throw (Throwable)new IllegalStateException("Unexpected editor content");
    }

    private final Hash findNewHashOfRewordedCommit(String newHead) {
        Object v0;
        String newCommitsRange;
        block3: {
            Iterable iterable;
            newCommitsRange = ((Hash)CollectionsKt.first((List)this.commit.getParents())).asString() + ".." + newHead;
            List newCommits = GitLogUtil.collectMetadata(this.project, this.repository.getRoot(), false, newCommitsRange).getCommits();
            if (newCommits.isEmpty()) {
                this.LOG.error("Couldn't find commits after reword in range " + newCommitsRange);
                return null;
            }
            Iterable iterable2 = iterable = (Iterable)newCommits;
            for (Object t : iterable2) {
                VcsCommitMetadata it = (VcsCommitMetadata)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)this.commit.getAuthor(), (Object)it.getAuthor()) && this.commit.getAuthorTime() == it.getAuthorTime() && StringUtil.equalsIgnoreWhitespaces((CharSequence)it.getFullMessage(), (CharSequence)this.newMessage))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        VcsCommitMetadata newCommit = v0;
        if (newCommit == null) {
            this.LOG.error("Couldn't find the reworded commit in range " + newCommitsRange);
            return null;
        }
        return (Hash)newCommit.getId();
    }

    private final UndoPossibility checkUndoPossibility() {
        String protectedBranch;
        this.repository.update();
        if (Intrinsics.areEqual((Object)this.repository.getCurrentRevision(), (Object)this.headAfterReword) ^ true) {
            return UndoPossibility.HeadMoved.INSTANCE;
        }
        if (this.rewordedCommit == null) {
            this.LOG.error("Couldn't find the reworded commit");
            return UndoPossibility.Error.INSTANCE;
        }
        Hash hash = this.rewordedCommit;
        if (hash == null) {
            Intrinsics.throwNpe();
        }
        if ((protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranchContainingCommit(this.repository, hash)) != null) {
            return new UndoPossibility.PushedToProtectedBranch(protectedBranch);
        }
        return UndoPossibility.Possible.INSTANCE;
    }

    private final void notifySuccess() {
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("Reworded Successfully", "", NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Undo", (Runnable)new Runnable(this, notification){
            final /* synthetic */ GitRewordOperation this$0;
            final /* synthetic */ Notification $notification;

            public final void run() {
                this.$notification.expire();
                GitRewordOperation.access$undoInBackground(this.this$0);
            }
            {
                this.this$0 = gitRewordOperation;
                this.$notification = notification;
            }
        }));
        MessageBusConnection connection = this.project.getMessageBus().connect();
        notification.whenExpired(new Runnable(connection){
            final /* synthetic */ MessageBusConnection $connection;

            public final void run() {
                this.$connection.disconnect();
            }
            {
                this.$connection = messageBusConnection;
            }
        });
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(this, notification){
            final /* synthetic */ GitRewordOperation this$0;
            final /* synthetic */ Notification $notification;

            public final void repositoryChanged(@NotNull GitRepository it) {
                if (Intrinsics.areEqual((Object)it, (Object)GitRewordOperation.access$getRepository$p(this.this$0))) {
                    BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)GitRewordOperation.access$getRepository$p(this.this$0)), (Runnable)new Runnable(this){
                        final /* synthetic */ notifySuccess.3 this$0;

                        public final void run() {
                            if (GitRewordOperation.access$checkUndoPossibility(this.this$0.this$0) != UndoPossibility.Possible.INSTANCE) {
                                this.this$0.$notification.expire();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = gitRewordOperation;
                this.$notification = notification;
            }
        });
        this.notifier.notify(notification);
    }

    private final void undoInBackground() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, this.project, "Undoing Reword"){
            final /* synthetic */ GitRewordOperation this$0;

            public void run(@NotNull ProgressIndicator indicator) {
                this.this$0.undo$intellij_vcs_git();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        });
    }

    public GitRewordOperation(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit2, @NotNull String newMessage) {
        Logger logger;
        this.repository = repository;
        this.commit = commit2;
        this.newMessage = newMessage;
        this.repository.update();
        GitRewordOperation gitRewordOperation = this;
        boolean $i$f$logger = false;
        gitRewordOperation.LOG = logger = Logger.getInstance(GitRewordOperation.class);
        this.project = this.repository.getProject();
        this.notifier = VcsNotifier.getInstance((Project)this.project);
        String string = this.repository.getCurrentRevision();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.initialHeadPosition = string;
    }

    public static final /* synthetic */ List access$injectRewordAction(GitRewordOperation $this, List list) {
        return $this.injectRewordAction(list);
    }

    public static final /* synthetic */ String access$supplyNewMessage(GitRewordOperation $this, String editorText) {
        return $this.supplyNewMessage(editorText);
    }

    public static final /* synthetic */ void access$undoInBackground(GitRewordOperation $this) {
        $this.undoInBackground();
    }

    public static final /* synthetic */ GitRepository access$getRepository$p(GitRewordOperation $this) {
        return $this.repository;
    }

    public static final /* synthetic */ UndoPossibility access$checkUndoPossibility(GitRewordOperation $this) {
        return $this.checkUndoPossibility();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "", "()V", "Error", "HeadMoved", "Possible", "PushedToProtectedBranch", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Possible;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$HeadMoved;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$PushedToProtectedBranch;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Error;", "intellij.vcs.git"})
    private static abstract class UndoPossibility {
        private UndoPossibility() {
        }

        public /* synthetic */ UndoPossibility(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Possible;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "()V", "intellij.vcs.git"})
        public static final class Possible
        extends UndoPossibility {
            public static final Possible INSTANCE;

            private Possible() {
                super(null);
            }

            static {
                Possible possible;
                INSTANCE = possible = new Possible();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$HeadMoved;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "()V", "intellij.vcs.git"})
        public static final class HeadMoved
        extends UndoPossibility {
            public static final HeadMoved INSTANCE;

            private HeadMoved() {
                super(null);
            }

            static {
                HeadMoved headMoved;
                INSTANCE = headMoved = new HeadMoved();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$PushedToProtectedBranch;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "branch", "", "(Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class PushedToProtectedBranch
        extends UndoPossibility {
            @NotNull
            private final String branch;

            @NotNull
            public final String getBranch() {
                return this.branch;
            }

            public PushedToProtectedBranch(@NotNull String branch) {
                super(null);
                this.branch = branch;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/GitRewordOperation$UndoPossibility$Error;", "Lgit4idea/rebase/GitRewordOperation$UndoPossibility;", "()V", "intellij.vcs.git"})
        public static final class Error
        extends UndoPossibility {
            public static final Error INSTANCE;

            private Error() {
                super(null);
            }

            static {
                Error error;
                INSTANCE = error = new Error();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u0012H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgit4idea/rebase/GitRewordOperation$RewordProcess;", "Lgit4idea/rebase/GitRebaseProcess;", "spec", "Lgit4idea/rebase/GitRebaseSpec;", "(Lgit4idea/rebase/GitRewordOperation;Lgit4idea/rebase/GitRebaseSpec;)V", "succeeded", "", "getSucceeded", "()Z", "setSucceeded", "(Z)V", "notifySuccess", "", "successful", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/rebase/GitSuccessfulRebase;", "skippedCommits", "Lcom/intellij/util/containers/MultiMap;", "Lgit4idea/rebase/GitRebaseUtils$CommitInfo;", "intellij.vcs.git"})
    private final class RewordProcess
    extends GitRebaseProcess {
        private boolean succeeded;

        public final boolean getSucceeded() {
            return this.succeeded;
        }

        public final void setSucceeded(boolean bl) {
            this.succeeded = bl;
        }

        @Override
        protected void notifySuccess(@NotNull Map<GitRepository, GitSuccessfulRebase> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
            this.succeeded = true;
        }

        public RewordProcess(GitRebaseSpec spec) {
            super(GitRewordOperation.this.project, spec, null);
        }
    }
}

