/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.util.text.StringUtil;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitSuccessfulRebase
extends GitRebaseStatus {
    private final SuccessType mySuccessType;

    private GitSuccessfulRebase(@NotNull SuccessType successType, @NotNull Collection<GitRebaseUtils.CommitInfo> skippedCommits) {
        super(GitRebaseStatus.Type.SUCCESS, skippedCommits);
        this.mySuccessType = successType;
    }

    @NotNull
    public SuccessType getSuccessType() {
        return this.mySuccessType;
    }

    @NotNull
    static GitSuccessfulRebase parseFromOutput(@NotNull List<String> output, @NotNull Collection<GitRebaseUtils.CommitInfo> skippedCommits) {
        return new GitSuccessfulRebase(SuccessType.fromOutput(output), skippedCommits);
    }

    static enum SuccessType {
        REBASED{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @Nullable String baseBranch, boolean withCheckout) {
                String msg = withCheckout ? "Checked out" + SuccessType.mention(currentBranch) + " and rebased it" : "Rebased" + SuccessType.mention(currentBranch);
                if (baseBranch != null) {
                    msg = msg + " on " + baseBranch;
                }
                return msg;
            }
        }
        ,
        UP_TO_DATE{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @Nullable String baseBranch, boolean withCheckout) {
                String msg;
                String string = msg = currentBranch != null ? currentBranch + " is up-to-date" : "Up-to-date";
                if (baseBranch != null) {
                    msg = msg + " with " + baseBranch;
                }
                return msg;
            }
        }
        ,
        FAST_FORWARDED{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @Nullable String baseBranch, boolean withCheckout) {
                String msg = withCheckout ? "Checked out" + SuccessType.mention(currentBranch) + " and fast-forwarded it" : "Fast-forwarded" + SuccessType.mention(currentBranch);
                if (baseBranch != null) {
                    msg = msg + " to " + baseBranch;
                }
                return msg;
            }
        };


        @NotNull
        private static String mention(@Nullable String currentBranch) {
            return currentBranch != null ? " " + currentBranch : "";
        }

        @NotNull
        abstract String formatMessage(@Nullable String var1, @Nullable String var2, boolean var3);

        @NotNull
        public static SuccessType fromOutput(@NotNull List<String> output) {
            for (String line : output) {
                if (StringUtil.containsIgnoreCase((String)line, (String)"Fast-forwarded")) {
                    return FAST_FORWARDED;
                }
                if (!StringUtil.containsIgnoreCase((String)line, (String)"is up to date")) continue;
                return UP_TO_DATE;
            }
            return REBASED;
        }
    }
}

