/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfigHelperKt;
import git4idea.repo.GitRemote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitConfig {
    private static final Logger LOG = Logger.getInstance(GitConfig.class);
    private static final Pattern REMOTE_SECTION = Pattern.compile("(?:svn-)?remote \"(.*)\"", 2);
    private static final Pattern URL_SECTION = Pattern.compile("url \"(.*)\"", 2);
    private static final Pattern BRANCH_INFO_SECTION = Pattern.compile("branch \"(.*)\"", 2);
    private static final Pattern BRANCH_COMMON_PARAMS_SECTION = Pattern.compile("branch", 2);
    @NotNull
    private final Collection<Remote> myRemotes;
    @NotNull
    private final Collection<Url> myUrls;
    @NotNull
    private final Collection<BranchConfig> myTrackedInfos;

    private GitConfig(@NotNull Collection<Remote> remotes, @NotNull Collection<Url> urls, @NotNull Collection<BranchConfig> trackedInfos) {
        this.myRemotes = remotes;
        this.myUrls = urls;
        this.myTrackedInfos = trackedInfos;
    }

    @NotNull
    Collection<GitRemote> parseRemotes() {
        return ((StreamEx)StreamEx.of(this.myRemotes).map(remote -> GitConfig.convertRemoteToGitRemote(this.myUrls, remote)).filter(remote -> !remote.getUrls().isEmpty())).toList();
    }

    @NotNull
    private static GitRemote convertRemoteToGitRemote(@NotNull Collection<Url> urls, @NotNull Remote remote) {
        UrlsAndPushUrls substitutedUrls = GitConfig.substituteUrls(urls, remote);
        return new GitRemote(remote.myName, substitutedUrls.getUrls(), substitutedUrls.getPushUrls(), remote.getFetchSpecs(), remote.getPushSpec());
    }

    @NotNull
    Collection<GitBranchTrackInfo> parseTrackInfos(@NotNull Collection<GitLocalBranch> localBranches, @NotNull Collection<GitRemoteBranch> remoteBranches) {
        return ContainerUtil.mapNotNull(this.myTrackedInfos, config -> GitConfig.convertBranchConfig(config, localBranches, remoteBranches));
    }

    @NotNull
    static GitConfig read(@NotNull File configFile) {
        Ini ini;
        GitConfig emptyConfig = new GitConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        if (!configFile.exists()) {
            LOG.info("No .git/config file at " + configFile.getPath());
            return emptyConfig;
        }
        try {
            ini = GitConfigHelperKt.loadIniFile(configFile);
        }
        catch (IOException e) {
            return emptyConfig;
        }
        ClassLoader classLoader = GitConfigHelperKt.findClassLoader();
        Pair<Collection<Remote>, Collection<Url>> remotesAndUrls = GitConfig.parseRemotes(ini, classLoader);
        Collection<BranchConfig> trackedInfos = GitConfig.parseTrackedInfos(ini, classLoader);
        return new GitConfig((Collection)remotesAndUrls.getFirst(), (Collection)remotesAndUrls.getSecond(), trackedInfos);
    }

    @NotNull
    private static Collection<BranchConfig> parseTrackedInfos(@NotNull Ini ini, @Nullable ClassLoader classLoader) {
        ArrayList<BranchConfig> configs = new ArrayList<BranchConfig>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            BranchConfig branchConfig;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (!StringUtil.startsWithIgnoreCase((String)sectionName, (String)"branch") || (branchConfig = GitConfig.parseBranchSection(sectionName, section, classLoader)) == null) continue;
            configs.add(branchConfig);
        }
        return configs;
    }

    @Nullable
    private static GitBranchTrackInfo convertBranchConfig(@Nullable BranchConfig branchConfig, @NotNull Collection<GitLocalBranch> localBranches, @NotNull Collection<GitRemoteBranch> remoteBranches) {
        if (branchConfig == null) {
            return null;
        }
        String branchName = branchConfig.getName();
        String remoteName = branchConfig.getBean().getRemote();
        String mergeName = branchConfig.getBean().getMerge();
        String rebaseName = branchConfig.getBean().getRebase();
        if (StringUtil.isEmptyOrSpaces((String)mergeName) && StringUtil.isEmptyOrSpaces((String)rebaseName)) {
            LOG.debug("No branch." + branchName + ".merge/rebase item in the .git/config");
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)remoteName)) {
            LOG.debug("No branch." + branchName + ".remote item in the .git/config");
            return null;
        }
        boolean merge = mergeName != null;
        String remoteBranchName = StringUtil.unquoteString((String)(merge ? mergeName : rebaseName));
        GitLocalBranch localBranch = GitConfig.findLocalBranch(branchName, localBranches);
        GitRemoteBranch remoteBranch = GitConfig.findRemoteBranch(remoteBranchName, remoteName, remoteBranches);
        if (localBranch == null || remoteBranch == null) {
            LOG.debug("localBranch: " + localBranch + ", remoteBranch: " + remoteBranch);
            return null;
        }
        return new GitBranchTrackInfo(localBranch, remoteBranch, merge);
    }

    @Nullable
    private static GitLocalBranch findLocalBranch(@NotNull String branchName, @NotNull Collection<GitLocalBranch> localBranches) {
        String name = GitBranchUtil.stripRefsPrefix(branchName);
        return (GitLocalBranch)ContainerUtil.find(localBranches, input -> input.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull String remoteBranchName, @NotNull String remoteName, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        String branchName = GitBranchUtil.stripRefsPrefix(remoteBranchName);
        return (GitRemoteBranch)ContainerUtil.find(remoteBranches, branch -> branch.getNameForRemoteOperations().equals(branchName) && branch.getRemote().getName().equals(remoteName));
    }

    @Nullable
    private static BranchConfig parseBranchSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        BranchBean branchBean = (BranchBean)section.as(BranchBean.class, classLoader);
        Matcher matcher = BRANCH_INFO_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new BranchConfig(matcher.group(1), branchBean);
        }
        if (BRANCH_COMMON_PARAMS_SECTION.matcher(sectionName).matches()) {
            LOG.debug(String.format("Common branch option(s) defined .git/config. sectionName: %s%n section: %s", sectionName, section));
            return null;
        }
        LOG.error(String.format("Invalid branch section format in .git/config. sectionName: %s%n section: %s", sectionName, section));
        return null;
    }

    @NotNull
    private static Pair<Collection<Remote>, Collection<Url>> parseRemotes(@NotNull Ini ini, @Nullable ClassLoader classLoader) {
        ArrayList<Remote> remotes = new ArrayList<Remote>();
        ArrayList<Url> urls = new ArrayList<Url>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            Profile.Section section;
            String sectionName = (String)stringSectionEntry.getKey();
            Remote remote = GitConfig.parseRemoteSection(sectionName, section = (Profile.Section)stringSectionEntry.getValue(), classLoader);
            if (remote != null) {
                remotes.add(remote);
                continue;
            }
            Url url = GitConfig.parseUrlSection(sectionName, section, classLoader);
            if (url == null) continue;
            urls.add(url);
        }
        return Pair.create(remotes, urls);
    }

    @NotNull
    private static UrlsAndPushUrls substituteUrls(@NotNull Collection<Url> urlSections, @NotNull Remote remote) {
        String insteadOf;
        boolean substituted;
        ArrayList<String> urls = new ArrayList<String>(remote.getUrls().size());
        ArrayList<String> pushUrls = new ArrayList<String>();
        for (String remoteUrl : remote.getUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                String pushInsteadOf = url.getPushInsteadOf();
                if (insteadOf != null && remoteUrl.startsWith(insteadOf)) {
                    urls.add(GitConfig.substituteUrl(remoteUrl, url, insteadOf));
                    substituted = true;
                    break;
                }
                if (pushInsteadOf == null || !remoteUrl.startsWith(pushInsteadOf)) continue;
                if (remote.getPushUrls().isEmpty()) {
                    pushUrls.add(GitConfig.substituteUrl(remoteUrl, url, pushInsteadOf));
                }
                urls.add(remoteUrl);
                substituted = true;
                break;
            }
            if (substituted) continue;
            urls.add(remoteUrl);
        }
        for (String remotePushUrl : remote.getPushUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                if (insteadOf == null || !remotePushUrl.startsWith(insteadOf)) continue;
                pushUrls.add(GitConfig.substituteUrl(remotePushUrl, url, insteadOf));
                substituted = true;
                break;
            }
            if (substituted) continue;
            pushUrls.add(remotePushUrl);
        }
        if (pushUrls.isEmpty()) {
            pushUrls = new ArrayList(urls);
        }
        return new UrlsAndPushUrls(urls, pushUrls);
    }

    @NotNull
    private static String substituteUrl(@NotNull String remoteUrl, @NotNull Url url, @NotNull String insteadOf) {
        return url.myName + remoteUrl.substring(insteadOf.length());
    }

    @Nullable
    private static Remote parseRemoteSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        Matcher matcher = REMOTE_SECTION.matcher(sectionName);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return new Remote(matcher.group(1), (RemoteBean)section.as(RemoteBean.class, classLoader));
        }
        return null;
    }

    @Nullable
    private static Url parseUrlSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        Matcher matcher = URL_SECTION.matcher(sectionName);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return new Url(matcher.group(1), (UrlBean)section.as(UrlBean.class, classLoader));
        }
        return null;
    }

    @NotNull
    private static String[] notNull(@Nullable String[] s) {
        return s == null ? ArrayUtil.EMPTY_STRING_ARRAY : s;
    }

    @NotNull
    private static Collection<String> nonNullCollection(@Nullable String[] array) {
        return array == null ? Collections.emptyList() : new ArrayList<String>(Arrays.asList(array));
    }

    private static interface BranchBean {
        @Nullable
        public String getRemote();

        @Nullable
        public String getMerge();

        @Nullable
        public String getRebase();
    }

    private static class BranchConfig {
        private final String myName;
        private final BranchBean myBean;

        BranchConfig(String name, BranchBean bean) {
            this.myName = name;
            this.myBean = bean;
        }

        public String getName() {
            return this.myName;
        }

        public BranchBean getBean() {
            return this.myBean;
        }
    }

    private static interface UrlBean {
        @Nullable
        public String getInsteadof();

        @Nullable
        public String getPushinsteadof();
    }

    private static class Url {
        private final String myName;
        private final UrlBean myUrlBean;

        private Url(String name, UrlBean urlBean) {
            this.myUrlBean = urlBean;
            this.myName = name;
        }

        @Nullable
        public String getInsteadOf() {
            return this.myUrlBean.getInsteadof();
        }

        @Nullable
        public String getPushInsteadOf() {
            return this.myUrlBean.getPushinsteadof();
        }
    }

    private static interface RemoteBean {
        @Nullable
        public String[] getFetch();

        @Nullable
        public String[] getPush();

        @Nullable
        public String[] getUrl();

        @Nullable
        public String[] getPushurl();
    }

    private static class Remote {
        private final String myName;
        private final RemoteBean myRemoteBean;

        private Remote(@NotNull String name, @NotNull RemoteBean remoteBean) {
            this.myRemoteBean = remoteBean;
            this.myName = name;
        }

        @NotNull
        private Collection<String> getUrls() {
            return GitConfig.nonNullCollection(this.myRemoteBean.getUrl());
        }

        @NotNull
        private Collection<String> getPushUrls() {
            return GitConfig.nonNullCollection(this.myRemoteBean.getPushurl());
        }

        @NotNull
        private List<String> getPushSpec() {
            String[] push = this.myRemoteBean.getPush();
            return push == null ? Collections.emptyList() : Arrays.asList(push);
        }

        @NotNull
        private List<String> getFetchSpecs() {
            return Arrays.asList(GitConfig.notNull(this.myRemoteBean.getFetch()));
        }
    }

    private static class UrlsAndPushUrls {
        final List<String> myUrls;
        final Collection<String> myPushUrls;

        private UrlsAndPushUrls(List<String> urls, Collection<String> pushUrls) {
            this.myPushUrls = pushUrls;
            this.myUrls = urls;
        }

        public Collection<String> getPushUrls() {
            return this.myPushUrls;
        }

        public List<String> getUrls() {
            return this.myUrls;
        }
    }
}

