/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepositoryFiles;
import git4idea.validators.GitRefNameValidator;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;
    @NotNull
    private final GitRepositoryFiles myGitFiles;

    GitRepositoryReader(@NotNull GitRepositoryFiles gitFiles) {
        this.myGitFiles = gitFiles;
        this.myHeadFile = gitFiles.getHeadFile();
        DvcsUtil.assertFileExists((File)this.myHeadFile, (String)(".git/HEAD file not found at " + this.myHeadFile));
        this.myRefsHeadsDir = gitFiles.getRefsHeadsFile();
        this.myRefsRemotesDir = gitFiles.getRefsRemotesFile();
        this.myPackedRefsFile = gitFiles.getPackedRefsPath();
    }

    @NotNull
    GitBranchState readState(@NotNull Collection<GitRemote> remotes) {
        String currentRevision;
        GitLocalBranch currentBranch;
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> branches2 = this.readBranches(remotes);
        Map localBranches = (Map)branches2.first;
        HeadInfo headInfo = this.readHead();
        Repository.State state = this.readRepositoryState(headInfo);
        if (!headInfo.isBranch || !localBranches.isEmpty()) {
            currentBranch = this.findCurrentBranch(headInfo, state, localBranches.keySet());
            currentRevision = GitRepositoryReader.getCurrentRevision(headInfo, currentBranch == null ? null : (Hash)localBranches.get(currentBranch));
        } else if (headInfo.content != null) {
            currentBranch = new GitLocalBranch(headInfo.content);
            currentRevision = null;
        } else {
            currentBranch = null;
            currentRevision = null;
        }
        if (currentBranch == null && currentRevision == null) {
            LOG.error("Couldn't identify neither current branch nor current revision. .git/HEAD content: [" + headInfo.content + "]");
        }
        return new GitBranchState(currentRevision, currentBranch, state, localBranches, (Map)branches2.second);
    }

    @NotNull
    GitHooksInfo readHooksInfo() {
        return new GitHooksInfo(GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPreCommitHookFile()) || GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getCommitMsgHookFile()), GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPrePushHookFile()));
    }

    private static boolean isExistingExecutableFile(@NotNull File file) {
        return file.exists() && file.canExecute();
    }

    boolean hasShallowCommits() {
        File shallowFile = this.myGitFiles.getShallowFile();
        if (!shallowFile.exists()) {
            return false;
        }
        return shallowFile.length() > 0L;
    }

    @Nullable
    private static String getCurrentRevision(@NotNull HeadInfo headInfo, @Nullable Hash currentBranchHash) {
        Object currentRevision = !headInfo.isBranch ? headInfo.content : (currentBranchHash == null ? null : currentBranchHash.asString());
        return currentRevision;
    }

    @Nullable
    private GitLocalBranch findCurrentBranch(@NotNull HeadInfo headInfo, @NotNull Repository.State state, @NotNull Set<GitLocalBranch> localBranches) {
        String currentBranchName = this.findCurrentBranchName(state, headInfo);
        if (currentBranchName == null) {
            return null;
        }
        return (GitLocalBranch)ContainerUtil.find(localBranches, branch -> GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)branch.getFullName(), (Object)currentBranchName));
    }

    @NotNull
    private Repository.State readRepositoryState(@NotNull HeadInfo headInfo) {
        if (this.isMergeInProgress()) {
            return Repository.State.MERGING;
        }
        if (this.isRebaseInProgress()) {
            return Repository.State.REBASING;
        }
        if (!headInfo.isBranch) {
            return Repository.State.DETACHED;
        }
        return Repository.State.NORMAL;
    }

    @Nullable
    private String findCurrentBranchName(@NotNull Repository.State state, @NotNull HeadInfo headInfo) {
        String currentBranch = null;
        if (headInfo.isBranch) {
            currentBranch = headInfo.content;
        } else if (state == Repository.State.REBASING && (currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseApplyDir())) == null) {
            currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseMergeDir());
        }
        return GitRefUtil.addRefsHeadsPrefixIfNeeded(currentBranch);
    }

    @Nullable
    private static String readRebaseDirBranchFile(@NonNls File rebaseDir) {
        File headName;
        if (rebaseDir.exists() && (headName = new File(rebaseDir, "head-name")).exists()) {
            return DvcsUtil.tryLoadFileOrReturn((File)headName, null, (String)"UTF-8");
        }
        return null;
    }

    private boolean isMergeInProgress() {
        return this.myGitFiles.getMergeHeadFile().exists();
    }

    private boolean isRebaseInProgress() {
        return this.myGitFiles.getRebaseApplyDir().exists() || this.myGitFiles.getRebaseMergeDir().exists();
    }

    @NotNull
    private Map<String, String> readPackedBranches() {
        if (!this.myPackedRefsFile.exists()) {
            return Collections.emptyMap();
        }
        try {
            String content = DvcsUtil.tryLoadFile((File)this.myPackedRefsFile, (String)"UTF-8");
            return ContainerUtil.map2MapNotNull((Object[])LineTokenizer.tokenize((CharSequence)content, (boolean)false), GitRefUtil::parseRefsLine);
        }
        catch (RepoStateException e) {
            return Collections.emptyMap();
        }
    }

    @NotNull
    private Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> readBranches(@NotNull Collection<GitRemote> remotes) {
        Map<String, String> data = this.readBranchRefsFromFiles();
        Map<String, Hash> resolvedRefs = GitRefUtil.resolveRefs(data);
        return GitRepositoryReader.createBranchesFromData(remotes, resolvedRefs);
    }

    @NotNull
    private Map<String, String> readBranchRefsFromFiles() {
        HashMap result2 = ContainerUtil.newHashMap(this.readPackedBranches());
        result2.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsHeadsDir, "refs/heads/"));
        result2.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsRemotesDir, "refs/remotes/"));
        result2.remove("refs/remotes/origin/HEAD");
        return result2;
    }

    @NotNull
    private static Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> createBranchesFromData(@NotNull Collection<GitRemote> remotes, @NotNull Map<String, Hash> data) {
        HashMap localBranches = ContainerUtil.newHashMap();
        HashMap remoteBranches = ContainerUtil.newHashMap();
        for (Map.Entry<String, Hash> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = entry.getValue();
            if (refName.startsWith("refs/heads/")) {
                localBranches.put(new GitLocalBranch(refName), hash);
                continue;
            }
            if (refName.startsWith("refs/remotes/")) {
                remoteBranches.put(GitRepositoryReader.parseRemoteBranch(refName, remotes), hash);
                continue;
            }
            LOG.warn("Unexpected ref format: " + refName);
        }
        return Pair.create((Object)localBranches, (Object)remoteBranches);
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    @NotNull
    private static Map<String, String> readFromBranchFiles(@NotNull File refsRootDir, @NotNull String prefix) {
        if (!refsRootDir.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        FileUtil.processFilesRecursively((File)refsRootDir, file -> {
            String relativePath;
            if (!file.isDirectory() && !GitRepositoryReader.isHidden(file) && (relativePath = FileUtil.getRelativePath((File)refsRootDir, (File)file)) != null) {
                String hash;
                String branchName = prefix + FileUtil.toSystemIndependentName((String)relativePath);
                boolean isBranchNameValid = GitRefNameValidator.getInstance().checkInput(branchName);
                if (isBranchNameValid && (hash = GitRepositoryReader.loadHashFromBranchFile(file)) != null) {
                    result2.put(branchName, hash);
                }
            }
            return true;
        }, dir -> !GitRepositoryReader.isHidden(dir));
        return result2;
    }

    private static boolean isHidden(@NotNull File file) {
        return file.getName().startsWith(".");
    }

    @NotNull
    private static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Collection<GitRemote> remotes) {
        String branchName;
        String remoteName;
        GitRemote remote;
        String stdName = GitBranchUtil.stripRefsPrefix(fullBranchName);
        int slash = stdName.indexOf(47);
        if (slash == -1) {
            return new GitSvnRemoteBranch(fullBranchName);
        }
        do {
            remoteName = stdName.substring(0, slash);
            branchName = stdName.substring(slash + 1);
            remote = GitUtil.findRemoteByName(remotes, remoteName);
            slash = stdName.indexOf(47, slash + 1);
        } while (remote == null && slash >= 0);
        if (remote == null) {
            LOG.trace(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            return new GitStandardRemoteBranch(fakeRemote, branchName);
        }
        return new GitStandardRemoteBranch(remote, branchName);
    }

    @NotNull
    private HeadInfo readHead() {
        String headContent;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.myHeadFile, (String)"UTF-8");
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return new HeadInfo(false, null);
        }
        Hash hash = GitRefUtil.parseHash(headContent);
        if (hash != null) {
            return new HeadInfo(false, headContent);
        }
        String target = GitRefUtil.getTarget(headContent);
        if (target != null) {
            return new HeadInfo(true, target);
        }
        LOG.error((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        return new HeadInfo(false, null);
    }

    private static class HeadInfo {
        @Nullable
        private final String content;
        private final boolean isBranch;

        HeadInfo(boolean branch, @Nullable String content) {
            this.isBranch = branch;
            this.content = content;
        }
    }
}

