/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitRepositoryUpdater
implements Disposable,
AsyncVfsEventsListener {
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final VirtualFile myRemotesDir;
    @Nullable
    private final VirtualFile myHeadsDir;
    @Nullable
    private final VirtualFile myTagsDir;
    @NotNull
    private final Set<LocalFileSystem.WatchRequest> myWatchRequests;

    GitRepositoryUpdater(@NotNull GitRepository repository, @NotNull GitRepositoryFiles gitFiles) {
        this.myRepository = repository;
        List rootPaths = ContainerUtil.map(gitFiles.getRootDirs(), file -> file.getPath());
        this.myWatchRequests = LocalFileSystem.getInstance().addRootsToWatch((Collection)rootPaths, true);
        this.myRepositoryFiles = gitFiles;
        this.visitSubDirsInVfs();
        this.myHeadsDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsHeadsFile());
        this.myRemotesDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsRemotesFile());
        this.myTagsDir = VcsUtil.getVirtualFile((File)this.myRepositoryFiles.getRefsTagsFile());
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)this);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
    }

    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        boolean configChanged = false;
        boolean headChanged = false;
        boolean branchFileChanged = false;
        boolean packedRefsChanged = false;
        boolean rebaseFileChanged = false;
        boolean mergeFileChanged = false;
        boolean tagChanged = false;
        for (VFileEvent vFileEvent : events) {
            String filePath = GitFileUtils.stripFileProtocolPrefix(vFileEvent.getPath());
            if (this.myRepositoryFiles.isConfigFile(filePath)) {
                configChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isHeadFile(filePath)) {
                headChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myHeadsDir);
                continue;
            }
            if (this.myRepositoryFiles.isRemoteBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myRemotesDir);
                continue;
            }
            if (this.myRepositoryFiles.isPackedRefs(filePath)) {
                packedRefsChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                rebaseFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isMergeFile(filePath)) {
                mergeFileChanged = true;
                continue;
            }
            if (!this.myRepositoryFiles.isTagFile(filePath)) continue;
            DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myTagsDir);
            tagChanged = true;
        }
        if (headChanged || configChanged || branchFileChanged || packedRefsChanged || rebaseFileChanged || mergeFileChanged) {
            this.myRepository.update();
        }
        if (tagChanged || packedRefsChanged) {
            ((GitRepositoryChangeListener)BackgroundTaskUtil.syncPublisher((Project)this.myRepository.getProject(), GitRepository.GIT_REPO_CHANGE)).repositoryChanged(this.myRepository);
        }
    }

    private void visitSubDirsInVfs() {
        for (VirtualFile rootDir : this.myRepositoryFiles.getRootDirs()) {
            rootDir.getChildren();
        }
        for (String path : this.myRepositoryFiles.getDirsToWatch()) {
            DvcsUtil.ensureAllChildrenInVfs((VirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByPath(path));
        }
    }
}

