/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitUtil;
import git4idea.rebase.GitCommitEditingAction;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUncommitAction
extends GitCommitEditingAction {
    private static final Logger LOG = Logger.getInstance(GitUncommitAction.class);
    private static final String FAILURE_TITLE = "Can't Undo Commit";

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e.getPresentation().isEnabledAndVisible()) {
            DataPackBase dataPackBase = ((VisiblePack)this.getUi(e).getDataPack()).getDataPack();
            if (!(dataPackBase instanceof DataPack)) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                return;
            }
            if (this.isHeadCommit(e)) {
                e.getPresentation().setEnabled(true);
            } else {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("The selected commit is not the last in the current branch");
            }
        }
    }

    @Override
    public void actionPerformedAfterChecks(@NotNull AnActionEvent e) {
        Project project = (Project)ObjectUtils.notNull((Object)e.getProject());
        VcsShortCommitDetails commit2 = this.getSelectedCommit(e);
        ChangeListChooser chooser = new ChangeListChooser(project, (Collection)ChangeListManager.getInstance((Project)project).getChangeListsCopy(), null, "Select Target Changelist", commit2.getSubject());
        chooser.show();
        LocalChangeList selectedList = chooser.getSelectedList();
        if (selectedList != null) {
            GitUncommitAction.resetInBackground(this.getLogData(e), this.getRepository(e), commit2, selectedList);
        }
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        return FAILURE_TITLE;
    }

    private static void resetInBackground(final @NotNull VcsLogData data, final @NotNull GitRepository repository, final @NotNull VcsShortCommitDetails commit2, final @NotNull LocalChangeList changeList) {
        final Project project = repository.getProject();
        new Task.Backgroundable(project, "Undoing Last Commit...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection changesInCommit;
                try {
                    changesInCommit = GitUncommitAction.getChangesInCommit(data, commit2);
                }
                catch (VcsException e) {
                    String message = "Couldn't load changes of " + ((Hash)commit2.getId()).asString();
                    LOG.warn(message, (Throwable)e);
                    Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.ERROR, null);
                    VcsNotifier.getInstance((Project)project).notify(notification);
                    return;
                }
                new GitResetOperation(project, Collections.singletonMap(repository, commit2.getParents().get(0)), GitResetMode.SOFT, indicator).execute();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl((Project)project);
                changeListManager.invokeAfterUpdate(() -> {
                    Collection<Change> changes = GitUtil.findCorrespondentLocalChanges((ChangeListManager)changeListManager, changesInCommit);
                    changeListManager.moveChangesTo(changeList, changes.toArray(new Change[0]));
                }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing Changes...", ModalityState.defaultModalityState());
            }
        }.queue();
    }

    @NotNull
    private static Collection<Change> getChangesInCommit(@NotNull VcsLogData data, @NotNull VcsShortCommitDetails commit2) throws VcsException {
        VirtualFile root;
        Hash hash = (Hash)commit2.getId();
        VcsFullCommitDetails details = GitUncommitAction.getChangesFromCache(data, hash, root = commit2.getRoot());
        if (details == null) {
            details = VcsLogUtil.getDetails((VcsLogData)data, (VirtualFile)root, (Hash)hash);
        }
        return details.getChanges();
    }

    @Nullable
    private static VcsFullCommitDetails getChangesFromCache(@NotNull VcsLogData data, @NotNull Hash hash, @NotNull VirtualFile root) {
        Ref details = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> details.set((Object)data.getCommitDetailsGetter().getCommitDataIfAvailable(data.getCommitIndex(hash, root))));
        if (details.isNull() || details.get() instanceof LoadingDetails) {
            return null;
        }
        return (VcsFullCommitDetails)details.get();
    }
}

