/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsShelveChangesSaver;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.stash.GitChangesSaver;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GitShelveChangesSaver
extends GitChangesSaver {
    private final VcsShelveChangesSaver myVcsShelveChangesSaver;
    private final ShelvedChangesViewManager myShelveViewManager;

    public GitShelveChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, String stashMessage) {
        super(project, git, indicator, stashMessage);
        this.myShelveViewManager = ShelvedChangesViewManager.getInstance((Project)this.myProject);
        this.myVcsShelveChangesSaver = new VcsShelveChangesSaver(project, indicator, stashMessage){

            protected void doRollback(@NotNull Collection<? extends VirtualFile> rootsToSave) {
                for (VirtualFile virtualFile : rootsToSave) {
                    GitRollbackEnvironment.resetHardLocal(GitShelveChangesSaver.this.myProject, virtualFile);
                }
            }
        };
    }

    @Override
    protected void save(@NotNull Collection<VirtualFile> rootsToSave) throws VcsException {
        this.myVcsShelveChangesSaver.save(rootsToSave);
    }

    @Override
    public void load() {
        this.myVcsShelveChangesSaver.load();
    }

    @Override
    public boolean wereChangesSaved() {
        return this.myVcsShelveChangesSaver.getShelvedLists() != null && !this.myVcsShelveChangesSaver.getShelvedLists().isEmpty();
    }

    @Override
    public String getSaverName() {
        return "shelf";
    }

    @Override
    @NotNull
    public String getOperationName() {
        return "shelve";
    }

    @Override
    public void showSavedChanges() {
        if (this.myVcsShelveChangesSaver.getShelvedLists() == null) {
            return;
        }
        this.myShelveViewManager.activateView((ShelvedChangeList)this.myVcsShelveChangesSaver.getShelvedLists().get(this.myVcsShelveChangesSaver.getShelvedLists().keySet().iterator().next()));
    }

    public String toString() {
        return "ShelveChangesSaver. Lists: " + this.myVcsShelveChangesSaver.getShelvedLists();
    }
}

