/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashUtils;
import git4idea.ui.GitUnstashDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStashChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitStashChangesSaver.class);
    private static final String NO_LOCAL_CHANGES_TO_SAVE = "No local changes to save";
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Set<VirtualFile> myStashedRoots = ContainerUtil.newHashSet();

    public GitStashChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage) {
        super(project, git, progressIndicator, stashMessage);
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    @Override
    protected void save(@NotNull Collection<VirtualFile> rootsToSave) throws VcsException {
        LOG.info("saving " + rootsToSave);
        for (VirtualFile root : rootsToSave) {
            String message = "Stashing changes from '" + root.getName() + "'...";
            LOG.info(message);
            String oldProgressTitle = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(message);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository is null for root " + root);
            } else {
                GitCommandResult result2 = this.myGit.stashSave(repository, this.myStashMessage);
                if (result2.success() && GitStashChangesSaver.somethingWasStashed(result2)) {
                    this.myStashedRoots.add(root);
                } else {
                    if (!result2.success()) {
                        throw new VcsException("Couldn't stash " + repository.getRoot() + ": " + result2.getErrorOutputAsJoinedString());
                    }
                    LOG.warn("There was nothing to stash in " + repository.getRoot());
                }
            }
            this.myProgressIndicator.setText(oldProgressTitle);
        }
    }

    private static boolean somethingWasStashed(@NotNull GitCommandResult result2) {
        return !StringUtil.containsIgnoreCase((String)result2.getErrorOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE) && !StringUtil.containsIgnoreCase((String)result2.getOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE);
    }

    @Override
    public void load() {
        String oldProgressTitle = this.myProgressIndicator.getText();
        GitStashUtils.unstash(this.myProject, this.myStashedRoots, (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)root -> {
            String message = "Popping changes to '" + root.getName() + "'...";
            this.myProgressIndicator.setText(message);
            GitLineHandler handler = new GitLineHandler(this.myProject, (VirtualFile)root, GitCommand.STASH);
            handler.addParameters("pop");
            return handler;
        }), (GitConflictResolver)new UnstashConflictResolver(this.myProject, this.myGit, this.myStashedRoots, this.myParams));
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    @Override
    public boolean wereChangesSaved() {
        return !this.myStashedRoots.isEmpty();
    }

    @Override
    public String getSaverName() {
        return "stash";
    }

    @Override
    @NotNull
    public String getOperationName() {
        return "stash";
    }

    @Override
    public void showSavedChanges() {
        GitUnstashDialog.showUnstashDialog(this.myProject, new ArrayList<VirtualFile>(this.myStashedRoots), this.myStashedRoots.iterator().next());
    }

    public String toString() {
        return "StashChangesSaver. Roots: " + this.myStashedRoots;
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private UnstashMergeDialogCustomizer() {
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            return "Uncommitted changes that were stashed before update have conflicts with updated files.";
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            return GitChangesSaver.getConflictLeftPanelTitle();
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
            return GitChangesSaver.getConflictRightPanelTitle();
        }
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final Set<VirtualFile> myStashedRoots;

        UnstashConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Set<VirtualFile> stashedRoots, @Nullable GitConflictResolver.Params params) {
            super(project, git, stashedRoots, UnstashConflictResolver.makeParamsOrUse(params, project));
            this.myStashedRoots = stashedRoots;
        }

        private static GitConflictResolver.Params makeParamsOrUse(@Nullable GitConflictResolver.Params givenParams, Project project) {
            if (givenParams != null) {
                return givenParams;
            }
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle("Local changes were not restored");
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer());
            params.setReverse(true);
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Local changes were restored with conflicts", "Your uncommitted changes were saved to <a href='saver'>stash</a>.<br/>Unstash is not complete, you have unresolved merges in your working tree<br/><a href='resolve'>Resolve</a> conflicts and drop the stash.", new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (event.getDescription().equals("saver")) {
                            GitUnstashDialog.showUnstashDialog(myProject, new ArrayList<VirtualFile>(myStashedRoots), (VirtualFile)myStashedRoots.iterator().next());
                        } else if (event.getDescription().equals("resolve")) {
                            this.mergeNoProceed();
                        }
                    }
                }
            });
        }
    }
}

