/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitConfigUtil;
import git4idea.merge.GitConflictResolver;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import git4idea.util.StringScanner;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a&\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a8\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0014"}, d2={"loadStashStack", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "consumer", "Lcom/intellij/util/Consumer;", "Lgit4idea/ui/StashInfo;", "charset", "Ljava/nio/charset/Charset;", "unstash", "handler", "Lgit4idea/commands/GitLineHandler;", "conflictResolver", "Lgit4idea/merge/GitConflictResolver;", "roots", "", "handlerProvider", "Lkotlin/Function1;", "intellij.vcs.git"})
@JvmName(name="GitStashUtils")
public final class GitStashUtils {
    public static final void unstash(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, @NotNull GitConflictResolver conflictResolver) {
        GitStashUtils.unstash(project, CollectionsKt.listOf((Object)root), (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)new Function1<VirtualFile, GitLineHandler>(handler){
            final /* synthetic */ GitLineHandler $handler;

            @NotNull
            public final GitLineHandler invoke(@NotNull VirtualFile it) {
                return this.$handler;
            }
            {
                this.$handler = gitLineHandler;
                super(1);
            }
        }), conflictResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void unstash(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver) {
        Closeable closeable = (Closeable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)"Unstash");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)closeable;
            boolean bl = false;
            for (VirtualFile virtualFile : roots) {
                void result2;
                GitLineHandler handler = (GitLineHandler)handlerProvider.invoke((Object)virtualFile);
                GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(virtualFile);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(virtualFile, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                handler.addLineListener(conflictDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(localChangesDetector);
                GitCommandResult result22 = Git.getInstance().runCommand((Computable<GitLineHandler>)((Computable)new Computable<GitLineHandler>(handler){
                    final /* synthetic */ GitLineHandler $handler;

                    @NotNull
                    public final GitLineHandler compute() {
                        return this.$handler;
                    }
                    {
                        this.$handler = gitLineHandler;
                    }
                }));
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
                if (conflictDetector.hasHappened()) {
                    boolean conflictsResolved = conflictResolver.merge();
                    if (conflictsResolved) continue;
                    return;
                }
                if (untrackedFilesDetector.wasMessageDetected()) {
                    GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, virtualFile, (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), "unstash", null);
                    return;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, virtualFile, "unstash", (Collection<String>)localChangesDetector.getRelativeFilePaths());
                    return;
                }
                if (result2.success()) continue;
                VcsNotifier.getInstance((Project)project).notifyError("Unstash Failed", result2.getErrorOutputAsHtmlString());
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void loadStashStack(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<StashInfo> consumer) {
        GitStashUtils.loadStashStack(project, root, Charset.forName(GitConfigUtil.getLogEncoding(project, root)), consumer);
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadStashStack(Project project, VirtualFile root, Charset charset, Consumer<StashInfo> consumer) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STASH.readLockingCommand());
        h.setSilent(true);
        h.addParameters("list");
        String out = null;
        try {
            h.setCharset(charset);
            out = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(project, e, h.printableCommandLine());
            return;
        }
        StringScanner s = new StringScanner(out);
        while (s.hasMoreData()) {
            String string;
            void $receiver$iv;
            String string2 = s.line();
            String string3 = s.boundedToken(':');
            String string4 = s.boundedToken(':');
            Consumer<StashInfo> consumer2 = consumer;
            CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string5 = string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string6 = string3;
            String string7 = string4;
            consumer2.consume((Object)new StashInfo(string7, string6, string5));
        }
    }
}

