/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitFormatException;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.status.GitChangesCollector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class GitNewChangesCollector
extends GitChangesCollector {
    private static final Logger LOG = Logger.getInstance(GitNewChangesCollector.class);
    private final GitRepository myRepository;
    private final Collection<Change> myChanges = new HashSet<Change>();
    private final Set<VirtualFile> myUnversionedFiles = new HashSet<VirtualFile>();
    @NotNull
    private final Git myGit;

    @NotNull
    static GitNewChangesCollector collect(@NotNull Project project, @NotNull Git git, @NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager vcsManager, @NotNull AbstractVcs vcs, @NotNull VcsDirtyScope dirtyScope, @NotNull VirtualFile vcsRoot) throws VcsException {
        return new GitNewChangesCollector(project, git, changeListManager, vcsManager, vcs, dirtyScope, vcsRoot);
    }

    @Override
    @NotNull
    Collection<VirtualFile> getUnversionedFiles() {
        return this.myUnversionedFiles;
    }

    @Override
    @NotNull
    Collection<Change> getChanges() {
        return this.myChanges;
    }

    private GitNewChangesCollector(@NotNull Project project, @NotNull Git git, @NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager vcsManager, @NotNull AbstractVcs vcs, @NotNull VcsDirtyScope dirtyScope, @NotNull VirtualFile vcsRoot) throws VcsException {
        super(project, changeListManager, vcsManager, vcs, dirtyScope, vcsRoot);
        this.myGit = git;
        this.myRepository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(vcsRoot);
        Collection<FilePath> dirtyPaths = this.dirtyPaths(true);
        if (!dirtyPaths.isEmpty()) {
            this.collectChanges(dirtyPaths);
            this.collectUnversionedFiles();
        }
    }

    private void collectChanges(Collection<FilePath> dirtyPaths) throws VcsException {
        GitLineHandler handler = this.statusHandler(dirtyPaths);
        String output = this.myGit.runCommand(handler).getOutputOrThrow(new int[0]);
        this.parseOutput(output, handler);
    }

    private void collectUnversionedFiles() throws VcsException {
        if (this.myRepository == null) {
            this.myUnversionedFiles.addAll(this.myGit.untrackedFiles(this.myProject, this.myVcsRoot, null));
        } else {
            GitUntrackedFilesHolder untrackedFilesHolder = this.myRepository.getUntrackedFilesHolder();
            this.myUnversionedFiles.addAll(untrackedFilesHolder.retrieveUntrackedFiles());
        }
    }

    private GitLineHandler statusHandler(Collection<FilePath> dirtyPaths) {
        GitLineHandler handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.STATUS);
        String[] params = new String[]{"--porcelain", "-z", "--untracked-files=no"};
        handler.addParameters(params);
        handler.endOptions();
        handler.addRelativePaths(dirtyPaths);
        if (handler.isLargeCommandLine()) {
            handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.STATUS);
            handler.addParameters(params);
            handler.endOptions();
        }
        handler.setSilent(true);
        return handler;
    }

    private void parseOutput(@NotNull String output, @NotNull GitHandler handler) throws VcsException {
        VcsRevisionNumber head = this.getHead();
        String[] split = output.split("\u0000");
        block12: for (int pos = 0; pos < split.length; ++pos) {
            String line = split[pos];
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (line.length() < 4) {
                GitNewChangesCollector.throwGFE("Line is too short.", handler, output, line, '0', '0');
            }
            String xyStatus = line.substring(0, 2);
            String filepath = line.substring(3);
            char xStatus = xyStatus.charAt(0);
            char yStatus = xyStatus.charAt(1);
            switch (xStatus) {
                case ' ': {
                    if (yStatus == 'M') {
                        this.reportModified(filepath, head);
                        continue block12;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath, head);
                        continue block12;
                    }
                    if (yStatus == 'A') {
                        this.reportAdded(filepath);
                        continue block12;
                    }
                    if (yStatus == 'T') {
                        this.reportTypeChanged(filepath, head);
                        continue block12;
                    }
                    if (yStatus == 'U') {
                        this.reportConflict(filepath, head);
                        continue block12;
                    }
                    GitNewChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block12;
                }
                case 'M': {
                    if (yStatus == ' ' || yStatus == 'M' || yStatus == 'T') {
                        this.reportModified(filepath, head);
                        continue block12;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath, head);
                        continue block12;
                    }
                    GitNewChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block12;
                }
                case 'C': {
                    ++pos;
                }
                case 'A': {
                    if (yStatus == 'M' || yStatus == ' ' || yStatus == 'T') {
                        this.reportAdded(filepath);
                        continue block12;
                    }
                    if (yStatus == 'D') continue block12;
                    if (yStatus == 'U' || yStatus == 'A') {
                        this.reportConflict(filepath, head);
                        continue block12;
                    }
                    GitNewChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block12;
                }
                case 'D': {
                    if (yStatus == 'M' || yStatus == ' ' || yStatus == 'T') {
                        this.reportDeleted(filepath, head);
                        continue block12;
                    }
                    if (yStatus == 'U') {
                        this.reportConflict(filepath, head);
                        continue block12;
                    }
                    if (yStatus == 'D') continue block12;
                    GitNewChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block12;
                }
                case 'U': {
                    if (yStatus == 'U' || yStatus == 'A' || yStatus == 'D' || yStatus == 'T') {
                        this.reportConflict(filepath, head);
                        continue block12;
                    }
                    GitNewChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block12;
                }
                case 'R': {
                    String oldFilename = split[++pos];
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath, head);
                        continue block12;
                    }
                    if (yStatus == ' ' || yStatus == 'M' || yStatus == 'T') {
                        this.reportRename(filepath, oldFilename, head);
                        continue block12;
                    }
                    GitNewChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block12;
                }
                case 'T': {
                    if (yStatus == ' ' || yStatus == 'M') {
                        this.reportTypeChanged(filepath, head);
                        continue block12;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath, head);
                        continue block12;
                    }
                    GitNewChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block12;
                }
                case '?': {
                    GitNewChangesCollector.throwGFE("Unexpected unversioned file flag.", handler, output, line, xStatus, yStatus);
                    continue block12;
                }
                case '!': {
                    GitNewChangesCollector.throwGFE("Unexpected ignored file flag.", handler, output, line, xStatus, yStatus);
                }
                default: {
                    GitNewChangesCollector.throwGFE("Unexpected symbol as xStatus.", handler, output, line, xStatus, yStatus);
                }
            }
        }
    }

    @NotNull
    private VcsRevisionNumber getHead() throws VcsException {
        if (this.myRepository != null) {
            this.myRepository.update();
            String rev = this.myRepository.getCurrentRevision();
            return rev != null ? new GitRevisionNumber(rev) : VcsRevisionNumber.NULL;
        }
        LOG.info("GitRepository is null for root " + this.myVcsRoot);
        return this.getHeadFromGit();
    }

    @NotNull
    private VcsRevisionNumber getHeadFromGit() throws VcsException {
        Object nativeHead;
        block2: {
            nativeHead = VcsRevisionNumber.NULL;
            try {
                nativeHead = GitChangeUtils.resolveReference(this.myProject, this.myVcsRoot, "HEAD");
            }
            catch (VcsException e) {
                if (GitChangeUtils.isHeadMissing(e)) break block2;
                throw e;
            }
        }
        return nativeHead;
    }

    private static void throwYStatus(String output, GitHandler handler, String line, char xStatus, char yStatus) {
        GitNewChangesCollector.throwGFE("Unexpected symbol as yStatus.", handler, output, line, xStatus, yStatus);
    }

    private static void throwGFE(String message, GitHandler handler, String output, String line, char xStatus, char yStatus) {
        throw new GitFormatException(String.format("%s\n xStatus=[%s], yStatus=[%s], line=[%s], \nhandler:\n%s\n output: \n%s", message, Character.valueOf(xStatus), Character.valueOf(yStatus), line.replace('\u0000', '!'), handler, output));
    }

    private void reportModified(String filepath, VcsRevisionNumber head) throws VcsException {
        ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, filepath, head, this.myProject, false);
        ContentRevision after = GitContentRevision.createRevision(this.myVcsRoot, filepath, null, this.myProject, false);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportTypeChanged(String filepath, VcsRevisionNumber head) throws VcsException {
        ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, filepath, head, this.myProject, false);
        ContentRevision after = GitContentRevision.createRevisionForTypeChange(this.myProject, this.myVcsRoot, filepath, null, false);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportAdded(String filepath) throws VcsException {
        ContentRevision before = null;
        ContentRevision after = GitContentRevision.createRevision(this.myVcsRoot, filepath, null, this.myProject, false);
        this.reportChange(FileStatus.ADDED, before, after);
    }

    private void reportDeleted(String filepath, VcsRevisionNumber head) throws VcsException {
        ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, filepath, head, this.myProject, false);
        ContentRevision after = null;
        this.reportChange(FileStatus.DELETED, before, after);
    }

    private void reportRename(String filepath, String oldFilename, VcsRevisionNumber head) throws VcsException {
        ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, oldFilename, head, this.myProject, false);
        ContentRevision after = GitContentRevision.createRevision(this.myVcsRoot, filepath, null, this.myProject, false);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportConflict(String filepath, VcsRevisionNumber head) throws VcsException {
        ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, filepath, head, this.myProject, false);
        ContentRevision after = GitContentRevision.createRevision(this.myVcsRoot, filepath, null, this.myProject, false);
        this.reportChange(FileStatus.MERGED_WITH_CONFLICTS, before, after);
    }

    private void reportChange(FileStatus status, ContentRevision before, ContentRevision after) {
        this.myChanges.add(new Change(before, after, status));
    }
}

