/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserWithRollback
extends ChangesBrowserBase
implements Disposable {
    private final Set<Change> myOriginalChanges;

    public ChangesBrowserWithRollback(@NotNull Project project, @NotNull List<Change> changes) {
        super(project, false, true);
        this.myOriginalChanges = new HashSet<Change>(changes);
        new RollbackDialogAction().registerCustomShortcutSet((JComponent)((Object)this), null);
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.myViewer.rebuildTree();
    }

    public void dispose() {
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        return ContainerUtil.append((List)super.createToolbarActions(), (Object[])new AnAction[]{new RollbackDialogAction()});
    }

    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        return ContainerUtil.append((List)super.createPopupMenuActions(), (Object[])new AnAction[]{new RollbackDialogAction()});
    }

    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        Collection allChanges = ChangeListManager.getInstance((Project)this.myProject).getAllChanges();
        List newChanges = ContainerUtil.filter((Collection)allChanges, this.myOriginalChanges::contains);
        RemoteStatusChangeNodeDecorator decorator = RemoteRevisionsCache.getInstance((Project)this.myProject).getChangesNodeDecorator();
        return TreeModelBuilder.buildFromChanges((Project)this.myProject, (ChangesGroupingPolicyFactory)this.getGrouping(), (Collection)newChanges, (ChangeNodeDecorator)decorator);
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        @NotNull
        private final MergingUpdateQueue myUpdateQueue;

        private MyChangeListListener() {
            this.myUpdateQueue = new MergingUpdateQueue("ChangesBrowserWithRollback", 300, true, (JComponent)((Object)ChangesBrowserWithRollback.this), (Disposable)ChangesBrowserWithRollback.this);
        }

        private void doUpdate() {
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    ChangesBrowserWithRollback.this.myViewer.rebuildTree();
                }
            });
        }

        public void changeListsChanged() {
            this.doUpdate();
        }
    }
}

