/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.stash.GitStashUtils;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.validators.GitBranchNameValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class GitUnstashDialog
extends DialogWrapper {
    private JComboBox myGitRootComboBox;
    private JLabel myCurrentBranch;
    private JButton myViewButton;
    private JButton myDropButton;
    private JButton myClearButton;
    private JCheckBox myPopStashCheckBox;
    private JTextField myBranchTextField;
    private JPanel myPanel;
    private JList myStashList;
    private JCheckBox myReinstateIndexCheckBox;
    private final HashSet<String> myBranches;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(GitUnstashDialog.class);

    public GitUnstashDialog(final Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myBranches = new HashSet();
        this.setModal(false);
        this.myProject = project;
        this.setTitle(GitBundle.getString("unstash.title"));
        this.setOKButtonText(GitBundle.getString("unstash.button.apply"));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranch);
        this.myStashList.setModel(new DefaultListModel());
        this.refreshStashList();
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.refreshStashList();
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myStashList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myBranchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myPopStashCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == Messages.showYesNoDialog((Component)GitUnstashDialog.this.getContentPane(), (String)GitBundle.message("git.unstash.clear.confirmation.message", new Object[0]), (String)GitBundle.message("git.unstash.clear.confirmation.title", new Object[0]), (Icon)Messages.getWarningIcon())) {
                    final GitLineHandler h = new GitLineHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                    h.addParameters("clear");
                    new Task.Modal(project, GitBundle.getString("unstash.clearing.stashes"), false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            GitCommandResult result2 = Git.getInstance().runCommand(h);
                            if (!result2.success()) {
                                ApplicationManager.getApplication().invokeLater(() -> GitUIUtil.showOperationError(project, GitBundle.getString("unstash.clearing.stashes"), result2.getErrorOutputAsJoinedString()));
                            }
                        }

                        public void onFinished() {
                            GitUnstashDialog.this.refreshStashList();
                            GitUnstashDialog.this.updateDialogState();
                        }
                    }.queue();
                }
            }
        });
        this.myDropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final StashInfo stash = GitUnstashDialog.this.getSelectedStash();
                if (0 == Messages.showYesNoDialog((Component)GitUnstashDialog.this.getContentPane(), (String)GitBundle.message("git.unstash.drop.confirmation.message", stash.getStash(), stash.getMessage()), (String)GitBundle.message("git.unstash.drop.confirmation.title", stash.getStash()), (Icon)Messages.getQuestionIcon())) {
                    final ModalityState current = ModalityState.current();
                    ProgressManager.getInstance().run((Task)new Task.Modal(GitUnstashDialog.this.myProject, "Removing stash " + stash.getStash(), true){

                        public void run(@NotNull ProgressIndicator indicator) {
                            GitLineHandler h = this.dropHandler(stash.getStash());
                            try {
                                Git.getInstance().runCommand(h).throwOnError(new int[0]);
                            }
                            catch (VcsException ex) {
                                ApplicationManager.getApplication().invokeLater(() -> GitUIUtil.showOperationError(this.myProject, ex, h.printableCommandLine()), current);
                            }
                        }
                    });
                    GitUnstashDialog.this.refreshStashList();
                    GitUnstashDialog.this.updateDialogState();
                }
            }

            private GitLineHandler dropHandler(String stash) {
                GitLineHandler h = new GitLineHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                h.addParameters("drop", stash);
                return h;
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String resolvedStash;
                VirtualFile root = GitUnstashDialog.this.getGitRoot();
                String selectedStash = GitUnstashDialog.this.getSelectedStash().getStash();
                try {
                    GitLineHandler h = new GitLineHandler(project, root, GitCommand.REV_LIST);
                    h.setSilent(true);
                    h.addParameters("--timestamp", "--max-count=1", selectedStash);
                    h.endOptions();
                    String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
                    resolvedStash = GitRevisionNumber.parseRevlistOutputAsRevisionNumber(h, output).asString();
                }
                catch (VcsException ex) {
                    GitUIUtil.showOperationError(GitUnstashDialog.this.myProject, ex, "resolving revision");
                    return;
                }
                GitUtil.showSubmittedFiles(GitUnstashDialog.this.myProject, resolvedStash, root, true, false);
            }
        });
        this.init();
        this.updateDialogState();
    }

    private void updateDialogState() {
        String branch = this.myBranchTextField.getText();
        if (branch.length() != 0) {
            this.setOKButtonText(GitBundle.getString("unstash.button.branch"));
            this.myPopStashCheckBox.setEnabled(false);
            this.myPopStashCheckBox.setSelected(true);
            this.myReinstateIndexCheckBox.setEnabled(false);
            this.myReinstateIndexCheckBox.setSelected(true);
            if (!GitBranchNameValidator.INSTANCE.checkInput(branch)) {
                this.setErrorText(GitBundle.getString("unstash.error.invalid.branch.name"));
                this.setOKActionEnabled(false);
                return;
            }
            if (this.myBranches.contains(branch)) {
                this.setErrorText(GitBundle.getString("unstash.error.branch.exists"));
                this.setOKActionEnabled(false);
                return;
            }
        } else {
            if (!this.myPopStashCheckBox.isEnabled()) {
                this.myPopStashCheckBox.setSelected(false);
            }
            this.myPopStashCheckBox.setEnabled(true);
            this.setOKButtonText(this.myPopStashCheckBox.isSelected() ? GitBundle.getString("unstash.button.pop") : GitBundle.getString("unstash.button.apply"));
            if (!this.myReinstateIndexCheckBox.isEnabled()) {
                this.myReinstateIndexCheckBox.setSelected(false);
            }
            this.myReinstateIndexCheckBox.setEnabled(true);
        }
        if (this.myStashList.getModel().getSize() == 0) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.myClearButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myClearButton.setEnabled(true);
        if (this.myStashList.getSelectedIndex() == -1) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myViewButton.setEnabled(true);
        this.myDropButton.setEnabled(true);
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void refreshStashList() {
        DefaultListModel listModel = (DefaultListModel)this.myStashList.getModel();
        listModel.clear();
        VirtualFile root = this.getGitRoot();
        GitStashUtils.loadStashStack(this.myProject, root, (Consumer<StashInfo>)((Consumer)stashInfo -> listModel.addElement(stashInfo)));
        this.myBranches.clear();
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
        if (repository != null) {
            this.myBranches.addAll(GitBranchUtil.convertBranchesToNames(repository.getBranches().getLocalBranches()));
        } else {
            LOG.error("Repository is null for root " + root);
        }
        this.myStashList.setSelectedIndex(0);
    }

    private VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    private GitLineHandler handler() {
        GitLineHandler h = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.STASH);
        String branch = this.myBranchTextField.getText();
        if (branch.length() == 0) {
            h.addParameters(this.myPopStashCheckBox.isSelected() ? "pop" : "apply");
            if (this.myReinstateIndexCheckBox.isSelected()) {
                h.addParameters("--index");
            }
        } else {
            h.addParameters("branch", branch);
        }
        String selectedStash = this.getSelectedStash().getStash();
        h.addParameters(selectedStash);
        return h;
    }

    private StashInfo getSelectedStash() {
        return (StashInfo)this.myStashList.getSelectedValue();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Unstash";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStashList;
    }

    protected void doOKAction() {
        VirtualFile root = this.getGitRoot();
        GitLineHandler h = this.handler();
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashUtils.unstash(this.myProject, root, h, (GitConflictResolver)new UnstashConflictResolver(this.myProject, root, this.getSelectedStash())), GitBundle.getString("unstash.unstashing"), true, this.myProject);
        if (completed) {
            super.doOKAction();
        }
    }

    public static void showUnstashDialog(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot) {
        new GitUnstashDialog(project, gitRoots, defaultRoot).show();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRootComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setText("  ");
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.stashes"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myViewButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.view"));
        jButton3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.view.tooltip"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDropButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.drop"));
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.drop.tooltip"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myClearButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.clear"));
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.clear.tooltip"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.branch.label:"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchTextField = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.branch.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myStashList = jBList;
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPopStashCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.pop.stash"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.pop.stash.tooltip"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReinstateIndexCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.reinstate.index"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.reinstate.index.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor((Component)jBScrollPane);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private final StashInfo myStashInfo;

        UnstashMergeDialogCustomizer(StashInfo stashInfo) {
            this.myStashInfo = stashInfo;
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            return "<html>Conflicts during unstashing <code>" + this.myStashInfo.getStash() + "\"" + this.myStashInfo.getMessage() + "\"</code></html>";
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            return "Local changes";
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
            return "Changes from stash";
        }
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final VirtualFile myRoot;
        private final StashInfo myStashInfo;

        UnstashConflictResolver(Project project, VirtualFile root, StashInfo stashInfo) {
            super(project, Git.getInstance(), Collections.singleton(root), UnstashConflictResolver.makeParams(project, stashInfo));
            this.myRoot = root;
            this.myStashInfo = stashInfo;
        }

        private static GitConflictResolver.Params makeParams(Project project, StashInfo stashInfo) {
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle("Unstashed with conflicts");
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer(stashInfo));
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Conflicts were not resolved during unstash", "Unstash is not complete, you have unresolved merges in your working tree<br/><a href='resolve'>Resolve</a> conflicts.", new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                        new UnstashConflictResolver(myProject, myRoot, myStashInfo).mergeNoProceed();
                    }
                }
            });
        }
    }
}

