/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsBranchPopup;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopup
extends DvcsBranchPopup<GitRepository> {
    private static final String DIMENSION_SERVICE_KEY = "Git.Branch.Popup";
    static final String SHOW_ALL_LOCALS_KEY = "Git.Branch.Popup.ShowAllLocals";
    static final String SHOW_ALL_REMOTES_KEY = "Git.Branch.Popup.ShowAllRemotes";
    static final String SHOW_ALL_REPOSITORIES = "Git.Branch.Popup.ShowAllRepositories";

    static GitBranchPopup getInstance(@NotNull Project project, @NotNull GitRepository currentRepository) {
        GitVcsSettings vcsSettings = GitVcsSettings.getInstance(project);
        Condition preselectActionCondition = action -> {
            GitBranchPopupActions.LocalBranchActions branchAction = GitBranchPopup.getBranchAction(action);
            if (branchAction != null) {
                String branchName = branchAction.getBranchName();
                List<GitRepository> repositories = branchAction.getRepositories();
                String recentBranch = repositories.size() == 1 ? vcsSettings.getRecentBranchesByRepository().get(repositories.iterator().next().getRoot().getPath()) : vcsSettings.getRecentCommonBranch();
                if (recentBranch != null && recentBranch.equals(branchName)) {
                    return true;
                }
            }
            return false;
        };
        return new GitBranchPopup(currentRepository, GitUtil.getRepositoryManager(project), vcsSettings, (Condition<AnAction>)preselectActionCondition);
    }

    @Nullable
    private static GitBranchPopupActions.LocalBranchActions getBranchAction(@NotNull AnAction action) {
        AnAction resultAction = action instanceof EmptyAction.MyDelegatingActionGroup ? ((EmptyAction.MyDelegatingActionGroup)action).getDelegate() : action;
        return (GitBranchPopupActions.LocalBranchActions)((Object)ObjectUtils.tryCast((Object)resultAction, GitBranchPopupActions.LocalBranchActions.class));
    }

    private GitBranchPopup(@NotNull GitRepository currentRepository, @NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        super((Repository)currentRepository, (AbstractRepositoryManager)repositoryManager, (DvcsMultiRootBranchConfig)new GitMultiRootBranchConfig(repositoryManager.getRepositories()), (DvcsSyncSettings)vcsSettings, preselectActionCondition, DIMENSION_SERVICE_KEY);
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
        if (GitVcsSettings.getInstance(this.myProject).shouldUpdateBranchInfo() && !gitBranchIncomingOutgoingManager.supportsIncomingOutgoing()) {
            this.myPopup.addToolbarAction(GitBranchPopup.createWarningAction("Update checks not supported. Git 2.9+ required", (Consumer<AnActionEvent>)((Consumer)e -> ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, "Git"))), false);
        } else if (GitVcsSettings.getInstance(this.myProject).shouldUpdateBranchInfo() && gitBranchIncomingOutgoingManager.hasAuthenticationProblems()) {
            this.myPopup.addToolbarAction(GitBranchPopup.createWarningAction("Update checks failed. Click to retry", (Consumer<AnActionEvent>)((Consumer)e -> {
                gitBranchIncomingOutgoingManager.forceUpdateBranches(true);
                this.myPopup.cancel();
            })), false);
        }
    }

    @NotNull
    private static AnAction createWarningAction(@NotNull String text, @NotNull Consumer<AnActionEvent> actionEventConsumer) {
        DumbAwareAction updateBranchInfoWithAuthenticationAction = DumbAwareAction.create((String)text, actionEventConsumer);
        Presentation presentation = updateBranchInfoWithAuthenticationAction.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.Warning);
        presentation.setHoveredIcon(AllIcons.General.Warning);
        return updateBranchInfoWithAuthenticationAction;
    }

    protected void fillWithCommonRepositoryActions(@NotNull LightActionGroup popupGroup, @NotNull AbstractRepositoryManager<GitRepository> repositoryManager) {
        List allRepositories = repositoryManager.getRepositories();
        GitRebaseSpec rebaseSpec = GitUtil.getRepositoryManager(this.myProject).getOngoingRebaseSpec();
        if (rebaseSpec != null && rebaseSpec.getAllRepositories().size() == allRepositories.size()) {
            popupGroup.addAll(GitBranchPopupActions.getRebaseActions());
        }
        popupGroup.add((AnAction)new GitBranchPopupActions.GitNewBranchAction(this.myProject, allRepositories));
        popupGroup.add((AnAction)new GitBranchPopupActions.CheckoutRevisionActions(this.myProject, allRepositories));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator("Common Local Branches");
        List localBranchActions = this.myMultiRootBranchConfig.getLocalBranchNames().stream().map(l -> this.createLocalBranchActions(allRepositories, (String)l)).filter(Objects::nonNull).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR).collect(Collectors.toList());
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches(localBranchActions);
        String currentBranch = MultiRootBranches.getCommonCurrentBranch((Collection)allRepositories);
        if (currentBranch != null) {
            localBranchActions.add(0, new GitBranchPopupActions.CurrentBranchActions(this.myProject, allRepositories, currentBranch, (GitRepository)this.myCurrentRepository));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, localBranchActions, (int)topShownBranches, (String)SHOW_ALL_LOCALS_KEY, (boolean)true);
        popupGroup.addSeparator("Common Remote Branches");
        List remoteBranchActions = ContainerUtil.map(((GitMultiRootBranchConfig)this.myMultiRootBranchConfig).getRemoteBranches(), remoteBranch -> new GitBranchPopupActions.RemoteBranchActions(this.myProject, allRepositories, (String)remoteBranch, (GitRepository)this.myCurrentRepository));
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)SHOW_ALL_REMOTES_KEY);
    }

    @Nullable
    private GitBranchPopupActions.LocalBranchActions createLocalBranchActions(@NotNull List<GitRepository> allRepositories, @NotNull String branch) {
        List repositories = this.filterRepositoriesNotOnThisBranch(branch, allRepositories);
        return repositories.isEmpty() ? null : new GitBranchPopupActions.LocalBranchActions(this.myProject, repositories, branch, (GitRepository)this.myCurrentRepository);
    }

    @NotNull
    protected LightActionGroup createRepositoriesActions() {
        LightActionGroup popupGroup = new LightActionGroup(false);
        popupGroup.addSeparator("Repositories");
        List rootActions = DvcsUtil.sortRepositories((Collection)this.myRepositoryManager.getRepositories()).stream().map(repo -> new RootAction((Repository)repo, new GitBranchPopupActions(repo.getProject(), (GitRepository)repo).createActions(), GitBranchUtil.getDisplayableBranchText(repo))).collect(Collectors.toList());
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, rootActions, (int)(rootActions.size() > 8 ? 5 : 8), (String)SHOW_ALL_REPOSITORIES);
        return popupGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull LightActionGroup popupGroup, @Nullable LightActionGroup actions) {
        popupGroup.addAll(new GitBranchPopupActions(((GitRepository)this.myCurrentRepository).getProject(), (GitRepository)this.myCurrentRepository).createActions(actions, this.myRepoTitleInfo, true));
    }
}

