/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import git4idea.GitLocalBranch;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitReference;
import git4idea.actions.GitAbstractRebaseAction;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.ui.branch.GitRefDialog;
import git4idea.validators.GitNewBranchNameValidator;
import icons.DvcsImplIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopupActions {
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, "", false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @NotNull String repoInfo, boolean firstLevelGroup) {
        LightActionGroup popupGroup = new LightActionGroup(false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        if (this.myRepository.isRebaseInProgress()) {
            GitRebaseSpec rebaseSpec = GitRepositoryManager.getInstance(this.myProject).getOngoingRebaseSpec();
            popupGroup.addAll(rebaseSpec != null && GitBranchPopupActions.isSpecForRepo(rebaseSpec, this.myRepository) ? GitBranchPopupActions.getRebaseActions() : GitBranchPopupActions.createPerRepoRebaseActions(this.myRepository));
        }
        popupGroup.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        popupGroup.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Local Branches" + repoInfo);
        GitLocalBranch currentBranch = this.myRepository.getCurrentBranch();
        GitBranchesCollection branchesCollection = this.myRepository.getBranches();
        List localBranchActions = ((StreamEx)((StreamEx)StreamEx.of(branchesCollection.getLocalBranches()).filter(branch -> !branch.equals(currentBranch))).map(branch -> new LocalBranchActions(this.myProject, repositoryList, branch.getName(), this.myRepository)).sorted((b1, b2) -> {
            int delta = BranchActionUtil.FAVORITE_BRANCH_COMPARATOR.compare(b1, b2);
            if (delta != 0) {
                return delta;
            }
            return StringUtil.naturalCompare((String)b1.myBranchName, (String)b2.myBranchName);
        })).toList();
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches((List)localBranchActions);
        if (currentBranch != null) {
            localBranchActions.add(0, new CurrentBranchActions(this.myProject, repositoryList, currentBranch.getName(), this.myRepository));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)localBranchActions, (int)topShownBranches, (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllLocals" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator("Remote Branches" + repoInfo);
        List remoteBranchActions = ((StreamEx)StreamEx.of(branchesCollection.getRemoteBranches()).map(GitReference::getName).sorted(StringUtil::naturalCompare)).map(remoteName -> new RemoteBranchActions(this.myProject, repositoryList, (String)remoteName, this.myRepository)).toList();
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllRemotes" : null));
        return popupGroup;
    }

    private static boolean isSpecForRepo(@NotNull GitRebaseSpec spec, @NotNull GitRepository repository) {
        Collection<GitRepository> repositoriesFromSpec = spec.getAllRepositories();
        return repositoriesFromSpec.size() == 1 && repository.equals(ContainerUtil.getFirstItem(repositoriesFromSpec));
    }

    @NotNull
    private static List<AnAction> createPerRepoRebaseActions(@NotNull GitRepository repository) {
        return Arrays.asList(GitBranchPopupActions.createRepositoryRebaseAction("Git.Rebase.Abort", repository), GitBranchPopupActions.createRepositoryRebaseAction("Git.Rebase.Continue", repository), GitBranchPopupActions.createRepositoryRebaseAction("Git.Rebase.Skip", repository));
    }

    @NotNull
    static List<AnAction> getRebaseActions() {
        ActionManager actionManager = ActionManager.getInstance();
        return Arrays.asList(actionManager.getAction("Git.Rebase.Abort"), actionManager.getAction("Git.Rebase.Continue"), actionManager.getAction("Git.Rebase.Skip"));
    }

    @NotNull
    private static AnAction createRepositoryRebaseAction(@NotNull String rebaseActionId, final @NotNull GitRepository repository) {
        final GitAbstractRebaseAction rebaseAction = (GitAbstractRebaseAction)((Object)ObjectUtils.notNull((Object)((Object)((GitAbstractRebaseAction)ActionManager.getInstance().getAction(rebaseActionId)))));
        DumbAwareAction repositoryAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(repository.isRebaseInProgress());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                rebaseAction.performInBackground(repository);
            }
        };
        repositoryAction.getTemplatePresentation().copyFrom(rebaseAction.getTemplatePresentation());
        return repositoryAction;
    }

    @NotNull
    private static String getCurrentBranchPresentation(@NotNull Collection<GitRepository> repositories) {
        Set currentBranches = ContainerUtil.map2Set(repositories, repo -> (String)ObjectUtils.notNull((Object)repo.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)((String)ObjectUtils.notNull((Object)repo.getCurrentRevision())))));
        if (currentBranches.size() == 1) {
            return GitBranchPopupActions.getBranchPresentation((String)currentBranches.iterator().next());
        }
        return "current branch";
    }

    @NotNull
    private static String getBranchPresentation(@NotNull String branch) {
        return "'" + branch + "'";
    }

    static class TagActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myTagName;
        private final GitRepository mySelectedRepository;

        TagActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String tagName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myTagName = tagName;
            this.mySelectedRepository = selectedRepository;
            this.getTemplatePresentation().setText(tagName, false);
            this.setIcons(EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new DeleteTagAction(this.myProject, this.myRepositories, this.myTagName)};
        }

        private static class DeleteTagAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myTagName;

            DeleteTagAction(Project project, List<GitRepository> repositories, String tagName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myTagName = tagName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteTag(this.myTagName, this.myRepositories);
            }
        }
    }

    private static class CheckoutWithRebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            super("Checkout and Rebase onto Current");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            String description = String.format("Checkout %s, and rebase it onto %s in one step (like `git rebase HEAD %s`)", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories), this.myBranchName);
            e.getPresentation().setDescription(description);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        RebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            super("Rebase Current onto Selected");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isOnBranch = ContainerUtil.and(this.myRepositories, GitRepository::isOnBranch);
            String description = isOnBranch ? String.format("Rebase %s onto %s", GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories), GitBranchPopupActions.getBranchPresentation(this.myBranchName)) : "Rebase is not possible in the detached HEAD state";
            e.getPresentation().setDescription(description);
            e.getPresentation().setEnabled(isOnBranch);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebase(this.myRepositories, this.myBranchName);
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        MergeAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, boolean localBranch) {
            super("Merge into Current");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void update(@NotNull AnActionEvent e) {
            String description = String.format("Merge %s into %s", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories));
            e.getPresentation().setDescription(description);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final GitRepository mySelectedRepository;

        CompareAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            super("Compare with Current");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.compare(this.myBranchName, this.myRepositories, this.mySelectedRepository);
        }

        public void update(@NotNull AnActionEvent e) {
            String description = String.format("Compare commits in %1$s and %2$s, and the file tree in %1$s and its current state", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories));
            e.getPresentation().setDescription(description);
        }
    }

    static class RemoteBranchActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        RemoteBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(!GitProtectedBranchesKt.isRemoteBranchProtected(this.myRepositories, this.myBranchName));
            }
        }

        private static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myRemoteBranchName;

            CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String remoteBranchName) {
                super("Checkout As...");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"New branch name:", (String)"Checkout Remote Branch", null, (String)this.guessBranchName(), (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.checkoutNewBranchStartingFrom(name, this.myRemoteBranchName, this.myRepositories, null);
                }
            }

            private String guessBranchName() {
                int slashPosition = this.myRemoteBranchName.indexOf("/");
                return this.myRemoteBranchName.substring(slashPosition + 1);
            }
        }
    }

    static class CurrentBranchActions
    extends LocalBranchActions {
        CurrentBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            super(project, repositories, branchName, selectedRepository);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new LocalBranchActions.RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName)};
        }
    }

    static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        protected final Project myProject;
        protected final List<GitRepository> myRepositories;
        protected final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;
        @NotNull
        private final GitVcsSettings myGitVcsSettings;
        @NotNull
        private final GitBranchIncomingOutgoingManager myIncomingOutgoingManager;

        LocalBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.myGitVcsSettings = GitVcsSettings.getInstance(this.myProject);
            this.myIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            this.getTemplatePresentation().setText(this.calcBranchText(), false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        private String calcBranchText() {
            return this.myBranchName;
        }

        @NotNull
        List<GitRepository> getRepositories() {
            return this.myRepositories;
        }

        @NotNull
        public String getBranchName() {
            return this.myBranchName;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new Separator(), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.chooseRepo(), this.myBranchName, this.isFavorite());
        }

        @Nullable
        private GitRepository chooseRepo() {
            return this.myRepositories.size() > 1 ? null : this.mySelectedRepository;
        }

        public boolean hasIncomingCommits() {
            return this.myGitVcsSettings.shouldUpdateBranchInfo() && this.myIncomingOutgoingManager.hasIncomingFor(this.chooseRepo(), this.myBranchName);
        }

        public boolean hasOutgoingCommits() {
            return this.myGitVcsSettings.shouldUpdateBranchInfo() && this.myIncomingOutgoingManager.hasOutgoingFor(this.chooseRepo(), this.myBranchName);
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<GitRepository> repositories, String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteBranch(this.myBranchName, this.myRepositories);
            }
        }

        private static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            RenameBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String currentBranchName) {
                super("Rename...");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                String newName = Messages.showInputDialog((Project)this.myProject, (String)("New name for the branch '" + this.myCurrentBranchName + "':"), (String)("Rename Branch " + this.myCurrentBranchName), null, (String)this.myCurrentBranchName, (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (newName != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.renameBranch(this.myCurrentBranchName, newName, this.myRepositories);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (this.myRepositories.stream().anyMatch(Repository::isFresh)) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setDescription("Renaming branch is not possible before the first commit");
                }
            }
        }

        private static class CheckoutAsNewBranch
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAsNewBranch(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                super("Checkout As...");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"New branch name:", (String)("Checkout New Branch From " + this.myBranchName), null, (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.checkoutNewBranchStartingFrom(name, this.myBranchName, this.myRepositories, null);
                }
            }
        }

        private static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                super("Checkout");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(this.myBranchName, false, this.myRepositories, null);
            }
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories) {
            super("Checkout Tag or Revision...");
            this.myProject = project;
            this.myRepositories = repositories;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitRefDialog dialog = new GitRefDialog(this.myProject, this.myRepositories, "Checkout", "Enter reference (branch, tag) name or commit hash:");
            if (dialog.showAndGet()) {
                String reference = dialog.getReference();
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(reference, true, this.myRepositories, null);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isFresh = ContainerUtil.and(this.myRepositories, repository -> repository.isFresh());
            if (isFresh) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Checkout is not possible before the first commit");
            }
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            super(project, repositories);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitNewBranchOptions options = GitBranchUtil.getNewBranchNameFromUser(this.myProject, this.myRepositories, "Create New Branch", null);
            if (options != null) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                if (options.shouldCheckout()) {
                    brancher.checkoutNewBranch(options.getName(), this.myRepositories);
                } else {
                    brancher.createBranch(options.getName(), StreamEx.of((Collection)this.myRepositories).toMap(position -> "HEAD"));
                }
            }
        }
    }
}

