/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitLogBranchOperationsActionGroup
extends ActionGroup
implements DumbAware {
    private static final int MAX_BRANCH_GROUPS = 2;
    private static final int MAX_TAG_GROUPS = 1;

    public GitLogBranchOperationsActionGroup() {
        this.setPopup(false);
    }

    public boolean hideIfNoVisibleChildren() {
        return true;
    }

    @NotNull
    public AnAction[] getChildren(AnActionEvent e) {
        if (e == null) {
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        List refs = (List)e.getData(VcsLogDataKeys.VCS_LOG_REFS);
        if (project == null || log == null || logUI == null || refs == null) {
            return AnAction.EMPTY_ARRAY;
        }
        List commits2 = log.getSelectedCommits();
        if (commits2.size() != 1) {
            return AnAction.EMPTY_ARRAY;
        }
        CommitId commit2 = (CommitId)commits2.get(0);
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        GitRepository root = (GitRepository)repositoryManager.getRepositoryForRoot(commit2.getRoot());
        if (root == null) {
            return AnAction.EMPTY_ARRAY;
        }
        List branchRefs = ContainerUtil.filter((Collection)refs, ref -> {
            if (ref.getType() == GitRefManager.LOCAL_BRANCH) {
                return !ref.getName().equals(root.getCurrentBranchName());
            }
            return ref.getType() == GitRefManager.REMOTE_BRANCH;
        });
        List tagRefs = ContainerUtil.filter((Collection)refs, ref -> ref.getType() == GitRefManager.TAG);
        VcsLogProvider provider = (VcsLogProvider)logUI.getDataPack().getLogProviders().get(root.getRoot());
        if (provider != null) {
            VcsLogRefManager refManager = provider.getReferenceManager();
            Comparator comparator = refManager.getLabelsOrderComparator();
            ContainerUtil.sort((List)branchRefs, (Comparator)comparator);
            ContainerUtil.sort((List)tagRefs, (Comparator)comparator);
        }
        ArrayList<DefaultActionGroup> groups = new ArrayList<DefaultActionGroup>();
        if (!branchRefs.isEmpty()) {
            GitVcsSettings settings = GitVcsSettings.getInstance(project);
            boolean showBranchesPopup = branchRefs.size() > 2;
            List<GitRepository> allRepositories = repositoryManager.getRepositories();
            THashSet commonBranches = new THashSet(GitReference.BRANCH_NAME_HASHING_STRATEGY);
            for (GitLocalBranch gitLocalBranch : GitBranchUtil.getCommonLocalBranches((Collection<? extends GitRepository>)allRepositories)) {
                commonBranches.add(gitLocalBranch.getName());
            }
            for (GitRemoteBranch gitRemoteBranch : GitBranchUtil.getCommonRemoteBranches((Collection<? extends GitRepository>)allRepositories)) {
                commonBranches.add(gitRemoteBranch.getName());
            }
            ArrayList<AnAction> branchActionGroups = new ArrayList<AnAction>();
            for (VcsRef ref2 : branchRefs) {
                branchActionGroups.add(GitLogBranchOperationsActionGroup.createBranchGroup(project, ref2, root, allRepositories, (Set<String>)commonBranches, settings, showBranchesPopup));
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup("Branches", branchActionGroups);
            defaultActionGroup.setPopup(showBranchesPopup);
            groups.add(defaultActionGroup);
        }
        if (!tagRefs.isEmpty()) {
            boolean showTagsPopup = tagRefs.size() > 1;
            ArrayList<AnAction> tagActionGroups = new ArrayList<AnAction>();
            for (VcsRef ref3 : tagRefs) {
                tagActionGroups.add(GitLogBranchOperationsActionGroup.createTagGroup(project, ref3, root, showTagsPopup));
            }
            DefaultActionGroup tagsGroup = new DefaultActionGroup("Tags", tagActionGroups);
            tagsGroup.setPopup(showTagsPopup);
            groups.add(tagsGroup);
        }
        return groups.toArray(AnAction.EMPTY_ARRAY);
    }

    @NotNull
    private static AnAction createBranchGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, @NotNull List<GitRepository> allRepositories, @NotNull Set<String> commonBranches, @NotNull GitVcsSettings settings, boolean showBranchesPopup) {
        boolean isSyncBranch = settings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC && allRepositories.size() > 1 && commonBranches.contains(ref.getName());
        boolean isLocal = ref.getType() == GitRefManager.LOCAL_BRANCH;
        ArrayList<Object> actions = new ArrayList<Object>(3);
        if (isSyncBranch) {
            ActionGroup allReposActions = GitLogBranchOperationsActionGroup.createBranchActions(project, allRepositories, ref, repository, isLocal);
            allReposActions.getTemplatePresentation().setText("In All Repositories");
            allReposActions.setPopup(true);
            actions.add(allReposActions);
            actions.add(Separator.getInstance());
        }
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createBranchActions(project, Collections.singletonList(repository), ref, repository, isLocal);
        singleRepoActions.setPopup(false);
        actions.add(singleRepoActions);
        String text = showBranchesPopup ? ref.getName() : "Branch '" + ref.getName() + "'";
        DefaultActionGroup group = new DefaultActionGroup(actions);
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        return group;
    }

    @NotNull
    private static AnAction createTagGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, boolean showTagsPopup) {
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createTagActions(project, Collections.singletonList(repository), ref, repository);
        singleRepoActions.setPopup(false);
        String text = showTagsPopup ? ref.getName() : "Tag '" + ref.getName() + "'";
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{singleRepoActions});
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        return group;
    }

    @NotNull
    private static ActionGroup createBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull VcsRef ref, @NotNull GitRepository selectedRepository, boolean isLocal) {
        if (isLocal) {
            return new GitBranchPopupActions.LocalBranchActions(project, repositories, ref.getName(), selectedRepository);
        }
        return new GitBranchPopupActions.RemoteBranchActions(project, repositories, ref.getName(), selectedRepository);
    }

    @NotNull
    private static ActionGroup createTagActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull VcsRef ref, @NotNull GitRepository selectedRepository) {
        return new GitBranchPopupActions.TagActions(project, repositories, ref.getName(), selectedRepository);
    }
}

