/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.history.GitLogUtil;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class GitRebaseOverMergeProblem {
    private static final Logger LOG = Logger.getInstance(GitRebaseOverMergeProblem.class);
    public static final String DESCRIPTION = "You are about to rebase a merge commit with conflicts.\n\nChoose 'Merge' if you don't want to resolve conflicts again, or you still can rebase if you want to linearize the history.";

    public static boolean hasProblem(@NotNull Project project, @NotNull VirtualFile root, @NotNull String baseRef, @NotNull String currentRef) {
        String range = baseRef + ".." + currentRef;
        try {
            List<GitCommit> commits2 = GitLogUtil.collectFullDetails(project, root, range, "--merges");
            return StreamEx.of(commits2).anyMatch(commit2 -> !commit2.getChanges().isEmpty());
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get git log --merges " + range, (Throwable)e);
            return false;
        }
    }

    @NotNull
    public static Decision showDialog() {
        Ref decision = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> decision.set((Object)GitRebaseOverMergeProblem.doShowDialog()));
        return (Decision)((Object)decision.get());
    }

    @NotNull
    private static Decision doShowDialog() {
        int decision = DialogManager.showMessage(DESCRIPTION, "Rebasing Merge Commits", Decision.getButtonTitles(), Decision.getDefaultButtonIndex(), Decision.getFocusedButtonIndex(), Messages.getWarningIcon(), null);
        return Decision.getOption(decision);
    }

    public static enum Decision {
        MERGE_INSTEAD("Merge"),
        REBASE_ANYWAY("Rebase"),
        CANCEL_OPERATION(CommonBundle.getCancelButtonText());

        private final String myButtonText;

        private Decision(String buttonText) {
            this.myButtonText = buttonText;
        }

        @NotNull
        private static String[] getButtonTitles() {
            return (String[])ContainerUtil.map2Array((Object[])Decision.values(), String.class, decision -> decision.myButtonText);
        }

        @NotNull
        public static Decision getOption(int index) {
            return (Decision)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.find((Object[])Decision.values(), decision -> decision.ordinal() == index)));
        }

        private static int getDefaultButtonIndex() {
            return MERGE_INSTEAD.ordinal();
        }

        private static int getFocusedButtonIndex() {
            return REBASE_ANYWAY.ordinal();
        }
    }
}

