/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.fetch.GitFetchSupport;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitSubmoduleUpdater;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateProcess {
    private static final Logger LOG = Logger.getInstance(GitUpdateProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final List<GitRepository> myRepositories;
    @NotNull
    private final Map<GitRepository, GitSubmodule> mySubmodulesInDetachedHead;
    private final boolean myCheckRebaseOverMergeProblem;
    private final boolean myCheckForTrackedBranchExistence;
    private final UpdatedFiles myUpdatedFiles;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final GitMerger myMerger;
    @NotNull
    private final Map<GitRepository, String> mySkippedRoots = new LinkedHashMap<GitRepository, String>();

    public GitUpdateProcess(@NotNull Project project, @Nullable ProgressIndicator progressIndicator, @NotNull Collection<GitRepository> repositories, @NotNull UpdatedFiles updatedFiles, boolean checkRebaseOverMergeProblem, boolean checkForTrackedBranchExistence) {
        this.myProject = project;
        this.myCheckRebaseOverMergeProblem = checkRebaseOverMergeProblem;
        this.myCheckForTrackedBranchExistence = checkForTrackedBranchExistence;
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myUpdatedFiles = updatedFiles;
        this.myRepositories = GitUtil.getRepositoryManager(project).sortByDependency(repositories);
        this.myProgressIndicator = progressIndicator == null ? new EmptyProgressIndicator() : progressIndicator;
        this.myMerger = new GitMerger(this.myProject);
        for (GitRepository repository : this.myRepositories) {
            repository.update();
        }
        this.mySubmodulesInDetachedHead = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : this.myRepositories) {
            GitSubmodule submodule;
            if (repository.isOnBranch() || (submodule = GitSubmoduleKt.asSubmodule(repository)) == null) continue;
            this.mySubmodulesInDetachedHead.put(repository, submodule);
        }
    }

    @NotNull
    public GitUpdateResult update(UpdateMethod updateMethod) {
        GitUpdateResult result2;
        LOG.info("update started|" + (Object)((Object)updateMethod));
        String oldText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText("Updating...");
        if (this.checkRebaseInProgress() || this.isMergeInProgress() || this.areUnmergedFiles()) {
            return GitUpdateResult.NOT_READY;
        }
        Map<GitRepository, GitBranchPair> trackedBranches = this.checkTrackedBranchesConfiguration();
        if (ContainerUtil.isEmpty(trackedBranches)) {
            return GitUpdateResult.NOT_READY;
        }
        if (!this.fetchAndNotify(this.myRepositories)) {
            return GitUpdateResult.NOT_READY;
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"VCS Update");){
            result2 = this.updateImpl(updateMethod);
        }
        this.myProgressIndicator.setText(oldText);
        return result2;
    }

    @NotNull
    private GitUpdateResult updateImpl(@NotNull UpdateMethod updateMethod) {
        Collection<GitRepository> problematicRoots;
        Map<GitRepository, GitUpdater> updaters;
        Map<GitRepository, GitBranchPair> trackedBranches = this.checkTrackedBranchesConfiguration();
        if (trackedBranches == null) {
            return GitUpdateResult.NOT_READY;
        }
        try {
            updaters = this.defineUpdaters(updateMethod, trackedBranches);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            GitUIUtil.notifyError(this.myProject, "Git update failed", e.getMessage(), true, (Exception)((Object)e));
            return GitUpdateResult.ERROR;
        }
        if (updaters.isEmpty()) {
            return GitUpdateResult.NOTHING_TO_UPDATE;
        }
        if ((updaters = this.tryFastForwardMergeForRebaseUpdaters(updaters)).isEmpty()) {
            return GitUpdateResult.SUCCESS;
        }
        if (this.myCheckRebaseOverMergeProblem && !(problematicRoots = this.findRootsRebasingOverMerge(updaters)).isEmpty()) {
            Object decision = GitRebaseOverMergeProblem.showDialog();
            if (decision == GitRebaseOverMergeProblem.Decision.MERGE_INSTEAD) {
                for (GitRepository repo : problematicRoots) {
                    GitBranchPair branchAndTracked = trackedBranches.get(repo);
                    if (branchAndTracked == null) {
                        LOG.error("No tracked branch information for root " + repo.getRoot());
                        continue;
                    }
                    updaters.put(repo, new GitMergeUpdater(this.myProject, this.myGit, repo, branchAndTracked, this.myProgressIndicator, this.myUpdatedFiles));
                }
            } else if (decision == GitRebaseOverMergeProblem.Decision.CANCEL_OPERATION) {
                return GitUpdateResult.CANCEL;
            }
        }
        ArrayList myRootsToSave = ContainerUtil.newArrayList();
        LOG.info("updateImpl: identifying if save is needed...");
        for (Map.Entry entry : updaters.entrySet()) {
            GitRepository repo;
            repo = (GitRepository)entry.getKey();
            GitUpdater updater = (GitUpdater)entry.getValue();
            if (!updater.isSaveNeeded()) continue;
            myRootsToSave.add(repo.getRoot());
            LOG.info("update| root " + repo + " needs save");
        }
        LOG.info("updateImpl: saving local changes...");
        Ref incomplete = Ref.create((Object)false);
        Ref ref = Ref.create();
        Map<GitRepository, GitUpdater> finalUpdaters = updaters;
        new GitPreservingProcess(this.myProject, this.myGit, myRootsToSave, "Update", "Remote", GitVcsSettings.getInstance(this.myProject).updateChangesPolicy(), this.myProgressIndicator, () -> {
            LOG.info("updateImpl: updating...");
            GitRepository currentlyUpdatedRoot = null;
            try {
                for (GitRepository repo : finalUpdaters.keySet()) {
                    GitUpdater updater = (GitUpdater)finalUpdaters.get(repo);
                    if (updater == null) continue;
                    currentlyUpdatedRoot = repo;
                    GitUpdateResult res = updater.update();
                    LOG.info("updating root " + currentlyUpdatedRoot + " finished: " + (Object)((Object)res));
                    if (res == GitUpdateResult.INCOMPLETE) {
                        incomplete.set((Object)true);
                    }
                    compoundResult.set((Object)GitUpdateProcess.joinResults((GitUpdateResult)((Object)((Object)((Object)compoundResult.get()))), res));
                }
            }
            catch (VcsException e) {
                String rootName = currentlyUpdatedRoot == null ? "" : DvcsUtil.getShortRepositoryName(currentlyUpdatedRoot);
                LOG.info("Error updating changes for root " + currentlyUpdatedRoot, (Throwable)e);
                GitUIUtil.notifyImportantError(this.myProject, "Error updating " + rootName, "Updating " + rootName + " failed with an error: " + e.getLocalizedMessage());
            }
        }).execute((Computable<Boolean>)((Computable)() -> (Boolean)incomplete.get() == false && !compoundResult.isNull() && ((GitUpdateResult)((Object)((Object)((Object)compoundResult.get())))).isSuccess()));
        return (GitUpdateResult)((Object)ObjectUtils.notNull((Object)ref.get(), (Object)((Object)GitUpdateResult.ERROR)));
    }

    @NotNull
    private Collection<GitRepository> findRootsRebasingOverMerge(@NotNull Map<GitRepository, GitUpdater> updaters) {
        return ContainerUtil.mapNotNull(updaters.keySet(), repo -> {
            GitUpdater updater = (GitUpdater)updaters.get(repo);
            if (updater instanceof GitRebaseUpdater) {
                String currentRef = ((GitRebaseUpdater)updater).getSourceAndTarget().getBranch().getFullName();
                String baseRef = ((GitRemoteBranch)ObjectUtils.assertNotNull((Object)((GitRebaseUpdater)updater).getSourceAndTarget().getDest())).getFullName();
                return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo : null;
            }
            return null;
        });
    }

    @NotNull
    private Map<GitRepository, GitUpdater> tryFastForwardMergeForRebaseUpdaters(@NotNull Map<GitRepository, GitUpdater> updaters) {
        LinkedHashMap<GitRepository, GitUpdater> modifiedUpdaters = new LinkedHashMap<GitRepository, GitUpdater>();
        Map changesUnderRoots = new LocalChangesUnderRoots(this.myChangeListManager, this.myVcsManager).getChangesUnderRoots(GitUtil.getRootsFromRepositories(updaters.keySet()));
        for (GitRepository repository : updaters.keySet()) {
            GitRebaseUpdater rebaseUpdater;
            GitUpdater updater = updaters.get(repository);
            Collection changes = (Collection)changesUnderRoots.get(repository.getRoot());
            LOG.debug("Changes under root '" + DvcsUtil.getShortRepositoryName((Repository)repository) + "': " + changes);
            if (updater instanceof GitRebaseUpdater && changes != null && !changes.isEmpty() && (rebaseUpdater = (GitRebaseUpdater)updater).fastForwardMerge()) continue;
            modifiedUpdaters.put(repository, updater);
        }
        return modifiedUpdaters;
    }

    @NotNull
    private Map<GitRepository, GitUpdater> defineUpdaters(@NotNull UpdateMethod updateMethod, @NotNull Map<GitRepository, GitBranchPair> trackedBranches) throws VcsException {
        LinkedHashMap<GitRepository, GitUpdater> updaters = new LinkedHashMap<GitRepository, GitUpdater>();
        for (GitRepository repository : trackedBranches.keySet()) {
            GitBranchPair branchAndTracked = trackedBranches.get(repository);
            GitUpdater updater = GitUpdater.getUpdater(this.myProject, this.myGit, branchAndTracked, repository, this.myProgressIndicator, this.myUpdatedFiles, updateMethod);
            if (!updater.isUpdateNeeded(branchAndTracked)) continue;
            updaters.put(repository, updater);
        }
        for (GitRepository repository : this.mySubmodulesInDetachedHead.keySet()) {
            GitSubmoduleUpdater updater = new GitSubmoduleUpdater(this.myProject, this.myGit, this.mySubmodulesInDetachedHead.get(repository).getParent(), repository, this.myProgressIndicator, this.myUpdatedFiles);
            updaters.put(repository, updater);
        }
        LOG.info("Updaters: " + updaters);
        return updaters;
    }

    @NotNull
    Map<GitRepository, String> getSkippedRoots() {
        return this.mySkippedRoots;
    }

    @NotNull
    private static GitUpdateResult joinResults(@Nullable GitUpdateResult compoundResult, GitUpdateResult result2) {
        if (compoundResult == null) {
            return result2;
        }
        return compoundResult.join(result2);
    }

    private boolean fetchAndNotify(@NotNull Collection<GitRepository> repositories) {
        return GitFetchSupport.fetchSupport(this.myProject).fetchDefaultRemote(repositories).showNotificationIfFailed("Update failed");
    }

    @Nullable
    private Map<GitRepository, GitBranchPair> checkTrackedBranchesConfiguration() {
        LOG.info("checking tracked branch configuration...");
        LinkedHashMap currentBranches = ContainerUtil.newLinkedHashMap();
        ArrayList detachedHeads = ContainerUtil.newArrayList();
        for (GitRepository repository : this.myRepositories) {
            if (this.mySubmodulesInDetachedHead.containsKey(repository)) {
                LOG.debug("Repository " + repository + " is a submodule in detached HEAD state, not checking its tracked branch");
                continue;
            }
            GitLocalBranch branch = repository.getCurrentBranch();
            if (branch != null) {
                currentBranches.put(repository, branch);
                continue;
            }
            detachedHeads.add(repository);
            LOG.info(String.format("skipping update of [%s] (detached HEAD)", DvcsUtil.getShortRepositoryName((Repository)repository)));
        }
        if (!detachedHeads.isEmpty() && (currentBranches.isEmpty() || this.isSyncControl())) {
            GitUpdateProcess.notifyDetachedHeadError((GitRepository)detachedHeads.get(0));
            return null;
        }
        for (GitRepository repo : detachedHeads) {
            this.mySkippedRoots.put(repo, "detached HEAD");
        }
        LinkedHashMap trackedBranches = ContainerUtil.newLinkedHashMap();
        ArrayList noTrackedBranch = ContainerUtil.newArrayList();
        for (GitRepository repository : currentBranches.keySet()) {
            GitLocalBranch branch;
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, branch = (GitLocalBranch)currentBranches.get(repository));
            if (trackInfo != null) {
                trackedBranches.put(repository, new GitBranchPair(branch, trackInfo.getRemoteBranch()));
                continue;
            }
            noTrackedBranch.add(repository);
            LOG.info(String.format("skipping update of [%s] (no tracked branch for current branch [%s])", DvcsUtil.getShortRepositoryName((Repository)repository), branch));
        }
        if (this.myCheckForTrackedBranchExistence && !noTrackedBranch.isEmpty() && (trackedBranches.isEmpty() || this.isSyncControl())) {
            GitRepository repo = (GitRepository)noTrackedBranch.get(0);
            GitUpdateProcess.notifyNoTrackedBranchError(repo, (GitLocalBranch)currentBranches.get(repo));
            return null;
        }
        for (GitRepository repo : noTrackedBranch) {
            this.mySkippedRoots.put(repo, "no tracked branch");
        }
        return trackedBranches;
    }

    private static void notifyNoTrackedBranchError(@NotNull GitRepository repository, @NotNull GitLocalBranch currentBranch) {
        GitUIUtil.notifyImportantError(repository.getProject(), "Can't Update", GitUpdateProcess.getNoTrackedBranchError(repository, currentBranch.getName()));
    }

    private static void notifyDetachedHeadError(@NotNull GitRepository repository) {
        GitUIUtil.notifyImportantError(repository.getProject(), "Can't Update: No Current Branch", GitUpdateProcess.getDetachedHeadErrorNotificationContent(repository));
    }

    @VisibleForTesting
    @NotNull
    static String getDetachedHeadErrorNotificationContent(@NotNull GitRepository repository) {
        return "You are in 'detached HEAD' state, which means that you're not on any branch" + GitUtil.mention(repository) + "<br/>Checkout a branch to make update possible.";
    }

    private boolean isSyncControl() {
        return GitVcsSettings.getInstance(this.myProject).getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    @VisibleForTesting
    @NotNull
    static String getNoTrackedBranchError(@NotNull GitRepository repository, @NotNull String branchName) {
        String recommendedCommand = GitUpdateProcess.recommendSetupTrackingCommand(repository, branchName);
        return "No tracked branch configured for branch " + GitUIUtil.code(branchName) + GitUtil.mention(repository) + " or the branch doesn't exist.<br/>To make your branch track a remote branch call, for example,<br/><code>" + recommendedCommand + "</code>";
    }

    @NotNull
    private static String recommendSetupTrackingCommand(@NotNull GitRepository repository, @NotNull String branchName) {
        return String.format(GitVersionSpecialty.KNOWS_SET_UPSTREAM_TO.existsIn(repository) ? "git branch --set-upstream-to=origin/%1$s %1$s" : "git branch --set-upstream %1$s origin/%1$s", branchName);
    }

    private boolean isMergeInProgress() {
        LOG.info("isMergeInProgress: checking if there is an unfinished merge process...");
        Collection<VirtualFile> mergingRoots = this.myMerger.getMergingRoots();
        if (mergingRoots.isEmpty()) {
            return false;
        }
        LOG.info("isMergeInProgress: roots with unfinished merge: " + mergingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished merge. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, mergingRoots, params, false).merge();
    }

    private boolean areUnmergedFiles() {
        LOG.info("areUnmergedFiles: checking if there are unmerged files...");
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle("Update was not started");
        params.setMergeDescription("Unmerged files detected. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, GitUtil.getRootsFromRepositories(this.myRepositories), params, false).merge();
    }

    private boolean checkRebaseInProgress() {
        LOG.info("checkRebaseInProgress: checking if there is an unfinished rebase process...");
        final GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, this.myProgressIndicator);
        final Collection<VirtualFile> rebasingRoots = rebaser.getRebasingRoots();
        if (rebasingRoots.isEmpty()) {
            return false;
        }
        LOG.info("checkRebaseInProgress: roots with unfinished rebase: " + rebasingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished rebase process. These conflicts must be resolved before update.");
        params.setErrorNotificationAdditionalDescription("Then you may <b>continue rebase</b>. <br/> You also may <b>abort rebase</b> to restore the original branch and stop rebasing.");
        params.setReverse(true);
        return !new GitConflictResolver(this.myProject, this.myGit, rebasingRoots, params){

            @Override
            protected boolean proceedIfNothingToMerge() {
                return rebaser.continueRebase(rebasingRoots);
            }

            @Override
            protected boolean proceedAfterAllMerged() {
                return rebaser.continueRebase(rebasingRoots);
            }
        }.merge();
    }
}

