/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import org.jetbrains.annotations.NotNull;

public enum GitUpdateResult {
    NOTHING_TO_UPDATE(1),
    SUCCESS(2),
    SUCCESS_WITH_RESOLVED_CONFLICTS(3),
    INCOMPLETE(4),
    CANCEL(5),
    ERROR(6),
    NOT_READY(7);

    private final int myPriority;

    private GitUpdateResult(int priority) {
        this.myPriority = priority;
    }

    public boolean isSuccess() {
        return this == SUCCESS || this == SUCCESS_WITH_RESOLVED_CONFLICTS || this == INCOMPLETE || this == NOTHING_TO_UPDATE;
    }

    @NotNull
    public GitUpdateResult join(@NotNull GitUpdateResult next) {
        if (this.myPriority >= next.myPriority) {
            return this;
        }
        return next;
    }
}

