/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.util.containers.MultiMap;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateSession
implements UpdateSession {
    private final boolean myResult;
    @NotNull
    private final Map<GitRepository, String> mySkippedRoots;

    public GitUpdateSession(boolean result2, @NotNull Map<GitRepository, String> roots) {
        this.myResult = result2;
        this.mySkippedRoots = roots;
    }

    @NotNull
    public List<VcsException> getExceptions() {
        return Collections.emptyList();
    }

    public void onRefreshFilesCompleted() {
    }

    public boolean isCanceled() {
        return !this.myResult;
    }

    @Nullable
    public String getAdditionalNotificationContent() {
        if (this.mySkippedRoots.isEmpty()) {
            return null;
        }
        if (this.mySkippedRoots.size() == 1) {
            GitRepository repo = this.mySkippedRoots.keySet().iterator().next();
            return DvcsUtil.getShortRepositoryName((Repository)repo) + " was skipped (" + this.mySkippedRoots.get(repo) + ")";
        }
        String prefix = "Skipped " + this.mySkippedRoots.size() + " repositories: <br/>";
        MultiMap<String, GitRepository> grouped = GitUpdateSession.groupByReasons(this.mySkippedRoots);
        if (grouped.keySet().size() == 1) {
            String reason2 = (String)grouped.keySet().iterator().next();
            return prefix + DvcsUtil.getShortNames((Collection)grouped.get((Object)reason2)) + " (" + reason2 + ")";
        }
        return prefix + StringUtil.join((Collection)grouped.keySet(), reason -> DvcsUtil.getShortNames((Collection)grouped.get(reason)) + " (" + reason + ")", (String)"<br/>");
    }

    @NotNull
    private static MultiMap<String, GitRepository> groupByReasons(@NotNull Map<GitRepository, String> skippedRoots) {
        MultiMap result2 = MultiMap.create();
        skippedRoots.forEach((file, s) -> result2.putValue(s, file));
        return result2;
    }
}

