/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitFileUtils {
    private static final Logger LOG = Logger.getInstance(GitFileUtils.class);

    private GitFileUtils() {
    }

    @Deprecated
    public static void delete(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, String ... additionalOptions) throws VcsException {
        GitFileUtils.deletePaths(project, root, files, additionalOptions);
    }

    public static void deletePaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.doDelete(project, root, paths, additionalOptions);
        }
    }

    public static void deleteFiles(@NotNull Project project, @NotNull VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files), new String[0]);
    }

    private static void doDelete(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, String ... additionalOptions) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RM);
        handler.addParameters(additionalOptions);
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    public static void deleteFilesFromCache(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, files, "--cached");
        GitFileUtils.updateUntrackedFilesHolderOnFileRemove(project, root, files);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.addPaths(project, root, paths, false);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
    }

    public static void addFilesForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitFileUtils.addPaths(project, root, paths, true);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
    }

    private static void updateUntrackedFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> addedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().remove(addedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileRemove(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> removedFiles) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().add(removedFiles);
    }

    public static void addFiles(Project project, VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.addPaths(project, root, paths, false);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
    }

    public static void addPathsForce(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitFileUtils.addPaths(project, root, paths, true);
        }
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
    }

    @NotNull
    private static Collection<VirtualFile> getVirtualFilesFromFilePaths(@NotNull Collection<FilePath> paths) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(paths.size());
        for (FilePath path : paths) {
            VirtualFile file = path.getVirtualFile();
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths, boolean force) throws VcsException {
        if (!force && (paths = GitFileUtils.excludeIgnoredFiles(project, root, paths)).isEmpty()) {
            return;
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.ADD);
        handler.addParameters("--ignore-errors", "-A");
        if (force) {
            handler.addParameters("-f");
        }
        handler.endOptions();
        handler.addParameters(paths);
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    @NotNull
    private static List<String> excludeIgnoredFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LS_FILES);
        handler.setSilent(true);
        handler.addParameters("--ignored", "--others", "--exclude-standard");
        handler.endOptions();
        handler.addParameters(paths);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        ArrayList<String> nonIgnoredFiles = new ArrayList<String>(paths.size());
        HashSet<String> ignoredPaths = new HashSet<String>(Arrays.asList(StringUtil.splitByLines((String)output)));
        for (String pathToCheck : paths) {
            if (ignoredPaths.contains(pathToCheck)) continue;
            nonIgnoredFiles.add(pathToCheck);
        }
        return nonIgnoredFiles;
    }

    public static byte[] getFileContent(Project project, VirtualFile root, String revisionOrBranch, String relativePath) throws VcsException {
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.CAT_FILE);
        h.setSilent(true);
        if (GitVersionSpecialty.CAT_FILE_SUPPORTS_TEXTCONV.existsIn(project) && Registry.is((String)"git.read.content.with.textconv")) {
            h.addParameters("--textconv");
        } else if (GitVersionSpecialty.CAT_FILE_SUPPORTS_FILTERS.existsIn(project) && Registry.is((String)"git.read.content.with.filters")) {
            h.addParameters("--filters");
        } else {
            h.addParameters("-p");
        }
        h.addParameters(revisionOrBranch + ":" + relativePath);
        return h.run();
    }

    public static String stripFileProtocolPrefix(String path) {
        String FILE_PROTOCOL = "file://";
        if (path.startsWith("file://")) {
            return path.substring("file://".length());
        }
        return path;
    }
}

