/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsPreservingExecutor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitPreservingProcess;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GitPreservingExecutor
implements VcsPreservingExecutor {
    public boolean execute(@NotNull Project project, @NotNull Collection<VirtualFile> rootsToSave, @NotNull String operationTitle, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        if (!GitPreservingExecutor.areRootsUnderGitWithInitialCommit(rootsToSave, gitRepositoryManager)) {
            return false;
        }
        new GitPreservingProcess(project, Git.getInstance(), rootsToSave, operationTitle, "", GitVcsSettings.getInstance(project).updateChangesPolicy(), indicator, operation).execute();
        return true;
    }

    private static boolean areRootsUnderGitWithInitialCommit(@NotNull Collection<VirtualFile> roots, @NotNull GitRepositoryManager gitRepositoryManager) {
        return ContainerUtil.all(roots, root -> {
            GitRepository gitRepository = (GitRepository)gitRepositoryManager.getRepositoryForRoot((VirtualFile)root);
            if (gitRepository == null) {
                return false;
            }
            return gitRepository.getCurrentRevision() != null;
        });
    }
}

