/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class GitVcsConsoleWriter {
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    private final ProjectLevelVcsManager myVcsManager;

    @NotNull
    public static GitVcsConsoleWriter getInstance(@NotNull Project project) {
        return (GitVcsConsoleWriter)ServiceManager.getService((Project)project, GitVcsConsoleWriter.class);
    }

    public GitVcsConsoleWriter(@NotNull ProjectLevelVcsManager vcsManager) {
        this.myVcsManager = vcsManager;
    }

    public void showMessage(@NotNull String message) {
        this.showMessage(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void showErrorMessage(@NotNull String line) {
        this.showMessage(line, ConsoleViewContentType.ERROR_OUTPUT);
    }

    public void showCommandLine(@NotNull String cmdLine) {
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss.SSS");
        this.showMessage(f.format(new Date()) + ": " + cmdLine, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    private void showMessage(@NotNull String message, @NotNull ConsoleViewContentType contentType) {
        if (message.length() == 0) {
            return;
        }
        this.myVcsManager.addMessageToConsoleWindow(StringUtil.shortenPathWithEllipsis((String)message, (int)10000), contentType);
    }
}

