/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.openapi.ui.InputValidatorEx;
import git4idea.GitBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class GitNewBranchNameValidator
implements InputValidatorEx {
    private final Collection<GitRepository> myRepositories;
    private String myErrorText;

    private GitNewBranchNameValidator(@NotNull Collection<GitRepository> repositories) {
        this.myRepositories = repositories;
    }

    public static GitNewBranchNameValidator newInstance(@NotNull Collection<GitRepository> repositories) {
        return new GitNewBranchNameValidator(repositories);
    }

    public boolean checkInput(@NotNull String inputString) {
        if (!GitRefNameValidator.getInstance().checkInput(inputString)) {
            this.myErrorText = "Invalid name for branch";
            return false;
        }
        return this.checkBranchConflict(inputString);
    }

    private boolean checkBranchConflict(@NotNull String inputString) {
        if (this.isNotPermitted(inputString) || this.conflictsWithLocalBranch(inputString) || this.conflictsWithRemoteBranch(inputString)) {
            return false;
        }
        this.myErrorText = null;
        return true;
    }

    private boolean isNotPermitted(@NotNull String inputString) {
        if (inputString.equalsIgnoreCase("head")) {
            this.myErrorText = "Branch name " + inputString + " is not valid";
            return true;
        }
        return false;
    }

    private boolean conflictsWithLocalBranch(@NotNull String inputString) {
        return this.conflictsWithLocalOrRemote(inputString, true, " already exists");
    }

    private boolean conflictsWithRemoteBranch(@NotNull String inputString) {
        return this.conflictsWithLocalOrRemote(inputString, false, " clashes with remote branch with the same name");
    }

    private boolean conflictsWithLocalOrRemote(@NotNull String inputString, boolean local, @NotNull String message) {
        int conflictsWithCurrentName = 0;
        for (GitRepository repository : this.myRepositories) {
            if (inputString.equals(repository.getCurrentBranchName())) {
                ++conflictsWithCurrentName;
                continue;
            }
            GitBranchesCollection branchesCollection = repository.getBranches();
            Collection<GitBranch> branches2 = local ? branchesCollection.getLocalBranches() : branchesCollection.getRemoteBranches();
            for (GitBranch branch : branches2) {
                if (!branch.getName().equals(inputString)) continue;
                this.myErrorText = "Branch name " + inputString + message;
                if (this.myRepositories.size() > 1 && !this.allReposHaveBranch(inputString, local)) {
                    this.myErrorText = this.myErrorText + " in repository " + repository.getPresentableUrl();
                }
                return true;
            }
        }
        if (conflictsWithCurrentName == this.myRepositories.size()) {
            this.myErrorText = "You are already on branch " + inputString;
            return true;
        }
        return false;
    }

    private boolean allReposHaveBranch(String inputString, boolean local) {
        for (GitRepository repository : this.myRepositories) {
            GitBranchesCollection branchesCollection = repository.getBranches();
            Collection<GitBranch> branches2 = local ? branchesCollection.getLocalBranches() : branchesCollection.getRemoteBranches();
            if (GitBranchUtil.convertBranchesToNames(branches2).contains(inputString)) continue;
            return false;
        }
        return true;
    }

    public boolean canClose(String inputString) {
        return this.checkInput(inputString);
    }

    public String getErrorText(String inputString) {
        return this.myErrorText;
    }
}

