/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.view.Choreographer;
import java.util.ArrayList;

public class AnimationHandler {
    private final ArrayMap<AnimationFrameCallback, Long> mDelayedCallbackStartTime = new ArrayMap();
    private final ArrayList<AnimationFrameCallback> mAnimationCallbacks = new ArrayList();
    private final ArrayList<AnimationFrameCallback> mCommitCallbacks = new ArrayList();
    private AnimationFrameCallbackProvider mProvider;
    private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

        @Override
        public void doFrame(long frameTimeNanos) {
            AnimationHandler.this.doAnimationFrame(AnimationHandler.this.getProvider().getFrameTime());
            if (AnimationHandler.this.mAnimationCallbacks.size() > 0) {
                AnimationHandler.this.getProvider().postFrameCallback(this);
            }
        }
    };
    public static final ThreadLocal<AnimationHandler> sAnimatorHandler = new ThreadLocal();
    private boolean mListDirty = false;

    public static AnimationHandler getInstance() {
        if (sAnimatorHandler.get() == null) {
            sAnimatorHandler.set(new AnimationHandler());
        }
        return sAnimatorHandler.get();
    }

    public void setProvider(AnimationFrameCallbackProvider provider) {
        this.mProvider = provider == null ? new MyFrameCallbackProvider() : provider;
    }

    private AnimationFrameCallbackProvider getProvider() {
        if (this.mProvider == null) {
            this.mProvider = new MyFrameCallbackProvider();
        }
        return this.mProvider;
    }

    public void addAnimationFrameCallback(AnimationFrameCallback callback, long delay) {
        if (this.mAnimationCallbacks.size() == 0) {
            this.getProvider().postFrameCallback(this.mFrameCallback);
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
        if (delay > 0L) {
            this.mDelayedCallbackStartTime.put(callback, SystemClock.uptimeMillis() + delay);
        }
    }

    public void addOneShotCommitCallback(AnimationFrameCallback callback) {
        if (!this.mCommitCallbacks.contains(callback)) {
            this.mCommitCallbacks.add(callback);
        }
    }

    public void removeCallback(AnimationFrameCallback callback) {
        this.mCommitCallbacks.remove(callback);
        this.mDelayedCallbackStartTime.remove(callback);
        int id2 = this.mAnimationCallbacks.indexOf(callback);
        if (id2 >= 0) {
            this.mAnimationCallbacks.set(id2, null);
            this.mListDirty = true;
        }
    }

    private void doAnimationFrame(long frameTime) {
        long currentTime = SystemClock.uptimeMillis();
        int size = this.mAnimationCallbacks.size();
        for (int i = 0; i < size; ++i) {
            final AnimationFrameCallback callback = this.mAnimationCallbacks.get(i);
            if (callback == null || !this.isCallbackDue(callback, currentTime)) continue;
            callback.doAnimationFrame(frameTime);
            if (!this.mCommitCallbacks.contains(callback)) continue;
            this.getProvider().postCommitCallback(new Runnable(){

                @Override
                public void run() {
                    AnimationHandler.this.commitAnimationFrame(callback, AnimationHandler.this.getProvider().getFrameTime());
                }
            });
        }
        this.cleanUpList();
    }

    private void commitAnimationFrame(AnimationFrameCallback callback, long frameTime) {
        if (!this.mDelayedCallbackStartTime.containsKey(callback) && this.mCommitCallbacks.contains(callback)) {
            callback.commitAnimationFrame(frameTime);
            this.mCommitCallbacks.remove(callback);
        }
    }

    private boolean isCallbackDue(AnimationFrameCallback callback, long currentTime) {
        Long startTime = this.mDelayedCallbackStartTime.get(callback);
        if (startTime == null) {
            return true;
        }
        if (startTime < currentTime) {
            this.mDelayedCallbackStartTime.remove(callback);
            return true;
        }
        return false;
    }

    public static int getAnimationCount() {
        AnimationHandler handler = sAnimatorHandler.get();
        if (handler == null) {
            return 0;
        }
        return handler.getCallbackSize();
    }

    public static void setFrameDelay(long delay) {
        AnimationHandler.getInstance().getProvider().setFrameDelay(delay);
    }

    public static long getFrameDelay() {
        return AnimationHandler.getInstance().getProvider().getFrameDelay();
    }

    void autoCancelBasedOn(ObjectAnimator objectAnimator) {
        for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
            AnimationFrameCallback cb = this.mAnimationCallbacks.get(i);
            if (cb == null || !objectAnimator.shouldAutoCancel(cb)) continue;
            ((Animator)((Object)this.mAnimationCallbacks.get(i))).cancel();
        }
    }

    private void cleanUpList() {
        if (this.mListDirty) {
            for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
                if (this.mAnimationCallbacks.get(i) != null) continue;
                this.mAnimationCallbacks.remove(i);
            }
            this.mListDirty = false;
        }
    }

    private int getCallbackSize() {
        int count = 0;
        int size = this.mAnimationCallbacks.size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.mAnimationCallbacks.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static interface AnimationFrameCallbackProvider {
        public void postFrameCallback(Choreographer.FrameCallback var1);

        public void postCommitCallback(Runnable var1);

        public long getFrameTime();

        public long getFrameDelay();

        public void setFrameDelay(long var1);
    }

    static interface AnimationFrameCallback {
        public boolean doAnimationFrame(long var1);

        public void commitAnimationFrame(long var1);
    }

    private class MyFrameCallbackProvider
    implements AnimationFrameCallbackProvider {
        final Choreographer mChoreographer = Choreographer.getInstance();

        private MyFrameCallbackProvider() {
        }

        @Override
        public void postFrameCallback(Choreographer.FrameCallback callback) {
            this.mChoreographer.postFrameCallback(callback);
        }

        @Override
        public void postCommitCallback(Runnable runnable) {
            this.mChoreographer.postCallback(3, runnable, null);
        }

        @Override
        public long getFrameTime() {
            return this.mChoreographer.getFrameTime();
        }

        @Override
        public long getFrameDelay() {
            return Choreographer.getFrameDelay();
        }

        @Override
        public void setFrameDelay(long delay) {
            Choreographer.setFrameDelay(delay);
        }
    }
}

