/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezone;

import android.app.timezone.Utils;
import android.os.Parcel;
import android.os.Parcelable;

public class DistroRulesVersion
implements Parcelable {
    private final String mRulesVersion;
    private final int mRevision;
    public static final Parcelable.Creator<DistroRulesVersion> CREATOR = new Parcelable.Creator<DistroRulesVersion>(){

        @Override
        public DistroRulesVersion createFromParcel(Parcel in) {
            String rulesVersion = in.readString();
            int revision = in.readInt();
            return new DistroRulesVersion(rulesVersion, revision);
        }

        public DistroRulesVersion[] newArray(int size) {
            return new DistroRulesVersion[size];
        }
    };

    public DistroRulesVersion(String rulesVersion, int revision) {
        this.mRulesVersion = Utils.validateRulesVersion("rulesVersion", rulesVersion);
        this.mRevision = Utils.validateVersion("revision", revision);
    }

    public String getRulesVersion() {
        return this.mRulesVersion;
    }

    public int getRevision() {
        return this.mRevision;
    }

    public boolean isOlderThan(DistroRulesVersion distroRulesVersion) {
        int rulesComparison = this.mRulesVersion.compareTo(distroRulesVersion.mRulesVersion);
        if (rulesComparison < 0) {
            return true;
        }
        if (rulesComparison > 0) {
            return false;
        }
        return this.mRevision < distroRulesVersion.mRevision;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mRulesVersion);
        out.writeInt(this.mRevision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistroRulesVersion that = (DistroRulesVersion)o;
        if (this.mRevision != that.mRevision) {
            return false;
        }
        return this.mRulesVersion.equals(that.mRulesVersion);
    }

    public int hashCode() {
        int result = this.mRulesVersion.hashCode();
        result = 31 * result + this.mRevision;
        return result;
    }

    public String toString() {
        return "DistroRulesVersion{mRulesVersion='" + this.mRulesVersion + '\'' + ", mRevision='" + this.mRevision + '\'' + '}';
    }

    public String toDumpString() {
        return this.mRulesVersion + "," + this.mRevision;
    }
}

