/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHealthAppConfiguration;
import android.bluetooth.IBluetoothHealthCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothHealth
extends IInterface {
    public boolean registerAppConfiguration(BluetoothHealthAppConfiguration var1, IBluetoothHealthCallback var2) throws RemoteException;

    public boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration var1) throws RemoteException;

    public boolean connectChannelToSource(BluetoothDevice var1, BluetoothHealthAppConfiguration var2) throws RemoteException;

    public boolean connectChannelToSink(BluetoothDevice var1, BluetoothHealthAppConfiguration var2, int var3) throws RemoteException;

    public boolean disconnectChannel(BluetoothDevice var1, BluetoothHealthAppConfiguration var2, int var3) throws RemoteException;

    public ParcelFileDescriptor getMainChannelFd(BluetoothDevice var1, BluetoothHealthAppConfiguration var2) throws RemoteException;

    public List<BluetoothDevice> getConnectedHealthDevices() throws RemoteException;

    public List<BluetoothDevice> getHealthDevicesMatchingConnectionStates(int[] var1) throws RemoteException;

    public int getHealthDeviceConnectionState(BluetoothDevice var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothHealth {
        private static final String DESCRIPTOR = "android.bluetooth.IBluetoothHealth";
        static final int TRANSACTION_registerAppConfiguration = 1;
        static final int TRANSACTION_unregisterAppConfiguration = 2;
        static final int TRANSACTION_connectChannelToSource = 3;
        static final int TRANSACTION_connectChannelToSink = 4;
        static final int TRANSACTION_disconnectChannel = 5;
        static final int TRANSACTION_getMainChannelFd = 6;
        static final int TRANSACTION_getConnectedHealthDevices = 7;
        static final int TRANSACTION_getHealthDevicesMatchingConnectionStates = 8;
        static final int TRANSACTION_getHealthDeviceConnectionState = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothHealth asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothHealth) {
                return (IBluetoothHealth)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    BluetoothHealthAppConfiguration _arg0 = 0 != data.readInt() ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(data) : null;
                    IBluetoothHealthCallback _arg1 = IBluetoothHealthCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.registerAppConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    BluetoothHealthAppConfiguration _arg0 = 0 != data.readInt() ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.unregisterAppConfiguration(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    BluetoothHealthAppConfiguration _arg1 = 0 != data.readInt() ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.connectChannelToSource(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    BluetoothHealthAppConfiguration _arg1 = 0 != data.readInt() ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    boolean _result = this.connectChannelToSink(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    BluetoothHealthAppConfiguration _arg1 = 0 != data.readInt() ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    boolean _result = this.disconnectChannel(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    BluetoothHealthAppConfiguration _arg1 = 0 != data.readInt() ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(data) : null;
                    ParcelFileDescriptor _result = this.getMainChannelFd(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    List<BluetoothDevice> _result = this.getConnectedHealthDevices();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    List<BluetoothDevice> _result = this.getHealthDevicesMatchingConnectionStates(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getHealthDeviceConnectionState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IBluetoothHealth {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerAppConfiguration(BluetoothHealthAppConfiguration config, IBluetoothHealthCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean connectChannelToSource(BluetoothDevice device, BluetoothHealthAppConfiguration config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean connectChannelToSink(BluetoothDevice device, BluetoothHealthAppConfiguration config, int channelType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(channelType);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disconnectChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config, int id2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(id2);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor getMainChannelFd(BluetoothDevice device, BluetoothHealthAppConfiguration config) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getConnectedHealthDevices() throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getHealthDevicesMatchingConnectionStates(int[] states) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(states);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getHealthDeviceConnectionState(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

