/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.SystemApi;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PermissionInfo
extends PackageItemInfo
implements Parcelable {
    public static final int PROTECTION_NORMAL = 0;
    public static final int PROTECTION_DANGEROUS = 1;
    public static final int PROTECTION_SIGNATURE = 2;
    @Deprecated
    public static final int PROTECTION_SIGNATURE_OR_SYSTEM = 3;
    public static final int PROTECTION_FLAG_PRIVILEGED = 16;
    @Deprecated
    public static final int PROTECTION_FLAG_SYSTEM = 16;
    public static final int PROTECTION_FLAG_DEVELOPMENT = 32;
    public static final int PROTECTION_FLAG_APPOP = 64;
    public static final int PROTECTION_FLAG_PRE23 = 128;
    public static final int PROTECTION_FLAG_INSTALLER = 256;
    public static final int PROTECTION_FLAG_VERIFIER = 512;
    public static final int PROTECTION_FLAG_PREINSTALLED = 1024;
    public static final int PROTECTION_FLAG_SETUP = 2048;
    public static final int PROTECTION_FLAG_INSTANT = 4096;
    public static final int PROTECTION_FLAG_RUNTIME_ONLY = 8192;
    @SystemApi
    public static final int PROTECTION_FLAG_OEM = 16384;
    public static final int PROTECTION_FLAG_VENDOR_PRIVILEGED = 32768;
    @SystemApi
    public static final int PROTECTION_FLAG_SYSTEM_TEXT_CLASSIFIER = 65536;
    @Deprecated
    public static final int PROTECTION_MASK_BASE = 15;
    @Deprecated
    public static final int PROTECTION_MASK_FLAGS = 65520;
    @Deprecated
    public int protectionLevel;
    public String group;
    public static final int FLAG_COSTS_MONEY = 1;
    @SystemApi
    public static final int FLAG_REMOVED = 2;
    public static final int FLAG_INSTALLED = 0x40000000;
    public int flags;
    public int descriptionRes;
    @SystemApi
    public int requestRes;
    public CharSequence nonLocalizedDescription;
    public static final Parcelable.Creator<PermissionInfo> CREATOR = new Parcelable.Creator<PermissionInfo>(){

        @Override
        public PermissionInfo createFromParcel(Parcel source) {
            return new PermissionInfo(source);
        }

        public PermissionInfo[] newArray(int size) {
            return new PermissionInfo[size];
        }
    };

    public static int fixProtectionLevel(int level) {
        if (level == 3) {
            level = 18;
        }
        if ((level & 0x8000) != 0 && (level & 0x10) == 0) {
            level &= 0xFFFF7FFF;
        }
        return level;
    }

    public static String protectionToString(int level) {
        String protLevel = "????";
        switch (level & 0xF) {
            case 1: {
                protLevel = "dangerous";
                break;
            }
            case 0: {
                protLevel = "normal";
                break;
            }
            case 2: {
                protLevel = "signature";
                break;
            }
            case 3: {
                protLevel = "signatureOrSystem";
            }
        }
        if ((level & 0x10) != 0) {
            protLevel = protLevel + "|privileged";
        }
        if ((level & 0x20) != 0) {
            protLevel = protLevel + "|development";
        }
        if ((level & 0x40) != 0) {
            protLevel = protLevel + "|appop";
        }
        if ((level & 0x80) != 0) {
            protLevel = protLevel + "|pre23";
        }
        if ((level & 0x100) != 0) {
            protLevel = protLevel + "|installer";
        }
        if ((level & 0x200) != 0) {
            protLevel = protLevel + "|verifier";
        }
        if ((level & 0x400) != 0) {
            protLevel = protLevel + "|preinstalled";
        }
        if ((level & 0x800) != 0) {
            protLevel = protLevel + "|setup";
        }
        if ((level & 0x1000) != 0) {
            protLevel = protLevel + "|instant";
        }
        if ((level & 0x2000) != 0) {
            protLevel = protLevel + "|runtime";
        }
        if ((level & 0x4000) != 0) {
            protLevel = protLevel + "|oem";
        }
        if ((level & 0x8000) != 0) {
            protLevel = protLevel + "|vendorPrivileged";
        }
        if ((level & 0x10000) != 0) {
            protLevel = protLevel + "|textClassifier";
        }
        return protLevel;
    }

    public PermissionInfo() {
    }

    public PermissionInfo(PermissionInfo orig) {
        super(orig);
        this.protectionLevel = orig.protectionLevel;
        this.flags = orig.flags;
        this.group = orig.group;
        this.descriptionRes = orig.descriptionRes;
        this.requestRes = orig.requestRes;
        this.nonLocalizedDescription = orig.nonLocalizedDescription;
    }

    public CharSequence loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedDescription != null) {
            return this.nonLocalizedDescription;
        }
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, null)) != null) {
            return label;
        }
        return null;
    }

    public int getProtection() {
        return this.protectionLevel & 0xF;
    }

    public int getProtectionFlags() {
        return this.protectionLevel & 0xFFFFFFF0;
    }

    public String toString() {
        return "PermissionInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeInt(this.protectionLevel);
        dest.writeInt(this.flags);
        dest.writeString(this.group);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.requestRes);
        TextUtils.writeToParcel(this.nonLocalizedDescription, dest, parcelableFlags);
    }

    public int calculateFootprint() {
        int size = this.name.length();
        if (this.nonLocalizedLabel != null) {
            size += this.nonLocalizedLabel.length();
        }
        if (this.nonLocalizedDescription != null) {
            size += this.nonLocalizedDescription.length();
        }
        return size;
    }

    public boolean isAppOp() {
        return (this.protectionLevel & 0x40) != 0;
    }

    private PermissionInfo(Parcel source) {
        super(source);
        this.protectionLevel = source.readInt();
        this.flags = source.readInt();
        this.group = source.readString();
        this.descriptionRes = source.readInt();
        this.requestRes = source.readInt();
        this.nonLocalizedDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtectionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Protection {
    }
}

