/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.RectF;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.io.PrintWriter;
import libcore.util.NativeAllocationRegistry;

public class Matrix {
    public static final int MSCALE_X = 0;
    public static final int MSKEW_X = 1;
    public static final int MTRANS_X = 2;
    public static final int MSKEW_Y = 3;
    public static final int MSCALE_Y = 4;
    public static final int MTRANS_Y = 5;
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    public static final Matrix IDENTITY_MATRIX = new Matrix(){

        void oops() {
            throw new IllegalStateException("Matrix can not be modified");
        }

        @Override
        public void set(Matrix src) {
            this.oops();
        }

        @Override
        public void reset() {
            this.oops();
        }

        @Override
        public void setTranslate(float dx, float dy) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy, float px, float py) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees, float px, float py) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue, float px, float py) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky, float px, float py) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky) {
            this.oops();
        }

        @Override
        public boolean setConcat(Matrix a, Matrix b) {
            this.oops();
            return false;
        }

        @Override
        public boolean preTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean preConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean postTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean postConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
            this.oops();
            return false;
        }

        @Override
        public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
            this.oops();
            return false;
        }

        @Override
        public void setValues(float[] values) {
            this.oops();
        }
    };
    private static final long NATIVE_ALLOCATION_SIZE = 40L;
    public final long native_instance;

    public Matrix() {
        this.native_instance = Matrix.nCreate(0L);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.native_instance);
    }

    public Matrix(Matrix src) {
        this.native_instance = Matrix.nCreate(src != null ? src.native_instance : 0L);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.native_instance);
    }

    public boolean isIdentity() {
        return Matrix.nIsIdentity(this.native_instance);
    }

    public boolean isAffine() {
        return Matrix.nIsAffine(this.native_instance);
    }

    public boolean rectStaysRect() {
        return Matrix.nRectStaysRect(this.native_instance);
    }

    public void set(Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            Matrix.nSet(this.native_instance, src.native_instance);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        return Matrix.nEquals(this.native_instance, ((Matrix)obj).native_instance);
    }

    public int hashCode() {
        return 44;
    }

    public void reset() {
        Matrix.nReset(this.native_instance);
    }

    public void setTranslate(float dx, float dy) {
        Matrix.nSetTranslate(this.native_instance, dx, dy);
    }

    public void setScale(float sx, float sy, float px, float py) {
        Matrix.nSetScale(this.native_instance, sx, sy, px, py);
    }

    public void setScale(float sx, float sy) {
        Matrix.nSetScale(this.native_instance, sx, sy);
    }

    public void setRotate(float degrees, float px, float py) {
        Matrix.nSetRotate(this.native_instance, degrees, px, py);
    }

    public void setRotate(float degrees) {
        Matrix.nSetRotate(this.native_instance, degrees);
    }

    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        Matrix.nSetSinCos(this.native_instance, sinValue, cosValue, px, py);
    }

    public void setSinCos(float sinValue, float cosValue) {
        Matrix.nSetSinCos(this.native_instance, sinValue, cosValue);
    }

    public void setSkew(float kx, float ky, float px, float py) {
        Matrix.nSetSkew(this.native_instance, kx, ky, px, py);
    }

    public void setSkew(float kx, float ky) {
        Matrix.nSetSkew(this.native_instance, kx, ky);
    }

    public boolean setConcat(Matrix a, Matrix b) {
        Matrix.nSetConcat(this.native_instance, a.native_instance, b.native_instance);
        return true;
    }

    public boolean preTranslate(float dx, float dy) {
        Matrix.nPreTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean preScale(float sx, float sy, float px, float py) {
        Matrix.nPreScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean preScale(float sx, float sy) {
        Matrix.nPreScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean preRotate(float degrees, float px, float py) {
        Matrix.nPreRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean preRotate(float degrees) {
        Matrix.nPreRotate(this.native_instance, degrees);
        return true;
    }

    public boolean preSkew(float kx, float ky, float px, float py) {
        Matrix.nPreSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean preSkew(float kx, float ky) {
        Matrix.nPreSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean preConcat(Matrix other) {
        Matrix.nPreConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean postTranslate(float dx, float dy) {
        Matrix.nPostTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean postScale(float sx, float sy, float px, float py) {
        Matrix.nPostScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean postScale(float sx, float sy) {
        Matrix.nPostScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean postRotate(float degrees, float px, float py) {
        Matrix.nPostRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean postRotate(float degrees) {
        Matrix.nPostRotate(this.native_instance, degrees);
        return true;
    }

    public boolean postSkew(float kx, float ky, float px, float py) {
        Matrix.nPostSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean postSkew(float kx, float ky) {
        Matrix.nPostSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean postConcat(Matrix other) {
        Matrix.nPostConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.nSetRectToRect(this.native_instance, src, dst, stf.nativeInt);
    }

    private static void checkPointArrays(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        int srcStop = srcIndex + (pointCount << 1);
        int dstStop = dstIndex + (pointCount << 1);
        if ((pointCount | srcIndex | dstIndex | srcStop | dstStop) < 0 || srcStop > src.length || dstStop > dst.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        if (pointCount > 4) {
            throw new IllegalArgumentException();
        }
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        return Matrix.nSetPolyToPoly(this.native_instance, src, srcIndex, dst, dstIndex, pointCount);
    }

    public boolean invert(Matrix inverse) {
        return Matrix.nInvert(this.native_instance, inverse.native_instance);
    }

    public void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        Matrix.nMapPoints(this.native_instance, dst, dstIndex, src, srcIndex, pointCount, true);
    }

    public void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, vectorCount);
        Matrix.nMapPoints(this.native_instance, dst, dstIndex, src, srcIndex, vectorCount, false);
    }

    public void mapPoints(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapPoints(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapVectors(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapVectors(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    public void mapVectors(float[] vecs) {
        this.mapVectors(vecs, 0, vecs, 0, vecs.length >> 1);
    }

    public boolean mapRect(RectF dst, RectF src) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.nMapRect(this.native_instance, dst, src);
    }

    public boolean mapRect(RectF rect) {
        return this.mapRect(rect, rect);
    }

    public float mapRadius(float radius) {
        return Matrix.nMapRadius(this.native_instance, radius);
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.nGetValues(this.native_instance, values);
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.nSetValues(this.native_instance, values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Matrix{");
        this.toShortString(sb);
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    public void toShortString(StringBuilder sb) {
        float[] values = new float[9];
        this.getValues(values);
        sb.append('[');
        sb.append(values[0]);
        sb.append(", ");
        sb.append(values[1]);
        sb.append(", ");
        sb.append(values[2]);
        sb.append("][");
        sb.append(values[3]);
        sb.append(", ");
        sb.append(values[4]);
        sb.append(", ");
        sb.append(values[5]);
        sb.append("][");
        sb.append(values[6]);
        sb.append(", ");
        sb.append(values[7]);
        sb.append(", ");
        sb.append(values[8]);
        sb.append(']');
    }

    public void printShortString(PrintWriter pw) {
        float[] values = new float[9];
        this.getValues(values);
        pw.print('[');
        pw.print(values[0]);
        pw.print(", ");
        pw.print(values[1]);
        pw.print(", ");
        pw.print(values[2]);
        pw.print("][");
        pw.print(values[3]);
        pw.print(", ");
        pw.print(values[4]);
        pw.print(", ");
        pw.print(values[5]);
        pw.print("][");
        pw.print(values[6]);
        pw.print(", ");
        pw.print(values[7]);
        pw.print(", ");
        pw.print(values[8]);
        pw.print(']');
    }

    public long ni() {
        return this.native_instance;
    }

    @LayoutlibDelegate
    private static long nCreate(long l) {
        return Matrix_Delegate.nCreate(l);
    }

    @LayoutlibDelegate
    private static long nGetNativeFinalizer() {
        return Matrix_Delegate.nGetNativeFinalizer();
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nSetRectToRect(long l, RectF rectF, RectF rectF2, int n) {
        return Matrix_Delegate.nSetRectToRect(l, rectF, rectF2, n);
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nSetPolyToPoly(long l, float[] fArray, int n, float[] fArray2, int n2, int n3) {
        return Matrix_Delegate.nSetPolyToPoly(l, fArray, n, fArray2, n2, n3);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nMapPoints(long l, float[] fArray, int n, float[] fArray2, int n2, int n3, boolean bl) {
        Matrix_Delegate.nMapPoints(l, fArray, n, fArray2, n2, n3, bl);
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nMapRect(long l, RectF rectF, RectF rectF2) {
        return Matrix_Delegate.nMapRect(l, rectF, rectF2);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nGetValues(long l, float[] fArray) {
        Matrix_Delegate.nGetValues(l, fArray);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetValues(long l, float[] fArray) {
        Matrix_Delegate.nSetValues(l, fArray);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsIdentity(long l) {
        return Matrix_Delegate.nIsIdentity(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsAffine(long l) {
        return Matrix_Delegate.nIsAffine(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nRectStaysRect(long l) {
        return Matrix_Delegate.nRectStaysRect(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nReset(long l) {
        Matrix_Delegate.nReset(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSet(long l, long l2) {
        Matrix_Delegate.nSet(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetTranslate(long l, float f, float f2) {
        Matrix_Delegate.nSetTranslate(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetScale(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.nSetScale(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetScale(long l, float f, float f2) {
        Matrix_Delegate.nSetScale(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetRotate(long l, float f, float f2, float f3) {
        Matrix_Delegate.nSetRotate(l, f, f2, f3);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetRotate(long l, float f) {
        Matrix_Delegate.nSetRotate(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetSinCos(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.nSetSinCos(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetSinCos(long l, float f, float f2) {
        Matrix_Delegate.nSetSinCos(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetSkew(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.nSetSkew(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetSkew(long l, float f, float f2) {
        Matrix_Delegate.nSetSkew(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetConcat(long l, long l2, long l3) {
        Matrix_Delegate.nSetConcat(l, l2, l3);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreTranslate(long l, float f, float f2) {
        Matrix_Delegate.nPreTranslate(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreScale(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.nPreScale(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreScale(long l, float f, float f2) {
        Matrix_Delegate.nPreScale(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreRotate(long l, float f, float f2, float f3) {
        Matrix_Delegate.nPreRotate(l, f, f2, f3);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreRotate(long l, float f) {
        Matrix_Delegate.nPreRotate(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreSkew(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.nPreSkew(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreSkew(long l, float f, float f2) {
        Matrix_Delegate.nPreSkew(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPreConcat(long l, long l2) {
        Matrix_Delegate.nPreConcat(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostTranslate(long l, float f, float f2) {
        Matrix_Delegate.nPostTranslate(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostScale(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.nPostScale(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostScale(long l, float f, float f2) {
        Matrix_Delegate.nPostScale(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostRotate(long l, float f, float f2, float f3) {
        Matrix_Delegate.nPostRotate(l, f, f2, f3);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostRotate(long l, float f) {
        Matrix_Delegate.nPostRotate(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostSkew(long l, float f, float f2, float f3, float f4) {
        Matrix_Delegate.nPostSkew(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostSkew(long l, float f, float f2) {
        Matrix_Delegate.nPostSkew(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nPostConcat(long l, long l2) {
        Matrix_Delegate.nPostConcat(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nInvert(long l, long l2) {
        return Matrix_Delegate.nInvert(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nMapRadius(long l, float f) {
        return Matrix_Delegate.nMapRadius(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nEquals(long l, long l2) {
        return Matrix_Delegate.nEquals(l, l2);
    }

    static /* synthetic */ long access$000() {
        return Matrix.nGetNativeFinalizer();
    }

    public static enum ScaleToFit {
        FILL(0),
        START(1),
        CENTER(2),
        END(3);

        final int nativeInt;

        private ScaleToFit(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Matrix.class.getClassLoader(), Matrix.access$000(), 40L);

        private NoImagePreloadHolder() {
        }
    }
}

