/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FontVariationAxis {
    private final int mTag;
    private final String mTagString;
    private final float mStyleValue;
    private static final Pattern TAG_PATTERN = Pattern.compile("[ -~]{4}");
    private static final Pattern STYLE_VALUE_PATTERN = Pattern.compile("-?(([0-9]+(\\.[0-9]+)?)|(\\.[0-9]+))");

    public FontVariationAxis(String tagString, float styleValue) {
        if (!FontVariationAxis.isValidTag(tagString)) {
            throw new IllegalArgumentException("Illegal tag pattern: " + tagString);
        }
        this.mTag = FontVariationAxis.makeTag(tagString);
        this.mTagString = tagString;
        this.mStyleValue = styleValue;
    }

    public int getOpenTypeTagValue() {
        return this.mTag;
    }

    public String getTag() {
        return this.mTagString;
    }

    public float getStyleValue() {
        return this.mStyleValue;
    }

    public String toString() {
        return "'" + this.mTagString + "' " + Float.toString(this.mStyleValue);
    }

    private static boolean isValidTag(String tagString) {
        return tagString != null && TAG_PATTERN.matcher(tagString).matches();
    }

    private static boolean isValidValueFormat(String valueString) {
        return valueString != null && STYLE_VALUE_PATTERN.matcher(valueString).matches();
    }

    public static int makeTag(String tagString) {
        char c1 = tagString.charAt(0);
        char c2 = tagString.charAt(1);
        char c3 = tagString.charAt(2);
        char c4 = tagString.charAt(3);
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    public static FontVariationAxis[] fromFontVariationSettings(String settings) {
        if (settings == null || settings.isEmpty()) {
            return null;
        }
        ArrayList<FontVariationAxis> axisList = new ArrayList<FontVariationAxis>();
        int length = settings.length();
        for (int i = 0; i < length; ++i) {
            float value;
            char c = settings.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != '\'' && c != '\"' || length < i + 6 || settings.charAt(i + 5) != c) {
                throw new IllegalArgumentException("Tag should be wrapped with double or single quote: " + settings);
            }
            String tagString = settings.substring(i + 1, i + 5);
            int endOfValueString = settings.indexOf(44, i += 6);
            if (endOfValueString == -1) {
                endOfValueString = length;
            }
            try {
                value = Float.parseFloat(settings.substring(i, endOfValueString));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse float string: " + e.getMessage());
            }
            axisList.add(new FontVariationAxis(tagString, value));
            i = endOfValueString;
        }
        if (axisList.isEmpty()) {
            return null;
        }
        return axisList.toArray(new FontVariationAxis[0]);
    }

    public static String toFontVariationSettings(FontVariationAxis[] axes) {
        if (axes == null) {
            return "";
        }
        return TextUtils.join((CharSequence)",", axes);
    }
}

