/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.app.ActivityThread;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.IAudioService;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

@Deprecated
public class Camera {
    private static final String TAG = "Camera";
    private static final int CAMERA_MSG_ERROR = 1;
    private static final int CAMERA_MSG_SHUTTER = 2;
    private static final int CAMERA_MSG_FOCUS = 4;
    private static final int CAMERA_MSG_ZOOM = 8;
    private static final int CAMERA_MSG_PREVIEW_FRAME = 16;
    private static final int CAMERA_MSG_VIDEO_FRAME = 32;
    private static final int CAMERA_MSG_POSTVIEW_FRAME = 64;
    private static final int CAMERA_MSG_RAW_IMAGE = 128;
    private static final int CAMERA_MSG_COMPRESSED_IMAGE = 256;
    private static final int CAMERA_MSG_RAW_IMAGE_NOTIFY = 512;
    private static final int CAMERA_MSG_PREVIEW_METADATA = 1024;
    private static final int CAMERA_MSG_FOCUS_MOVE = 2048;
    private long mNativeContext;
    private EventHandler mEventHandler;
    private ShutterCallback mShutterCallback;
    private PictureCallback mRawImageCallback;
    private PictureCallback mJpegCallback;
    private PreviewCallback mPreviewCallback;
    private boolean mUsingPreviewAllocation;
    private PictureCallback mPostviewCallback;
    private AutoFocusCallback mAutoFocusCallback;
    private AutoFocusMoveCallback mAutoFocusMoveCallback;
    private OnZoomChangeListener mZoomListener;
    private FaceDetectionListener mFaceListener;
    private ErrorCallback mErrorCallback;
    private ErrorCallback mDetailedErrorCallback;
    private boolean mOneShot;
    private boolean mWithBuffer;
    private boolean mFaceDetectionRunning = false;
    private final Object mAutoFocusCallbackLock = new Object();
    private final Object mShutterSoundLock = new Object();
    private IAppOpsService mAppOps;
    private IAppOpsCallback mAppOpsCallback;
    @GuardedBy(value="mShutterSoundLock")
    private boolean mHasAppOpsPlayAudio = true;
    @GuardedBy(value="mShutterSoundLock")
    private boolean mShutterSoundEnabledFromApp = true;
    private static final int NO_ERROR = 0;
    public static final String ACTION_NEW_PICTURE = "android.hardware.action.NEW_PICTURE";
    public static final String ACTION_NEW_VIDEO = "android.hardware.action.NEW_VIDEO";
    public static final int CAMERA_HAL_API_VERSION_1_0 = 256;
    private static final int CAMERA_HAL_API_VERSION_NORMAL_CONNECT = -2;
    private static final int CAMERA_HAL_API_VERSION_UNSPECIFIED = -1;
    private static final int CAMERA_FACE_DETECTION_HW = 0;
    private static final int CAMERA_FACE_DETECTION_SW = 1;
    public static final int CAMERA_ERROR_UNKNOWN = 1;
    public static final int CAMERA_ERROR_EVICTED = 2;
    public static final int CAMERA_ERROR_DISABLED = 3;
    public static final int CAMERA_ERROR_SERVER_DIED = 100;

    public static int getNumberOfCameras() {
        return OverrideMethod.invokeI("android.hardware.Camera#getNumberOfCameras()I", true, null);
    }

    public static void getCameraInfo(int cameraId, CameraInfo cameraInfo) {
        Camera._getCameraInfo(cameraId, cameraInfo);
        IBinder b = ServiceManager.getService("audio");
        IAudioService audioService = IAudioService.Stub.asInterface(b);
        try {
            if (audioService.isCameraSoundForced()) {
                cameraInfo.canDisableShutterSound = false;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Audio service is unavailable for queries");
        }
    }

    private static void _getCameraInfo(int n, CameraInfo cameraInfo) {
        OverrideMethod.invokeV("android.hardware.Camera#_getCameraInfo(ILandroid/hardware/Camera$CameraInfo;)V", true, null);
    }

    public static Camera open(int cameraId) {
        return new Camera(cameraId);
    }

    public static Camera open() {
        int numberOfCameras = Camera.getNumberOfCameras();
        CameraInfo cameraInfo = new CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return new Camera(i);
        }
        return null;
    }

    public static Camera openLegacy(int cameraId, int halVersion) {
        if (halVersion < 256) {
            throw new IllegalArgumentException("Invalid HAL version " + halVersion);
        }
        return new Camera(cameraId, halVersion);
    }

    private Camera(int cameraId, int halVersion) {
        int err = this.cameraInitVersion(cameraId, halVersion);
        if (Camera.checkInitErrors(err)) {
            if (err == -OsConstants.EACCES) {
                throw new RuntimeException("Fail to connect to camera service");
            }
            if (err == -OsConstants.ENODEV) {
                throw new RuntimeException("Camera initialization failed");
            }
            if (err == -OsConstants.ENOSYS) {
                throw new RuntimeException("Camera initialization failed because some methods are not implemented");
            }
            if (err == -OsConstants.EOPNOTSUPP) {
                throw new RuntimeException("Camera initialization failed because the hal version is not supported by this device");
            }
            if (err == -OsConstants.EINVAL) {
                throw new RuntimeException("Camera initialization failed because the input arugments are invalid");
            }
            if (err == -OsConstants.EBUSY) {
                throw new RuntimeException("Camera initialization failed because the camera device was already opened");
            }
            if (err == -OsConstants.EUSERS) {
                throw new RuntimeException("Camera initialization failed because the max number of camera devices were already opened");
            }
            throw new RuntimeException("Unknown camera error");
        }
    }

    private int cameraInitVersion(int cameraId, int halVersion) {
        this.mShutterCallback = null;
        this.mRawImageCallback = null;
        this.mJpegCallback = null;
        this.mPreviewCallback = null;
        this.mPostviewCallback = null;
        this.mUsingPreviewAllocation = false;
        this.mZoomListener = null;
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        return this.native_setup(new WeakReference<Camera>(this), cameraId, halVersion, ActivityThread.currentOpPackageName());
    }

    private int cameraInitNormal(int cameraId) {
        return this.cameraInitVersion(cameraId, -2);
    }

    public int cameraInitUnspecified(int cameraId) {
        return this.cameraInitVersion(cameraId, -1);
    }

    Camera(int cameraId) {
        int err = this.cameraInitNormal(cameraId);
        if (Camera.checkInitErrors(err)) {
            if (err == -OsConstants.EACCES) {
                throw new RuntimeException("Fail to connect to camera service");
            }
            if (err == -OsConstants.ENODEV) {
                throw new RuntimeException("Camera initialization failed");
            }
            throw new RuntimeException("Unknown camera error");
        }
        this.initAppOps();
    }

    public static boolean checkInitErrors(int err) {
        return err != 0;
    }

    public static Camera openUninitialized() {
        return new Camera();
    }

    Camera() {
    }

    private void initAppOps() {
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.updateAppOpsPlayAudio();
        this.mAppOpsCallback = new IAppOpsCallbackWrapper(this);
        try {
            this.mAppOps.startWatchingMode(28, ActivityThread.currentPackageName(), this.mAppOpsCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error registering appOps callback", e);
            this.mHasAppOpsPlayAudio = false;
        }
    }

    private void releaseAppOps() {
        try {
            if (this.mAppOps != null) {
                this.mAppOps.stopWatchingMode(this.mAppOpsCallback);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.release();
    }

    private int native_setup(Object object, int n, int n2, String string2) {
        return OverrideMethod.invokeI("android.hardware.Camera#native_setup(Ljava/lang/Object;IILjava/lang/String;)I", true, this);
    }

    private void native_release() {
        OverrideMethod.invokeV("android.hardware.Camera#native_release()V", true, this);
    }

    public void release() {
        this.native_release();
        this.mFaceDetectionRunning = false;
        this.releaseAppOps();
    }

    public void unlock() {
        OverrideMethod.invokeV("android.hardware.Camera#unlock()V", true, this);
    }

    public void lock() {
        OverrideMethod.invokeV("android.hardware.Camera#lock()V", true, this);
    }

    public void reconnect() throws IOException {
        OverrideMethod.invokeV("android.hardware.Camera#reconnect()V", true, this);
    }

    public void setPreviewDisplay(SurfaceHolder holder) throws IOException {
        if (holder != null) {
            this.setPreviewSurface(holder.getSurface());
        } else {
            this.setPreviewSurface(null);
        }
    }

    public void setPreviewSurface(Surface surface) throws IOException {
        OverrideMethod.invokeV("android.hardware.Camera#setPreviewSurface(Landroid/view/Surface;)V", true, this);
    }

    public void setPreviewTexture(SurfaceTexture surfaceTexture) throws IOException {
        OverrideMethod.invokeV("android.hardware.Camera#setPreviewTexture(Landroid/graphics/SurfaceTexture;)V", true, this);
    }

    public void startPreview() {
        OverrideMethod.invokeV("android.hardware.Camera#startPreview()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPreview() {
        this._stopPreview();
        this.mFaceDetectionRunning = false;
        this.mShutterCallback = null;
        this.mRawImageCallback = null;
        this.mPostviewCallback = null;
        this.mJpegCallback = null;
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = null;
        }
        this.mAutoFocusMoveCallback = null;
    }

    private void _stopPreview() {
        OverrideMethod.invokeV("android.hardware.Camera#_stopPreview()V", true, this);
    }

    public boolean previewEnabled() {
        return OverrideMethod.invokeI("android.hardware.Camera#previewEnabled()Z", true, this) != 0;
    }

    public void setPreviewCallback(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = false;
        this.mWithBuffer = false;
        if (cb != null) {
            this.mUsingPreviewAllocation = false;
        }
        this.setHasPreviewCallback(cb != null, false);
    }

    public void setOneShotPreviewCallback(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = true;
        this.mWithBuffer = false;
        if (cb != null) {
            this.mUsingPreviewAllocation = false;
        }
        this.setHasPreviewCallback(cb != null, false);
    }

    private void setHasPreviewCallback(boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.hardware.Camera#setHasPreviewCallback(ZZ)V", true, this);
    }

    public void setPreviewCallbackWithBuffer(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = false;
        this.mWithBuffer = true;
        if (cb != null) {
            this.mUsingPreviewAllocation = false;
        }
        this.setHasPreviewCallback(cb != null, true);
    }

    public void addCallbackBuffer(byte[] callbackBuffer) {
        this._addCallbackBuffer(callbackBuffer, 16);
    }

    public void addRawImageCallbackBuffer(byte[] callbackBuffer) {
        this.addCallbackBuffer(callbackBuffer, 128);
    }

    private void addCallbackBuffer(byte[] callbackBuffer, int msgType) {
        if (msgType != 16 && msgType != 128) {
            throw new IllegalArgumentException("Unsupported message type: " + msgType);
        }
        this._addCallbackBuffer(callbackBuffer, msgType);
    }

    private void _addCallbackBuffer(byte[] byArray, int n) {
        OverrideMethod.invokeV("android.hardware.Camera#_addCallbackBuffer([BI)V", true, this);
    }

    public Allocation createPreviewAllocation(RenderScript rs, int usage) throws RSIllegalArgumentException {
        Parameters p = this.getParameters();
        Size previewSize = p.getPreviewSize();
        Type.Builder yuvBuilder = new Type.Builder(rs, Element.createPixel(rs, Element.DataType.UNSIGNED_8, Element.DataKind.PIXEL_YUV));
        yuvBuilder.setYuvFormat(842094169);
        yuvBuilder.setX(previewSize.width);
        yuvBuilder.setY(previewSize.height);
        Allocation a = Allocation.createTyped(rs, yuvBuilder.create(), usage | 0x20);
        return a;
    }

    public void setPreviewCallbackAllocation(Allocation previewAllocation) throws IOException {
        Surface previewSurface = null;
        if (previewAllocation != null) {
            Parameters p = this.getParameters();
            Size previewSize = p.getPreviewSize();
            if (previewSize.width != previewAllocation.getType().getX() || previewSize.height != previewAllocation.getType().getY()) {
                throw new IllegalArgumentException("Allocation dimensions don't match preview dimensions: Allocation is " + previewAllocation.getType().getX() + ", " + previewAllocation.getType().getY() + ". Preview is " + previewSize.width + ", " + previewSize.height);
            }
            if ((previewAllocation.getUsage() & 0x20) == 0) {
                throw new IllegalArgumentException("Allocation usage does not include USAGE_IO_INPUT");
            }
            if (previewAllocation.getType().getElement().getDataKind() != Element.DataKind.PIXEL_YUV) {
                throw new IllegalArgumentException("Allocation is not of a YUV type");
            }
            previewSurface = previewAllocation.getSurface();
            this.mUsingPreviewAllocation = true;
        } else {
            this.mUsingPreviewAllocation = false;
        }
        this.setPreviewCallbackSurface(previewSurface);
    }

    private void setPreviewCallbackSurface(Surface surface) {
        OverrideMethod.invokeV("android.hardware.Camera#setPreviewCallbackSurface(Landroid/view/Surface;)V", true, this);
    }

    private static void postEventFromNative(Object camera_ref, int what, int arg1, int arg2, Object obj) {
        Camera c = (Camera)((WeakReference)camera_ref).get();
        if (c == null) {
            return;
        }
        if (c.mEventHandler != null) {
            Message m = c.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            c.mEventHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoFocus(AutoFocusCallback cb) {
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = cb;
        }
        this.native_autoFocus();
    }

    private void native_autoFocus() {
        OverrideMethod.invokeV("android.hardware.Camera#native_autoFocus()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAutoFocus() {
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = null;
        }
        this.native_cancelAutoFocus();
        this.mEventHandler.removeMessages(4);
    }

    private void native_cancelAutoFocus() {
        OverrideMethod.invokeV("android.hardware.Camera#native_cancelAutoFocus()V", true, this);
    }

    public void setAutoFocusMoveCallback(AutoFocusMoveCallback cb) {
        this.mAutoFocusMoveCallback = cb;
        this.enableFocusMoveCallback(this.mAutoFocusMoveCallback != null ? 1 : 0);
    }

    private void enableFocusMoveCallback(int n) {
        OverrideMethod.invokeV("android.hardware.Camera#enableFocusMoveCallback(I)V", true, this);
    }

    public void takePicture(ShutterCallback shutter, PictureCallback raw2, PictureCallback jpeg) {
        this.takePicture(shutter, raw2, null, jpeg);
    }

    private void native_takePicture(int n) {
        OverrideMethod.invokeV("android.hardware.Camera#native_takePicture(I)V", true, this);
    }

    public void takePicture(ShutterCallback shutter, PictureCallback raw2, PictureCallback postview, PictureCallback jpeg) {
        this.mShutterCallback = shutter;
        this.mRawImageCallback = raw2;
        this.mPostviewCallback = postview;
        this.mJpegCallback = jpeg;
        int msgType = 0;
        if (this.mShutterCallback != null) {
            msgType |= 2;
        }
        if (this.mRawImageCallback != null) {
            msgType |= 0x80;
        }
        if (this.mPostviewCallback != null) {
            msgType |= 0x40;
        }
        if (this.mJpegCallback != null) {
            msgType |= 0x100;
        }
        this.native_takePicture(msgType);
        this.mFaceDetectionRunning = false;
    }

    public void startSmoothZoom(int n) {
        OverrideMethod.invokeV("android.hardware.Camera#startSmoothZoom(I)V", true, this);
    }

    public void stopSmoothZoom() {
        OverrideMethod.invokeV("android.hardware.Camera#stopSmoothZoom()V", true, this);
    }

    public void setDisplayOrientation(int n) {
        OverrideMethod.invokeV("android.hardware.Camera#setDisplayOrientation(I)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableShutterSound(boolean enabled) {
        boolean canDisableShutterSound = true;
        IBinder b = ServiceManager.getService("audio");
        IAudioService audioService = IAudioService.Stub.asInterface(b);
        try {
            if (audioService.isCameraSoundForced()) {
                canDisableShutterSound = false;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Audio service is unavailable for queries");
        }
        if (!enabled && !canDisableShutterSound) {
            return false;
        }
        Object object = this.mShutterSoundLock;
        synchronized (object) {
            this.mShutterSoundEnabledFromApp = enabled;
            boolean ret = this._enableShutterSound(enabled);
            if (enabled && !this.mHasAppOpsPlayAudio) {
                Log.i(TAG, "Shutter sound is not allowed by AppOpsManager");
                if (canDisableShutterSound) {
                    this._enableShutterSound(false);
                }
            }
            return ret;
        }
    }

    public boolean disableShutterSound() {
        return this._enableShutterSound(false);
    }

    private boolean _enableShutterSound(boolean bl) {
        return OverrideMethod.invokeI("android.hardware.Camera#_enableShutterSound(Z)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppOpsPlayAudio() {
        Object object = this.mShutterSoundLock;
        synchronized (object) {
            boolean oldHasAppOpsPlayAudio = this.mHasAppOpsPlayAudio;
            try {
                int mode = 1;
                if (this.mAppOps != null) {
                    mode = this.mAppOps.checkAudioOperation(28, 13, Process.myUid(), ActivityThread.currentPackageName());
                }
                this.mHasAppOpsPlayAudio = mode == 0;
            }
            catch (RemoteException e) {
                Log.e(TAG, "AppOpsService check audio operation failed");
                this.mHasAppOpsPlayAudio = false;
            }
            if (oldHasAppOpsPlayAudio != this.mHasAppOpsPlayAudio) {
                if (!this.mHasAppOpsPlayAudio) {
                    IBinder b = ServiceManager.getService("audio");
                    IAudioService audioService = IAudioService.Stub.asInterface(b);
                    try {
                        if (audioService.isCameraSoundForced()) {
                            return;
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Audio service is unavailable for queries");
                    }
                    this._enableShutterSound(false);
                } else {
                    this.enableShutterSound(this.mShutterSoundEnabledFromApp);
                }
            }
        }
    }

    public void setZoomChangeListener(OnZoomChangeListener listener) {
        this.mZoomListener = listener;
    }

    public void setFaceDetectionListener(FaceDetectionListener listener) {
        this.mFaceListener = listener;
    }

    public void startFaceDetection() {
        if (this.mFaceDetectionRunning) {
            throw new RuntimeException("Face detection is already running");
        }
        this._startFaceDetection(0);
        this.mFaceDetectionRunning = true;
    }

    public void stopFaceDetection() {
        this._stopFaceDetection();
        this.mFaceDetectionRunning = false;
    }

    private void _startFaceDetection(int n) {
        OverrideMethod.invokeV("android.hardware.Camera#_startFaceDetection(I)V", true, this);
    }

    private void _stopFaceDetection() {
        OverrideMethod.invokeV("android.hardware.Camera#_stopFaceDetection()V", true, this);
    }

    public void setErrorCallback(ErrorCallback cb) {
        this.mErrorCallback = cb;
    }

    public void setDetailedErrorCallback(ErrorCallback cb) {
        this.mDetailedErrorCallback = cb;
    }

    private void native_setParameters(String string2) {
        OverrideMethod.invokeV("android.hardware.Camera#native_setParameters(Ljava/lang/String;)V", true, this);
    }

    private String native_getParameters() {
        return (String)OverrideMethod.invokeA("android.hardware.Camera#native_getParameters()Ljava/lang/String;", true, this);
    }

    public void setParameters(Parameters params) {
        if (this.mUsingPreviewAllocation) {
            Size newPreviewSize = params.getPreviewSize();
            Size currentPreviewSize = this.getParameters().getPreviewSize();
            if (newPreviewSize.width != currentPreviewSize.width || newPreviewSize.height != currentPreviewSize.height) {
                throw new IllegalStateException("Cannot change preview size while a preview allocation is configured.");
            }
        }
        this.native_setParameters(params.flatten());
    }

    public Parameters getParameters() {
        Parameters p = new Parameters();
        String s = this.native_getParameters();
        p.unflatten(s);
        return p;
    }

    public static Parameters getEmptyParameters() {
        Camera camera;
        Camera camera2 = camera = new Camera();
        Objects.requireNonNull(camera2);
        return camera2.new Parameters();
    }

    public static Parameters getParametersCopy(Parameters parameters) {
        Camera camera;
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
        Camera camera2 = camera = parameters.getOuter();
        Objects.requireNonNull(camera2);
        Parameters p = camera2.new Parameters();
        p.copyFrom(parameters);
        return p;
    }

    @Deprecated
    public class Parameters {
        private static final String KEY_PREVIEW_SIZE = "preview-size";
        private static final String KEY_PREVIEW_FORMAT = "preview-format";
        private static final String KEY_PREVIEW_FRAME_RATE = "preview-frame-rate";
        private static final String KEY_PREVIEW_FPS_RANGE = "preview-fps-range";
        private static final String KEY_PICTURE_SIZE = "picture-size";
        private static final String KEY_PICTURE_FORMAT = "picture-format";
        private static final String KEY_JPEG_THUMBNAIL_SIZE = "jpeg-thumbnail-size";
        private static final String KEY_JPEG_THUMBNAIL_WIDTH = "jpeg-thumbnail-width";
        private static final String KEY_JPEG_THUMBNAIL_HEIGHT = "jpeg-thumbnail-height";
        private static final String KEY_JPEG_THUMBNAIL_QUALITY = "jpeg-thumbnail-quality";
        private static final String KEY_JPEG_QUALITY = "jpeg-quality";
        private static final String KEY_ROTATION = "rotation";
        private static final String KEY_GPS_LATITUDE = "gps-latitude";
        private static final String KEY_GPS_LONGITUDE = "gps-longitude";
        private static final String KEY_GPS_ALTITUDE = "gps-altitude";
        private static final String KEY_GPS_TIMESTAMP = "gps-timestamp";
        private static final String KEY_GPS_PROCESSING_METHOD = "gps-processing-method";
        private static final String KEY_WHITE_BALANCE = "whitebalance";
        private static final String KEY_EFFECT = "effect";
        private static final String KEY_ANTIBANDING = "antibanding";
        private static final String KEY_SCENE_MODE = "scene-mode";
        private static final String KEY_FLASH_MODE = "flash-mode";
        private static final String KEY_FOCUS_MODE = "focus-mode";
        private static final String KEY_FOCUS_AREAS = "focus-areas";
        private static final String KEY_MAX_NUM_FOCUS_AREAS = "max-num-focus-areas";
        private static final String KEY_FOCAL_LENGTH = "focal-length";
        private static final String KEY_HORIZONTAL_VIEW_ANGLE = "horizontal-view-angle";
        private static final String KEY_VERTICAL_VIEW_ANGLE = "vertical-view-angle";
        private static final String KEY_EXPOSURE_COMPENSATION = "exposure-compensation";
        private static final String KEY_MAX_EXPOSURE_COMPENSATION = "max-exposure-compensation";
        private static final String KEY_MIN_EXPOSURE_COMPENSATION = "min-exposure-compensation";
        private static final String KEY_EXPOSURE_COMPENSATION_STEP = "exposure-compensation-step";
        private static final String KEY_AUTO_EXPOSURE_LOCK = "auto-exposure-lock";
        private static final String KEY_AUTO_EXPOSURE_LOCK_SUPPORTED = "auto-exposure-lock-supported";
        private static final String KEY_AUTO_WHITEBALANCE_LOCK = "auto-whitebalance-lock";
        private static final String KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED = "auto-whitebalance-lock-supported";
        private static final String KEY_METERING_AREAS = "metering-areas";
        private static final String KEY_MAX_NUM_METERING_AREAS = "max-num-metering-areas";
        private static final String KEY_ZOOM = "zoom";
        private static final String KEY_MAX_ZOOM = "max-zoom";
        private static final String KEY_ZOOM_RATIOS = "zoom-ratios";
        private static final String KEY_ZOOM_SUPPORTED = "zoom-supported";
        private static final String KEY_SMOOTH_ZOOM_SUPPORTED = "smooth-zoom-supported";
        private static final String KEY_FOCUS_DISTANCES = "focus-distances";
        private static final String KEY_VIDEO_SIZE = "video-size";
        private static final String KEY_PREFERRED_PREVIEW_SIZE_FOR_VIDEO = "preferred-preview-size-for-video";
        private static final String KEY_MAX_NUM_DETECTED_FACES_HW = "max-num-detected-faces-hw";
        private static final String KEY_MAX_NUM_DETECTED_FACES_SW = "max-num-detected-faces-sw";
        private static final String KEY_RECORDING_HINT = "recording-hint";
        private static final String KEY_VIDEO_SNAPSHOT_SUPPORTED = "video-snapshot-supported";
        private static final String KEY_VIDEO_STABILIZATION = "video-stabilization";
        private static final String KEY_VIDEO_STABILIZATION_SUPPORTED = "video-stabilization-supported";
        private static final String SUPPORTED_VALUES_SUFFIX = "-values";
        private static final String TRUE = "true";
        private static final String FALSE = "false";
        public static final String WHITE_BALANCE_AUTO = "auto";
        public static final String WHITE_BALANCE_INCANDESCENT = "incandescent";
        public static final String WHITE_BALANCE_FLUORESCENT = "fluorescent";
        public static final String WHITE_BALANCE_WARM_FLUORESCENT = "warm-fluorescent";
        public static final String WHITE_BALANCE_DAYLIGHT = "daylight";
        public static final String WHITE_BALANCE_CLOUDY_DAYLIGHT = "cloudy-daylight";
        public static final String WHITE_BALANCE_TWILIGHT = "twilight";
        public static final String WHITE_BALANCE_SHADE = "shade";
        public static final String EFFECT_NONE = "none";
        public static final String EFFECT_MONO = "mono";
        public static final String EFFECT_NEGATIVE = "negative";
        public static final String EFFECT_SOLARIZE = "solarize";
        public static final String EFFECT_SEPIA = "sepia";
        public static final String EFFECT_POSTERIZE = "posterize";
        public static final String EFFECT_WHITEBOARD = "whiteboard";
        public static final String EFFECT_BLACKBOARD = "blackboard";
        public static final String EFFECT_AQUA = "aqua";
        public static final String ANTIBANDING_AUTO = "auto";
        public static final String ANTIBANDING_50HZ = "50hz";
        public static final String ANTIBANDING_60HZ = "60hz";
        public static final String ANTIBANDING_OFF = "off";
        public static final String FLASH_MODE_OFF = "off";
        public static final String FLASH_MODE_AUTO = "auto";
        public static final String FLASH_MODE_ON = "on";
        public static final String FLASH_MODE_RED_EYE = "red-eye";
        public static final String FLASH_MODE_TORCH = "torch";
        public static final String SCENE_MODE_AUTO = "auto";
        public static final String SCENE_MODE_ACTION = "action";
        public static final String SCENE_MODE_PORTRAIT = "portrait";
        public static final String SCENE_MODE_LANDSCAPE = "landscape";
        public static final String SCENE_MODE_NIGHT = "night";
        public static final String SCENE_MODE_NIGHT_PORTRAIT = "night-portrait";
        public static final String SCENE_MODE_THEATRE = "theatre";
        public static final String SCENE_MODE_BEACH = "beach";
        public static final String SCENE_MODE_SNOW = "snow";
        public static final String SCENE_MODE_SUNSET = "sunset";
        public static final String SCENE_MODE_STEADYPHOTO = "steadyphoto";
        public static final String SCENE_MODE_FIREWORKS = "fireworks";
        public static final String SCENE_MODE_SPORTS = "sports";
        public static final String SCENE_MODE_PARTY = "party";
        public static final String SCENE_MODE_CANDLELIGHT = "candlelight";
        public static final String SCENE_MODE_BARCODE = "barcode";
        public static final String SCENE_MODE_HDR = "hdr";
        public static final String FOCUS_MODE_AUTO = "auto";
        public static final String FOCUS_MODE_INFINITY = "infinity";
        public static final String FOCUS_MODE_MACRO = "macro";
        public static final String FOCUS_MODE_FIXED = "fixed";
        public static final String FOCUS_MODE_EDOF = "edof";
        public static final String FOCUS_MODE_CONTINUOUS_VIDEO = "continuous-video";
        public static final String FOCUS_MODE_CONTINUOUS_PICTURE = "continuous-picture";
        public static final int FOCUS_DISTANCE_NEAR_INDEX = 0;
        public static final int FOCUS_DISTANCE_OPTIMAL_INDEX = 1;
        public static final int FOCUS_DISTANCE_FAR_INDEX = 2;
        public static final int PREVIEW_FPS_MIN_INDEX = 0;
        public static final int PREVIEW_FPS_MAX_INDEX = 1;
        private static final String PIXEL_FORMAT_YUV422SP = "yuv422sp";
        private static final String PIXEL_FORMAT_YUV420SP = "yuv420sp";
        private static final String PIXEL_FORMAT_YUV422I = "yuv422i-yuyv";
        private static final String PIXEL_FORMAT_YUV420P = "yuv420p";
        private static final String PIXEL_FORMAT_RGB565 = "rgb565";
        private static final String PIXEL_FORMAT_JPEG = "jpeg";
        private static final String PIXEL_FORMAT_BAYER_RGGB = "bayer-rggb";
        private final LinkedHashMap<String, String> mMap = new LinkedHashMap(64);

        private Parameters() {
        }

        public void copyFrom(Parameters other) {
            if (other == null) {
                throw new NullPointerException("other must not be null");
            }
            this.mMap.putAll(other.mMap);
        }

        private Camera getOuter() {
            return Camera.this;
        }

        public boolean same(Parameters other) {
            if (this == other) {
                return true;
            }
            return other != null && this.mMap.equals(other.mMap);
        }

        @Deprecated
        public void dump() {
            Log.e(Camera.TAG, "dump: size=" + this.mMap.size());
            for (String k : this.mMap.keySet()) {
                Log.e(Camera.TAG, "dump: " + k + "=" + this.mMap.get(k));
            }
        }

        public String flatten() {
            StringBuilder flattened = new StringBuilder(128);
            for (String k : this.mMap.keySet()) {
                flattened.append(k);
                flattened.append("=");
                flattened.append(this.mMap.get(k));
                flattened.append(";");
            }
            flattened.deleteCharAt(flattened.length() - 1);
            return flattened.toString();
        }

        public void unflatten(String flattened) {
            this.mMap.clear();
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(';');
            splitter.setString(flattened);
            for (String kv : splitter) {
                int pos = kv.indexOf(61);
                if (pos == -1) continue;
                String k = kv.substring(0, pos);
                String v = kv.substring(pos + 1);
                this.mMap.put(k, v);
            }
        }

        public void remove(String key) {
            this.mMap.remove(key);
        }

        public void set(String key, String value) {
            if (key.indexOf(61) != -1 || key.indexOf(59) != -1 || key.indexOf(0) != -1) {
                Log.e(Camera.TAG, "Key \"" + key + "\" contains invalid character (= or ; or \\0)");
                return;
            }
            if (value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(0) != -1) {
                Log.e(Camera.TAG, "Value \"" + value + "\" contains invalid character (= or ; or \\0)");
                return;
            }
            this.put(key, value);
        }

        public void set(String key, int value) {
            this.put(key, Integer.toString(value));
        }

        private void put(String key, String value) {
            this.mMap.remove(key);
            this.mMap.put(key, value);
        }

        private void set(String key, List<Area> areas) {
            if (areas == null) {
                this.set(key, "(0,0,0,0,0)");
            } else {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < areas.size(); ++i) {
                    Area area = areas.get(i);
                    Rect rect = area.rect;
                    buffer.append('(');
                    buffer.append(rect.left);
                    buffer.append(',');
                    buffer.append(rect.top);
                    buffer.append(',');
                    buffer.append(rect.right);
                    buffer.append(',');
                    buffer.append(rect.bottom);
                    buffer.append(',');
                    buffer.append(area.weight);
                    buffer.append(')');
                    if (i == areas.size() - 1) continue;
                    buffer.append(',');
                }
                this.set(key, buffer.toString());
            }
        }

        public String get(String key) {
            return this.mMap.get(key);
        }

        public int getInt(String key) {
            return Integer.parseInt(this.mMap.get(key));
        }

        public void setPreviewSize(int width, int height) {
            String v = Integer.toString(width) + "x" + Integer.toString(height);
            this.set(KEY_PREVIEW_SIZE, v);
        }

        public Size getPreviewSize() {
            String pair = this.get(KEY_PREVIEW_SIZE);
            return this.strToSize(pair);
        }

        public List<Size> getSupportedPreviewSizes() {
            String str = this.get("preview-size-values");
            return this.splitSize(str);
        }

        public List<Size> getSupportedVideoSizes() {
            String str = this.get("video-size-values");
            return this.splitSize(str);
        }

        public Size getPreferredPreviewSizeForVideo() {
            String pair = this.get(KEY_PREFERRED_PREVIEW_SIZE_FOR_VIDEO);
            return this.strToSize(pair);
        }

        public void setJpegThumbnailSize(int width, int height) {
            this.set(KEY_JPEG_THUMBNAIL_WIDTH, width);
            this.set(KEY_JPEG_THUMBNAIL_HEIGHT, height);
        }

        public Size getJpegThumbnailSize() {
            return new Size(this.getInt(KEY_JPEG_THUMBNAIL_WIDTH), this.getInt(KEY_JPEG_THUMBNAIL_HEIGHT));
        }

        public List<Size> getSupportedJpegThumbnailSizes() {
            String str = this.get("jpeg-thumbnail-size-values");
            return this.splitSize(str);
        }

        public void setJpegThumbnailQuality(int quality) {
            this.set(KEY_JPEG_THUMBNAIL_QUALITY, quality);
        }

        public int getJpegThumbnailQuality() {
            return this.getInt(KEY_JPEG_THUMBNAIL_QUALITY);
        }

        public void setJpegQuality(int quality) {
            this.set(KEY_JPEG_QUALITY, quality);
        }

        public int getJpegQuality() {
            return this.getInt(KEY_JPEG_QUALITY);
        }

        @Deprecated
        public void setPreviewFrameRate(int fps) {
            this.set(KEY_PREVIEW_FRAME_RATE, fps);
        }

        @Deprecated
        public int getPreviewFrameRate() {
            return this.getInt(KEY_PREVIEW_FRAME_RATE);
        }

        @Deprecated
        public List<Integer> getSupportedPreviewFrameRates() {
            String str = this.get("preview-frame-rate-values");
            return this.splitInt(str);
        }

        public void setPreviewFpsRange(int min, int max) {
            this.set(KEY_PREVIEW_FPS_RANGE, "" + min + "," + max);
        }

        public void getPreviewFpsRange(int[] range) {
            if (range == null || range.length != 2) {
                throw new IllegalArgumentException("range must be an array with two elements.");
            }
            this.splitInt(this.get(KEY_PREVIEW_FPS_RANGE), range);
        }

        public List<int[]> getSupportedPreviewFpsRange() {
            String str = this.get("preview-fps-range-values");
            return this.splitRange(str);
        }

        public void setPreviewFormat(int pixel_format) {
            String s = this.cameraFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set(KEY_PREVIEW_FORMAT, s);
        }

        public int getPreviewFormat() {
            return this.pixelFormatForCameraFormat(this.get(KEY_PREVIEW_FORMAT));
        }

        public List<Integer> getSupportedPreviewFormats() {
            String str = this.get("preview-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForCameraFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        public void setPictureSize(int width, int height) {
            String v = Integer.toString(width) + "x" + Integer.toString(height);
            this.set(KEY_PICTURE_SIZE, v);
        }

        public Size getPictureSize() {
            String pair = this.get(KEY_PICTURE_SIZE);
            return this.strToSize(pair);
        }

        public List<Size> getSupportedPictureSizes() {
            String str = this.get("picture-size-values");
            return this.splitSize(str);
        }

        public void setPictureFormat(int pixel_format) {
            String s = this.cameraFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set(KEY_PICTURE_FORMAT, s);
        }

        public int getPictureFormat() {
            return this.pixelFormatForCameraFormat(this.get(KEY_PICTURE_FORMAT));
        }

        public List<Integer> getSupportedPictureFormats() {
            String str = this.get("picture-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForCameraFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        private String cameraFormatForPixelFormat(int pixel_format) {
            switch (pixel_format) {
                case 16: {
                    return PIXEL_FORMAT_YUV422SP;
                }
                case 17: {
                    return PIXEL_FORMAT_YUV420SP;
                }
                case 20: {
                    return PIXEL_FORMAT_YUV422I;
                }
                case 842094169: {
                    return PIXEL_FORMAT_YUV420P;
                }
                case 4: {
                    return PIXEL_FORMAT_RGB565;
                }
                case 256: {
                    return PIXEL_FORMAT_JPEG;
                }
            }
            return null;
        }

        private int pixelFormatForCameraFormat(String format) {
            if (format == null) {
                return 0;
            }
            if (format.equals(PIXEL_FORMAT_YUV422SP)) {
                return 16;
            }
            if (format.equals(PIXEL_FORMAT_YUV420SP)) {
                return 17;
            }
            if (format.equals(PIXEL_FORMAT_YUV422I)) {
                return 20;
            }
            if (format.equals(PIXEL_FORMAT_YUV420P)) {
                return 842094169;
            }
            if (format.equals(PIXEL_FORMAT_RGB565)) {
                return 4;
            }
            if (format.equals(PIXEL_FORMAT_JPEG)) {
                return 256;
            }
            return 0;
        }

        public void setRotation(int rotation) {
            if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
                throw new IllegalArgumentException("Invalid rotation=" + rotation);
            }
            this.set(KEY_ROTATION, Integer.toString(rotation));
        }

        public void setGpsLatitude(double latitude) {
            this.set(KEY_GPS_LATITUDE, Double.toString(latitude));
        }

        public void setGpsLongitude(double longitude) {
            this.set(KEY_GPS_LONGITUDE, Double.toString(longitude));
        }

        public void setGpsAltitude(double altitude) {
            this.set(KEY_GPS_ALTITUDE, Double.toString(altitude));
        }

        public void setGpsTimestamp(long timestamp) {
            this.set(KEY_GPS_TIMESTAMP, Long.toString(timestamp));
        }

        public void setGpsProcessingMethod(String processing_method) {
            this.set(KEY_GPS_PROCESSING_METHOD, processing_method);
        }

        public void removeGpsData() {
            this.remove(KEY_GPS_LATITUDE);
            this.remove(KEY_GPS_LONGITUDE);
            this.remove(KEY_GPS_ALTITUDE);
            this.remove(KEY_GPS_TIMESTAMP);
            this.remove(KEY_GPS_PROCESSING_METHOD);
        }

        public String getWhiteBalance() {
            return this.get(KEY_WHITE_BALANCE);
        }

        public void setWhiteBalance(String value) {
            String oldValue = this.get(KEY_WHITE_BALANCE);
            if (this.same(value, oldValue)) {
                return;
            }
            this.set(KEY_WHITE_BALANCE, value);
            this.set(KEY_AUTO_WHITEBALANCE_LOCK, FALSE);
        }

        public List<String> getSupportedWhiteBalance() {
            String str = this.get("whitebalance-values");
            return this.split(str);
        }

        public String getColorEffect() {
            return this.get(KEY_EFFECT);
        }

        public void setColorEffect(String value) {
            this.set(KEY_EFFECT, value);
        }

        public List<String> getSupportedColorEffects() {
            String str = this.get("effect-values");
            return this.split(str);
        }

        public String getAntibanding() {
            return this.get(KEY_ANTIBANDING);
        }

        public void setAntibanding(String antibanding) {
            this.set(KEY_ANTIBANDING, antibanding);
        }

        public List<String> getSupportedAntibanding() {
            String str = this.get("antibanding-values");
            return this.split(str);
        }

        public String getSceneMode() {
            return this.get(KEY_SCENE_MODE);
        }

        public void setSceneMode(String value) {
            this.set(KEY_SCENE_MODE, value);
        }

        public List<String> getSupportedSceneModes() {
            String str = this.get("scene-mode-values");
            return this.split(str);
        }

        public String getFlashMode() {
            return this.get(KEY_FLASH_MODE);
        }

        public void setFlashMode(String value) {
            this.set(KEY_FLASH_MODE, value);
        }

        public List<String> getSupportedFlashModes() {
            String str = this.get("flash-mode-values");
            return this.split(str);
        }

        public String getFocusMode() {
            return this.get(KEY_FOCUS_MODE);
        }

        public void setFocusMode(String value) {
            this.set(KEY_FOCUS_MODE, value);
        }

        public List<String> getSupportedFocusModes() {
            String str = this.get("focus-mode-values");
            return this.split(str);
        }

        public float getFocalLength() {
            return Float.parseFloat(this.get(KEY_FOCAL_LENGTH));
        }

        public float getHorizontalViewAngle() {
            return Float.parseFloat(this.get(KEY_HORIZONTAL_VIEW_ANGLE));
        }

        public float getVerticalViewAngle() {
            return Float.parseFloat(this.get(KEY_VERTICAL_VIEW_ANGLE));
        }

        public int getExposureCompensation() {
            return this.getInt(KEY_EXPOSURE_COMPENSATION, 0);
        }

        public void setExposureCompensation(int value) {
            this.set(KEY_EXPOSURE_COMPENSATION, value);
        }

        public int getMaxExposureCompensation() {
            return this.getInt(KEY_MAX_EXPOSURE_COMPENSATION, 0);
        }

        public int getMinExposureCompensation() {
            return this.getInt(KEY_MIN_EXPOSURE_COMPENSATION, 0);
        }

        public float getExposureCompensationStep() {
            return this.getFloat(KEY_EXPOSURE_COMPENSATION_STEP, 0.0f);
        }

        public void setAutoExposureLock(boolean toggle) {
            this.set(KEY_AUTO_EXPOSURE_LOCK, toggle ? TRUE : FALSE);
        }

        public boolean getAutoExposureLock() {
            String str = this.get(KEY_AUTO_EXPOSURE_LOCK);
            return TRUE.equals(str);
        }

        public boolean isAutoExposureLockSupported() {
            String str = this.get(KEY_AUTO_EXPOSURE_LOCK_SUPPORTED);
            return TRUE.equals(str);
        }

        public void setAutoWhiteBalanceLock(boolean toggle) {
            this.set(KEY_AUTO_WHITEBALANCE_LOCK, toggle ? TRUE : FALSE);
        }

        public boolean getAutoWhiteBalanceLock() {
            String str = this.get(KEY_AUTO_WHITEBALANCE_LOCK);
            return TRUE.equals(str);
        }

        public boolean isAutoWhiteBalanceLockSupported() {
            String str = this.get(KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED);
            return TRUE.equals(str);
        }

        public int getZoom() {
            return this.getInt(KEY_ZOOM, 0);
        }

        public void setZoom(int value) {
            this.set(KEY_ZOOM, value);
        }

        public boolean isZoomSupported() {
            String str = this.get(KEY_ZOOM_SUPPORTED);
            return TRUE.equals(str);
        }

        public int getMaxZoom() {
            return this.getInt(KEY_MAX_ZOOM, 0);
        }

        public List<Integer> getZoomRatios() {
            return this.splitInt(this.get(KEY_ZOOM_RATIOS));
        }

        public boolean isSmoothZoomSupported() {
            String str = this.get(KEY_SMOOTH_ZOOM_SUPPORTED);
            return TRUE.equals(str);
        }

        public void getFocusDistances(float[] output) {
            if (output == null || output.length != 3) {
                throw new IllegalArgumentException("output must be a float array with three elements.");
            }
            this.splitFloat(this.get(KEY_FOCUS_DISTANCES), output);
        }

        public int getMaxNumFocusAreas() {
            return this.getInt(KEY_MAX_NUM_FOCUS_AREAS, 0);
        }

        public List<Area> getFocusAreas() {
            return this.splitArea(this.get(KEY_FOCUS_AREAS));
        }

        public void setFocusAreas(List<Area> focusAreas) {
            this.set(KEY_FOCUS_AREAS, focusAreas);
        }

        public int getMaxNumMeteringAreas() {
            return this.getInt(KEY_MAX_NUM_METERING_AREAS, 0);
        }

        public List<Area> getMeteringAreas() {
            return this.splitArea(this.get(KEY_METERING_AREAS));
        }

        public void setMeteringAreas(List<Area> meteringAreas) {
            this.set(KEY_METERING_AREAS, meteringAreas);
        }

        public int getMaxNumDetectedFaces() {
            return this.getInt(KEY_MAX_NUM_DETECTED_FACES_HW, 0);
        }

        public void setRecordingHint(boolean hint) {
            this.set(KEY_RECORDING_HINT, hint ? TRUE : FALSE);
        }

        public boolean isVideoSnapshotSupported() {
            String str = this.get(KEY_VIDEO_SNAPSHOT_SUPPORTED);
            return TRUE.equals(str);
        }

        public void setVideoStabilization(boolean toggle) {
            this.set(KEY_VIDEO_STABILIZATION, toggle ? TRUE : FALSE);
        }

        public boolean getVideoStabilization() {
            String str = this.get(KEY_VIDEO_STABILIZATION);
            return TRUE.equals(str);
        }

        public boolean isVideoStabilizationSupported() {
            String str = this.get(KEY_VIDEO_STABILIZATION_SUPPORTED);
            return TRUE.equals(str);
        }

        private ArrayList<String> split(String str) {
            if (str == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            ArrayList<String> substrings = new ArrayList<String>();
            for (String s : splitter) {
                substrings.add(s);
            }
            return substrings;
        }

        private ArrayList<Integer> splitInt(String str) {
            if (str == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            ArrayList<Integer> substrings = new ArrayList<Integer>();
            for (String s : splitter) {
                substrings.add(Integer.parseInt(s));
            }
            if (substrings.size() == 0) {
                return null;
            }
            return substrings;
        }

        private void splitInt(String str, int[] output) {
            if (str == null) {
                return;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            int index = 0;
            for (String s : splitter) {
                output[index++] = Integer.parseInt(s);
            }
        }

        private void splitFloat(String str, float[] output) {
            if (str == null) {
                return;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            int index = 0;
            for (String s : splitter) {
                output[index++] = Float.parseFloat(s);
            }
        }

        private float getFloat(String key, float defaultValue) {
            try {
                return Float.parseFloat(this.mMap.get(key));
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        private int getInt(String key, int defaultValue) {
            try {
                return Integer.parseInt(this.mMap.get(key));
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        private ArrayList<Size> splitSize(String str) {
            if (str == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            ArrayList<Size> sizeList = new ArrayList<Size>();
            for (String s : splitter) {
                Size size = this.strToSize(s);
                if (size == null) continue;
                sizeList.add(size);
            }
            if (sizeList.size() == 0) {
                return null;
            }
            return sizeList;
        }

        private Size strToSize(String str) {
            if (str == null) {
                return null;
            }
            int pos = str.indexOf(120);
            if (pos != -1) {
                String width = str.substring(0, pos);
                String height = str.substring(pos + 1);
                return new Size(Integer.parseInt(width), Integer.parseInt(height));
            }
            Log.e(Camera.TAG, "Invalid size parameter string=" + str);
            return null;
        }

        private ArrayList<int[]> splitRange(String str) {
            int endIndex;
            if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
                Log.e(Camera.TAG, "Invalid range list string=" + str);
                return null;
            }
            ArrayList<int[]> rangeList = new ArrayList<int[]>();
            int fromIndex = 1;
            do {
                int[] range = new int[2];
                endIndex = str.indexOf("),(", fromIndex);
                if (endIndex == -1) {
                    endIndex = str.length() - 1;
                }
                this.splitInt(str.substring(fromIndex, endIndex), range);
                rangeList.add(range);
                fromIndex = endIndex + 3;
            } while (endIndex != str.length() - 1);
            if (rangeList.size() == 0) {
                return null;
            }
            return rangeList;
        }

        private ArrayList<Area> splitArea(String str) {
            int endIndex;
            if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
                Log.e(Camera.TAG, "Invalid area string=" + str);
                return null;
            }
            ArrayList<Area> result = new ArrayList<Area>();
            int fromIndex = 1;
            int[] array2 = new int[5];
            do {
                if ((endIndex = str.indexOf("),(", fromIndex)) == -1) {
                    endIndex = str.length() - 1;
                }
                this.splitInt(str.substring(fromIndex, endIndex), array2);
                Rect rect = new Rect(array2[0], array2[1], array2[2], array2[3]);
                result.add(new Area(rect, array2[4]));
                fromIndex = endIndex + 3;
            } while (endIndex != str.length() - 1);
            if (result.size() == 0) {
                return null;
            }
            if (result.size() == 1) {
                Area area = result.get(0);
                Rect rect = area.rect;
                if (rect.left == 0 && rect.top == 0 && rect.right == 0 && rect.bottom == 0 && area.weight == 0) {
                    return null;
                }
            }
            return result;
        }

        private boolean same(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            return s1 != null && s1.equals(s2);
        }
    }

    @Deprecated
    public static class Area {
        public Rect rect;
        public int weight;

        public Area(Rect rect, int weight) {
            this.rect = rect;
            this.weight = weight;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Area)) {
                return false;
            }
            Area a = (Area)obj;
            if (this.rect == null ? a.rect != null : !this.rect.equals(a.rect)) {
                return false;
            }
            return this.weight == a.weight;
        }
    }

    @Deprecated
    public class Size {
        public int width;
        public int height;

        public Size(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Size)) {
                return false;
            }
            Size s = (Size)obj;
            return this.width == s.width && this.height == s.height;
        }

        public int hashCode() {
            return this.width * 32713 + this.height;
        }
    }

    @Deprecated
    public static interface ErrorCallback {
        public void onError(int var1, Camera var2);
    }

    @Deprecated
    public static class Face {
        public Rect rect;
        public int score;
        public int id = -1;
        public Point leftEye = null;
        public Point rightEye = null;
        public Point mouth = null;
    }

    @Deprecated
    public static interface FaceDetectionListener {
        public void onFaceDetection(Face[] var1, Camera var2);
    }

    @Deprecated
    public static interface OnZoomChangeListener {
        public void onZoomChange(int var1, boolean var2, Camera var3);
    }

    private static class IAppOpsCallbackWrapper
    extends IAppOpsCallback.Stub {
        private final WeakReference<Camera> mWeakCamera;

        IAppOpsCallbackWrapper(Camera camera) {
            this.mWeakCamera = new WeakReference<Camera>(camera);
        }

        @Override
        public void opChanged(int op, int uid, String packageName) {
            Camera camera;
            if (op == 28 && (camera = (Camera)this.mWeakCamera.get()) != null) {
                camera.updateAppOpsPlayAudio();
            }
        }
    }

    @Deprecated
    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1, Camera var2);
    }

    @Deprecated
    public static interface ShutterCallback {
        public void onShutter();
    }

    @Deprecated
    public static interface AutoFocusMoveCallback {
        public void onAutoFocusMoving(boolean var1, Camera var2);
    }

    @Deprecated
    public static interface AutoFocusCallback {
        public void onAutoFocus(boolean var1, Camera var2);
    }

    private class EventHandler
    extends Handler {
        private final Camera mCamera;

        public EventHandler(Camera c, Looper looper) {
            super(looper);
            this.mCamera = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    if (Camera.this.mShutterCallback != null) {
                        Camera.this.mShutterCallback.onShutter();
                    }
                    return;
                }
                case 128: {
                    if (Camera.this.mRawImageCallback != null) {
                        Camera.this.mRawImageCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 256: {
                    if (Camera.this.mJpegCallback != null) {
                        Camera.this.mJpegCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 16: {
                    PreviewCallback pCb = Camera.this.mPreviewCallback;
                    if (pCb != null) {
                        if (Camera.this.mOneShot) {
                            Camera.this.mPreviewCallback = null;
                        } else if (!Camera.this.mWithBuffer) {
                            Camera.this.setHasPreviewCallback(true, false);
                        }
                        pCb.onPreviewFrame((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 64: {
                    if (Camera.this.mPostviewCallback != null) {
                        Camera.this.mPostviewCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 4: {
                    AutoFocusCallback cb = null;
                    Object object = Camera.this.mAutoFocusCallbackLock;
                    synchronized (object) {
                        cb = Camera.this.mAutoFocusCallback;
                    }
                    if (cb != null) {
                        boolean success = msg.arg1 != 0;
                        cb.onAutoFocus(success, this.mCamera);
                    }
                    return;
                }
                case 8: {
                    if (Camera.this.mZoomListener != null) {
                        Camera.this.mZoomListener.onZoomChange(msg.arg1, msg.arg2 != 0, this.mCamera);
                    }
                    return;
                }
                case 1024: {
                    if (Camera.this.mFaceListener != null) {
                        Camera.this.mFaceListener.onFaceDetection((Face[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 1: {
                    Log.e(Camera.TAG, "Error " + msg.arg1);
                    if (Camera.this.mDetailedErrorCallback != null) {
                        Camera.this.mDetailedErrorCallback.onError(msg.arg1, this.mCamera);
                    } else if (Camera.this.mErrorCallback != null) {
                        if (msg.arg1 == 3) {
                            Camera.this.mErrorCallback.onError(2, this.mCamera);
                        } else {
                            Camera.this.mErrorCallback.onError(msg.arg1, this.mCamera);
                        }
                    }
                    return;
                }
                case 2048: {
                    if (Camera.this.mAutoFocusMoveCallback != null) {
                        Camera.this.mAutoFocusMoveCallback.onAutoFocusMoving(msg.arg1 != 0, this.mCamera);
                    }
                    return;
                }
            }
            Log.e(Camera.TAG, "Unknown message type " + msg.what);
        }
    }

    @Deprecated
    public static interface PreviewCallback {
        public void onPreviewFrame(byte[] var1, Camera var2);
    }

    @Deprecated
    public static class CameraInfo {
        public static final int CAMERA_FACING_BACK = 0;
        public static final int CAMERA_FACING_FRONT = 1;
        public int facing;
        public int orientation;
        public boolean canDisableShutterSound;
    }
}

