/*
 * Decompiled with CFR 0.152.
 */
package android.icu.number;

import android.icu.impl.Utility;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.DecimalQuantity_DualStorageBCD;
import android.icu.impl.number.MacroProps;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.number.FormattedNumber;
import android.icu.number.NumberFormatterImpl;
import android.icu.number.NumberFormatterSettings;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalizedNumberFormatter
extends NumberFormatterSettings<LocalizedNumberFormatter> {
    static final AtomicLongFieldUpdater<LocalizedNumberFormatter> callCount = AtomicLongFieldUpdater.newUpdater(LocalizedNumberFormatter.class, "callCountInternal");
    volatile long callCountInternal;
    volatile LocalizedNumberFormatter savedWithUnit;
    volatile NumberFormatterImpl compiled;

    LocalizedNumberFormatter(NumberFormatterSettings<?> parent, int key, Object value) {
        super(parent, key, value);
    }

    public FormattedNumber format(long input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(double input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Number input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Measure input) {
        MeasureUnit unit = input.getUnit();
        Number number = input.getNumber();
        if (Utility.equals(this.resolve().unit, unit)) {
            return this.format(number);
        }
        LocalizedNumberFormatter withUnit = this.savedWithUnit;
        if (withUnit == null || !Utility.equals(withUnit.resolve().unit, unit)) {
            this.savedWithUnit = withUnit = new LocalizedNumberFormatter(this, 3, unit);
        }
        return withUnit.format(number);
    }

    @Deprecated
    public FormattedNumber format(DecimalQuantity fq) {
        MicroProps micros;
        MacroProps macros = this.resolve();
        long currentCount = callCount.incrementAndGet(this);
        NumberStringBuilder string2 = new NumberStringBuilder();
        if (currentCount == macros.threshold) {
            this.compiled = NumberFormatterImpl.fromMacros(macros);
            micros = this.compiled.apply(fq, string2);
        } else {
            micros = this.compiled != null ? this.compiled.apply(fq, string2) : NumberFormatterImpl.applyStatic(macros, fq, string2);
        }
        return new FormattedNumber(string2, fq, micros);
    }

    @Override
    LocalizedNumberFormatter create(int key, Object value) {
        return new LocalizedNumberFormatter(this, key, value);
    }
}

