/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class MediaDrm
implements AutoCloseable {
    private static final String TAG = "MediaDrm";
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private static final String PERMISSION = "android.permission.ACCESS_DRM_CERTIFICATES";
    private EventHandler mEventHandler;
    private EventHandler mOnKeyStatusChangeEventHandler;
    private EventHandler mOnExpirationUpdateEventHandler;
    private OnEventListener mOnEventListener;
    private OnKeyStatusChangeListener mOnKeyStatusChangeListener;
    private OnExpirationUpdateListener mOnExpirationUpdateListener;
    private long mNativeContext;
    public static final int CERTIFICATE_TYPE_NONE = 0;
    public static final int CERTIFICATE_TYPE_X509 = 1;
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int EVENT_KEY_REQUIRED = 2;
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_VENDOR_DEFINED = 4;
    public static final int EVENT_SESSION_RECLAIMED = 5;
    private static final int DRM_EVENT = 200;
    private static final int EXPIRATION_UPDATE = 201;
    private static final int KEY_STATUS_CHANGE = 202;
    public static final int KEY_TYPE_STREAMING = 1;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final int HDCP_LEVEL_UNKNOWN = 0;
    public static final int HDCP_NONE = 1;
    public static final int HDCP_V1 = 2;
    public static final int HDCP_V2 = 3;
    public static final int HDCP_V2_1 = 4;
    public static final int HDCP_V2_2 = 5;
    public static final int HDCP_NO_DIGITAL_OUTPUT = Integer.MAX_VALUE;
    public static final int SECURITY_LEVEL_UNKNOWN = 0;
    public static final int SECURITY_LEVEL_SW_SECURE_CRYPTO = 1;
    public static final int SECURITY_LEVEL_SW_SECURE_DECODE = 2;
    public static final int SECURITY_LEVEL_HW_SECURE_CRYPTO = 3;
    public static final int SECURITY_LEVEL_HW_SECURE_DECODE = 4;
    public static final int SECURITY_LEVEL_HW_SECURE_ALL = 5;
    public static final int SECURITY_LEVEL_MAX = 6;
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_ALGORITHMS = "algorithms";
    public static final String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";

    public static boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), null);
    }

    public static boolean isCryptoSchemeSupported(UUID uuid, String mimeType) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), mimeType);
    }

    private static byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static boolean isCryptoSchemeSupportedNative(byte[] byArray, String string2) {
        return OverrideMethod.invokeI("android.media.MediaDrm#isCryptoSchemeSupportedNative([BLjava/lang/String;)Z", true, null) != 0;
    }

    public MediaDrm(UUID uuid) throws UnsupportedSchemeException {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<MediaDrm>(this), MediaDrm.getByteArrayFromUUID(uuid), ActivityThread.currentOpPackageName());
        this.mCloseGuard.open("release");
    }

    public void setOnExpirationUpdateListener(OnExpirationUpdateListener listener, Handler handler) {
        if (listener != null) {
            Looper looper;
            Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
            if (looper != null && (this.mEventHandler == null || this.mEventHandler.getLooper() != looper)) {
                this.mEventHandler = new EventHandler(this, looper);
            }
        }
        this.mOnExpirationUpdateListener = listener;
    }

    public void setOnKeyStatusChangeListener(OnKeyStatusChangeListener listener, Handler handler) {
        if (listener != null) {
            Looper looper;
            Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
            if (looper != null && (this.mEventHandler == null || this.mEventHandler.getLooper() != looper)) {
                this.mEventHandler = new EventHandler(this, looper);
            }
        }
        this.mOnKeyStatusChangeListener = listener;
    }

    public void setOnEventListener(OnEventListener listener) {
        this.mOnEventListener = listener;
    }

    private List<KeyStatus> keyStatusListFromParcel(Parcel parcel) {
        int nelems = parcel.readInt();
        ArrayList<KeyStatus> keyStatusList = new ArrayList<KeyStatus>(nelems);
        while (nelems-- > 0) {
            byte[] keyId = parcel.createByteArray();
            int keyStatusCode = parcel.readInt();
            keyStatusList.add(new KeyStatus(keyId, keyStatusCode));
        }
        return keyStatusList;
    }

    private static void postEventFromNative(Object mediadrm_ref, int what, int eventType, int extra, Object obj) {
        MediaDrm md = (MediaDrm)((WeakReference)mediadrm_ref).get();
        if (md == null) {
            return;
        }
        if (md.mEventHandler != null) {
            Message m = md.mEventHandler.obtainMessage(what, eventType, extra, obj);
            md.mEventHandler.sendMessage(m);
        }
    }

    public byte[] openSession() throws NotProvisionedException, ResourceBusyException {
        return this.openSession(MediaDrm.getMaxSecurityLevel());
    }

    public byte[] openSession(int n) throws NotProvisionedException, ResourceBusyException {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#openSession(I)[B", true, this);
    }

    public void closeSession(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#closeSession([B)V", true, this);
    }

    public KeyRequest getKeyRequest(byte[] byArray, byte[] byArray2, String string2, int n, HashMap<String, String> hashMap) throws NotProvisionedException {
        return (KeyRequest)OverrideMethod.invokeA("android.media.MediaDrm#getKeyRequest([B[BLjava/lang/String;ILjava/util/HashMap;)Landroid/media/MediaDrm$KeyRequest;", true, this);
    }

    public byte[] provideKeyResponse(byte[] byArray, byte[] byArray2) throws NotProvisionedException, DeniedByServerException {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#provideKeyResponse([B[B)[B", true, this);
    }

    public void restoreKeys(byte[] byArray, byte[] byArray2) {
        OverrideMethod.invokeV("android.media.MediaDrm#restoreKeys([B[B)V", true, this);
    }

    public void removeKeys(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#removeKeys([B)V", true, this);
    }

    public HashMap<String, String> queryKeyStatus(byte[] byArray) {
        return (HashMap)OverrideMethod.invokeA("android.media.MediaDrm#queryKeyStatus([B)Ljava/util/HashMap;", true, this);
    }

    public ProvisionRequest getProvisionRequest() {
        return this.getProvisionRequestNative(0, "");
    }

    private ProvisionRequest getProvisionRequestNative(int n, String string2) {
        return (ProvisionRequest)OverrideMethod.invokeA("android.media.MediaDrm#getProvisionRequestNative(ILjava/lang/String;)Landroid/media/MediaDrm$ProvisionRequest;", true, this);
    }

    public void provideProvisionResponse(byte[] response) throws DeniedByServerException {
        this.provideProvisionResponseNative(response);
    }

    private Certificate provideProvisionResponseNative(byte[] byArray) throws DeniedByServerException {
        return (Certificate)OverrideMethod.invokeA("android.media.MediaDrm#provideProvisionResponseNative([B)Landroid/media/MediaDrm$Certificate;", true, this);
    }

    public List<byte[]> getSecureStops() {
        return (List)OverrideMethod.invokeA("android.media.MediaDrm#getSecureStops()Ljava/util/List;", true, this);
    }

    public List<byte[]> getSecureStopIds() {
        return (List)OverrideMethod.invokeA("android.media.MediaDrm#getSecureStopIds()Ljava/util/List;", true, this);
    }

    public byte[] getSecureStop(byte[] byArray) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#getSecureStop([B)[B", true, this);
    }

    public void releaseSecureStops(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#releaseSecureStops([B)V", true, this);
    }

    public void removeSecureStop(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#removeSecureStop([B)V", true, this);
    }

    public void removeAllSecureStops() {
        OverrideMethod.invokeV("android.media.MediaDrm#removeAllSecureStops()V", true, this);
    }

    public void releaseAllSecureStops() {
        this.removeAllSecureStops();
    }

    public int getConnectedHdcpLevel() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getConnectedHdcpLevel()I", true, this);
    }

    public int getMaxHdcpLevel() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getMaxHdcpLevel()I", true, this);
    }

    public int getOpenSessionCount() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getOpenSessionCount()I", true, this);
    }

    public int getMaxSessionCount() {
        return OverrideMethod.invokeI("android.media.MediaDrm#getMaxSessionCount()I", true, this);
    }

    public static int getMaxSecurityLevel() {
        return 6;
    }

    public int getSecurityLevel(byte[] byArray) {
        return OverrideMethod.invokeI("android.media.MediaDrm#getSecurityLevel([B)I", true, this);
    }

    public String getPropertyString(String string2) {
        return (String)OverrideMethod.invokeA("android.media.MediaDrm#getPropertyString(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    public void setPropertyString(String string2, String string3) {
        OverrideMethod.invokeV("android.media.MediaDrm#setPropertyString(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public byte[] getPropertyByteArray(String string2) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#getPropertyByteArray(Ljava/lang/String;)[B", true, this);
    }

    public void setPropertyByteArray(String string2, byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#setPropertyByteArray(Ljava/lang/String;[B)V", true, this);
    }

    private static void setCipherAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#setCipherAlgorithmNative(Landroid/media/MediaDrm;[BLjava/lang/String;)V", true, null);
    }

    private static void setMacAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#setMacAlgorithmNative(Landroid/media/MediaDrm;[BLjava/lang/String;)V", true, null);
    }

    private static byte[] encryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#encryptNative(Landroid/media/MediaDrm;[B[B[B[B)[B", true, null);
    }

    private static byte[] decryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#decryptNative(Landroid/media/MediaDrm;[B[B[B[B)[B", true, null);
    }

    private static byte[] signNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#signNative(Landroid/media/MediaDrm;[B[B[B)[B", true, null);
    }

    private static boolean verifyNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return OverrideMethod.invokeI("android.media.MediaDrm#verifyNative(Landroid/media/MediaDrm;[B[B[B[B)Z", true, null) != 0;
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.getMetricsNative();
        return bundle;
    }

    private PersistableBundle getMetricsNative() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.MediaDrm#getMetricsNative()Landroid/os/PersistableBundle;", true, this);
    }

    public CryptoSession getCryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
        return new CryptoSession(sessionId, cipherAlgorithm, macAlgorithm);
    }

    public CertificateRequest getCertificateRequest(int certType, String certAuthority) {
        ProvisionRequest provisionRequest = this.getProvisionRequestNative(certType, certAuthority);
        return new CertificateRequest(provisionRequest.getData(), provisionRequest.getDefaultUrl());
    }

    public Certificate provideCertificateResponse(byte[] response) throws DeniedByServerException {
        return this.provideProvisionResponseNative(response);
    }

    private static byte[] signRSANative(MediaDrm mediaDrm, byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#signRSANative(Landroid/media/MediaDrm;[BLjava/lang/String;[B[B)[B", true, null);
    }

    public byte[] signRSA(byte[] sessionId, String algorithm, byte[] wrappedKey, byte[] message) {
        return MediaDrm.signRSANative(this, sessionId, algorithm, wrappedKey, message);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @Deprecated
    public void release() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.native_release();
        }
    }

    public void native_release() {
        OverrideMethod.invokeV("android.media.MediaDrm#native_release()V", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaDrm#native_init()V", true, null);
    }

    private void native_setup(Object object, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#native_setup(Ljava/lang/Object;[BLjava/lang/String;)V", true, this);
    }

    static {
        System.loadLibrary("media_jni");
        MediaDrm.native_init();
    }

    public static class MetricsConstants {
        public static final String OPEN_SESSION_OK_COUNT = "drm.mediadrm.open_session.ok.count";
        public static final String OPEN_SESSION_ERROR_COUNT = "drm.mediadrm.open_session.error.count";
        public static final String OPEN_SESSION_ERROR_LIST = "drm.mediadrm.open_session.error.list";
        public static final String CLOSE_SESSION_OK_COUNT = "drm.mediadrm.close_session.ok.count";
        public static final String CLOSE_SESSION_ERROR_COUNT = "drm.mediadrm.close_session.error.count";
        public static final String CLOSE_SESSION_ERROR_LIST = "drm.mediadrm.close_session.error.list";
        public static final String SESSION_START_TIMES_MS = "drm.mediadrm.session_start_times_ms";
        public static final String SESSION_END_TIMES_MS = "drm.mediadrm.session_end_times_ms";
        public static final String GET_KEY_REQUEST_OK_COUNT = "drm.mediadrm.get_key_request.ok.count";
        public static final String GET_KEY_REQUEST_ERROR_COUNT = "drm.mediadrm.get_key_request.error.count";
        public static final String GET_KEY_REQUEST_ERROR_LIST = "drm.mediadrm.get_key_request.error.list";
        public static final String GET_KEY_REQUEST_OK_TIME_MICROS = "drm.mediadrm.get_key_request.ok.average_time_micros";
        public static final String PROVIDE_KEY_RESPONSE_OK_COUNT = "drm.mediadrm.provide_key_response.ok.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_key_response.error.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_key_response.error.list";
        public static final String PROVIDE_KEY_RESPONSE_OK_TIME_MICROS = "drm.mediadrm.provide_key_response.ok.average_time_micros";
        public static final String GET_PROVISION_REQUEST_OK_COUNT = "drm.mediadrm.get_provision_request.ok.count";
        public static final String GET_PROVISION_REQUEST_ERROR_COUNT = "drm.mediadrm.get_provision_request.error.count";
        public static final String GET_PROVISION_REQUEST_ERROR_LIST = "drm.mediadrm.get_provision_request.error.list";
        public static final String PROVIDE_PROVISION_RESPONSE_OK_COUNT = "drm.mediadrm.provide_provision_response.ok.count";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_provision_response.error.count";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_provision_response.error.list";
        public static final String GET_DEVICE_UNIQUE_ID_OK_COUNT = "drm.mediadrm.get_device_unique_id.ok.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_COUNT = "drm.mediadrm.get_device_unique_id.error.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_LIST = "drm.mediadrm.get_device_unique_id.error.list";
        public static final String KEY_STATUS_EXPIRED_COUNT = "drm.mediadrm.key_status.EXPIRED.count";
        public static final String KEY_STATUS_INTERNAL_ERROR_COUNT = "drm.mediadrm.key_status.INTERNAL_ERROR.count";
        public static final String KEY_STATUS_OUTPUT_NOT_ALLOWED_COUNT = "drm.mediadrm.key_status_change.OUTPUT_NOT_ALLOWED.count";
        public static final String KEY_STATUS_PENDING_COUNT = "drm.mediadrm.key_status_change.PENDING.count";
        public static final String KEY_STATUS_USABLE_COUNT = "drm.mediadrm.key_status_change.USABLE.count";
        public static final String EVENT_PROVISION_REQUIRED_COUNT = "drm.mediadrm.event.PROVISION_REQUIRED.count";
        public static final String EVENT_KEY_NEEDED_COUNT = "drm.mediadrm.event.KEY_NEEDED.count";
        public static final String EVENT_KEY_EXPIRED_COUNT = "drm.mediadrm.event.KEY_EXPIRED.count";
        public static final String EVENT_VENDOR_DEFINED_COUNT = "drm.mediadrm.event.VENDOR_DEFINED.count";
        public static final String EVENT_SESSION_RECLAIMED_COUNT = "drm.mediadrm.event.SESSION_RECLAIMED.count";

        private MetricsConstants() {
        }
    }

    public static class Certificate {
        private byte[] mWrappedKey;
        private byte[] mCertificateData;

        Certificate() {
        }

        public byte[] getWrappedPrivateKey() {
            if (this.mWrappedKey == null) {
                throw new RuntimeException("Cerfificate is not initialized");
            }
            return this.mWrappedKey;
        }

        public byte[] getContent() {
            if (this.mCertificateData == null) {
                throw new RuntimeException("Cerfificate is not initialized");
            }
            return this.mCertificateData;
        }
    }

    public static class CertificateRequest {
        private byte[] mData;
        private String mDefaultUrl;

        CertificateRequest(byte[] data, String defaultUrl) {
            this.mData = data;
            this.mDefaultUrl = defaultUrl;
        }

        public byte[] getData() {
            return this.mData;
        }

        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }

    public class CryptoSession {
        private byte[] mSessionId;

        CryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
            this.mSessionId = sessionId;
            MediaDrm.setCipherAlgorithmNative(MediaDrm.this, sessionId, cipherAlgorithm);
            MediaDrm.setMacAlgorithmNative(MediaDrm.this, sessionId, macAlgorithm);
        }

        public byte[] encrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.encryptNative(MediaDrm.this, this.mSessionId, keyid, input, iv);
        }

        public byte[] decrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.decryptNative(MediaDrm.this, this.mSessionId, keyid, input, iv);
        }

        public byte[] sign(byte[] keyid, byte[] message) {
            return MediaDrm.signNative(MediaDrm.this, this.mSessionId, keyid, message);
        }

        public boolean verify(byte[] keyid, byte[] message, byte[] signature) {
            return MediaDrm.verifyNative(MediaDrm.this, this.mSessionId, keyid, message, signature);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ArrayProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HdcpLevel {
    }

    public static class ProvisionRequest {
        private byte[] mData;
        private String mDefaultUrl;

        ProvisionRequest() {
        }

        public byte[] getData() {
            if (this.mData == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mData;
        }

        public String getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mDefaultUrl;
        }
    }

    public static class KeyRequest {
        private byte[] mData;
        private String mDefaultUrl;
        private int mRequestType;
        public static final int REQUEST_TYPE_INITIAL = 0;
        public static final int REQUEST_TYPE_RENEWAL = 1;
        public static final int REQUEST_TYPE_RELEASE = 2;
        public static final int REQUEST_TYPE_NONE = 3;
        public static final int REQUEST_TYPE_UPDATE = 4;

        KeyRequest() {
        }

        public byte[] getData() {
            if (this.mData == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mData;
        }

        public String getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mDefaultUrl;
        }

        public int getRequestType() {
            return this.mRequestType;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyType {
    }

    private class EventHandler
    extends Handler {
        private MediaDrm mMediaDrm;

        public EventHandler(MediaDrm md, Looper looper) {
            super(looper);
            this.mMediaDrm = md;
        }

        @Override
        public void handleMessage(Message msg) {
            if (this.mMediaDrm.mNativeContext == 0L) {
                Log.w(MediaDrm.TAG, "MediaDrm went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 200: {
                    if (MediaDrm.this.mOnEventListener != null && msg.obj != null && msg.obj instanceof Parcel) {
                        byte[] data;
                        Parcel parcel = (Parcel)msg.obj;
                        byte[] sessionId = parcel.createByteArray();
                        if (sessionId.length == 0) {
                            sessionId = null;
                        }
                        if ((data = parcel.createByteArray()).length == 0) {
                            data = null;
                        }
                        Log.i(MediaDrm.TAG, "Drm event (" + msg.arg1 + "," + msg.arg2 + ")");
                        MediaDrm.this.mOnEventListener.onEvent(this.mMediaDrm, sessionId, msg.arg1, msg.arg2, data);
                    }
                    return;
                }
                case 202: {
                    Parcel parcel;
                    byte[] sessionId;
                    if (MediaDrm.this.mOnKeyStatusChangeListener != null && msg.obj != null && msg.obj instanceof Parcel && (sessionId = (parcel = (Parcel)msg.obj).createByteArray()).length > 0) {
                        List keyStatusList = MediaDrm.this.keyStatusListFromParcel(parcel);
                        boolean hasNewUsableKey = parcel.readInt() != 0;
                        Log.i(MediaDrm.TAG, "Drm key status changed");
                        MediaDrm.this.mOnKeyStatusChangeListener.onKeyStatusChange(this.mMediaDrm, sessionId, keyStatusList, hasNewUsableKey);
                    }
                    return;
                }
                case 201: {
                    Parcel parcel;
                    byte[] sessionId;
                    if (MediaDrm.this.mOnExpirationUpdateListener != null && msg.obj != null && msg.obj instanceof Parcel && (sessionId = (parcel = (Parcel)msg.obj).createByteArray()).length > 0) {
                        long expirationTime = parcel.readLong();
                        Log.i(MediaDrm.TAG, "Drm key expiration update: " + expirationTime);
                        MediaDrm.this.mOnExpirationUpdateListener.onExpirationUpdate(this.mMediaDrm, sessionId, expirationTime);
                    }
                    return;
                }
            }
            Log.e(MediaDrm.TAG, "Unknown message type " + msg.what);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DrmEvent {
    }

    public static interface OnEventListener {
        public void onEvent(MediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }

    public static class KeyStatus {
        private final byte[] mKeyId;
        private final int mStatusCode;
        public static final int STATUS_USABLE = 0;
        public static final int STATUS_EXPIRED = 1;
        public static final int STATUS_OUTPUT_NOT_ALLOWED = 2;
        public static final int STATUS_PENDING = 3;
        public static final int STATUS_INTERNAL_ERROR = 4;

        KeyStatus(byte[] keyId, int statusCode) {
            this.mKeyId = keyId;
            this.mStatusCode = statusCode;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public byte[] getKeyId() {
            return this.mKeyId;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface KeyStatusCode {
        }
    }

    public static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(MediaDrm var1, byte[] var2, List<KeyStatus> var3, boolean var4);
    }

    public static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(MediaDrm var1, byte[] var2, long var3);
    }

    public static class MediaDrmStateException
    extends IllegalStateException {
        private final int mErrorCode;
        private final String mDiagnosticInfo;

        public MediaDrmStateException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaDrm.error_" + sign + Math.abs(errorCode);
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CertificateType {
    }
}

