/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.hardware.display.WifiDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioRoutesInfo;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IMediaRouterClient;
import android.media.IMediaRouterService;
import android.media.IRemoteVolumeObserver;
import android.media.MediaRouterClientState;
import android.media.RemoteControlClient;
import android.media.VolumeProvider;
import android.media.session.MediaSession;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class MediaRouter {
    private static final String TAG = "MediaRouter";
    private static final boolean DEBUG = Log.isLoggable("MediaRouter", 3);
    static Static sStatic;
    public static final int ROUTE_TYPE_LIVE_AUDIO = 1;
    public static final int ROUTE_TYPE_LIVE_VIDEO = 2;
    public static final int ROUTE_TYPE_REMOTE_DISPLAY = 4;
    public static final int ROUTE_TYPE_USER = 0x800000;
    static final int ROUTE_TYPE_ANY = 0x800007;
    public static final int CALLBACK_FLAG_PERFORM_ACTIVE_SCAN = 1;
    public static final int CALLBACK_FLAG_UNFILTERED_EVENTS = 2;
    public static final int CALLBACK_FLAG_REQUEST_DISCOVERY = 4;
    public static final int CALLBACK_FLAG_PASSIVE_DISCOVERY = 8;
    public static final int AVAILABILITY_FLAG_IGNORE_DEFAULT_ROUTE = 1;
    static final HashMap<Context, MediaRouter> sRouters;

    static String typesToString(int types) {
        StringBuilder result = new StringBuilder();
        if ((types & 1) != 0) {
            result.append("ROUTE_TYPE_LIVE_AUDIO ");
        }
        if ((types & 2) != 0) {
            result.append("ROUTE_TYPE_LIVE_VIDEO ");
        }
        if ((types & 4) != 0) {
            result.append("ROUTE_TYPE_REMOTE_DISPLAY ");
        }
        if ((types & 0x800000) != 0) {
            result.append("ROUTE_TYPE_USER ");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaRouter(Context context) {
        Class<Static> clazz = Static.class;
        synchronized (Static.class) {
            if (sStatic == null) {
                Context appContext = context.getApplicationContext();
                sStatic = new Static(appContext);
                sStatic.startMonitoringRoutes(appContext);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public RouteInfo getDefaultRoute() {
        return MediaRouter.sStatic.mDefaultAudioVideo;
    }

    public RouteInfo getFallbackRoute() {
        return MediaRouter.sStatic.mBluetoothA2dpRoute != null ? MediaRouter.sStatic.mBluetoothA2dpRoute : MediaRouter.sStatic.mDefaultAudioVideo;
    }

    public RouteCategory getSystemCategory() {
        return MediaRouter.sStatic.mSystemCategory;
    }

    public RouteInfo getSelectedRoute() {
        return this.getSelectedRoute(0x800007);
    }

    public RouteInfo getSelectedRoute(int type) {
        if (MediaRouter.sStatic.mSelectedRoute != null && (MediaRouter.sStatic.mSelectedRoute.mSupportedTypes & type) != 0) {
            return MediaRouter.sStatic.mSelectedRoute;
        }
        if (type == 0x800000) {
            return null;
        }
        return MediaRouter.sStatic.mDefaultAudioVideo;
    }

    public boolean isRouteAvailable(int types, int flags) {
        int count = MediaRouter.sStatic.mRoutes.size();
        for (int i = 0; i < count; ++i) {
            RouteInfo route = MediaRouter.sStatic.mRoutes.get(i);
            if (!route.matchesTypes(types) || (flags & 1) != 0 && route == MediaRouter.sStatic.mDefaultAudioVideo) continue;
            return true;
        }
        return false;
    }

    public void addCallback(int types, Callback cb) {
        this.addCallback(types, cb, 0);
    }

    public void addCallback(int types, Callback cb, int flags) {
        int index = this.findCallbackInfo(cb);
        if (index >= 0) {
            CallbackInfo info = MediaRouter.sStatic.mCallbacks.get(index);
            info.type |= types;
            info.flags |= flags;
        } else {
            CallbackInfo info = new CallbackInfo(cb, types, flags, this);
            MediaRouter.sStatic.mCallbacks.add(info);
        }
        sStatic.updateDiscoveryRequest();
    }

    public void removeCallback(Callback cb) {
        int index = this.findCallbackInfo(cb);
        if (index >= 0) {
            MediaRouter.sStatic.mCallbacks.remove(index);
            sStatic.updateDiscoveryRequest();
        } else {
            Log.w(TAG, "removeCallback(" + cb + "): callback not registered");
        }
    }

    private int findCallbackInfo(Callback cb) {
        int count = MediaRouter.sStatic.mCallbacks.size();
        for (int i = 0; i < count; ++i) {
            CallbackInfo info = MediaRouter.sStatic.mCallbacks.get(i);
            if (info.cb != cb) continue;
            return i;
        }
        return -1;
    }

    public void selectRoute(int types, RouteInfo route) {
        if (route == null) {
            throw new IllegalArgumentException("Route cannot be null.");
        }
        MediaRouter.selectRouteStatic(types, route, true);
    }

    public void selectRouteInt(int types, RouteInfo route, boolean explicit) {
        MediaRouter.selectRouteStatic(types, route, explicit);
    }

    static void selectRouteStatic(int types, RouteInfo route, boolean explicit) {
        boolean newRouteHasAddress;
        boolean wasDefaultOrBluetoothRoute;
        Log.v(TAG, "Selecting route: " + route);
        assert (route != null);
        RouteInfo oldRoute = MediaRouter.sStatic.mSelectedRoute;
        RouteInfo currentSystemRoute = sStatic.isBluetoothA2dpOn() ? MediaRouter.sStatic.mBluetoothA2dpRoute : MediaRouter.sStatic.mDefaultAudioVideo;
        boolean bl = wasDefaultOrBluetoothRoute = oldRoute == MediaRouter.sStatic.mDefaultAudioVideo || oldRoute == MediaRouter.sStatic.mBluetoothA2dpRoute;
        if (!(oldRoute != route || wasDefaultOrBluetoothRoute && route != currentSystemRoute)) {
            return;
        }
        if (!route.matchesTypes(types)) {
            Log.w(TAG, "selectRoute ignored; cannot select route with supported types " + MediaRouter.typesToString(route.getSupportedTypes()) + " into route types " + MediaRouter.typesToString(types));
            return;
        }
        RouteInfo btRoute = MediaRouter.sStatic.mBluetoothA2dpRoute;
        if (sStatic.isPlaybackActive() && btRoute != null && (types & 1) != 0 && (route == btRoute || route == MediaRouter.sStatic.mDefaultAudioVideo)) {
            try {
                MediaRouter.sStatic.mAudioService.setBluetoothA2dpOn(route == btRoute);
                if (route != btRoute) {
                    StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 3; i < callStack.length; ++i) {
                        StackTraceElement caller = callStack[i];
                        sb.append(caller.getClassName() + "." + caller.getMethodName() + ":" + caller.getLineNumber()).append("  ");
                    }
                    Log.w(TAG, "Default route is selected while a BT route is available: pkgName=" + MediaRouter.sStatic.mPackageName + ", callers=" + sb.toString());
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error changing Bluetooth A2DP state", e);
            }
        }
        WifiDisplay activeDisplay = MediaRouter.sStatic.mDisplayService.getWifiDisplayStatus().getActiveDisplay();
        boolean oldRouteHasAddress = oldRoute != null && oldRoute.mDeviceAddress != null;
        boolean bl2 = newRouteHasAddress = route.mDeviceAddress != null;
        if (activeDisplay != null || oldRouteHasAddress || newRouteHasAddress) {
            if (newRouteHasAddress && !MediaRouter.matchesDeviceAddress(activeDisplay, route)) {
                if (MediaRouter.sStatic.mCanConfigureWifiDisplays) {
                    MediaRouter.sStatic.mDisplayService.connectWifiDisplay(route.mDeviceAddress);
                } else {
                    Log.e(TAG, "Cannot connect to wifi displays because this process is not allowed to do so.");
                }
            } else if (activeDisplay != null && !newRouteHasAddress) {
                MediaRouter.sStatic.mDisplayService.disconnectWifiDisplay();
            }
        }
        sStatic.setSelectedRoute(route, explicit);
        if (oldRoute != null) {
            MediaRouter.dispatchRouteUnselected(types & oldRoute.getSupportedTypes(), oldRoute);
            if (oldRoute.resolveStatusCode()) {
                MediaRouter.dispatchRouteChanged(oldRoute);
            }
        }
        if (route != null) {
            if (route.resolveStatusCode()) {
                MediaRouter.dispatchRouteChanged(route);
            }
            MediaRouter.dispatchRouteSelected(types & route.getSupportedTypes(), route);
        }
        sStatic.updateDiscoveryRequest();
    }

    static void selectDefaultRouteStatic() {
        if (MediaRouter.sStatic.mSelectedRoute != MediaRouter.sStatic.mBluetoothA2dpRoute && sStatic.isBluetoothA2dpOn()) {
            MediaRouter.selectRouteStatic(0x800007, MediaRouter.sStatic.mBluetoothA2dpRoute, false);
        } else {
            MediaRouter.selectRouteStatic(0x800007, MediaRouter.sStatic.mDefaultAudioVideo, false);
        }
    }

    static boolean matchesDeviceAddress(WifiDisplay display, RouteInfo info) {
        boolean routeHasAddress;
        boolean bl = routeHasAddress = info != null && info.mDeviceAddress != null;
        if (display == null && !routeHasAddress) {
            return true;
        }
        if (display != null && routeHasAddress) {
            return display.getDeviceAddress().equals(info.mDeviceAddress);
        }
        return false;
    }

    public void addUserRoute(UserRouteInfo info) {
        MediaRouter.addRouteStatic(info);
    }

    public void addRouteInt(RouteInfo info) {
        MediaRouter.addRouteStatic(info);
    }

    static void addRouteStatic(RouteInfo info) {
        Log.v(TAG, "Adding route: " + info);
        RouteCategory cat = info.getCategory();
        if (!MediaRouter.sStatic.mCategories.contains(cat)) {
            MediaRouter.sStatic.mCategories.add(cat);
        }
        if (cat.isGroupable() && !(info instanceof RouteGroup)) {
            RouteGroup group = new RouteGroup(info.getCategory());
            group.mSupportedTypes = info.mSupportedTypes;
            MediaRouter.sStatic.mRoutes.add(group);
            MediaRouter.dispatchRouteAdded(group);
            group.addRoute(info);
            info = group;
        } else {
            MediaRouter.sStatic.mRoutes.add(info);
            MediaRouter.dispatchRouteAdded(info);
        }
    }

    public void removeUserRoute(UserRouteInfo info) {
        MediaRouter.removeRouteStatic(info);
    }

    public void clearUserRoutes() {
        for (int i = 0; i < MediaRouter.sStatic.mRoutes.size(); ++i) {
            RouteInfo info = MediaRouter.sStatic.mRoutes.get(i);
            if (!(info instanceof UserRouteInfo) && !(info instanceof RouteGroup)) continue;
            MediaRouter.removeRouteStatic(info);
            --i;
        }
    }

    public void removeRouteInt(RouteInfo info) {
        MediaRouter.removeRouteStatic(info);
    }

    static void removeRouteStatic(RouteInfo info) {
        Log.v(TAG, "Removing route: " + info);
        if (MediaRouter.sStatic.mRoutes.remove(info)) {
            RouteCategory removingCat = info.getCategory();
            int count = MediaRouter.sStatic.mRoutes.size();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                RouteCategory cat = MediaRouter.sStatic.mRoutes.get(i).getCategory();
                if (removingCat != cat) continue;
                found = true;
                break;
            }
            if (info.isSelected()) {
                MediaRouter.selectDefaultRouteStatic();
            }
            if (!found) {
                MediaRouter.sStatic.mCategories.remove(removingCat);
            }
            MediaRouter.dispatchRouteRemoved(info);
        }
    }

    public int getCategoryCount() {
        return MediaRouter.sStatic.mCategories.size();
    }

    public RouteCategory getCategoryAt(int index) {
        return MediaRouter.sStatic.mCategories.get(index);
    }

    public int getRouteCount() {
        return MediaRouter.sStatic.mRoutes.size();
    }

    public RouteInfo getRouteAt(int index) {
        return MediaRouter.sStatic.mRoutes.get(index);
    }

    static int getRouteCountStatic() {
        return MediaRouter.sStatic.mRoutes.size();
    }

    static RouteInfo getRouteAtStatic(int index) {
        return MediaRouter.sStatic.mRoutes.get(index);
    }

    public UserRouteInfo createUserRoute(RouteCategory category) {
        return new UserRouteInfo(category);
    }

    public RouteCategory createRouteCategory(CharSequence name, boolean isGroupable) {
        return new RouteCategory(name, 0x800000, isGroupable);
    }

    public RouteCategory createRouteCategory(int nameResId, boolean isGroupable) {
        return new RouteCategory(nameResId, 0x800000, isGroupable);
    }

    public void rebindAsUser(int userId) {
        sStatic.rebindAsUser(userId);
    }

    static void updateRoute(RouteInfo info) {
        MediaRouter.dispatchRouteChanged(info);
    }

    static void dispatchRouteSelected(int type, RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteSelected(cbi.router, type, info);
        }
    }

    static void dispatchRouteUnselected(int type, RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteUnselected(cbi.router, type, info);
        }
    }

    static void dispatchRouteChanged(RouteInfo info) {
        MediaRouter.dispatchRouteChanged(info, info.mSupportedTypes);
    }

    static void dispatchRouteChanged(RouteInfo info, int oldSupportedTypes) {
        if (DEBUG) {
            Log.d(TAG, "Dispatching route change: " + info);
        }
        int newSupportedTypes = info.mSupportedTypes;
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            boolean oldVisibility = cbi.filterRouteEvent(oldSupportedTypes);
            boolean newVisibility = cbi.filterRouteEvent(newSupportedTypes);
            if (!oldVisibility && newVisibility) {
                cbi.cb.onRouteAdded(cbi.router, info);
                if (info.isSelected()) {
                    cbi.cb.onRouteSelected(cbi.router, newSupportedTypes, info);
                }
            }
            if (oldVisibility || newVisibility) {
                cbi.cb.onRouteChanged(cbi.router, info);
            }
            if (!oldVisibility || newVisibility) continue;
            if (info.isSelected()) {
                cbi.cb.onRouteUnselected(cbi.router, oldSupportedTypes, info);
            }
            cbi.cb.onRouteRemoved(cbi.router, info);
        }
    }

    static void dispatchRouteAdded(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteAdded(cbi.router, info);
        }
    }

    static void dispatchRouteRemoved(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteRemoved(cbi.router, info);
        }
    }

    static void dispatchRouteGrouped(RouteInfo info, RouteGroup group, int index) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(group)) continue;
            cbi.cb.onRouteGrouped(cbi.router, info, group, index);
        }
    }

    static void dispatchRouteUngrouped(RouteInfo info, RouteGroup group) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(group)) continue;
            cbi.cb.onRouteUngrouped(cbi.router, info, group);
        }
    }

    static void dispatchRouteVolumeChanged(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteVolumeChanged(cbi.router, info);
        }
    }

    static void dispatchRoutePresentationDisplayChanged(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRoutePresentationDisplayChanged(cbi.router, info);
        }
    }

    static void systemVolumeChanged(int newValue) {
        RouteInfo selectedRoute = MediaRouter.sStatic.mSelectedRoute;
        if (selectedRoute == null) {
            return;
        }
        if (selectedRoute == MediaRouter.sStatic.mBluetoothA2dpRoute || selectedRoute == MediaRouter.sStatic.mDefaultAudioVideo) {
            MediaRouter.dispatchRouteVolumeChanged(selectedRoute);
        } else if (MediaRouter.sStatic.mBluetoothA2dpRoute != null) {
            try {
                MediaRouter.dispatchRouteVolumeChanged(MediaRouter.sStatic.mAudioService.isBluetoothA2dpOn() ? MediaRouter.sStatic.mBluetoothA2dpRoute : MediaRouter.sStatic.mDefaultAudioVideo);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error checking Bluetooth A2DP state to report volume change", e);
            }
        } else {
            MediaRouter.dispatchRouteVolumeChanged(MediaRouter.sStatic.mDefaultAudioVideo);
        }
    }

    static void updateWifiDisplayStatus(WifiDisplayStatus status) {
        int i;
        WifiDisplay activeDisplay;
        WifiDisplay[] displays;
        if (status.getFeatureState() == 3) {
            displays = status.getDisplays();
            activeDisplay = status.getActiveDisplay();
            if (!MediaRouter.sStatic.mCanConfigureWifiDisplays) {
                displays = activeDisplay != null ? new WifiDisplay[]{activeDisplay} : WifiDisplay.EMPTY_ARRAY;
            }
        } else {
            displays = WifiDisplay.EMPTY_ARRAY;
            activeDisplay = null;
        }
        String activeDisplayAddress = activeDisplay != null ? activeDisplay.getDeviceAddress() : null;
        for (i = 0; i < displays.length; ++i) {
            WifiDisplay d = displays[i];
            if (!MediaRouter.shouldShowWifiDisplay(d, activeDisplay)) continue;
            RouteInfo route = MediaRouter.findWifiDisplayRoute(d);
            if (route == null) {
                route = MediaRouter.makeWifiDisplayRoute(d, status);
                MediaRouter.addRouteStatic(route);
            } else {
                String address = d.getDeviceAddress();
                boolean disconnected = !address.equals(activeDisplayAddress) && address.equals(MediaRouter.sStatic.mPreviousActiveWifiDisplayAddress);
                MediaRouter.updateWifiDisplayRoute(route, d, status, disconnected);
            }
            if (!d.equals(activeDisplay)) continue;
            MediaRouter.selectRouteStatic(route.getSupportedTypes(), route, false);
        }
        i = MediaRouter.sStatic.mRoutes.size();
        while (i-- > 0) {
            WifiDisplay d;
            RouteInfo route = MediaRouter.sStatic.mRoutes.get(i);
            if (route.mDeviceAddress == null || (d = MediaRouter.findWifiDisplay(displays, route.mDeviceAddress)) != null && MediaRouter.shouldShowWifiDisplay(d, activeDisplay)) continue;
            MediaRouter.removeRouteStatic(route);
        }
        MediaRouter.sStatic.mPreviousActiveWifiDisplayAddress = activeDisplayAddress;
    }

    private static boolean shouldShowWifiDisplay(WifiDisplay d, WifiDisplay activeDisplay) {
        return d.isRemembered() || d.equals(activeDisplay);
    }

    static int getWifiDisplayStatusCode(WifiDisplay d, WifiDisplayStatus wfdStatus) {
        int newStatus = wfdStatus.getScanState() == 1 ? 1 : (d.isAvailable() ? (d.canConnect() ? 3 : 5) : 4);
        if (d.equals(wfdStatus.getActiveDisplay())) {
            int activeState = wfdStatus.getActiveDisplayState();
            switch (activeState) {
                case 2: {
                    newStatus = 6;
                    break;
                }
                case 1: {
                    newStatus = 2;
                    break;
                }
                case 0: {
                    Log.e(TAG, "Active display is not connected!");
                }
            }
        }
        return newStatus;
    }

    static boolean isWifiDisplayEnabled(WifiDisplay d, WifiDisplayStatus wfdStatus) {
        return d.isAvailable() && (d.canConnect() || d.equals(wfdStatus.getActiveDisplay()));
    }

    static RouteInfo makeWifiDisplayRoute(WifiDisplay display, WifiDisplayStatus wfdStatus) {
        RouteInfo newRoute = new RouteInfo(MediaRouter.sStatic.mSystemCategory);
        newRoute.mDeviceAddress = display.getDeviceAddress();
        newRoute.mSupportedTypes = 7;
        newRoute.mVolumeHandling = 0;
        newRoute.mPlaybackType = 1;
        newRoute.setRealStatusCode(MediaRouter.getWifiDisplayStatusCode(display, wfdStatus));
        newRoute.mEnabled = MediaRouter.isWifiDisplayEnabled(display, wfdStatus);
        newRoute.mName = display.getFriendlyDisplayName();
        newRoute.mDescription = MediaRouter.sStatic.mResources.getText(17041132);
        newRoute.updatePresentationDisplay();
        newRoute.mDeviceType = 1;
        return newRoute;
    }

    private static void updateWifiDisplayRoute(RouteInfo route, WifiDisplay display, WifiDisplayStatus wfdStatus, boolean disconnected) {
        boolean enabled;
        boolean changed = false;
        String newName = display.getFriendlyDisplayName();
        if (!route.getName().equals(newName)) {
            route.mName = newName;
            changed = true;
        }
        changed |= route.mEnabled != (enabled = MediaRouter.isWifiDisplayEnabled(display, wfdStatus));
        route.mEnabled = enabled;
        if (changed |= route.setRealStatusCode(MediaRouter.getWifiDisplayStatusCode(display, wfdStatus))) {
            MediaRouter.dispatchRouteChanged(route);
        }
        if ((!enabled || disconnected) && route.isSelected()) {
            MediaRouter.selectDefaultRouteStatic();
        }
    }

    private static WifiDisplay findWifiDisplay(WifiDisplay[] displays, String deviceAddress) {
        for (int i = 0; i < displays.length; ++i) {
            WifiDisplay d = displays[i];
            if (!d.getDeviceAddress().equals(deviceAddress)) continue;
            return d;
        }
        return null;
    }

    private static RouteInfo findWifiDisplayRoute(WifiDisplay d) {
        int count = MediaRouter.sStatic.mRoutes.size();
        for (int i = 0; i < count; ++i) {
            RouteInfo info = MediaRouter.sStatic.mRoutes.get(i);
            if (!d.getDeviceAddress().equals(info.mDeviceAddress)) continue;
            return info;
        }
        return null;
    }

    static {
        sRouters = new HashMap();
    }

    static class WifiDisplayStatusChangedReceiver
    extends BroadcastReceiver {
        WifiDisplayStatusChangedReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED")) {
                MediaRouter.updateWifiDisplayStatus((WifiDisplayStatus)intent.getParcelableExtra("android.hardware.display.extra.WIFI_DISPLAY_STATUS"));
            }
        }
    }

    static class VolumeChangeReceiver
    extends BroadcastReceiver {
        VolumeChangeReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.media.VOLUME_CHANGED_ACTION")) {
                int oldVolume;
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                if (streamType != 3) {
                    return;
                }
                int newVolume = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", 0);
                if (newVolume != (oldVolume = intent.getIntExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", 0))) {
                    MediaRouter.systemVolumeChanged(newVolume);
                }
            }
        }
    }

    public static abstract class VolumeCallback {
        public abstract void onVolumeUpdateRequest(RouteInfo var1, int var2);

        public abstract void onVolumeSetRequest(RouteInfo var1, int var2);
    }

    static class VolumeCallbackInfo {
        public final VolumeCallback vcb;
        public final RouteInfo route;

        public VolumeCallbackInfo(VolumeCallback vcb, RouteInfo route) {
            this.vcb = vcb;
            this.route = route;
        }
    }

    public static class SimpleCallback
    extends Callback {
        @Override
        public void onRouteSelected(MediaRouter router, int type, RouteInfo info) {
        }

        @Override
        public void onRouteUnselected(MediaRouter router, int type, RouteInfo info) {
        }

        @Override
        public void onRouteAdded(MediaRouter router, RouteInfo info) {
        }

        @Override
        public void onRouteRemoved(MediaRouter router, RouteInfo info) {
        }

        @Override
        public void onRouteChanged(MediaRouter router, RouteInfo info) {
        }

        @Override
        public void onRouteGrouped(MediaRouter router, RouteInfo info, RouteGroup group, int index) {
        }

        @Override
        public void onRouteUngrouped(MediaRouter router, RouteInfo info, RouteGroup group) {
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter router, RouteInfo info) {
        }
    }

    public static abstract class Callback {
        public abstract void onRouteSelected(MediaRouter var1, int var2, RouteInfo var3);

        public abstract void onRouteUnselected(MediaRouter var1, int var2, RouteInfo var3);

        public abstract void onRouteAdded(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteRemoved(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteChanged(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteGrouped(MediaRouter var1, RouteInfo var2, RouteGroup var3, int var4);

        public abstract void onRouteUngrouped(MediaRouter var1, RouteInfo var2, RouteGroup var3);

        public abstract void onRouteVolumeChanged(MediaRouter var1, RouteInfo var2);

        public void onRoutePresentationDisplayChanged(MediaRouter router, RouteInfo info) {
        }
    }

    static class CallbackInfo {
        public int type;
        public int flags;
        public final Callback cb;
        public final MediaRouter router;

        public CallbackInfo(Callback cb, int type, int flags, MediaRouter router) {
            this.cb = cb;
            this.type = type;
            this.flags = flags;
            this.router = router;
        }

        public boolean filterRouteEvent(RouteInfo route) {
            return this.filterRouteEvent(route.mSupportedTypes);
        }

        public boolean filterRouteEvent(int supportedTypes) {
            return (this.flags & 2) != 0 || (this.type & supportedTypes) != 0;
        }
    }

    public static class RouteCategory {
        CharSequence mName;
        int mNameResId;
        int mTypes;
        final boolean mGroupable;
        boolean mIsSystem;

        RouteCategory(CharSequence name, int types, boolean groupable) {
            this.mName = name;
            this.mTypes = types;
            this.mGroupable = groupable;
        }

        RouteCategory(int nameResId, int types, boolean groupable) {
            this.mNameResId = nameResId;
            this.mTypes = types;
            this.mGroupable = groupable;
        }

        public CharSequence getName() {
            return this.getName(MediaRouter.sStatic.mResources);
        }

        public CharSequence getName(Context context) {
            return this.getName(context.getResources());
        }

        CharSequence getName(Resources res) {
            if (this.mNameResId != 0) {
                return res.getText(this.mNameResId);
            }
            return this.mName;
        }

        public List<RouteInfo> getRoutes(List<RouteInfo> out) {
            if (out == null) {
                out = new ArrayList<RouteInfo>();
            } else {
                out.clear();
            }
            int count = MediaRouter.getRouteCountStatic();
            for (int i = 0; i < count; ++i) {
                RouteInfo route = MediaRouter.getRouteAtStatic(i);
                if (route.mCategory != this) continue;
                out.add(route);
            }
            return out;
        }

        public int getSupportedTypes() {
            return this.mTypes;
        }

        public boolean isGroupable() {
            return this.mGroupable;
        }

        public boolean isSystem() {
            return this.mIsSystem;
        }

        public String toString() {
            return "RouteCategory{ name=" + this.getName() + " types=" + MediaRouter.typesToString(this.mTypes) + " groupable=" + this.mGroupable + " }";
        }
    }

    public static class RouteGroup
    extends RouteInfo {
        final ArrayList<RouteInfo> mRoutes = new ArrayList();
        private boolean mUpdateName;

        RouteGroup(RouteCategory category) {
            super(category);
            this.mGroup = this;
            this.mVolumeHandling = 0;
        }

        @Override
        CharSequence getName(Resources res) {
            if (this.mUpdateName) {
                this.updateName();
            }
            return super.getName(res);
        }

        public void addRoute(RouteInfo route) {
            if (route.getGroup() != null) {
                throw new IllegalStateException("Route " + route + " is already part of a group.");
            }
            if (route.getCategory() != this.mCategory) {
                throw new IllegalArgumentException("Route cannot be added to a group with a different category. (Route category=" + route.getCategory() + " group category=" + this.mCategory + ")");
            }
            int at = this.mRoutes.size();
            this.mRoutes.add(route);
            route.mGroup = this;
            this.mUpdateName = true;
            this.updateVolume();
            this.routeUpdated();
            MediaRouter.dispatchRouteGrouped(route, this, at);
        }

        public void addRoute(RouteInfo route, int insertAt) {
            if (route.getGroup() != null) {
                throw new IllegalStateException("Route " + route + " is already part of a group.");
            }
            if (route.getCategory() != this.mCategory) {
                throw new IllegalArgumentException("Route cannot be added to a group with a different category. (Route category=" + route.getCategory() + " group category=" + this.mCategory + ")");
            }
            this.mRoutes.add(insertAt, route);
            route.mGroup = this;
            this.mUpdateName = true;
            this.updateVolume();
            this.routeUpdated();
            MediaRouter.dispatchRouteGrouped(route, this, insertAt);
        }

        public void removeRoute(RouteInfo route) {
            if (route.getGroup() != this) {
                throw new IllegalArgumentException("Route " + route + " is not a member of this group.");
            }
            this.mRoutes.remove(route);
            route.mGroup = null;
            this.mUpdateName = true;
            this.updateVolume();
            MediaRouter.dispatchRouteUngrouped(route, this);
            this.routeUpdated();
        }

        public void removeRoute(int index) {
            RouteInfo route = this.mRoutes.remove(index);
            route.mGroup = null;
            this.mUpdateName = true;
            this.updateVolume();
            MediaRouter.dispatchRouteUngrouped(route, this);
            this.routeUpdated();
        }

        public int getRouteCount() {
            return this.mRoutes.size();
        }

        public RouteInfo getRouteAt(int index) {
            return this.mRoutes.get(index);
        }

        public void setIconDrawable(Drawable icon) {
            this.mIcon = icon;
        }

        public void setIconResource(int resId) {
            this.setIconDrawable(MediaRouter.sStatic.mResources.getDrawable(resId));
        }

        @Override
        public void requestSetVolume(int volume) {
            int maxVol = this.getVolumeMax();
            if (maxVol == 0) {
                return;
            }
            float scaledVolume = (float)volume / (float)maxVol;
            int routeCount = this.getRouteCount();
            for (int i = 0; i < routeCount; ++i) {
                RouteInfo route = this.getRouteAt(i);
                int routeVol = (int)(scaledVolume * (float)route.getVolumeMax());
                route.requestSetVolume(routeVol);
            }
            if (volume != this.mVolume) {
                this.mVolume = volume;
                MediaRouter.dispatchRouteVolumeChanged(this);
            }
        }

        @Override
        public void requestUpdateVolume(int direction) {
            int maxVol = this.getVolumeMax();
            if (maxVol == 0) {
                return;
            }
            int routeCount = this.getRouteCount();
            int volume = 0;
            for (int i = 0; i < routeCount; ++i) {
                RouteInfo route = this.getRouteAt(i);
                route.requestUpdateVolume(direction);
                int routeVol = route.getVolume();
                if (routeVol <= volume) continue;
                volume = routeVol;
            }
            if (volume != this.mVolume) {
                this.mVolume = volume;
                MediaRouter.dispatchRouteVolumeChanged(this);
            }
        }

        void memberNameChanged(RouteInfo info, CharSequence name) {
            this.mUpdateName = true;
            this.routeUpdated();
        }

        void memberStatusChanged(RouteInfo info, CharSequence status) {
            this.setStatusInt(status);
        }

        void memberVolumeChanged(RouteInfo info) {
            this.updateVolume();
        }

        void updateVolume() {
            int routeCount = this.getRouteCount();
            int volume = 0;
            for (int i = 0; i < routeCount; ++i) {
                int routeVol = this.getRouteAt(i).getVolume();
                if (routeVol <= volume) continue;
                volume = routeVol;
            }
            if (volume != this.mVolume) {
                this.mVolume = volume;
                MediaRouter.dispatchRouteVolumeChanged(this);
            }
        }

        @Override
        void routeUpdated() {
            int types = 0;
            int count = this.mRoutes.size();
            if (count == 0) {
                MediaRouter.removeRouteStatic(this);
                return;
            }
            int maxVolume = 0;
            boolean isLocal = true;
            boolean isFixedVolume = true;
            for (int i = 0; i < count; ++i) {
                RouteInfo route = this.mRoutes.get(i);
                types |= route.mSupportedTypes;
                int routeMaxVolume = route.getVolumeMax();
                if (routeMaxVolume > maxVolume) {
                    maxVolume = routeMaxVolume;
                }
                isLocal &= route.getPlaybackType() == 0;
                isFixedVolume &= route.getVolumeHandling() == 0;
            }
            this.mPlaybackType = isLocal ? 0 : 1;
            this.mVolumeHandling = isFixedVolume ? 0 : 1;
            this.mSupportedTypes = types;
            this.mVolumeMax = maxVolume;
            this.mIcon = count == 1 ? this.mRoutes.get(0).getIconDrawable() : null;
            super.routeUpdated();
        }

        void updateName() {
            StringBuilder sb = new StringBuilder();
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                RouteInfo info = this.mRoutes.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(info.getName());
            }
            this.mName = sb.toString();
            this.mUpdateName = false;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append('[');
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.mRoutes.get(i));
            }
            sb.append(']');
            return sb.toString();
        }
    }

    public static class UserRouteInfo
    extends RouteInfo {
        RemoteControlClient mRcc;
        SessionVolumeProvider mSvp;

        UserRouteInfo(RouteCategory category) {
            super(category);
            this.mSupportedTypes = 0x800000;
            this.mPlaybackType = 1;
            this.mVolumeHandling = 0;
        }

        public void setName(CharSequence name) {
            this.mNameResId = 0;
            this.mName = name;
            this.routeUpdated();
        }

        public void setName(int resId) {
            this.mNameResId = resId;
            this.mName = null;
            this.routeUpdated();
        }

        public void setDescription(CharSequence description) {
            this.mDescription = description;
            this.routeUpdated();
        }

        public void setStatus(CharSequence status) {
            this.setStatusInt(status);
        }

        public void setRemoteControlClient(RemoteControlClient rcc) {
            this.mRcc = rcc;
            this.updatePlaybackInfoOnRcc();
        }

        public RemoteControlClient getRemoteControlClient() {
            return this.mRcc;
        }

        public void setIconDrawable(Drawable icon) {
            this.mIcon = icon;
        }

        public void setIconResource(int resId) {
            this.setIconDrawable(MediaRouter.sStatic.mResources.getDrawable(resId));
        }

        public void setVolumeCallback(VolumeCallback vcb) {
            this.mVcb = new VolumeCallbackInfo(vcb, this);
        }

        public void setPlaybackType(int type) {
            if (this.mPlaybackType != type) {
                this.mPlaybackType = type;
                this.configureSessionVolume();
            }
        }

        public void setVolumeHandling(int volumeHandling) {
            if (this.mVolumeHandling != volumeHandling) {
                this.mVolumeHandling = volumeHandling;
                this.configureSessionVolume();
            }
        }

        public void setVolume(int volume) {
            if (this.mVolume != (volume = Math.max(0, Math.min(volume, this.getVolumeMax())))) {
                this.mVolume = volume;
                if (this.mSvp != null) {
                    this.mSvp.setCurrentVolume(this.mVolume);
                }
                MediaRouter.dispatchRouteVolumeChanged(this);
                if (this.mGroup != null) {
                    this.mGroup.memberVolumeChanged(this);
                }
            }
        }

        @Override
        public void requestSetVolume(int volume) {
            if (this.mVolumeHandling == 1) {
                if (this.mVcb == null) {
                    Log.e(MediaRouter.TAG, "Cannot requestSetVolume on user route - no volume callback set");
                    return;
                }
                this.mVcb.vcb.onVolumeSetRequest(this, volume);
            }
        }

        @Override
        public void requestUpdateVolume(int direction) {
            if (this.mVolumeHandling == 1) {
                if (this.mVcb == null) {
                    Log.e(MediaRouter.TAG, "Cannot requestChangeVolume on user route - no volumec callback set");
                    return;
                }
                this.mVcb.vcb.onVolumeUpdateRequest(this, direction);
            }
        }

        public void setVolumeMax(int volumeMax) {
            if (this.mVolumeMax != volumeMax) {
                this.mVolumeMax = volumeMax;
                this.configureSessionVolume();
            }
        }

        public void setPlaybackStream(int stream) {
            if (this.mPlaybackStream != stream) {
                this.mPlaybackStream = stream;
                this.configureSessionVolume();
            }
        }

        private void updatePlaybackInfoOnRcc() {
            this.configureSessionVolume();
        }

        private void configureSessionVolume() {
            if (this.mRcc == null) {
                if (DEBUG) {
                    Log.d(MediaRouter.TAG, "No Rcc to configure volume for route " + this.getName());
                }
                return;
            }
            MediaSession session = this.mRcc.getMediaSession();
            if (session == null) {
                if (DEBUG) {
                    Log.d(MediaRouter.TAG, "Rcc has no session to configure volume");
                }
                return;
            }
            if (this.mPlaybackType == 1) {
                int volumeControl = 0;
                switch (this.mVolumeHandling) {
                    case 1: {
                        volumeControl = 2;
                        break;
                    }
                }
                if (this.mSvp == null || this.mSvp.getVolumeControl() != volumeControl || this.mSvp.getMaxVolume() != this.mVolumeMax) {
                    this.mSvp = new SessionVolumeProvider(volumeControl, this.mVolumeMax, this.mVolume);
                    session.setPlaybackToRemote(this.mSvp);
                }
            } else {
                AudioAttributes.Builder bob = new AudioAttributes.Builder();
                bob.setLegacyStreamType(this.mPlaybackStream);
                session.setPlaybackToLocal(bob.build());
                this.mSvp = null;
            }
        }

        class SessionVolumeProvider
        extends VolumeProvider {
            public SessionVolumeProvider(int volumeControl, int maxVolume, int currentVolume) {
                super(volumeControl, maxVolume, currentVolume);
            }

            @Override
            public void onSetVolumeTo(final int volume) {
                MediaRouter.sStatic.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (UserRouteInfo.this.mVcb != null) {
                            UserRouteInfo.this.mVcb.vcb.onVolumeSetRequest(UserRouteInfo.this.mVcb.route, volume);
                        }
                    }
                });
            }

            @Override
            public void onAdjustVolume(final int direction) {
                MediaRouter.sStatic.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (UserRouteInfo.this.mVcb != null) {
                            UserRouteInfo.this.mVcb.vcb.onVolumeUpdateRequest(UserRouteInfo.this.mVcb.route, direction);
                        }
                    }
                });
            }
        }
    }

    public static class RouteInfo {
        CharSequence mName;
        int mNameResId;
        CharSequence mDescription;
        private CharSequence mStatus;
        int mSupportedTypes;
        int mDeviceType;
        RouteGroup mGroup;
        final RouteCategory mCategory;
        Drawable mIcon;
        int mPlaybackType = 0;
        int mVolumeMax = 15;
        int mVolume = 15;
        int mVolumeHandling = 1;
        int mPlaybackStream = 3;
        VolumeCallbackInfo mVcb;
        Display mPresentationDisplay;
        int mPresentationDisplayId = -1;
        String mDeviceAddress;
        boolean mEnabled = true;
        String mGlobalRouteId;
        private int mRealStatusCode;
        private int mResolvedStatusCode;
        public static final int STATUS_NONE = 0;
        public static final int STATUS_SCANNING = 1;
        public static final int STATUS_CONNECTING = 2;
        public static final int STATUS_AVAILABLE = 3;
        public static final int STATUS_NOT_AVAILABLE = 4;
        public static final int STATUS_IN_USE = 5;
        public static final int STATUS_CONNECTED = 6;
        public static final int DEVICE_TYPE_UNKNOWN = 0;
        public static final int DEVICE_TYPE_TV = 1;
        public static final int DEVICE_TYPE_SPEAKER = 2;
        public static final int DEVICE_TYPE_BLUETOOTH = 3;
        private Object mTag;
        public static final int PLAYBACK_TYPE_LOCAL = 0;
        public static final int PLAYBACK_TYPE_REMOTE = 1;
        public static final int PLAYBACK_VOLUME_FIXED = 0;
        public static final int PLAYBACK_VOLUME_VARIABLE = 1;
        final IRemoteVolumeObserver.Stub mRemoteVolObserver = new IRemoteVolumeObserver.Stub(){

            @Override
            public void dispatchRemoteVolumeUpdate(final int direction, final int value) {
                MediaRouter.sStatic.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (mVcb != null) {
                            if (direction != 0) {
                                mVcb.vcb.onVolumeUpdateRequest(mVcb.route, direction);
                            } else {
                                mVcb.vcb.onVolumeSetRequest(mVcb.route, value);
                            }
                        }
                    }
                });
            }
        };

        RouteInfo(RouteCategory category) {
            this.mCategory = category;
            this.mDeviceType = 0;
        }

        public CharSequence getName() {
            return this.getName(MediaRouter.sStatic.mResources);
        }

        public CharSequence getName(Context context) {
            return this.getName(context.getResources());
        }

        CharSequence getName(Resources res) {
            if (this.mNameResId != 0) {
                return res.getText(this.mNameResId);
            }
            return this.mName;
        }

        public CharSequence getDescription() {
            return this.mDescription;
        }

        public CharSequence getStatus() {
            return this.mStatus;
        }

        boolean setRealStatusCode(int statusCode) {
            if (this.mRealStatusCode != statusCode) {
                this.mRealStatusCode = statusCode;
                return this.resolveStatusCode();
            }
            return false;
        }

        boolean resolveStatusCode() {
            int resId;
            int statusCode = this.mRealStatusCode;
            if (this.isSelected()) {
                switch (statusCode) {
                    case 1: 
                    case 3: {
                        statusCode = 2;
                    }
                }
            }
            if (this.mResolvedStatusCode == statusCode) {
                return false;
            }
            this.mResolvedStatusCode = statusCode;
            switch (statusCode) {
                case 1: {
                    resId = 17040215;
                    break;
                }
                case 2: {
                    resId = 17040212;
                    break;
                }
                case 3: {
                    resId = 17040211;
                    break;
                }
                case 4: {
                    resId = 17040214;
                    break;
                }
                case 5: {
                    resId = 17040213;
                    break;
                }
                default: {
                    resId = 0;
                }
            }
            this.mStatus = resId != 0 ? MediaRouter.sStatic.mResources.getText(resId) : null;
            return true;
        }

        public int getStatusCode() {
            return this.mResolvedStatusCode;
        }

        public int getSupportedTypes() {
            return this.mSupportedTypes;
        }

        public int getDeviceType() {
            return this.mDeviceType;
        }

        public boolean matchesTypes(int types) {
            return (this.mSupportedTypes & types) != 0;
        }

        public RouteGroup getGroup() {
            return this.mGroup;
        }

        public RouteCategory getCategory() {
            return this.mCategory;
        }

        public Drawable getIconDrawable() {
            return this.mIcon;
        }

        public void setTag(Object tag) {
            this.mTag = tag;
            this.routeUpdated();
        }

        public Object getTag() {
            return this.mTag;
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        public int getPlaybackStream() {
            return this.mPlaybackStream;
        }

        public int getVolume() {
            if (this.mPlaybackType == 0) {
                int vol = 0;
                try {
                    vol = MediaRouter.sStatic.mAudioService.getStreamVolume(this.mPlaybackStream);
                }
                catch (RemoteException e) {
                    Log.e(MediaRouter.TAG, "Error getting local stream volume", e);
                }
                return vol;
            }
            return this.mVolume;
        }

        public void requestSetVolume(int volume) {
            if (this.mPlaybackType == 0) {
                try {
                    MediaRouter.sStatic.mAudioService.setStreamVolume(this.mPlaybackStream, volume, 0, ActivityThread.currentPackageName());
                }
                catch (RemoteException e) {
                    Log.e(MediaRouter.TAG, "Error setting local stream volume", e);
                }
            } else {
                sStatic.requestSetVolume(this, volume);
            }
        }

        public void requestUpdateVolume(int direction) {
            if (this.mPlaybackType == 0) {
                try {
                    int volume = Math.max(0, Math.min(this.getVolume() + direction, this.getVolumeMax()));
                    MediaRouter.sStatic.mAudioService.setStreamVolume(this.mPlaybackStream, volume, 0, ActivityThread.currentPackageName());
                }
                catch (RemoteException e) {
                    Log.e(MediaRouter.TAG, "Error setting local stream volume", e);
                }
            } else {
                sStatic.requestUpdateVolume(this, direction);
            }
        }

        public int getVolumeMax() {
            if (this.mPlaybackType == 0) {
                int volMax = 0;
                try {
                    volMax = MediaRouter.sStatic.mAudioService.getStreamMaxVolume(this.mPlaybackStream);
                }
                catch (RemoteException e) {
                    Log.e(MediaRouter.TAG, "Error getting local stream volume", e);
                }
                return volMax;
            }
            return this.mVolumeMax;
        }

        public int getVolumeHandling() {
            return this.mVolumeHandling;
        }

        public Display getPresentationDisplay() {
            return this.mPresentationDisplay;
        }

        boolean updatePresentationDisplay() {
            Display display = this.choosePresentationDisplay();
            if (this.mPresentationDisplay != display) {
                this.mPresentationDisplay = display;
                return true;
            }
            return false;
        }

        private Display choosePresentationDisplay() {
            if ((this.mSupportedTypes & 2) != 0) {
                Display[] displays = sStatic.getAllPresentationDisplays();
                if (this.mPresentationDisplayId >= 0) {
                    for (Display display : displays) {
                        if (display.getDisplayId() != this.mPresentationDisplayId) continue;
                        return display;
                    }
                    return null;
                }
                if (this.mDeviceAddress != null) {
                    for (Display display : displays) {
                        if (display.getType() != 3 || !this.mDeviceAddress.equals(display.getAddress())) continue;
                        return display;
                    }
                    return null;
                }
                if (this == MediaRouter.sStatic.mDefaultAudioVideo && displays.length > 0) {
                    return displays[0];
                }
            }
            return null;
        }

        public String getDeviceAddress() {
            return this.mDeviceAddress;
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public boolean isConnecting() {
            return this.mResolvedStatusCode == 2;
        }

        public boolean isSelected() {
            return this == MediaRouter.sStatic.mSelectedRoute;
        }

        public boolean isDefault() {
            return this == MediaRouter.sStatic.mDefaultAudioVideo;
        }

        public boolean isBluetooth() {
            return this == MediaRouter.sStatic.mBluetoothA2dpRoute;
        }

        public void select() {
            MediaRouter.selectRouteStatic(this.mSupportedTypes, this, true);
        }

        void setStatusInt(CharSequence status) {
            if (!status.equals(this.mStatus)) {
                this.mStatus = status;
                if (this.mGroup != null) {
                    this.mGroup.memberStatusChanged(this, status);
                }
                this.routeUpdated();
            }
        }

        void routeUpdated() {
            MediaRouter.updateRoute(this);
        }

        public String toString() {
            String supportedTypes = MediaRouter.typesToString(this.getSupportedTypes());
            return this.getClass().getSimpleName() + "{ name=" + this.getName() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", category=" + this.getCategory() + ", supportedTypes=" + supportedTypes + ", presentationDisplay=" + this.mPresentationDisplay + " }";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface PlaybackVolume {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PlaybackType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DeviceType {
        }
    }

    static class Static
    implements DisplayManager.DisplayListener {
        final String mPackageName;
        final Resources mResources;
        final IAudioService mAudioService;
        final DisplayManager mDisplayService;
        final IMediaRouterService mMediaRouterService;
        final Handler mHandler;
        final CopyOnWriteArrayList<CallbackInfo> mCallbacks = new CopyOnWriteArrayList();
        final ArrayList<RouteInfo> mRoutes = new ArrayList();
        final ArrayList<RouteCategory> mCategories = new ArrayList();
        final RouteCategory mSystemCategory;
        final AudioRoutesInfo mCurAudioRoutesInfo = new AudioRoutesInfo();
        RouteInfo mDefaultAudioVideo;
        RouteInfo mBluetoothA2dpRoute;
        RouteInfo mSelectedRoute;
        final boolean mCanConfigureWifiDisplays;
        boolean mActivelyScanningWifiDisplays;
        String mPreviousActiveWifiDisplayAddress;
        int mDiscoveryRequestRouteTypes;
        boolean mDiscoverRequestActiveScan;
        int mCurrentUserId = -1;
        IMediaRouterClient mClient;
        MediaRouterClientState mClientState;
        final IAudioRoutesObserver.Stub mAudioRoutesObserver = new IAudioRoutesObserver.Stub(){

            @Override
            public void dispatchAudioRoutesChanged(final AudioRoutesInfo newRoutes) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        this.updateAudioRoutes(newRoutes);
                    }
                });
            }
        };

        Static(Context appContext) {
            this.mPackageName = appContext.getPackageName();
            this.mResources = appContext.getResources();
            this.mHandler = new Handler(appContext.getMainLooper());
            IBinder b = ServiceManager.getService("audio");
            this.mAudioService = IAudioService.Stub.asInterface(b);
            this.mDisplayService = (DisplayManager)appContext.getSystemService("display");
            this.mMediaRouterService = IMediaRouterService.Stub.asInterface(ServiceManager.getService("media_router"));
            this.mSystemCategory = new RouteCategory(17039779, 3, false);
            this.mSystemCategory.mIsSystem = true;
            this.mCanConfigureWifiDisplays = appContext.checkPermission("android.permission.CONFIGURE_WIFI_DISPLAY", Process.myPid(), Process.myUid()) == 0;
        }

        void startMonitoringRoutes(Context appContext) {
            this.mDefaultAudioVideo = new RouteInfo(this.mSystemCategory);
            this.mDefaultAudioVideo.mNameResId = 17039780;
            this.mDefaultAudioVideo.mSupportedTypes = 3;
            this.mDefaultAudioVideo.updatePresentationDisplay();
            if (((AudioManager)appContext.getSystemService("audio")).isVolumeFixed()) {
                this.mDefaultAudioVideo.mVolumeHandling = 0;
            }
            MediaRouter.addRouteStatic(this.mDefaultAudioVideo);
            MediaRouter.updateWifiDisplayStatus(this.mDisplayService.getWifiDisplayStatus());
            appContext.registerReceiver(new WifiDisplayStatusChangedReceiver(), new IntentFilter("android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED"));
            appContext.registerReceiver(new VolumeChangeReceiver(), new IntentFilter("android.media.VOLUME_CHANGED_ACTION"));
            this.mDisplayService.registerDisplayListener(this, this.mHandler);
            AudioRoutesInfo newAudioRoutes = null;
            try {
                newAudioRoutes = this.mAudioService.startWatchingRoutes(this.mAudioRoutesObserver);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (newAudioRoutes != null) {
                this.updateAudioRoutes(newAudioRoutes);
            }
            this.rebindAsUser(UserHandle.myUserId());
            if (this.mSelectedRoute == null) {
                MediaRouter.selectDefaultRouteStatic();
            }
        }

        void updateAudioRoutes(AudioRoutesInfo newRoutes) {
            boolean audioRoutesChanged = false;
            boolean forceUseDefaultRoute = false;
            if (newRoutes.mainType != this.mCurAudioRoutesInfo.mainType) {
                this.mCurAudioRoutesInfo.mainType = newRoutes.mainType;
                int name = (newRoutes.mainType & 2) != 0 || (newRoutes.mainType & 1) != 0 ? 17039783 : ((newRoutes.mainType & 4) != 0 ? 17039781 : ((newRoutes.mainType & 8) != 0 ? 17039782 : ((newRoutes.mainType & 0x10) != 0 ? 17039784 : 17039780)));
                this.mDefaultAudioVideo.mNameResId = name;
                MediaRouter.dispatchRouteChanged(this.mDefaultAudioVideo);
                if ((newRoutes.mainType & 0x13) != 0) {
                    forceUseDefaultRoute = true;
                }
                audioRoutesChanged = true;
            }
            if (!TextUtils.equals(newRoutes.bluetoothName, this.mCurAudioRoutesInfo.bluetoothName)) {
                forceUseDefaultRoute = false;
                this.mCurAudioRoutesInfo.bluetoothName = newRoutes.bluetoothName;
                if (this.mCurAudioRoutesInfo.bluetoothName != null) {
                    if (this.mBluetoothA2dpRoute == null) {
                        RouteInfo info = new RouteInfo(this.mSystemCategory);
                        info.mName = this.mCurAudioRoutesInfo.bluetoothName;
                        info.mDescription = this.mResources.getText(17039581);
                        info.mSupportedTypes = 1;
                        info.mDeviceType = 3;
                        this.mBluetoothA2dpRoute = info;
                        MediaRouter.addRouteStatic(this.mBluetoothA2dpRoute);
                    } else {
                        this.mBluetoothA2dpRoute.mName = this.mCurAudioRoutesInfo.bluetoothName;
                        MediaRouter.dispatchRouteChanged(this.mBluetoothA2dpRoute);
                    }
                } else if (this.mBluetoothA2dpRoute != null) {
                    MediaRouter.removeRouteStatic(this.mBluetoothA2dpRoute);
                    this.mBluetoothA2dpRoute = null;
                }
                audioRoutesChanged = true;
            }
            if (audioRoutesChanged) {
                Log.v(MediaRouter.TAG, "Audio routes updated: " + newRoutes + ", a2dp=" + this.isBluetoothA2dpOn());
                if (this.mSelectedRoute == null || this.mSelectedRoute == this.mDefaultAudioVideo || this.mSelectedRoute == this.mBluetoothA2dpRoute) {
                    if (forceUseDefaultRoute || this.mBluetoothA2dpRoute == null) {
                        MediaRouter.selectRouteStatic(1, this.mDefaultAudioVideo, false);
                    } else {
                        MediaRouter.selectRouteStatic(1, this.mBluetoothA2dpRoute, false);
                    }
                }
            }
        }

        boolean isBluetoothA2dpOn() {
            try {
                return this.mBluetoothA2dpRoute != null && this.mAudioService.isBluetoothA2dpOn();
            }
            catch (RemoteException e) {
                Log.e(MediaRouter.TAG, "Error querying Bluetooth A2DP state", e);
                return false;
            }
        }

        void updateDiscoveryRequest() {
            int routeTypes = 0;
            int passiveRouteTypes = 0;
            boolean activeScan = false;
            boolean activeScanWifiDisplay = false;
            int count = this.mCallbacks.size();
            for (int i = 0; i < count; ++i) {
                CallbackInfo cbi = this.mCallbacks.get(i);
                if ((cbi.flags & 5) != 0) {
                    routeTypes |= cbi.type;
                } else if ((cbi.flags & 8) != 0) {
                    passiveRouteTypes |= cbi.type;
                } else {
                    routeTypes |= cbi.type;
                }
                if ((cbi.flags & 1) == 0) continue;
                activeScan = true;
                if ((cbi.type & 4) == 0) continue;
                activeScanWifiDisplay = true;
            }
            if (routeTypes != 0 || activeScan) {
                routeTypes |= passiveRouteTypes;
            }
            if (this.mCanConfigureWifiDisplays) {
                if (this.mSelectedRoute != null && this.mSelectedRoute.matchesTypes(4)) {
                    activeScanWifiDisplay = false;
                }
                if (activeScanWifiDisplay) {
                    if (!this.mActivelyScanningWifiDisplays) {
                        this.mActivelyScanningWifiDisplays = true;
                        this.mDisplayService.startWifiDisplayScan();
                    }
                } else if (this.mActivelyScanningWifiDisplays) {
                    this.mActivelyScanningWifiDisplays = false;
                    this.mDisplayService.stopWifiDisplayScan();
                }
            }
            if (routeTypes != this.mDiscoveryRequestRouteTypes || activeScan != this.mDiscoverRequestActiveScan) {
                this.mDiscoveryRequestRouteTypes = routeTypes;
                this.mDiscoverRequestActiveScan = activeScan;
                this.publishClientDiscoveryRequest();
            }
        }

        @Override
        public void onDisplayAdded(int displayId) {
            this.updatePresentationDisplays(displayId);
        }

        @Override
        public void onDisplayChanged(int displayId) {
            this.updatePresentationDisplays(displayId);
        }

        @Override
        public void onDisplayRemoved(int displayId) {
            this.updatePresentationDisplays(displayId);
        }

        public Display[] getAllPresentationDisplays() {
            return this.mDisplayService.getDisplays("android.hardware.display.category.PRESENTATION");
        }

        private void updatePresentationDisplays(int changedDisplayId) {
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                RouteInfo route = this.mRoutes.get(i);
                if (!route.updatePresentationDisplay() && (route.mPresentationDisplay == null || route.mPresentationDisplay.getDisplayId() != changedDisplayId)) continue;
                MediaRouter.dispatchRoutePresentationDisplayChanged(route);
            }
        }

        void setSelectedRoute(RouteInfo info, boolean explicit) {
            this.mSelectedRoute = info;
            this.publishClientSelectedRoute(explicit);
        }

        void rebindAsUser(int userId) {
            if (this.mCurrentUserId != userId || userId < 0 || this.mClient == null) {
                if (this.mClient != null) {
                    try {
                        this.mMediaRouterService.unregisterClient(this.mClient);
                    }
                    catch (RemoteException ex) {
                        Log.e(MediaRouter.TAG, "Unable to unregister media router client.", ex);
                    }
                    this.mClient = null;
                }
                this.mCurrentUserId = userId;
                try {
                    Client client = new Client();
                    this.mMediaRouterService.registerClientAsUser(client, this.mPackageName, userId);
                    this.mClient = client;
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter.TAG, "Unable to register media router client.", ex);
                }
                this.publishClientDiscoveryRequest();
                this.publishClientSelectedRoute(false);
                this.updateClientState();
            }
        }

        void publishClientDiscoveryRequest() {
            if (this.mClient != null) {
                try {
                    this.mMediaRouterService.setDiscoveryRequest(this.mClient, this.mDiscoveryRequestRouteTypes, this.mDiscoverRequestActiveScan);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter.TAG, "Unable to publish media router client discovery request.", ex);
                }
            }
        }

        void publishClientSelectedRoute(boolean explicit) {
            if (this.mClient != null) {
                try {
                    this.mMediaRouterService.setSelectedRoute(this.mClient, this.mSelectedRoute != null ? this.mSelectedRoute.mGlobalRouteId : null, explicit);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter.TAG, "Unable to publish media router client selected route.", ex);
                }
            }
        }

        void updateClientState() {
            int i;
            this.mClientState = null;
            if (this.mClient != null) {
                try {
                    this.mClientState = this.mMediaRouterService.getState(this.mClient);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter.TAG, "Unable to retrieve media router client state.", ex);
                }
            }
            ArrayList<MediaRouterClientState.RouteInfo> globalRoutes = this.mClientState != null ? this.mClientState.routes : null;
            int globalRouteCount = globalRoutes != null ? globalRoutes.size() : 0;
            for (i = 0; i < globalRouteCount; ++i) {
                MediaRouterClientState.RouteInfo globalRoute = globalRoutes.get(i);
                RouteInfo route = this.findGlobalRoute(globalRoute.id);
                if (route == null) {
                    route = this.makeGlobalRoute(globalRoute);
                    MediaRouter.addRouteStatic(route);
                    continue;
                }
                this.updateGlobalRoute(route, globalRoute);
            }
            i = this.mRoutes.size();
            block3: while (i-- > 0) {
                RouteInfo route = this.mRoutes.get(i);
                String globalRouteId = route.mGlobalRouteId;
                if (globalRouteId == null) continue;
                for (int j = 0; j < globalRouteCount; ++j) {
                    MediaRouterClientState.RouteInfo globalRoute = globalRoutes.get(j);
                    if (globalRouteId.equals(globalRoute.id)) continue block3;
                }
                MediaRouter.removeRouteStatic(route);
            }
        }

        void requestSetVolume(RouteInfo route, int volume) {
            if (route.mGlobalRouteId != null && this.mClient != null) {
                try {
                    this.mMediaRouterService.requestSetVolume(this.mClient, route.mGlobalRouteId, volume);
                }
                catch (RemoteException ex) {
                    Log.w(MediaRouter.TAG, "Unable to request volume change.", ex);
                }
            }
        }

        void requestUpdateVolume(RouteInfo route, int direction) {
            if (route.mGlobalRouteId != null && this.mClient != null) {
                try {
                    this.mMediaRouterService.requestUpdateVolume(this.mClient, route.mGlobalRouteId, direction);
                }
                catch (RemoteException ex) {
                    Log.w(MediaRouter.TAG, "Unable to request volume change.", ex);
                }
            }
        }

        RouteInfo makeGlobalRoute(MediaRouterClientState.RouteInfo globalRoute) {
            RouteInfo route = new RouteInfo(this.mSystemCategory);
            route.mGlobalRouteId = globalRoute.id;
            route.mName = globalRoute.name;
            route.mDescription = globalRoute.description;
            route.mSupportedTypes = globalRoute.supportedTypes;
            route.mDeviceType = globalRoute.deviceType;
            route.mEnabled = globalRoute.enabled;
            route.setRealStatusCode(globalRoute.statusCode);
            route.mPlaybackType = globalRoute.playbackType;
            route.mPlaybackStream = globalRoute.playbackStream;
            route.mVolume = globalRoute.volume;
            route.mVolumeMax = globalRoute.volumeMax;
            route.mVolumeHandling = globalRoute.volumeHandling;
            route.mPresentationDisplayId = globalRoute.presentationDisplayId;
            route.updatePresentationDisplay();
            return route;
        }

        void updateGlobalRoute(RouteInfo route, MediaRouterClientState.RouteInfo globalRoute) {
            int oldSupportedTypes;
            boolean changed = false;
            boolean volumeChanged = false;
            boolean presentationDisplayChanged = false;
            if (!Objects.equals(route.mName, globalRoute.name)) {
                route.mName = globalRoute.name;
                changed = true;
            }
            if (!Objects.equals(route.mDescription, globalRoute.description)) {
                route.mDescription = globalRoute.description;
                changed = true;
            }
            if ((oldSupportedTypes = route.mSupportedTypes) != globalRoute.supportedTypes) {
                route.mSupportedTypes = globalRoute.supportedTypes;
                changed = true;
            }
            if (route.mEnabled != globalRoute.enabled) {
                route.mEnabled = globalRoute.enabled;
                changed = true;
            }
            if (route.mRealStatusCode != globalRoute.statusCode) {
                route.setRealStatusCode(globalRoute.statusCode);
                changed = true;
            }
            if (route.mPlaybackType != globalRoute.playbackType) {
                route.mPlaybackType = globalRoute.playbackType;
                changed = true;
            }
            if (route.mPlaybackStream != globalRoute.playbackStream) {
                route.mPlaybackStream = globalRoute.playbackStream;
                changed = true;
            }
            if (route.mVolume != globalRoute.volume) {
                route.mVolume = globalRoute.volume;
                changed = true;
                volumeChanged = true;
            }
            if (route.mVolumeMax != globalRoute.volumeMax) {
                route.mVolumeMax = globalRoute.volumeMax;
                changed = true;
                volumeChanged = true;
            }
            if (route.mVolumeHandling != globalRoute.volumeHandling) {
                route.mVolumeHandling = globalRoute.volumeHandling;
                changed = true;
                volumeChanged = true;
            }
            if (route.mPresentationDisplayId != globalRoute.presentationDisplayId) {
                route.mPresentationDisplayId = globalRoute.presentationDisplayId;
                route.updatePresentationDisplay();
                changed = true;
                presentationDisplayChanged = true;
            }
            if (changed) {
                MediaRouter.dispatchRouteChanged(route, oldSupportedTypes);
            }
            if (volumeChanged) {
                MediaRouter.dispatchRouteVolumeChanged(route);
            }
            if (presentationDisplayChanged) {
                MediaRouter.dispatchRoutePresentationDisplayChanged(route);
            }
        }

        RouteInfo findGlobalRoute(String globalRouteId) {
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                RouteInfo route = this.mRoutes.get(i);
                if (!globalRouteId.equals(route.mGlobalRouteId)) continue;
                return route;
            }
            return null;
        }

        boolean isPlaybackActive() {
            if (this.mClient != null) {
                try {
                    return this.mMediaRouterService.isPlaybackActive(this.mClient);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter.TAG, "Unable to retrieve playback active state.", ex);
                }
            }
            return false;
        }

        class Client
        extends IMediaRouterClient.Stub {
            Client() {
            }

            @Override
            public void onStateChanged() {
                Static.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Client.this == Static.this.mClient) {
                            Static.this.updateClientState();
                        }
                    }
                });
            }

            @Override
            public void onRestoreRoute() {
                Static.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Client.this != Static.this.mClient || Static.this.mSelectedRoute == null || Static.this.mSelectedRoute != Static.this.mDefaultAudioVideo && Static.this.mSelectedRoute != Static.this.mBluetoothA2dpRoute) {
                            return;
                        }
                        Log.v(MediaRouter.TAG, "onRestoreRoute() : route=" + Static.this.mSelectedRoute);
                        Static.this.mSelectedRoute.select();
                    }
                });
            }
        }
    }
}

