/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.MathUtils;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;

public class BaseBundle {
    private static final String TAG = "Bundle";
    static final boolean DEBUG = false;
    private static final int BUNDLE_MAGIC = 1279544898;
    private static final int BUNDLE_MAGIC_NATIVE = 0x4C444E44;
    static final int FLAG_DEFUSABLE = 1;
    private static final boolean LOG_DEFUSABLE = false;
    private static volatile boolean sShouldDefuse = false;
    ArrayMap<String, Object> mMap = null;
    Parcel mParcelledData = null;
    private boolean mParcelledByNative;
    private ClassLoader mClassLoader;
    @VisibleForTesting
    public int mFlags;

    public static void setShouldDefuse(boolean shouldDefuse) {
        sShouldDefuse = shouldDefuse;
    }

    BaseBundle(ClassLoader loader, int capacity) {
        this.mMap = capacity > 0 ? new ArrayMap(capacity) : new ArrayMap();
        this.mClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
    }

    BaseBundle() {
        this((ClassLoader)null, 0);
    }

    BaseBundle(Parcel parcelledData) {
        this.readFromParcelInner(parcelledData);
    }

    BaseBundle(Parcel parcelledData, int length) {
        this.readFromParcelInner(parcelledData, length);
    }

    BaseBundle(ClassLoader loader) {
        this(loader, 0);
    }

    BaseBundle(int capacity) {
        this((ClassLoader)null, capacity);
    }

    BaseBundle(BaseBundle b) {
        this.copyInternal(b, false);
    }

    BaseBundle(boolean doInit) {
    }

    public String getPairValue() {
        this.unparcel();
        int size = this.mMap.size();
        if (size > 1) {
            Log.w(TAG, "getPairValue() used on Bundle with multiple pairs.");
        }
        if (size == 0) {
            return null;
        }
        Object o = this.mMap.valueAt(0);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning("getPairValue()", o, "String", e);
            return null;
        }
    }

    void setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
    }

    ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unparcel() {
        BaseBundle baseBundle = this;
        synchronized (baseBundle) {
            Parcel source = this.mParcelledData;
            if (source != null) {
                this.initializeFromParcelLocked(source, true, this.mParcelledByNative);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFromParcelLocked(Parcel parcelledData, boolean recycleParcel, boolean parcelledByNative) {
        block15: {
            if (BaseBundle.isEmptyParcel(parcelledData)) {
                if (this.mMap == null) {
                    this.mMap = new ArrayMap(1);
                } else {
                    this.mMap.erase();
                }
                this.mParcelledData = null;
                this.mParcelledByNative = false;
                return;
            }
            int count = parcelledData.readInt();
            if (count < 0) {
                return;
            }
            ArrayMap<String, Object> map = this.mMap;
            if (map == null) {
                map = new ArrayMap(count);
            } else {
                map.erase();
                map.ensureCapacity(count);
            }
            try {
                if (parcelledByNative) {
                    parcelledData.readArrayMapSafelyInternal(map, count, this.mClassLoader);
                } else {
                    parcelledData.readArrayMapInternal(map, count, this.mClassLoader);
                }
            }
            catch (BadParcelableException e) {
                if (sShouldDefuse) {
                    Log.w(TAG, "Failed to parse Bundle, but defusing quietly", e);
                    map.erase();
                    break block15;
                }
                throw e;
            }
            finally {
                this.mMap = map;
                if (recycleParcel) {
                    BaseBundle.recycleParcel(parcelledData);
                }
                this.mParcelledData = null;
                this.mParcelledByNative = false;
            }
        }
    }

    public boolean isParcelled() {
        return this.mParcelledData != null;
    }

    public boolean isEmptyParcel() {
        return BaseBundle.isEmptyParcel(this.mParcelledData);
    }

    private static boolean isEmptyParcel(Parcel p) {
        return p == NoImagePreloadHolder.EMPTY_PARCEL;
    }

    private static void recycleParcel(Parcel p) {
        if (p != null && !BaseBundle.isEmptyParcel(p)) {
            p.recycle();
        }
    }

    ArrayMap<String, Object> getMap() {
        this.unparcel();
        return this.mMap;
    }

    public int size() {
        this.unparcel();
        return this.mMap.size();
    }

    public boolean isEmpty() {
        this.unparcel();
        return this.mMap.isEmpty();
    }

    public boolean maybeIsEmpty() {
        if (this.isParcelled()) {
            return this.isEmptyParcel();
        }
        return this.isEmpty();
    }

    public static boolean kindofEquals(BaseBundle a, BaseBundle b) {
        return a == b || a != null && a.kindofEquals(b);
    }

    public boolean kindofEquals(BaseBundle other) {
        if (other == null) {
            return false;
        }
        if (this.isParcelled() != other.isParcelled()) {
            return false;
        }
        if (this.isParcelled()) {
            return this.mParcelledData.compareData(other.mParcelledData) == 0;
        }
        return this.mMap.equals(other.mMap);
    }

    public void clear() {
        this.unparcel();
        this.mMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyInternal(BaseBundle from, boolean deep) {
        BaseBundle baseBundle = from;
        synchronized (baseBundle) {
            if (from.mParcelledData != null) {
                if (from.isEmptyParcel()) {
                    this.mParcelledData = NoImagePreloadHolder.EMPTY_PARCEL;
                    this.mParcelledByNative = false;
                } else {
                    this.mParcelledData = Parcel.obtain();
                    this.mParcelledData.appendFrom(from.mParcelledData, 0, from.mParcelledData.dataSize());
                    this.mParcelledData.setDataPosition(0);
                    this.mParcelledByNative = from.mParcelledByNative;
                }
            } else {
                this.mParcelledData = null;
                this.mParcelledByNative = false;
            }
            if (from.mMap != null) {
                if (!deep) {
                    this.mMap = new ArrayMap<String, Object>(from.mMap);
                } else {
                    ArrayMap<String, Object> fromMap = from.mMap;
                    int N = fromMap.size();
                    this.mMap = new ArrayMap(N);
                    for (int i = 0; i < N; ++i) {
                        this.mMap.append(fromMap.keyAt(i), this.deepCopyValue(fromMap.valueAt(i)));
                    }
                }
            } else {
                this.mMap = null;
            }
            this.mClassLoader = from.mClassLoader;
        }
    }

    Object deepCopyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Bundle) {
            return ((Bundle)value).deepCopy();
        }
        if (value instanceof PersistableBundle) {
            return ((PersistableBundle)value).deepCopy();
        }
        if (value instanceof ArrayList) {
            return this.deepcopyArrayList((ArrayList)value);
        }
        if (value.getClass().isArray()) {
            if (value instanceof int[]) {
                return ((int[])value).clone();
            }
            if (value instanceof long[]) {
                return ((long[])value).clone();
            }
            if (value instanceof float[]) {
                return ((float[])value).clone();
            }
            if (value instanceof double[]) {
                return ((double[])value).clone();
            }
            if (value instanceof Object[]) {
                return ((Object[])value).clone();
            }
            if (value instanceof byte[]) {
                return ((byte[])value).clone();
            }
            if (value instanceof short[]) {
                return ((short[])value).clone();
            }
            if (value instanceof char[]) {
                return ((char[])value).clone();
            }
        }
        return value;
    }

    ArrayList deepcopyArrayList(ArrayList from) {
        int N = from.size();
        ArrayList<Object> out = new ArrayList<Object>(N);
        for (int i = 0; i < N; ++i) {
            out.add(this.deepCopyValue(from.get(i)));
        }
        return out;
    }

    public boolean containsKey(String key) {
        this.unparcel();
        return this.mMap.containsKey(key);
    }

    public Object get(String key) {
        this.unparcel();
        return this.mMap.get(key);
    }

    public void remove(String key) {
        this.unparcel();
        this.mMap.remove(key);
    }

    public void putAll(PersistableBundle bundle) {
        this.unparcel();
        bundle.unparcel();
        this.mMap.putAll(bundle.mMap);
    }

    void putAll(ArrayMap map) {
        this.unparcel();
        this.mMap.putAll(map);
    }

    public Set<String> keySet() {
        this.unparcel();
        return this.mMap.keySet();
    }

    public void putBoolean(String key, boolean value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putByte(String key, byte value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putChar(String key, char value) {
        this.unparcel();
        this.mMap.put(key, Character.valueOf(value));
    }

    void putShort(String key, short value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putInt(String key, int value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putLong(String key, long value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putFloat(String key, float value) {
        this.unparcel();
        this.mMap.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putString(String key, String value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharSequence(String key, CharSequence value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putIntegerArrayList(String key, ArrayList<Integer> value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putStringArrayList(String key, ArrayList<String> value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharSequenceArrayList(String key, ArrayList<CharSequence> value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putSerializable(String key, Serializable value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putBooleanArray(String key, boolean[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putByteArray(String key, byte[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putShortArray(String key, short[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharArray(String key, char[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putIntArray(String key, int[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putLongArray(String key, long[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putFloatArray(String key, float[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putDoubleArray(String key, double[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putStringArray(String key, String[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharSequenceArray(String key, CharSequence[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public boolean getBoolean(String key) {
        this.unparcel();
        return this.getBoolean(key, false);
    }

    void typeWarning(String key, Object value, String className, Object defaultValue, ClassCastException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key ");
        sb.append(key);
        sb.append(" expected ");
        sb.append(className);
        sb.append(" but value was a ");
        sb.append(value.getClass().getName());
        sb.append(".  The default value ");
        sb.append(defaultValue);
        sb.append(" was returned.");
        Log.w(TAG, sb.toString());
        Log.w(TAG, "Attempt to cast generated internal exception:", e);
    }

    void typeWarning(String key, Object value, String className, ClassCastException e) {
        this.typeWarning(key, value, className, "<null>", e);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Boolean", defaultValue, e);
            return defaultValue;
        }
    }

    byte getByte(String key) {
        this.unparcel();
        return this.getByte(key, (byte)0);
    }

    Byte getByte(String key, byte defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Byte)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Byte", defaultValue, e);
            return defaultValue;
        }
    }

    char getChar(String key) {
        this.unparcel();
        return this.getChar(key, '\u0000');
    }

    char getChar(String key, char defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Character)o).charValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Character", Character.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    short getShort(String key) {
        this.unparcel();
        return this.getShort(key, (short)0);
    }

    short getShort(String key, short defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Short)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Short", defaultValue, e);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        this.unparcel();
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Integer)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Integer", defaultValue, e);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        this.unparcel();
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Long)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Long", defaultValue, e);
            return defaultValue;
        }
    }

    float getFloat(String key) {
        this.unparcel();
        return this.getFloat(key, 0.0f);
    }

    float getFloat(String key, float defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Float", Float.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        this.unparcel();
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Double)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Double", defaultValue, e);
            return defaultValue;
        }
    }

    public String getString(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String", e);
            return null;
        }
    }

    public String getString(String key, String defaultValue) {
        String s = this.getString(key);
        return s == null ? defaultValue : s;
    }

    CharSequence getCharSequence(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (CharSequence)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence", e);
            return null;
        }
    }

    CharSequence getCharSequence(String key, CharSequence defaultValue) {
        CharSequence cs = this.getCharSequence(key);
        return cs == null ? defaultValue : cs;
    }

    Serializable getSerializable(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Serializable)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Serializable", e);
            return null;
        }
    }

    ArrayList<Integer> getIntegerArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<Integer>", e);
            return null;
        }
    }

    ArrayList<String> getStringArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<String>", e);
            return null;
        }
    }

    ArrayList<CharSequence> getCharSequenceArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<CharSequence>", e);
            return null;
        }
    }

    public boolean[] getBooleanArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (boolean[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    byte[] getByteArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    short[] getShortArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (short[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "short[]", e);
            return null;
        }
    }

    char[] getCharArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (char[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "char[]", e);
            return null;
        }
    }

    public int[] getIntArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (int[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "int[]", e);
            return null;
        }
    }

    public long[] getLongArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (long[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "long[]", e);
            return null;
        }
    }

    float[] getFloatArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (float[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "float[]", e);
            return null;
        }
    }

    public double[] getDoubleArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (double[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "double[]", e);
            return null;
        }
    }

    public String[] getStringArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (String[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String[]", e);
            return null;
        }
    }

    CharSequence[] getCharSequenceArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (CharSequence[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence[]", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToParcelInner(Parcel parcel, int flags) {
        ArrayMap<String, Object> map;
        if (parcel.hasReadWriteHelper()) {
            this.unparcel();
        }
        BaseBundle baseBundle = this;
        synchronized (baseBundle) {
            if (this.mParcelledData != null) {
                if (this.mParcelledData == NoImagePreloadHolder.EMPTY_PARCEL) {
                    parcel.writeInt(0);
                } else {
                    int length = this.mParcelledData.dataSize();
                    parcel.writeInt(length);
                    parcel.writeInt(this.mParcelledByNative ? 0x4C444E44 : 1279544898);
                    parcel.appendFrom(this.mParcelledData, 0, length);
                }
                return;
            }
            map = this.mMap;
        }
        if (map == null || map.size() <= 0) {
            parcel.writeInt(0);
            return;
        }
        int lengthPos = parcel.dataPosition();
        parcel.writeInt(-1);
        parcel.writeInt(1279544898);
        int startPos = parcel.dataPosition();
        parcel.writeArrayMapInternal(map);
        int endPos = parcel.dataPosition();
        parcel.setDataPosition(lengthPos);
        int length = endPos - startPos;
        parcel.writeInt(length);
        parcel.setDataPosition(endPos);
    }

    void readFromParcelInner(Parcel parcel) {
        int length = parcel.readInt();
        this.readFromParcelInner(parcel, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromParcelInner(Parcel parcel, int length) {
        boolean isNativeBundle;
        if (length < 0) {
            throw new RuntimeException("Bad length in parcel: " + length);
        }
        if (length == 0) {
            this.mParcelledData = NoImagePreloadHolder.EMPTY_PARCEL;
            this.mParcelledByNative = false;
            return;
        }
        int magic = parcel.readInt();
        boolean isJavaBundle = magic == 1279544898;
        boolean bl = isNativeBundle = magic == 0x4C444E44;
        if (!isJavaBundle && !isNativeBundle) {
            throw new IllegalStateException("Bad magic number for Bundle: 0x" + Integer.toHexString(magic));
        }
        if (parcel.hasReadWriteHelper()) {
            BaseBundle baseBundle = this;
            synchronized (baseBundle) {
                this.initializeFromParcelLocked(parcel, false, isNativeBundle);
            }
            return;
        }
        int offset = parcel.dataPosition();
        parcel.setDataPosition(MathUtils.addOrThrow(offset, length));
        Parcel p = Parcel.obtain();
        p.setDataPosition(0);
        p.appendFrom(parcel, offset, length);
        p.adoptClassCookies(parcel);
        p.setDataPosition(0);
        this.mParcelledData = p;
        this.mParcelledByNative = isNativeBundle;
    }

    public static void dumpStats(IndentingPrintWriter pw, String key, Object value) {
        Parcel tmp = Parcel.obtain();
        tmp.writeValue(value);
        int size = tmp.dataPosition();
        tmp.recycle();
        if (size > 1024) {
            pw.println(key + " [size=" + size + "]");
            if (value instanceof BaseBundle) {
                BaseBundle.dumpStats(pw, (BaseBundle)value);
            } else if (value instanceof SparseArray) {
                BaseBundle.dumpStats(pw, (SparseArray)value);
            }
        }
    }

    public static void dumpStats(IndentingPrintWriter pw, SparseArray array2) {
        pw.increaseIndent();
        if (array2 == null) {
            pw.println("[null]");
            return;
        }
        for (int i = 0; i < array2.size(); ++i) {
            BaseBundle.dumpStats(pw, "0x" + Integer.toHexString(array2.keyAt(i)), array2.valueAt(i));
        }
        pw.decreaseIndent();
    }

    public static void dumpStats(IndentingPrintWriter pw, BaseBundle bundle) {
        pw.increaseIndent();
        if (bundle == null) {
            pw.println("[null]");
            return;
        }
        ArrayMap<String, Object> map = bundle.getMap();
        for (int i = 0; i < map.size(); ++i) {
            BaseBundle.dumpStats(pw, map.keyAt(i), map.valueAt(i));
        }
        pw.decreaseIndent();
    }

    static class NoImagePreloadHolder {
        public static final Parcel EMPTY_PARCEL = Parcel.obtain();

        NoImagePreloadHolder() {
        }
    }
}

