/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.FileUtils;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.LinkedList;

public class Environment {
    private static final String TAG = "Environment";
    private static final String ENV_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    private static final String ENV_ANDROID_ROOT = "ANDROID_ROOT";
    private static final String ENV_ANDROID_DATA = "ANDROID_DATA";
    private static final String ENV_ANDROID_EXPAND = "ANDROID_EXPAND";
    private static final String ENV_ANDROID_STORAGE = "ANDROID_STORAGE";
    private static final String ENV_DOWNLOAD_CACHE = "DOWNLOAD_CACHE";
    private static final String ENV_OEM_ROOT = "OEM_ROOT";
    private static final String ENV_ODM_ROOT = "ODM_ROOT";
    private static final String ENV_VENDOR_ROOT = "VENDOR_ROOT";
    private static final String ENV_PRODUCT_ROOT = "PRODUCT_ROOT";
    public static final String DIR_ANDROID = "Android";
    private static final String DIR_DATA = "data";
    private static final String DIR_MEDIA = "media";
    private static final String DIR_OBB = "obb";
    private static final String DIR_FILES = "files";
    private static final String DIR_CACHE = "cache";
    @Deprecated
    public static final String DIRECTORY_ANDROID = "Android";
    private static final File DIR_ANDROID_ROOT = Environment.getDirectory("ANDROID_ROOT", "/system");
    private static final File DIR_ANDROID_DATA = Environment.getDirectory("ANDROID_DATA", "/data");
    private static final File DIR_ANDROID_EXPAND = Environment.getDirectory("ANDROID_EXPAND", "/mnt/expand");
    private static final File DIR_ANDROID_STORAGE = Environment.getDirectory("ANDROID_STORAGE", "/storage");
    private static final File DIR_DOWNLOAD_CACHE = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
    private static final File DIR_OEM_ROOT = Environment.getDirectory("OEM_ROOT", "/oem");
    private static final File DIR_ODM_ROOT = Environment.getDirectory("ODM_ROOT", "/odm");
    private static final File DIR_VENDOR_ROOT = Environment.getDirectory("VENDOR_ROOT", "/vendor");
    private static final File DIR_PRODUCT_ROOT = Environment.getDirectory("PRODUCT_ROOT", "/product");
    private static UserEnvironment sCurrentUser;
    private static boolean sUserRequired;
    public static String DIRECTORY_MUSIC;
    public static String DIRECTORY_PODCASTS;
    public static String DIRECTORY_RINGTONES;
    public static String DIRECTORY_ALARMS;
    public static String DIRECTORY_NOTIFICATIONS;
    public static String DIRECTORY_PICTURES;
    public static String DIRECTORY_MOVIES;
    public static String DIRECTORY_DOWNLOADS;
    public static String DIRECTORY_DCIM;
    public static String DIRECTORY_DOCUMENTS;
    public static final String[] STANDARD_DIRECTORIES;
    public static final int HAS_MUSIC = 1;
    public static final int HAS_PODCASTS = 2;
    public static final int HAS_RINGTONES = 4;
    public static final int HAS_ALARMS = 8;
    public static final int HAS_NOTIFICATIONS = 16;
    public static final int HAS_PICTURES = 32;
    public static final int HAS_MOVIES = 64;
    public static final int HAS_DOWNLOADS = 128;
    public static final int HAS_DCIM = 256;
    public static final int HAS_DOCUMENTS = 512;
    public static final int HAS_ANDROID = 65536;
    public static final int HAS_OTHER = 131072;
    public static final String MEDIA_UNKNOWN = "unknown";
    public static final String MEDIA_REMOVED = "removed";
    public static final String MEDIA_UNMOUNTED = "unmounted";
    public static final String MEDIA_CHECKING = "checking";
    public static final String MEDIA_NOFS = "nofs";
    public static final String MEDIA_MOUNTED = "mounted";
    public static final String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static final String MEDIA_SHARED = "shared";
    public static final String MEDIA_BAD_REMOVAL = "bad_removal";
    public static final String MEDIA_UNMOUNTABLE = "unmountable";
    public static final String MEDIA_EJECTING = "ejecting";

    public static void initForCurrentUser() {
        int userId = UserHandle.myUserId();
        sCurrentUser = new UserEnvironment(userId);
    }

    public static File getRootDirectory() {
        return DIR_ANDROID_ROOT;
    }

    public static File getStorageDirectory() {
        return DIR_ANDROID_STORAGE;
    }

    public static File getOemDirectory() {
        return DIR_OEM_ROOT;
    }

    public static File getOdmDirectory() {
        return DIR_ODM_ROOT;
    }

    public static File getVendorDirectory() {
        return DIR_VENDOR_ROOT;
    }

    public static File getProductDirectory() {
        return DIR_PRODUCT_ROOT;
    }

    @Deprecated
    public static File getUserSystemDirectory(int userId) {
        return new File(new File(Environment.getDataSystemDirectory(), "users"), Integer.toString(userId));
    }

    @Deprecated
    public static File getUserConfigDirectory(int userId) {
        return new File(new File(new File(Environment.getDataDirectory(), "misc"), "user"), Integer.toString(userId));
    }

    public static File getDataDirectory() {
        return DIR_ANDROID_DATA;
    }

    public static File getDataDirectory(String volumeUuid) {
        if (TextUtils.isEmpty(volumeUuid)) {
            return DIR_ANDROID_DATA;
        }
        return new File("/mnt/expand/" + volumeUuid);
    }

    public static File getExpandDirectory() {
        return DIR_ANDROID_EXPAND;
    }

    public static File getDataSystemDirectory() {
        return new File(Environment.getDataDirectory(), "system");
    }

    public static File getDataSystemDeDirectory() {
        return Environment.buildPath(Environment.getDataDirectory(), "system_de");
    }

    public static File getDataSystemCeDirectory() {
        return Environment.buildPath(Environment.getDataDirectory(), "system_ce");
    }

    public static File getDataSystemCeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "system_ce", String.valueOf(userId));
    }

    public static File getDataSystemDeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "system_de", String.valueOf(userId));
    }

    public static File getDataMiscDirectory() {
        return new File(Environment.getDataDirectory(), "misc");
    }

    public static File getDataMiscCeDirectory() {
        return Environment.buildPath(Environment.getDataDirectory(), "misc_ce");
    }

    public static File getDataMiscCeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc_ce", String.valueOf(userId));
    }

    public static File getDataMiscDeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc_de", String.valueOf(userId));
    }

    private static File getDataProfilesDeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc", "profiles", "cur", String.valueOf(userId));
    }

    public static File getDataVendorCeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "vendor_ce", String.valueOf(userId));
    }

    public static File getDataVendorDeDirectory(int userId) {
        return Environment.buildPath(Environment.getDataDirectory(), "vendor_de", String.valueOf(userId));
    }

    public static File getDataRefProfilesDePackageDirectory(String packageName) {
        return Environment.buildPath(Environment.getDataDirectory(), "misc", "profiles", "ref", packageName);
    }

    public static File getDataProfilesDePackageDirectory(int userId, String packageName) {
        return Environment.buildPath(Environment.getDataProfilesDeDirectory(userId), packageName);
    }

    public static File getDataAppDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "app");
    }

    public static File getDataUserCeDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "user");
    }

    public static File getDataUserCeDirectory(String volumeUuid, int userId) {
        return new File(Environment.getDataUserCeDirectory(volumeUuid), String.valueOf(userId));
    }

    public static File getDataUserCePackageDirectory(String volumeUuid, int userId, String packageName) {
        return new File(Environment.getDataUserCeDirectory(volumeUuid, userId), packageName);
    }

    public static File getDataUserDeDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "user_de");
    }

    public static File getDataUserDeDirectory(String volumeUuid, int userId) {
        return new File(Environment.getDataUserDeDirectory(volumeUuid), String.valueOf(userId));
    }

    public static File getDataUserDePackageDirectory(String volumeUuid, int userId, String packageName) {
        return new File(Environment.getDataUserDeDirectory(volumeUuid, userId), packageName);
    }

    public static File getDataPreloadsDirectory() {
        return new File(Environment.getDataDirectory(), "preloads");
    }

    public static File getDataPreloadsDemoDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), "demo");
    }

    public static File getDataPreloadsAppsDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), "apps");
    }

    public static File getDataPreloadsMediaDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), DIR_MEDIA);
    }

    public static File getDataPreloadsFileCacheDirectory(String packageName) {
        return new File(Environment.getDataPreloadsFileCacheDirectory(), packageName);
    }

    public static File getDataPreloadsFileCacheDirectory() {
        return new File(Environment.getDataPreloadsDirectory(), "file_cache");
    }

    public static File getExternalStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getExternalDirs()[0];
    }

    public static File getLegacyExternalStorageDirectory() {
        return new File(System.getenv(ENV_EXTERNAL_STORAGE));
    }

    public static File getLegacyExternalStorageObbDirectory() {
        return Environment.buildPath(Environment.getLegacyExternalStorageDirectory(), "Android", DIR_OBB);
    }

    public static boolean isStandardDirectory(String dir) {
        for (String valid : STANDARD_DIRECTORIES) {
            if (!valid.equals(dir)) continue;
            return true;
        }
        return false;
    }

    public static int classifyExternalStorageDirectory(File dir) {
        int res = 0;
        for (File f : FileUtils.listFilesOrEmpty(dir)) {
            if (f.isFile() && Environment.isInterestingFile(f)) {
                res |= 0x20000;
                continue;
            }
            if (!f.isDirectory() || !Environment.hasInterestingFiles(f)) continue;
            String name = f.getName();
            if (DIRECTORY_MUSIC.equals(name)) {
                res |= 1;
                continue;
            }
            if (DIRECTORY_PODCASTS.equals(name)) {
                res |= 2;
                continue;
            }
            if (DIRECTORY_RINGTONES.equals(name)) {
                res |= 4;
                continue;
            }
            if (DIRECTORY_ALARMS.equals(name)) {
                res |= 8;
                continue;
            }
            if (DIRECTORY_NOTIFICATIONS.equals(name)) {
                res |= 0x10;
                continue;
            }
            if (DIRECTORY_PICTURES.equals(name)) {
                res |= 0x20;
                continue;
            }
            if (DIRECTORY_MOVIES.equals(name)) {
                res |= 0x40;
                continue;
            }
            if (DIRECTORY_DOWNLOADS.equals(name)) {
                res |= 0x80;
                continue;
            }
            if (DIRECTORY_DCIM.equals(name)) {
                res |= 0x100;
                continue;
            }
            if (DIRECTORY_DOCUMENTS.equals(name)) {
                res |= 0x200;
                continue;
            }
            if ("Android".equals(name)) {
                res |= 0x10000;
                continue;
            }
            res |= 0x20000;
        }
        return res;
    }

    private static boolean hasInterestingFiles(File dir) {
        LinkedList<File> explore = new LinkedList<File>();
        explore.add(dir);
        while (!explore.isEmpty()) {
            dir = (File)explore.pop();
            for (File f : FileUtils.listFilesOrEmpty(dir)) {
                if (Environment.isInterestingFile(f)) {
                    return true;
                }
                if (!f.isDirectory()) continue;
                explore.add(f);
            }
        }
        return false;
    }

    private static boolean isInterestingFile(File file) {
        if (file.isFile()) {
            String name = file.getName().toLowerCase();
            return !name.endsWith(".exe") && !name.equals("autorun.inf") && !name.equals("launchpad.zip") && !name.equals(".nomedia");
        }
        return false;
    }

    public static File getExternalStoragePublicDirectory(String type) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStoragePublicDirs(type)[0];
    }

    public static File[] buildExternalStorageAndroidDataDirs() {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAndroidDataDirs();
    }

    public static File[] buildExternalStorageAppDataDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppDataDirs(packageName);
    }

    public static File[] buildExternalStorageAppMediaDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppMediaDirs(packageName);
    }

    public static File[] buildExternalStorageAppObbDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppObbDirs(packageName);
    }

    public static File[] buildExternalStorageAppFilesDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppFilesDirs(packageName);
    }

    public static File[] buildExternalStorageAppCacheDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppCacheDirs(packageName);
    }

    public static File getDownloadCacheDirectory() {
        return DIR_DOWNLOAD_CACHE;
    }

    public static String getExternalStorageState() {
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.getExternalStorageState(externalDir);
    }

    @Deprecated
    public static String getStorageState(File path) {
        return Environment.getExternalStorageState(path);
    }

    public static String getExternalStorageState(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.getState();
        }
        return MEDIA_UNKNOWN;
    }

    public static boolean isExternalStorageRemovable() {
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.isExternalStorageRemovable(externalDir);
    }

    public static boolean isExternalStorageRemovable(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.isRemovable();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    public static boolean isExternalStorageEmulated() {
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.isExternalStorageEmulated(externalDir);
    }

    public static boolean isExternalStorageEmulated(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.isEmulated();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    static File getDirectory(String variableName, String defaultPath) {
        String path = System.getenv(variableName);
        return path == null ? new File(defaultPath) : new File(path);
    }

    public static void setUserRequired(boolean userRequired) {
        sUserRequired = userRequired;
    }

    private static void throwIfUserRequired() {
        if (sUserRequired) {
            Log.wtf(TAG, "Path requests must specify a user by using UserEnvironment", new Throwable());
        }
    }

    public static File[] buildPaths(File[] base, String ... segments) {
        File[] result = new File[base.length];
        for (int i = 0; i < base.length; ++i) {
            result[i] = Environment.buildPath(base[i], segments);
        }
        return result;
    }

    public static File buildPath(File base, String ... segments) {
        File cur = base;
        for (String segment : segments) {
            cur = cur == null ? new File(segment) : new File(cur, segment);
        }
        return cur;
    }

    public static File maybeTranslateEmulatedPathToInternal(File path) {
        return StorageManager.maybeTranslateEmulatedPathToInternal(path);
    }

    static {
        Environment.initForCurrentUser();
        DIRECTORY_MUSIC = "Music";
        DIRECTORY_PODCASTS = "Podcasts";
        DIRECTORY_RINGTONES = "Ringtones";
        DIRECTORY_ALARMS = "Alarms";
        DIRECTORY_NOTIFICATIONS = "Notifications";
        DIRECTORY_PICTURES = "Pictures";
        DIRECTORY_MOVIES = "Movies";
        DIRECTORY_DOWNLOADS = "Download";
        DIRECTORY_DCIM = "DCIM";
        DIRECTORY_DOCUMENTS = "Documents";
        STANDARD_DIRECTORIES = new String[]{DIRECTORY_MUSIC, DIRECTORY_PODCASTS, DIRECTORY_RINGTONES, DIRECTORY_ALARMS, DIRECTORY_NOTIFICATIONS, DIRECTORY_PICTURES, DIRECTORY_MOVIES, DIRECTORY_DOWNLOADS, DIRECTORY_DCIM, DIRECTORY_DOCUMENTS};
    }

    public static class UserEnvironment {
        private final int mUserId;

        public UserEnvironment(int userId) {
            this.mUserId = userId;
        }

        public File[] getExternalDirs() {
            StorageVolume[] volumes = StorageManager.getVolumeList(this.mUserId, 256);
            File[] files = new File[volumes.length];
            for (int i = 0; i < volumes.length; ++i) {
                files[i] = volumes[i].getPathFile();
            }
            return files;
        }

        @Deprecated
        public File getExternalStorageDirectory() {
            return this.getExternalDirs()[0];
        }

        @Deprecated
        public File getExternalStoragePublicDirectory(String type) {
            return this.buildExternalStoragePublicDirs(type)[0];
        }

        public File[] buildExternalStoragePublicDirs(String type) {
            return Environment.buildPaths(this.getExternalDirs(), type);
        }

        public File[] buildExternalStorageAndroidDataDirs() {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA);
        }

        public File[] buildExternalStorageAndroidObbDirs() {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_OBB);
        }

        public File[] buildExternalStorageAppDataDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA, packageName);
        }

        public File[] buildExternalStorageAppMediaDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_MEDIA, packageName);
        }

        public File[] buildExternalStorageAppObbDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_OBB, packageName);
        }

        public File[] buildExternalStorageAppFilesDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA, packageName, Environment.DIR_FILES);
        }

        public File[] buildExternalStorageAppCacheDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA, packageName, Environment.DIR_CACHE);
        }
    }
}

