/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.CancellationSignal;
import android.os.StrictMode;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.webkit.MimeTypeMap;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.SizedInputStream;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;

public class FileUtils {
    private static final String TAG = "FileUtils";
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private static final File[] EMPTY = new File[0];
    private static final boolean ENABLE_COPY_OPTIMIZATIONS = true;
    private static final long COPY_CHECKPOINT_BYTES = 524288L;

    public static int setPermissions(File path, int mode, int uid, int gid) {
        return FileUtils.setPermissions(path.getAbsolutePath(), mode, uid, gid);
    }

    public static int setPermissions(String path, int mode, int uid, int gid) {
        try {
            Os.chmod(path, mode);
        }
        catch (ErrnoException e) {
            Slog.w(TAG, "Failed to chmod(" + path + "): " + e);
            return e.errno;
        }
        if (uid >= 0 || gid >= 0) {
            try {
                Os.chown(path, uid, gid);
            }
            catch (ErrnoException e) {
                Slog.w(TAG, "Failed to chown(" + path + "): " + e);
                return e.errno;
            }
        }
        return 0;
    }

    public static int setPermissions(FileDescriptor fd, int mode, int uid, int gid) {
        try {
            Os.fchmod(fd, mode);
        }
        catch (ErrnoException e) {
            Slog.w(TAG, "Failed to fchmod(): " + e);
            return e.errno;
        }
        if (uid >= 0 || gid >= 0) {
            try {
                Os.fchown(fd, uid, gid);
            }
            catch (ErrnoException e) {
                Slog.w(TAG, "Failed to fchown(): " + e);
                return e.errno;
            }
        }
        return 0;
    }

    public static void copyPermissions(File from, File to) throws IOException {
        try {
            StructStat stat = Os.stat(from.getAbsolutePath());
            Os.chmod(to.getAbsolutePath(), stat.st_mode);
            Os.chown(to.getAbsolutePath(), stat.st_uid, stat.st_gid);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    public static int getUid(String path) {
        try {
            return Os.stat((String)path).st_uid;
        }
        catch (ErrnoException e) {
            return -1;
        }
    }

    public static boolean sync(FileOutputStream stream) {
        try {
            if (stream != null) {
                stream.getFD().sync();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Deprecated
    public static boolean copyFile(File srcFile, File destFile) {
        try {
            FileUtils.copyFileOrThrow(srcFile, destFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Deprecated
    public static void copyFileOrThrow(File srcFile, File destFile) throws IOException {
        try (FileInputStream in = new FileInputStream(srcFile);){
            FileUtils.copyToFileOrThrow(in, destFile);
        }
    }

    @Deprecated
    public static boolean copyToFile(InputStream inputStream, File destFile) {
        try {
            FileUtils.copyToFileOrThrow(inputStream, destFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Deprecated
    public static void copyToFileOrThrow(InputStream in, File destFile) throws IOException {
        if (destFile.exists()) {
            destFile.delete();
        }
        try (FileOutputStream out = new FileOutputStream(destFile);){
            FileUtils.copy(in, out);
            try {
                Os.fsync(out.getFD());
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        }
    }

    public static long copy(File from, File to) throws IOException {
        return FileUtils.copy(from, to, null, null);
    }

    public static long copy(File from, File to, ProgressListener listener, CancellationSignal signal) throws IOException {
        Throwable throwable = null;
        try (FileInputStream in = new FileInputStream(from);){
            long l;
            FileOutputStream out = new FileOutputStream(to);
            Throwable throwable2 = null;
            try {
                l = FileUtils.copy(in, out, listener, signal);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        FileUtils.$closeResource(throwable2, out);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            FileUtils.$closeResource(throwable2, out);
            return l;
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return FileUtils.copy(in, out, null, null);
    }

    public static long copy(InputStream in, OutputStream out, ProgressListener listener, CancellationSignal signal) throws IOException {
        if (in instanceof FileInputStream && out instanceof FileOutputStream) {
            return FileUtils.copy(((FileInputStream)in).getFD(), ((FileOutputStream)out).getFD(), listener, signal);
        }
        return FileUtils.copyInternalUserspace(in, out, listener, signal);
    }

    public static long copy(FileDescriptor in, FileDescriptor out) throws IOException {
        return FileUtils.copy(in, out, null, null);
    }

    public static long copy(FileDescriptor in, FileDescriptor out, ProgressListener listener, CancellationSignal signal) throws IOException {
        return FileUtils.copy(in, out, listener, signal, Long.MAX_VALUE);
    }

    public static long copy(FileDescriptor in, FileDescriptor out, ProgressListener listener, CancellationSignal signal, long count) throws IOException {
        try {
            StructStat st_in = Os.fstat(in);
            StructStat st_out = Os.fstat(out);
            if (OsConstants.S_ISREG(st_in.st_mode) && OsConstants.S_ISREG(st_out.st_mode)) {
                return FileUtils.copyInternalSendfile(in, out, listener, signal, count);
            }
            if (OsConstants.S_ISFIFO(st_in.st_mode) || OsConstants.S_ISFIFO(st_out.st_mode)) {
                return FileUtils.copyInternalSplice(in, out, listener, signal, count);
            }
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
        return FileUtils.copyInternalUserspace(in, out, listener, signal, count);
    }

    @VisibleForTesting
    public static long copyInternalSplice(FileDescriptor in, FileDescriptor out, ProgressListener listener, CancellationSignal signal, long count) throws ErrnoException {
        long t;
        long progress = 0L;
        long checkpoint = 0L;
        while ((t = Os.splice(in, null, out, null, Math.min(count, 524288L), OsConstants.SPLICE_F_MOVE | OsConstants.SPLICE_F_MORE)) != 0L) {
            progress += t;
            count -= t;
            if ((checkpoint += t) < 524288L) continue;
            if (signal != null) {
                signal.throwIfCanceled();
            }
            if (listener != null) {
                listener.onProgress(progress);
            }
            checkpoint = 0L;
        }
        if (listener != null) {
            listener.onProgress(progress);
        }
        return progress;
    }

    @VisibleForTesting
    public static long copyInternalSendfile(FileDescriptor in, FileDescriptor out, ProgressListener listener, CancellationSignal signal, long count) throws ErrnoException {
        long t;
        long progress = 0L;
        long checkpoint = 0L;
        while ((t = Os.sendfile(out, in, null, Math.min(count, 524288L))) != 0L) {
            progress += t;
            count -= t;
            if ((checkpoint += t) < 524288L) continue;
            if (signal != null) {
                signal.throwIfCanceled();
            }
            if (listener != null) {
                listener.onProgress(progress);
            }
            checkpoint = 0L;
        }
        if (listener != null) {
            listener.onProgress(progress);
        }
        return progress;
    }

    @VisibleForTesting
    public static long copyInternalUserspace(FileDescriptor in, FileDescriptor out, ProgressListener listener, CancellationSignal signal, long count) throws IOException {
        if (count != Long.MAX_VALUE) {
            return FileUtils.copyInternalUserspace(new SizedInputStream(new FileInputStream(in), count), new FileOutputStream(out), listener, signal);
        }
        return FileUtils.copyInternalUserspace(new FileInputStream(in), new FileOutputStream(out), listener, signal);
    }

    @VisibleForTesting
    public static long copyInternalUserspace(InputStream in, OutputStream out, ProgressListener listener, CancellationSignal signal) throws IOException {
        int t;
        long progress = 0L;
        long checkpoint = 0L;
        byte[] buffer = new byte[8192];
        while ((t = in.read(buffer)) != -1) {
            out.write(buffer, 0, t);
            progress += (long)t;
            if ((checkpoint += (long)t) < 524288L) continue;
            if (signal != null) {
                signal.throwIfCanceled();
            }
            if (listener != null) {
                listener.onProgress(progress);
            }
            checkpoint = 0L;
        }
        if (listener != null) {
            listener.onProgress(progress);
        }
        return progress;
    }

    public static boolean isFilenameSafe(File file) {
        return NoImagePreloadHolder.SAFE_FILENAME_PATTERN.matcher(file.getPath()).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, int max, String ellipsis) throws IOException {
        FileInputStream input = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(input);
        try {
            int len;
            long size = file.length();
            if (max > 0 || size > 0L && max == 0) {
                byte[] data;
                int length;
                if (size > 0L && (max == 0 || size < (long)max)) {
                    max = (int)size;
                }
                if ((length = bis.read(data = new byte[max + 1])) <= 0) {
                    String string2 = "";
                    return string2;
                }
                if (length <= max) {
                    String string3 = new String(data, 0, length);
                    return string3;
                }
                if (ellipsis == null) {
                    String string4 = new String(data, 0, max);
                    return string4;
                }
                String string5 = new String(data, 0, max) + ellipsis;
                return string5;
            }
            if (max < 0) {
                String string6;
                int len2;
                boolean rolled = false;
                byte[] last = null;
                byte[] data = null;
                do {
                    if (last != null) {
                        rolled = true;
                    }
                    byte[] tmp = last;
                    last = data;
                    data = tmp;
                    if (data != null) continue;
                    data = new byte[-max];
                } while ((len2 = bis.read(data)) == data.length);
                if (last == null && len2 <= 0) {
                    string6 = "";
                    return string6;
                }
                if (last == null) {
                    string6 = new String(data, 0, len2);
                    return string6;
                }
                if (len2 > 0) {
                    rolled = true;
                    System.arraycopy(last, len2, last, 0, last.length - len2);
                    System.arraycopy(data, 0, last, last.length - len2, len2);
                }
                if (ellipsis == null || !rolled) {
                    string6 = new String(last);
                    return string6;
                }
                string6 = ellipsis + new String(last);
                return string6;
            }
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            do {
                if ((len = bis.read(data)) <= 0) continue;
                contents.write(data, 0, len);
            } while (len == data.length);
            String string7 = contents.toString();
            return string7;
        }
        finally {
            bis.close();
            ((InputStream)input).close();
        }
    }

    public static void stringToFile(File file, String string2) throws IOException {
        FileUtils.stringToFile(file.getAbsolutePath(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bytesToFile(String filename, byte[] content) throws IOException {
        block14: {
            if (filename.startsWith("/proc/")) {
                int oldMask = StrictMode.allowThreadDiskWritesMask();
                try (FileOutputStream fos = new FileOutputStream(filename);){
                    fos.write(content);
                    break block14;
                }
                finally {
                    StrictMode.setThreadPolicyMask(oldMask);
                }
            }
            try (FileOutputStream fos = new FileOutputStream(filename);){
                fos.write(content);
            }
        }
    }

    public static void stringToFile(String filename, String string2) throws IOException {
        FileUtils.bytesToFile(filename, string2.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksumCrc32(File file) throws FileNotFoundException, IOException {
        CRC32 checkSummer = new CRC32();
        FilterInputStream cis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(file), checkSummer);
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
            long l = checkSummer.getValue();
            return l;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean deleteOlderFiles(File dir, int minCount, long minAgeMs) {
        if (minCount < 0 || minAgeMs < 0L) {
            throw new IllegalArgumentException("Constraints must be positive or 0");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                return Long.compare(rhs.lastModified(), lhs.lastModified());
            }
        });
        boolean deleted = false;
        for (int i = minCount; i < files.length; ++i) {
            File file = files[i];
            long age = System_Delegate.currentTimeMillis() - file.lastModified();
            if (age <= minAgeMs || !file.delete()) continue;
            Log.d(TAG, "Deleted old file " + file);
            deleted = true;
        }
        return deleted;
    }

    public static boolean contains(File[] dirs, File file) {
        for (File dir : dirs) {
            if (!FileUtils.contains(dir, file)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(File dir, File file) {
        if (dir == null || file == null) {
            return false;
        }
        return FileUtils.contains(dir.getAbsolutePath(), file.getAbsolutePath());
    }

    public static boolean contains(String dirPath, String filePath) {
        if (dirPath.equals(filePath)) {
            return true;
        }
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        return filePath.startsWith(dirPath);
    }

    public static boolean deleteContentsAndDir(File dir) {
        if (FileUtils.deleteContents(dir)) {
            return dir.delete();
        }
        return false;
    }

    public static boolean deleteContents(File dir) {
        File[] files = dir.listFiles();
        boolean success = true;
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    success &= FileUtils.deleteContents(file);
                }
                if (file.delete()) continue;
                Log.w(TAG, "Failed to delete " + file);
                success = false;
            }
        }
        return success;
    }

    private static boolean isValidExtFilenameChar(char c) {
        switch (c) {
            case '\u0000': 
            case '/': {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidExtFilename(String name) {
        return name != null && name.equals(FileUtils.buildValidExtFilename(name));
    }

    public static String buildValidExtFilename(String name) {
        if (TextUtils.isEmpty(name) || ".".equals(name) || "..".equals(name)) {
            return "(invalid)";
        }
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (FileUtils.isValidExtFilenameChar(c)) {
                res.append(c);
                continue;
            }
            res.append('_');
        }
        FileUtils.trimFilename(res, 255);
        return res.toString();
    }

    private static boolean isValidFatFilenameChar(char c) {
        if ('\u0000' <= c && c <= '\u001f') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': 
            case '\u007f': {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidFatFilename(String name) {
        return name != null && name.equals(FileUtils.buildValidFatFilename(name));
    }

    public static String buildValidFatFilename(String name) {
        if (TextUtils.isEmpty(name) || ".".equals(name) || "..".equals(name)) {
            return "(invalid)";
        }
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (FileUtils.isValidFatFilenameChar(c)) {
                res.append(c);
                continue;
            }
            res.append('_');
        }
        FileUtils.trimFilename(res, 255);
        return res.toString();
    }

    @VisibleForTesting
    public static String trimFilename(String str, int maxBytes) {
        StringBuilder res = new StringBuilder(str);
        FileUtils.trimFilename(res, maxBytes);
        return res.toString();
    }

    private static void trimFilename(StringBuilder res, int maxBytes) {
        byte[] raw2 = res.toString().getBytes(StandardCharsets.UTF_8);
        if (raw2.length > maxBytes) {
            maxBytes -= 3;
            while (raw2.length > maxBytes) {
                res.deleteCharAt(res.length() / 2);
                raw2 = res.toString().getBytes(StandardCharsets.UTF_8);
            }
            res.insert(res.length() / 2, "...");
        }
    }

    public static String rewriteAfterRename(File beforeDir, File afterDir, String path) {
        if (path == null) {
            return null;
        }
        File result = FileUtils.rewriteAfterRename(beforeDir, afterDir, new File(path));
        return result != null ? result.getAbsolutePath() : null;
    }

    public static String[] rewriteAfterRename(File beforeDir, File afterDir, String[] paths) {
        if (paths == null) {
            return null;
        }
        String[] result = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = FileUtils.rewriteAfterRename(beforeDir, afterDir, paths[i]);
        }
        return result;
    }

    public static File rewriteAfterRename(File beforeDir, File afterDir, File file) {
        if (file == null || beforeDir == null || afterDir == null) {
            return null;
        }
        if (FileUtils.contains(beforeDir, file)) {
            String splice = file.getAbsolutePath().substring(beforeDir.getAbsolutePath().length());
            return new File(afterDir, splice);
        }
        return null;
    }

    private static File buildUniqueFileWithExtension(File parent, String name, String ext) throws FileNotFoundException {
        File file = FileUtils.buildFile(parent, name, ext);
        int n = 0;
        while (file.exists()) {
            if (n++ >= 32) {
                throw new FileNotFoundException("Failed to create unique file");
            }
            file = FileUtils.buildFile(parent, name + " (" + n + ")", ext);
        }
        return file;
    }

    public static File buildUniqueFile(File parent, String mimeType, String displayName) throws FileNotFoundException {
        String[] parts = FileUtils.splitFileName(mimeType, displayName);
        return FileUtils.buildUniqueFileWithExtension(parent, parts[0], parts[1]);
    }

    public static File buildUniqueFile(File parent, String displayName) throws FileNotFoundException {
        String ext;
        String name;
        int lastDot = displayName.lastIndexOf(46);
        if (lastDot >= 0) {
            name = displayName.substring(0, lastDot);
            ext = displayName.substring(lastDot + 1);
        } else {
            name = displayName;
            ext = null;
        }
        return FileUtils.buildUniqueFileWithExtension(parent, name, ext);
    }

    public static String[] splitFileName(String mimeType, String displayName) {
        String ext;
        String name;
        if ("vnd.android.document/directory".equals(mimeType)) {
            name = displayName;
            ext = null;
        } else {
            String mimeTypeFromExt;
            int lastDot = displayName.lastIndexOf(46);
            if (lastDot >= 0) {
                name = displayName.substring(0, lastDot);
                ext = displayName.substring(lastDot + 1);
                mimeTypeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext.toLowerCase());
            } else {
                name = displayName;
                ext = null;
                mimeTypeFromExt = null;
            }
            if (mimeTypeFromExt == null) {
                mimeTypeFromExt = "application/octet-stream";
            }
            String extFromMimeType = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (!Objects.equals(mimeType, mimeTypeFromExt) && !Objects.equals(ext, extFromMimeType)) {
                name = displayName;
                ext = extFromMimeType;
            }
        }
        if (ext == null) {
            ext = "";
        }
        return new String[]{name, ext};
    }

    private static File buildFile(File parent, String name, String ext) {
        if (TextUtils.isEmpty(ext)) {
            return new File(parent, name);
        }
        return new File(parent, name + "." + ext);
    }

    public static String[] listOrEmpty(File dir) {
        if (dir == null) {
            return EmptyArray.STRING;
        }
        String[] res = dir.list();
        if (res != null) {
            return res;
        }
        return EmptyArray.STRING;
    }

    public static File[] listFilesOrEmpty(File dir) {
        if (dir == null) {
            return EMPTY;
        }
        File[] res = dir.listFiles();
        if (res != null) {
            return res;
        }
        return EMPTY;
    }

    public static File[] listFilesOrEmpty(File dir, FilenameFilter filter) {
        if (dir == null) {
            return EMPTY;
        }
        File[] res = dir.listFiles(filter);
        if (res != null) {
            return res;
        }
        return EMPTY;
    }

    public static File newFileOrNull(String path) {
        return path != null ? new File(path) : null;
    }

    public static File createDir(File baseDir, String name) {
        File dir = new File(baseDir, name);
        if (dir.exists()) {
            return dir.isDirectory() ? dir : null;
        }
        return dir.mkdir() ? dir : null;
    }

    public static long roundStorageSize(long size) {
        long val = 1L;
        long pow = 1L;
        while (val * pow < size) {
            if ((val <<= 1) <= 512L) continue;
            val = 1L;
            pow *= 1000L;
        }
        return val * pow;
    }

    @VisibleForTesting
    public static class MemoryPipe
    extends Thread
    implements AutoCloseable {
        private final FileDescriptor[] pipe;
        private final byte[] data;
        private final boolean sink;

        private MemoryPipe(byte[] data, boolean sink) throws IOException {
            try {
                this.pipe = Os.pipe();
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
            this.data = data;
            this.sink = sink;
        }

        private MemoryPipe startInternal() {
            super.start();
            return this;
        }

        public static MemoryPipe createSource(byte[] data) throws IOException {
            return new MemoryPipe(data, false).startInternal();
        }

        public static MemoryPipe createSink(byte[] data) throws IOException {
            return new MemoryPipe(data, true).startInternal();
        }

        public FileDescriptor getFD() {
            return this.sink ? this.pipe[1] : this.pipe[0];
        }

        public FileDescriptor getInternalFD() {
            return this.sink ? this.pipe[0] : this.pipe[1];
        }

        @Override
        public void run() {
            FileDescriptor fd = this.getInternalFD();
            try {
                int i = 0;
                while (i < this.data.length) {
                    if (this.sink) {
                        i += Os.read(fd, this.data, i, this.data.length - i);
                        continue;
                    }
                    i += Os.write(fd, this.data, i, this.data.length - i);
                }
            }
            catch (ErrnoException | IOException exception) {
            }
            finally {
                if (this.sink) {
                    SystemClock.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                IoUtils.closeQuietly(fd);
            }
        }

        @Override
        public void close() throws Exception {
            IoUtils.closeQuietly(this.getFD());
        }
    }

    public static interface ProgressListener {
        public void onProgress(long var1);
    }

    private static class NoImagePreloadHolder {
        public static final Pattern SAFE_FILENAME_PATTERN = Pattern.compile("[\\w%+,./=_-]+");

        private NoImagePreloadHolder() {
        }
    }
}

