/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.NetworkOnMainThreadException;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.StrictMode;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMRuntime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libcore.util.SneakyThrow;

public class Parcel {
    private static final boolean DEBUG_RECYCLE = false;
    private static final boolean DEBUG_ARRAY_MAP = false;
    private static final String TAG = "Parcel";
    private long mNativePtr;
    private boolean mOwnsNativeParcelObject;
    private long mNativeSize;
    private ArrayMap<Class, Object> mClassCookies;
    private RuntimeException mStack;
    private static boolean sParcelExceptionStackTrace;
    private static final int POOL_SIZE = 6;
    private static final Parcel[] sOwnedPool;
    private static final Parcel[] sHolderPool;
    private static final int VAL_NULL = -1;
    private static final int VAL_STRING = 0;
    private static final int VAL_INTEGER = 1;
    private static final int VAL_MAP = 2;
    private static final int VAL_BUNDLE = 3;
    private static final int VAL_PARCELABLE = 4;
    private static final int VAL_SHORT = 5;
    private static final int VAL_LONG = 6;
    private static final int VAL_FLOAT = 7;
    private static final int VAL_DOUBLE = 8;
    private static final int VAL_BOOLEAN = 9;
    private static final int VAL_CHARSEQUENCE = 10;
    private static final int VAL_LIST = 11;
    private static final int VAL_SPARSEARRAY = 12;
    private static final int VAL_BYTEARRAY = 13;
    private static final int VAL_STRINGARRAY = 14;
    private static final int VAL_IBINDER = 15;
    private static final int VAL_PARCELABLEARRAY = 16;
    private static final int VAL_OBJECTARRAY = 17;
    private static final int VAL_INTARRAY = 18;
    private static final int VAL_LONGARRAY = 19;
    private static final int VAL_BYTE = 20;
    private static final int VAL_SERIALIZABLE = 21;
    private static final int VAL_SPARSEBOOLEANARRAY = 22;
    private static final int VAL_BOOLEANARRAY = 23;
    private static final int VAL_CHARSEQUENCEARRAY = 24;
    private static final int VAL_PERSISTABLEBUNDLE = 25;
    private static final int VAL_SIZE = 26;
    private static final int VAL_SIZEF = 27;
    private static final int VAL_DOUBLEARRAY = 28;
    private static final int EX_SECURITY = -1;
    private static final int EX_BAD_PARCELABLE = -2;
    private static final int EX_ILLEGAL_ARGUMENT = -3;
    private static final int EX_NULL_POINTER = -4;
    private static final int EX_ILLEGAL_STATE = -5;
    private static final int EX_NETWORK_MAIN_THREAD = -6;
    private static final int EX_UNSUPPORTED_OPERATION = -7;
    private static final int EX_SERVICE_SPECIFIC = -8;
    private static final int EX_PARCELABLE = -9;
    private static final int EX_HAS_REPLY_HEADER = -128;
    private static final int EX_TRANSACTION_FAILED = -129;
    private static volatile long sLastWriteExceptionStackTrace;
    private static final int WRITE_EXCEPTION_STACK_TRACE_THRESHOLD_MS = 1000;
    public static final Parcelable.Creator<String> STRING_CREATOR;
    private ReadWriteHelper mReadWriteHelper = ReadWriteHelper.DEFAULT;
    private static final HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> mCreators;

    @CriticalNative
    private static int nativeDataSize(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataSize(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataAvail(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataAvail(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataPosition(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataPosition(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataCapacity(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataCapacity(J)I", true, null);
    }

    @FastNative
    private static long nativeSetDataSize(long l, int n) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeSetDataSize(JI)J", true, null);
    }

    @CriticalNative
    private static void nativeSetDataPosition(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataPosition(JI)V", true, null);
    }

    @FastNative
    private static void nativeSetDataCapacity(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataCapacity(JI)V", true, null);
    }

    @CriticalNative
    private static boolean nativePushAllowFds(long l, boolean bl) {
        return OverrideMethod.invokeI("android.os.Parcel#nativePushAllowFds(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static void nativeRestoreAllowFds(long l, boolean bl) {
        OverrideMethod.invokeV("android.os.Parcel#nativeRestoreAllowFds(JZ)V", true, null);
    }

    private static void nativeWriteByteArray(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteByteArray(J[BII)V", true, null);
    }

    private static void nativeWriteBlob(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteBlob(J[BII)V", true, null);
    }

    @FastNative
    private static void nativeWriteInt(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteInt(JI)V", true, null);
    }

    @FastNative
    private static void nativeWriteLong(long l, long l2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteLong(JJ)V", true, null);
    }

    @FastNative
    private static void nativeWriteFloat(long l, float f) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteFloat(JF)V", true, null);
    }

    @FastNative
    private static void nativeWriteDouble(long l, double d) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteDouble(JD)V", true, null);
    }

    static void nativeWriteString(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteString(JLjava/lang/String;)V", true, null);
    }

    private static void nativeWriteStrongBinder(long l, IBinder iBinder) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteStrongBinder(JLandroid/os/IBinder;)V", true, null);
    }

    private static long nativeWriteFileDescriptor(long l, FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeWriteFileDescriptor(JLjava/io/FileDescriptor;)J", true, null);
    }

    private static byte[] nativeCreateByteArray(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeCreateByteArray(J)[B", true, null);
    }

    private static boolean nativeReadByteArray(long l, byte[] byArray, int n) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadByteArray(J[BI)Z", true, null) != 0;
    }

    private static byte[] nativeReadBlob(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeReadBlob(J)[B", true, null);
    }

    @CriticalNative
    private static int nativeReadInt(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadInt(J)I", true, null);
    }

    @CriticalNative
    private static long nativeReadLong(long l) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeReadLong(J)J", true, null);
    }

    @CriticalNative
    private static float nativeReadFloat(long l) {
        return OverrideMethod.invokeF("android.os.Parcel#nativeReadFloat(J)F", true, null);
    }

    @CriticalNative
    private static double nativeReadDouble(long l) {
        return OverrideMethod.invokeD("android.os.Parcel#nativeReadDouble(J)D", true, null);
    }

    static String nativeReadString(long l) {
        return (String)OverrideMethod.invokeA("android.os.Parcel#nativeReadString(J)Ljava/lang/String;", true, null);
    }

    private static IBinder nativeReadStrongBinder(long l) {
        return (IBinder)OverrideMethod.invokeA("android.os.Parcel#nativeReadStrongBinder(J)Landroid/os/IBinder;", true, null);
    }

    private static FileDescriptor nativeReadFileDescriptor(long l) {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.Parcel#nativeReadFileDescriptor(J)Ljava/io/FileDescriptor;", true, null);
    }

    private static long nativeCreate() {
        return OverrideMethod.invokeL("android.os.Parcel#nativeCreate()J", true, null);
    }

    private static long nativeFreeBuffer(long l) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeFreeBuffer(J)J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.os.Parcel#nativeDestroy(J)V", true, null);
    }

    private static byte[] nativeMarshall(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeMarshall(J)[B", true, null);
    }

    private static long nativeUnmarshall(long l, byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeUnmarshall(J[BII)J", true, null);
    }

    private static int nativeCompareData(long l, long l2) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeCompareData(JJ)I", true, null);
    }

    private static long nativeAppendFrom(long l, long l2, int n, int n2) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeAppendFrom(JJII)J", true, null);
    }

    @CriticalNative
    private static boolean nativeHasFileDescriptors(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeHasFileDescriptors(J)Z", true, null) != 0;
    }

    private static void nativeWriteInterfaceToken(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteInterfaceToken(JLjava/lang/String;)V", true, null);
    }

    private static void nativeEnforceInterface(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeEnforceInterface(JLjava/lang/String;)V", true, null);
    }

    @CriticalNative
    private static long nativeGetBlobAshmemSize(long l) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeGetBlobAshmemSize(J)J", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parcel obtain() {
        Parcel[] pool;
        Parcel[] parcelArray = pool = sOwnedPool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                Parcel p = pool[i];
                if (p == null) continue;
                pool[i] = null;
                p.mReadWriteHelper = ReadWriteHelper.DEFAULT;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return p;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Parcel(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Parcel[] pool;
        this.freeBuffer();
        if (this.mOwnsNativeParcelObject) {
            pool = sOwnedPool;
        } else {
            this.mNativePtr = 0L;
            pool = sHolderPool;
        }
        Parcel[] parcelArray = pool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                if (pool[i] != null) continue;
                pool[i] = this;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setReadWriteHelper(ReadWriteHelper helper) {
        this.mReadWriteHelper = helper != null ? helper : ReadWriteHelper.DEFAULT;
    }

    public boolean hasReadWriteHelper() {
        return this.mReadWriteHelper != null && this.mReadWriteHelper != ReadWriteHelper.DEFAULT;
    }

    public static long getGlobalAllocSize() {
        return OverrideMethod.invokeL("android.os.Parcel#getGlobalAllocSize()J", true, null);
    }

    public static long getGlobalAllocCount() {
        return OverrideMethod.invokeL("android.os.Parcel#getGlobalAllocCount()J", true, null);
    }

    public int dataSize() {
        return Parcel.nativeDataSize(this.mNativePtr);
    }

    public int dataAvail() {
        return Parcel.nativeDataAvail(this.mNativePtr);
    }

    public int dataPosition() {
        return Parcel.nativeDataPosition(this.mNativePtr);
    }

    public int dataCapacity() {
        return Parcel.nativeDataCapacity(this.mNativePtr);
    }

    public void setDataSize(int size) {
        this.updateNativeSize(Parcel.nativeSetDataSize(this.mNativePtr, size));
    }

    public void setDataPosition(int pos) {
        Parcel.nativeSetDataPosition(this.mNativePtr, pos);
    }

    public void setDataCapacity(int size) {
        Parcel.nativeSetDataCapacity(this.mNativePtr, size);
    }

    public boolean pushAllowFds(boolean allowFds) {
        return Parcel.nativePushAllowFds(this.mNativePtr, allowFds);
    }

    public void restoreAllowFds(boolean lastValue) {
        Parcel.nativeRestoreAllowFds(this.mNativePtr, lastValue);
    }

    public byte[] marshall() {
        return Parcel.nativeMarshall(this.mNativePtr);
    }

    public void unmarshall(byte[] data, int offset, int length) {
        this.updateNativeSize(Parcel.nativeUnmarshall(this.mNativePtr, data, offset, length));
    }

    public void appendFrom(Parcel parcel, int offset, int length) {
        this.updateNativeSize(Parcel.nativeAppendFrom(this.mNativePtr, parcel.mNativePtr, offset, length));
    }

    public int compareData(Parcel other) {
        return Parcel.nativeCompareData(this.mNativePtr, other.mNativePtr);
    }

    public void setClassCookie(Class clz, Object cookie) {
        if (this.mClassCookies == null) {
            this.mClassCookies = new ArrayMap();
        }
        this.mClassCookies.put(clz, cookie);
    }

    public Object getClassCookie(Class clz) {
        return this.mClassCookies != null ? this.mClassCookies.get(clz) : null;
    }

    public void adoptClassCookies(Parcel from) {
        this.mClassCookies = from.mClassCookies;
    }

    public Map<Class, Object> copyClassCookies() {
        return new ArrayMap<Class, Object>(this.mClassCookies);
    }

    public void putClassCookies(Map<Class, Object> cookies) {
        if (cookies == null) {
            return;
        }
        if (this.mClassCookies == null) {
            this.mClassCookies = new ArrayMap();
        }
        this.mClassCookies.putAll(cookies);
    }

    public boolean hasFileDescriptors() {
        return Parcel.nativeHasFileDescriptors(this.mNativePtr);
    }

    public void writeInterfaceToken(String interfaceName) {
        Parcel.nativeWriteInterfaceToken(this.mNativePtr, interfaceName);
    }

    public void enforceInterface(String interfaceName) {
        Parcel.nativeEnforceInterface(this.mNativePtr, interfaceName);
    }

    public void writeByteArray(byte[] b) {
        this.writeByteArray(b, 0, b != null ? b.length : 0);
    }

    public void writeByteArray(byte[] b, int offset, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        Arrays.checkOffsetAndCount((int)b.length, (int)offset, (int)len);
        Parcel.nativeWriteByteArray(this.mNativePtr, b, offset, len);
    }

    public void writeBlob(byte[] b) {
        this.writeBlob(b, 0, b != null ? b.length : 0);
    }

    public void writeBlob(byte[] b, int offset, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        Arrays.checkOffsetAndCount((int)b.length, (int)offset, (int)len);
        Parcel.nativeWriteBlob(this.mNativePtr, b, offset, len);
    }

    public void writeInt(int val) {
        Parcel.nativeWriteInt(this.mNativePtr, val);
    }

    public void writeLong(long val) {
        Parcel.nativeWriteLong(this.mNativePtr, val);
    }

    public void writeFloat(float val) {
        Parcel.nativeWriteFloat(this.mNativePtr, val);
    }

    public void writeDouble(double val) {
        Parcel.nativeWriteDouble(this.mNativePtr, val);
    }

    public void writeString(String val) {
        this.mReadWriteHelper.writeString(this, val);
    }

    public void writeStringNoHelper(String val) {
        Parcel.nativeWriteString(this.mNativePtr, val);
    }

    public void writeBoolean(boolean val) {
        this.writeInt(val ? 1 : 0);
    }

    public void writeCharSequence(CharSequence val) {
        TextUtils.writeToParcel(val, this, 0);
    }

    public void writeStrongBinder(IBinder val) {
        Parcel.nativeWriteStrongBinder(this.mNativePtr, val);
    }

    public void writeStrongInterface(IInterface val) {
        this.writeStrongBinder(val == null ? null : val.asBinder());
    }

    public void writeFileDescriptor(FileDescriptor val) {
        this.updateNativeSize(Parcel.nativeWriteFileDescriptor(this.mNativePtr, val));
    }

    private void updateNativeSize(long newNativeSize) {
        if (this.mOwnsNativeParcelObject) {
            if (newNativeSize > Integer.MAX_VALUE) {
                newNativeSize = Integer.MAX_VALUE;
            }
            if (newNativeSize != this.mNativeSize) {
                int delta = (int)(newNativeSize - this.mNativeSize);
                if (delta > 0) {
                    VMRuntime.getRuntime().registerNativeAllocation(delta);
                } else {
                    VMRuntime.getRuntime().registerNativeFree(-delta);
                }
                this.mNativeSize = newNativeSize;
            }
        }
    }

    public void writeRawFileDescriptor(FileDescriptor val) {
        Parcel.nativeWriteFileDescriptor(this.mNativePtr, val);
    }

    public void writeRawFileDescriptorArray(FileDescriptor[] value) {
        if (value != null) {
            int N = value.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeRawFileDescriptor(value[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeByte(byte val) {
        this.writeInt(val);
    }

    public void writeMap(Map val) {
        this.writeMapInternal(val);
    }

    void writeMapInternal(Map<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        Set<Map.Entry<String, Object>> entries = val.entrySet();
        int size = entries.size();
        this.writeInt(size);
        for (Map.Entry<String, Object> e : entries) {
            this.writeValue(e.getKey());
            this.writeValue(e.getValue());
            --size;
        }
        if (size != 0) {
            throw new BadParcelableException("Map size does not match number of entries!");
        }
    }

    void writeArrayMapInternal(ArrayMap<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    public void writeArrayMap(ArrayMap<String, Object> val) {
        this.writeArrayMapInternal(val);
    }

    public void writeArraySet(ArraySet<? extends Object> val) {
        int size = val != null ? val.size() : -1;
        this.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.writeValue(val.valueAt(i));
        }
    }

    public void writeBundle(Bundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    public void writePersistableBundle(PersistableBundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    public void writeSize(Size val) {
        this.writeInt(val.getWidth());
        this.writeInt(val.getHeight());
    }

    public void writeSizeF(SizeF val) {
        this.writeFloat(val.getWidth());
        this.writeFloat(val.getHeight());
    }

    public void writeList(List val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val.get(i));
        }
    }

    public void writeArray(Object[] val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.length;
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val[i]);
        }
    }

    public void writeSparseArray(SparseArray<Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    public void writeSparseBooleanArray(SparseBooleanArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeByte((byte)(val.valueAt(i) ? 1 : 0));
        }
    }

    public void writeSparseIntArray(SparseIntArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeInt(val.valueAt(i));
        }
    }

    public void writeBooleanArray(boolean[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i] ? 1 : 0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public boolean[] createBooleanArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            boolean[] val = new boolean[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
            return val;
        }
        return null;
    }

    public void readBooleanArray(boolean[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeCharArray(char[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public char[] createCharArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            char[] val = new char[N];
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
            return val;
        }
        return null;
    }

    public void readCharArray(char[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeIntArray(int[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public int[] createIntArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            int[] val = new int[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
            return val;
        }
        return null;
    }

    public void readIntArray(int[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeLongArray(long[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeLong(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public long[] createLongArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            long[] val = new long[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
            return val;
        }
        return null;
    }

    public void readLongArray(long[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeFloatArray(float[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeFloat(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public float[] createFloatArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            float[] val = new float[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
            return val;
        }
        return null;
    }

    public void readFloatArray(float[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeDoubleArray(double[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeDouble(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public double[] createDoubleArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            double[] val = new double[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
            return val;
        }
        return null;
    }

    public void readDoubleArray(double[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeStringArray(String[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeString(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public String[] createStringArray() {
        int N = this.readInt();
        if (N >= 0) {
            String[] val = new String[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString();
            }
            return val;
        }
        return null;
    }

    public void readStringArray(String[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeBinderArray(IBinder[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeStrongBinder(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeCharSequenceArray(CharSequence[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeCharSequenceList(ArrayList<CharSequence> val) {
        if (val != null) {
            int N = val.size();
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val.get(i));
            }
        } else {
            this.writeInt(-1);
        }
    }

    public IBinder[] createBinderArray() {
        int N = this.readInt();
        if (N >= 0) {
            IBinder[] val = new IBinder[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
            return val;
        }
        return null;
    }

    public void readBinderArray(IBinder[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public <T extends Parcelable> void writeTypedList(List<T> val) {
        this.writeTypedList(val, 0);
    }

    public <T extends Parcelable> void writeTypedList(List<T> val, int parcelableFlags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeTypedObject((Parcelable)val.get(i), parcelableFlags);
        }
    }

    public void writeStringList(List<String> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.get(i));
        }
    }

    public void writeBinderList(List<IBinder> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeStrongBinder(val.get(i));
        }
    }

    public <T extends Parcelable> void writeParcelableList(List<T> val, int flags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeParcelable((Parcelable)val.get(i), flags);
        }
    }

    public <T extends Parcelable> void writeTypedArray(T[] val, int parcelableFlags) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeTypedObject(val[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public <T extends Parcelable> void writeTypedObject(T val, int parcelableFlags) {
        if (val != null) {
            this.writeInt(1);
            val.writeToParcel(this, parcelableFlags);
        } else {
            this.writeInt(0);
        }
    }

    public void writeValue(Object v) {
        if (v == null) {
            this.writeInt(-1);
        } else if (v instanceof String) {
            this.writeInt(0);
            this.writeString((String)v);
        } else if (v instanceof Integer) {
            this.writeInt(1);
            this.writeInt((Integer)v);
        } else if (v instanceof Map) {
            this.writeInt(2);
            this.writeMap((Map)v);
        } else if (v instanceof Bundle) {
            this.writeInt(3);
            this.writeBundle((Bundle)v);
        } else if (v instanceof PersistableBundle) {
            this.writeInt(25);
            this.writePersistableBundle((PersistableBundle)v);
        } else if (v instanceof Parcelable) {
            this.writeInt(4);
            this.writeParcelable((Parcelable)v, 0);
        } else if (v instanceof Short) {
            this.writeInt(5);
            this.writeInt(((Short)v).intValue());
        } else if (v instanceof Long) {
            this.writeInt(6);
            this.writeLong((Long)v);
        } else if (v instanceof Float) {
            this.writeInt(7);
            this.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            this.writeInt(8);
            this.writeDouble((Double)v);
        } else if (v instanceof Boolean) {
            this.writeInt(9);
            this.writeInt((Boolean)v != false ? 1 : 0);
        } else if (v instanceof CharSequence) {
            this.writeInt(10);
            this.writeCharSequence((CharSequence)v);
        } else if (v instanceof List) {
            this.writeInt(11);
            this.writeList((List)v);
        } else if (v instanceof SparseArray) {
            this.writeInt(12);
            this.writeSparseArray((SparseArray)v);
        } else if (v instanceof boolean[]) {
            this.writeInt(23);
            this.writeBooleanArray((boolean[])v);
        } else if (v instanceof byte[]) {
            this.writeInt(13);
            this.writeByteArray((byte[])v);
        } else if (v instanceof String[]) {
            this.writeInt(14);
            this.writeStringArray((String[])v);
        } else if (v instanceof CharSequence[]) {
            this.writeInt(24);
            this.writeCharSequenceArray((CharSequence[])v);
        } else if (v instanceof IBinder) {
            this.writeInt(15);
            this.writeStrongBinder((IBinder)v);
        } else if (v instanceof Parcelable[]) {
            this.writeInt(16);
            this.writeParcelableArray((Parcelable[])v, 0);
        } else if (v instanceof int[]) {
            this.writeInt(18);
            this.writeIntArray((int[])v);
        } else if (v instanceof long[]) {
            this.writeInt(19);
            this.writeLongArray((long[])v);
        } else if (v instanceof Byte) {
            this.writeInt(20);
            this.writeInt(((Byte)v).byteValue());
        } else if (v instanceof Size) {
            this.writeInt(26);
            this.writeSize((Size)v);
        } else if (v instanceof SizeF) {
            this.writeInt(27);
            this.writeSizeF((SizeF)v);
        } else if (v instanceof double[]) {
            this.writeInt(28);
            this.writeDoubleArray((double[])v);
        } else {
            Class<?> clazz = v.getClass();
            if (clazz.isArray() && clazz.getComponentType() == Object.class) {
                this.writeInt(17);
                this.writeArray((Object[])v);
            } else if (v instanceof Serializable) {
                this.writeInt(21);
                this.writeSerializable((Serializable)v);
            } else {
                throw new RuntimeException("Parcel: unable to marshal value " + v);
            }
        }
    }

    public void writeParcelable(Parcelable p, int parcelableFlags) {
        if (p == null) {
            this.writeString(null);
            return;
        }
        this.writeParcelableCreator(p);
        p.writeToParcel(this, parcelableFlags);
    }

    public void writeParcelableCreator(Parcelable p) {
        String name = p.getClass().getName();
        this.writeString(name);
    }

    public void writeSerializable(Serializable s) {
        if (s == null) {
            this.writeString(null);
            return;
        }
        String name = s.getClass().getName();
        this.writeString(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(s);
            oos.close();
            this.writeByteArray(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException writing serializable object (name = " + name + ")", ioe);
        }
    }

    public static void setStackTraceParceling(boolean enabled) {
        sParcelExceptionStackTrace = enabled;
    }

    public void writeException(Exception e) {
        int sizePosition;
        long timeNow;
        int code = 0;
        if (e instanceof Parcelable && e.getClass().getClassLoader() == Parcelable.class.getClassLoader()) {
            code = -9;
        } else if (e instanceof SecurityException) {
            code = -1;
        } else if (e instanceof BadParcelableException) {
            code = -2;
        } else if (e instanceof IllegalArgumentException) {
            code = -3;
        } else if (e instanceof NullPointerException) {
            code = -4;
        } else if (e instanceof IllegalStateException) {
            code = -5;
        } else if (e instanceof NetworkOnMainThreadException) {
            code = -6;
        } else if (e instanceof UnsupportedOperationException) {
            code = -7;
        } else if (e instanceof ServiceSpecificException) {
            code = -8;
        }
        this.writeInt(code);
        StrictMode.clearGatheredViolations();
        if (code == 0) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.writeString(e.getMessage());
        long l = timeNow = sParcelExceptionStackTrace ? SystemClock.elapsedRealtime() : 0L;
        if (sParcelExceptionStackTrace && timeNow - sLastWriteExceptionStackTrace > 1000L) {
            sLastWriteExceptionStackTrace = timeNow;
            sizePosition = this.dataPosition();
            this.writeInt(0);
            StackTraceElement[] stackTrace = e.getStackTrace();
            int truncatedSize = Math.min(stackTrace.length, 5);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < truncatedSize; ++i) {
                sb.append("\tat ").append(stackTrace[i]).append('\n');
            }
            this.writeString(sb.toString());
            int payloadPosition = this.dataPosition();
            this.setDataPosition(sizePosition);
            this.writeInt(payloadPosition - sizePosition);
            this.setDataPosition(payloadPosition);
        } else {
            this.writeInt(0);
        }
        switch (code) {
            case -8: {
                this.writeInt(((ServiceSpecificException)e).errorCode);
                break;
            }
            case -9: {
                sizePosition = this.dataPosition();
                this.writeInt(0);
                this.writeParcelable((Parcelable)((Object)e), 1);
                int payloadPosition = this.dataPosition();
                this.setDataPosition(sizePosition);
                this.writeInt(payloadPosition - sizePosition);
                this.setDataPosition(payloadPosition);
            }
        }
    }

    public void writeNoException() {
        if (StrictMode.hasGatheredViolations()) {
            this.writeInt(-128);
            int sizePosition = this.dataPosition();
            this.writeInt(0);
            StrictMode.writeGatheredViolationsToParcel(this);
            int payloadPosition = this.dataPosition();
            this.setDataPosition(sizePosition);
            this.writeInt(payloadPosition - sizePosition);
            this.setDataPosition(payloadPosition);
        } else {
            this.writeInt(0);
        }
    }

    public void readException() {
        int code = this.readExceptionCode();
        if (code != 0) {
            String msg = this.readString();
            this.readException(code, msg);
        }
    }

    public int readExceptionCode() {
        int code = this.readInt();
        if (code == -128) {
            int headerSize = this.readInt();
            if (headerSize == 0) {
                Log.e(TAG, "Unexpected zero-sized Parcel reply header.");
            } else {
                StrictMode.readAndHandleBinderCallViolations(this);
            }
            return 0;
        }
        return code;
    }

    public void readException(int code, String msg) {
        String remoteStackTrace = null;
        int remoteStackPayloadSize = this.readInt();
        if (remoteStackPayloadSize > 0) {
            remoteStackTrace = this.readString();
        }
        Exception e = this.createException(code, msg);
        if (remoteStackTrace != null) {
            RemoteException cause = new RemoteException("Remote stack trace:\n" + remoteStackTrace, null, false, false);
            try {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                if (rootCause != null) {
                    rootCause.initCause(cause);
                }
            }
            catch (RuntimeException ex) {
                Log.e(TAG, "Cannot set cause " + cause + " for " + e, ex);
            }
        }
        SneakyThrow.sneakyThrow(e);
    }

    private Exception createException(int code, String msg) {
        switch (code) {
            case -9: {
                if (this.readInt() > 0) {
                    return (Exception)this.readParcelable(Parcelable.class.getClassLoader());
                }
                return new RuntimeException(msg + " [missing Parcelable]");
            }
            case -1: {
                return new SecurityException(msg);
            }
            case -2: {
                return new BadParcelableException(msg);
            }
            case -3: {
                return new IllegalArgumentException(msg);
            }
            case -4: {
                return new NullPointerException(msg);
            }
            case -5: {
                return new IllegalStateException(msg);
            }
            case -6: {
                return new NetworkOnMainThreadException();
            }
            case -7: {
                return new UnsupportedOperationException(msg);
            }
            case -8: {
                return new ServiceSpecificException(this.readInt(), msg);
            }
        }
        return new RuntimeException("Unknown exception code: " + code + " msg " + msg);
    }

    public int readInt() {
        return Parcel.nativeReadInt(this.mNativePtr);
    }

    public long readLong() {
        return Parcel.nativeReadLong(this.mNativePtr);
    }

    public float readFloat() {
        return Parcel.nativeReadFloat(this.mNativePtr);
    }

    public double readDouble() {
        return Parcel.nativeReadDouble(this.mNativePtr);
    }

    public String readString() {
        return this.mReadWriteHelper.readString(this);
    }

    public String readStringNoHelper() {
        return Parcel.nativeReadString(this.mNativePtr);
    }

    public boolean readBoolean() {
        return this.readInt() != 0;
    }

    public CharSequence readCharSequence() {
        return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(this);
    }

    public IBinder readStrongBinder() {
        return Parcel.nativeReadStrongBinder(this.mNativePtr);
    }

    public ParcelFileDescriptor readFileDescriptor() {
        FileDescriptor fd = Parcel.nativeReadFileDescriptor(this.mNativePtr);
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    public FileDescriptor readRawFileDescriptor() {
        return Parcel.nativeReadFileDescriptor(this.mNativePtr);
    }

    public FileDescriptor[] createRawFileDescriptorArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        FileDescriptor[] f = new FileDescriptor[N];
        for (int i = 0; i < N; ++i) {
            f[i] = this.readRawFileDescriptor();
        }
        return f;
    }

    public void readRawFileDescriptorArray(FileDescriptor[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readRawFileDescriptor();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @Deprecated
    static FileDescriptor openFileDescriptor(String string2, int n) throws FileNotFoundException {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.Parcel#openFileDescriptor(Ljava/lang/String;I)Ljava/io/FileDescriptor;", true, null);
    }

    @Deprecated
    static FileDescriptor dupFileDescriptor(FileDescriptor fileDescriptor) throws IOException {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.Parcel#dupFileDescriptor(Ljava/io/FileDescriptor;)Ljava/io/FileDescriptor;", true, null);
    }

    @Deprecated
    static void closeFileDescriptor(FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("android.os.Parcel#closeFileDescriptor(Ljava/io/FileDescriptor;)V", true, null);
    }

    public byte readByte() {
        return (byte)(this.readInt() & 0xFF);
    }

    public void readMap(Map outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readMapInternal(outVal, N, loader);
    }

    public void readList(List outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readListInternal(outVal, N, loader);
    }

    public HashMap readHashMap(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        HashMap m = new HashMap(N);
        this.readMapInternal(m, N, loader);
        return m;
    }

    public Bundle readBundle() {
        return this.readBundle(null);
    }

    public Bundle readBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        Bundle bundle = new Bundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    public PersistableBundle readPersistableBundle() {
        return this.readPersistableBundle(null);
    }

    public PersistableBundle readPersistableBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        PersistableBundle bundle = new PersistableBundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    public Size readSize() {
        int width = this.readInt();
        int height = this.readInt();
        return new Size(width, height);
    }

    public SizeF readSizeF() {
        float width = this.readFloat();
        float height = this.readFloat();
        return new SizeF(width, height);
    }

    public byte[] createByteArray() {
        return Parcel.nativeCreateByteArray(this.mNativePtr);
    }

    public void readByteArray(byte[] val) {
        boolean valid = Parcel.nativeReadByteArray(this.mNativePtr, val, val != null ? val.length : 0);
        if (!valid) {
            throw new RuntimeException("bad array lengths");
        }
    }

    public byte[] readBlob() {
        return Parcel.nativeReadBlob(this.mNativePtr);
    }

    public String[] readStringArray() {
        String[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new String[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readString();
            }
        }
        return array2;
    }

    public CharSequence[] readCharSequenceArray() {
        CharSequence[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new CharSequence[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readCharSequence();
            }
        }
        return array2;
    }

    public ArrayList<CharSequence> readCharSequenceList() {
        ArrayList<CharSequence> array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new ArrayList<CharSequence>(length);
            for (int i = 0; i < length; ++i) {
                array2.add(this.readCharSequence());
            }
        }
        return array2;
    }

    public ArrayList readArrayList(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList l = new ArrayList(N);
        this.readListInternal(l, N, loader);
        return l;
    }

    public Object[] readArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Object[] l = new Object[N];
        this.readArrayInternal(l, N, loader);
        return l;
    }

    public SparseArray readSparseArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseArray sa = new SparseArray(N);
        this.readSparseArrayInternal(sa, N, loader);
        return sa;
    }

    public SparseBooleanArray readSparseBooleanArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseBooleanArray sa = new SparseBooleanArray(N);
        this.readSparseBooleanArrayInternal(sa, N);
        return sa;
    }

    public SparseIntArray readSparseIntArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseIntArray sa = new SparseIntArray(N);
        this.readSparseIntArrayInternal(sa, N);
        return sa;
    }

    public <T> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(N);
        while (N > 0) {
            l.add(this.readTypedObject(c));
            --N;
        }
        return l;
    }

    public <T> void readTypedList(List<T> list, Parcelable.Creator<T> c) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readTypedObject(c));
        }
        while (i < N) {
            list.add(this.readTypedObject(c));
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public ArrayList<String> createStringArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>(N);
        while (N > 0) {
            l.add(this.readString());
            --N;
        }
        return l;
    }

    public ArrayList<IBinder> createBinderArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<IBinder> l = new ArrayList<IBinder>(N);
        while (N > 0) {
            l.add(this.readStrongBinder());
            --N;
        }
        return l;
    }

    public void readStringList(List<String> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readString());
        }
        while (i < N) {
            list.add(this.readString());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public void readBinderList(List<IBinder> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readStrongBinder());
        }
        while (i < N) {
            list.add(this.readStrongBinder());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public <T extends Parcelable> List<T> readParcelableList(List<T> list, ClassLoader cl) {
        int i;
        int N = this.readInt();
        if (N == -1) {
            list.clear();
            return list;
        }
        int M = list.size();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readParcelable(cl));
        }
        while (i < N) {
            list.add(this.readParcelable(cl));
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
        return list;
    }

    public <T> T[] createTypedArray(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        T[] l = c.newArray(N);
        for (int i = 0; i < N; ++i) {
            l[i] = this.readTypedObject(c);
        }
        return l;
    }

    public <T> void readTypedArray(T[] val, Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readTypedObject(c);
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @Deprecated
    public <T> T[] readTypedArray(Parcelable.Creator<T> c) {
        return this.createTypedArray(c);
    }

    public <T> T readTypedObject(Parcelable.Creator<T> c) {
        if (this.readInt() != 0) {
            return c.createFromParcel(this);
        }
        return null;
    }

    public <T extends Parcelable> void writeParcelableArray(T[] value, int parcelableFlags) {
        if (value != null) {
            int N = value.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeParcelable((Parcelable)value[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public Object readValue(ClassLoader loader) {
        int type = this.readInt();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readHashMap(loader);
            }
            case 4: {
                return this.readParcelable(loader);
            }
            case 5: {
                return (short)this.readInt();
            }
            case 6: {
                return this.readLong();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readDouble();
            }
            case 9: {
                return this.readInt() == 1;
            }
            case 10: {
                return this.readCharSequence();
            }
            case 11: {
                return this.readArrayList(loader);
            }
            case 23: {
                return this.createBooleanArray();
            }
            case 13: {
                return this.createByteArray();
            }
            case 14: {
                return this.readStringArray();
            }
            case 24: {
                return this.readCharSequenceArray();
            }
            case 15: {
                return this.readStrongBinder();
            }
            case 17: {
                return this.readArray(loader);
            }
            case 18: {
                return this.createIntArray();
            }
            case 19: {
                return this.createLongArray();
            }
            case 20: {
                return this.readByte();
            }
            case 21: {
                return this.readSerializable(loader);
            }
            case 16: {
                return this.readParcelableArray(loader);
            }
            case 12: {
                return this.readSparseArray(loader);
            }
            case 22: {
                return this.readSparseBooleanArray();
            }
            case 3: {
                return this.readBundle(loader);
            }
            case 25: {
                return this.readPersistableBundle(loader);
            }
            case 26: {
                return this.readSize();
            }
            case 27: {
                return this.readSizeF();
            }
            case 28: {
                return this.createDoubleArray();
            }
        }
        int off = this.dataPosition() - 4;
        throw new RuntimeException("Parcel " + this + ": Unmarshalling unknown type code " + type + " at offset " + off);
    }

    public <T extends Parcelable> T readParcelable(ClassLoader loader) {
        Parcelable.Creator<?> creator = this.readParcelableCreator(loader);
        if (creator == null) {
            return null;
        }
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    public <T extends Parcelable> T readCreator(Parcelable.Creator<?> creator, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parcelable.Creator<?> readParcelableCreator(ClassLoader loader) {
        Parcelable.Creator creator;
        String name = this.readString();
        if (name == null) {
            return null;
        }
        HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> hashMap = mCreators;
        synchronized (hashMap) {
            HashMap<String, Parcelable.Creator<Object>> map = mCreators.get(loader);
            if (map == null) {
                map = new HashMap();
                mCreators.put(loader, map);
            }
            if ((creator = map.get(name)) == null) {
                try {
                    ClassLoader parcelableClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
                    Class<?> parcelableClass = Class.forName(name, false, parcelableClassLoader);
                    if (!Parcelable.class.isAssignableFrom(parcelableClass)) {
                        throw new BadParcelableException("Parcelable protocol requires subclassing from Parcelable on class " + name);
                    }
                    Field f = parcelableClass.getField("CREATOR");
                    if ((f.getModifiers() & 8) == 0) {
                        throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
                    }
                    Class<?> creatorType = f.getType();
                    if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                        throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
                    }
                    creator = (Parcelable.Creator)f.get(null);
                }
                catch (IllegalAccessException e) {
                    Log.e(TAG, "Illegal access when unmarshalling: " + name, e);
                    throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name);
                }
                catch (ClassNotFoundException e) {
                    Log.e(TAG, "Class not found when unmarshalling: " + name, e);
                    throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name);
                }
                catch (NoSuchFieldException e) {
                    throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
                }
                if (creator == null) {
                    throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
                }
                map.put(name, creator);
            }
        }
        return creator;
    }

    public Parcelable[] readParcelableArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Parcelable[] p = new Parcelable[N];
        for (int i = 0; i < N; ++i) {
            p[i] = this.readParcelable(loader);
        }
        return p;
    }

    public <T extends Parcelable> T[] readParcelableArray(ClassLoader loader, Class<T> clazz) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Parcelable[] p = (Parcelable[])Array.newInstance(clazz, N);
        for (int i = 0; i < N; ++i) {
            p[i] = this.readParcelable(loader);
        }
        return p;
    }

    public Serializable readSerializable() {
        return this.readSerializable(null);
    }

    private Serializable readSerializable(final ClassLoader loader) {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        byte[] serializedData = this.createByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedData);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
                    Class<?> c;
                    if (loader != null && (c = Class.forName(osClass.getName(), false, loader)) != null) {
                        return c;
                    }
                    return super.resolveClass(osClass);
                }
            };
            return (Serializable)ois.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException reading a Serializable object (name = " + name + ")", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Parcelable encountered ClassNotFoundException reading a Serializable object (name = " + name + ")", cnfe);
        }
    }

    protected static Parcel obtain(int obj) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Parcel obtain(long obj) {
        Parcel[] pool;
        Parcel[] parcelArray = pool = sHolderPool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                Parcel p = pool[i];
                if (p == null) continue;
                pool[i] = null;
                p.init(obj);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return p;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return new Parcel(obj);
        }
    }

    private Parcel(long nativePtr) {
        this.init(nativePtr);
    }

    private void init(long nativePtr) {
        if (nativePtr != 0L) {
            this.mNativePtr = nativePtr;
            this.mOwnsNativeParcelObject = false;
        } else {
            this.mNativePtr = Parcel.nativeCreate();
            this.mOwnsNativeParcelObject = true;
        }
    }

    private void freeBuffer() {
        if (this.mOwnsNativeParcelObject) {
            this.updateNativeSize(Parcel.nativeFreeBuffer(this.mNativePtr));
        }
        this.mReadWriteHelper = ReadWriteHelper.DEFAULT;
    }

    private void destroy() {
        if (this.mNativePtr != 0L) {
            if (this.mOwnsNativeParcelObject) {
                Parcel.nativeDestroy(this.mNativePtr);
                this.updateNativeSize(0L);
            }
            this.mNativePtr = 0L;
        }
        this.mReadWriteHelper = null;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    void readMapInternal(Map outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object key = this.readValue(loader);
            Object value = this.readValue(loader);
            outVal.put(key, value);
            --N;
        }
    }

    void readArrayMapInternal(ArrayMap outVal, int N, ClassLoader loader) {
        while (N > 0) {
            String key = this.readString();
            Object value = this.readValue(loader);
            outVal.append(key, value);
            --N;
        }
        outVal.validate();
    }

    void readArrayMapSafelyInternal(ArrayMap outVal, int N, ClassLoader loader) {
        while (N > 0) {
            String key = this.readString();
            Object value = this.readValue(loader);
            outVal.put(key, value);
            --N;
        }
    }

    public void readArrayMap(ArrayMap outVal, ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return;
        }
        this.readArrayMapInternal(outVal, N, loader);
    }

    public ArraySet<? extends Object> readArraySet(ClassLoader loader) {
        int size = this.readInt();
        if (size < 0) {
            return null;
        }
        ArraySet<Object> result = new ArraySet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object value = this.readValue(loader);
            result.append(value);
        }
        return result;
    }

    private void readListInternal(List outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object value = this.readValue(loader);
            outVal.add(value);
            --N;
        }
    }

    private void readArrayInternal(Object[] outVal, int N, ClassLoader loader) {
        for (int i = 0; i < N; ++i) {
            Object value;
            outVal[i] = value = this.readValue(loader);
        }
    }

    private void readSparseArrayInternal(SparseArray outVal, int N, ClassLoader loader) {
        while (N > 0) {
            int key = this.readInt();
            Object value = this.readValue(loader);
            outVal.append(key, value);
            --N;
        }
    }

    private void readSparseBooleanArrayInternal(SparseBooleanArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            boolean value = this.readByte() == 1;
            outVal.append(key, value);
            --N;
        }
    }

    private void readSparseIntArrayInternal(SparseIntArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            int value = this.readInt();
            outVal.append(key, value);
            --N;
        }
    }

    public long getBlobAshmemSize() {
        return Parcel.nativeGetBlobAshmemSize(this.mNativePtr);
    }

    static {
        sOwnedPool = new Parcel[6];
        sHolderPool = new Parcel[6];
        STRING_CREATOR = new Parcelable.Creator<String>(){

            @Override
            public String createFromParcel(Parcel source) {
                return source.readString();
            }

            public String[] newArray(int size) {
                return new String[size];
            }
        };
        mCreators = new HashMap();
    }

    public static class ReadWriteHelper {
        public static final ReadWriteHelper DEFAULT = new ReadWriteHelper();

        public void writeString(Parcel p, String s) {
            Parcel.nativeWriteString(p.mNativePtr, s);
        }

        public String readString(Parcel p) {
            return Parcel.nativeReadString(p.mNativePtr);
        }
    }
}

