/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;

public class Session {
    public static final String START_SESSION = "START_SESSION";
    public static final String START_EXTERNAL_SESSION = "START_EXTERNAL_SESSION";
    public static final String CREATE_SUBSESSION = "CREATE_SUBSESSION";
    public static final String CONTINUE_SUBSESSION = "CONTINUE_SUBSESSION";
    public static final String END_SUBSESSION = "END_SUBSESSION";
    public static final String END_SESSION = "END_SESSION";
    public static final String SUBSESSION_SEPARATION_CHAR = "->";
    public static final String SESSION_SEPARATION_CHAR_CHILD = "_";
    public static final String EXTERNAL_INDICATOR = "E-";
    public static final String TRUNCATE_STRING = "...";
    public static final int UNDEFINED = -1;
    private String mSessionId;
    private String mShortMethodName;
    private long mExecutionStartTimeMs;
    private long mExecutionEndTimeMs = -1L;
    private Session mParentSession;
    private ArrayList<Session> mChildSessions;
    private boolean mIsCompleted = false;
    private boolean mIsExternal = false;
    private int mChildCounter = 0;
    private boolean mIsStartedFromActiveSession = false;
    private String mOwnerInfo;
    private String mFullMethodPathCache;

    public Session(String sessionId, String shortMethodName, long startTimeMs, boolean isStartedFromActiveSession, String ownerInfo) {
        this.setSessionId(sessionId);
        this.setShortMethodName(shortMethodName);
        this.mExecutionStartTimeMs = startTimeMs;
        this.mParentSession = null;
        this.mChildSessions = new ArrayList(5);
        this.mIsStartedFromActiveSession = isStartedFromActiveSession;
        this.mOwnerInfo = ownerInfo;
    }

    public void setSessionId(String sessionId) {
        if (sessionId == null) {
            this.mSessionId = "?";
        }
        this.mSessionId = sessionId;
    }

    public String getShortMethodName() {
        return this.mShortMethodName;
    }

    public void setShortMethodName(String shortMethodName) {
        if (shortMethodName == null) {
            shortMethodName = "";
        }
        this.mShortMethodName = shortMethodName;
    }

    public void setIsExternal(boolean isExternal) {
        this.mIsExternal = isExternal;
    }

    public boolean isExternal() {
        return this.mIsExternal;
    }

    public void setParentSession(Session parentSession) {
        this.mParentSession = parentSession;
    }

    public void addChild(Session childSession) {
        if (childSession != null) {
            this.mChildSessions.add(childSession);
        }
    }

    public void removeChild(Session child) {
        if (child != null) {
            this.mChildSessions.remove(child);
        }
    }

    public long getExecutionStartTimeMilliseconds() {
        return this.mExecutionStartTimeMs;
    }

    public void setExecutionStartTimeMs(long startTimeMs) {
        this.mExecutionStartTimeMs = startTimeMs;
    }

    public Session getParentSession() {
        return this.mParentSession;
    }

    public ArrayList<Session> getChildSessions() {
        return this.mChildSessions;
    }

    public boolean isSessionCompleted() {
        return this.mIsCompleted;
    }

    public boolean isStartedFromActiveSession() {
        return this.mIsStartedFromActiveSession;
    }

    public Info getInfo() {
        return Info.getInfo(this);
    }

    @VisibleForTesting
    public String getSessionId() {
        return this.mSessionId;
    }

    public void markSessionCompleted(long executionEndTimeMs) {
        this.mExecutionEndTimeMs = executionEndTimeMs;
        this.mIsCompleted = true;
    }

    public long getLocalExecutionTime() {
        if (this.mExecutionEndTimeMs == -1L) {
            return -1L;
        }
        return this.mExecutionEndTimeMs - this.mExecutionStartTimeMs;
    }

    public synchronized String getNextChildId() {
        return String.valueOf(this.mChildCounter++);
    }

    private String getFullSessionId() {
        Session parentSession = this.mParentSession;
        if (parentSession == null) {
            return this.mSessionId;
        }
        if (Log.VERBOSE) {
            return parentSession.getFullSessionId() + SESSION_SEPARATION_CHAR_CHILD + this.mSessionId;
        }
        return parentSession.getFullSessionId();
    }

    public String printFullSessionTree() {
        Session topNode = this;
        while (topNode.getParentSession() != null) {
            topNode = topNode.getParentSession();
        }
        return topNode.printSessionTree();
    }

    public String printSessionTree() {
        StringBuilder sb = new StringBuilder();
        this.printSessionTree(0, sb);
        return sb.toString();
    }

    private void printSessionTree(int tabI, StringBuilder sb) {
        sb.append(this.toString());
        for (Session child : this.mChildSessions) {
            sb.append("\n");
            for (int i = 0; i <= tabI; ++i) {
                sb.append("\t");
            }
            child.printSessionTree(tabI + 1, sb);
        }
    }

    public String getFullMethodPath(boolean truncatePath) {
        StringBuilder sb = new StringBuilder();
        this.getFullMethodPath(sb, truncatePath);
        return sb.toString();
    }

    private synchronized void getFullMethodPath(StringBuilder sb, boolean truncatePath) {
        if (!TextUtils.isEmpty(this.mFullMethodPathCache) && !truncatePath) {
            sb.append(this.mFullMethodPathCache);
            return;
        }
        Session parentSession = this.getParentSession();
        boolean isSessionStarted = false;
        if (parentSession != null) {
            isSessionStarted = !this.mShortMethodName.equals(parentSession.mShortMethodName);
            parentSession.getFullMethodPath(sb, truncatePath);
            sb.append(SUBSESSION_SEPARATION_CHAR);
        }
        if (this.isExternal()) {
            if (truncatePath) {
                sb.append(TRUNCATE_STRING);
            } else {
                sb.append("(");
                sb.append(this.mShortMethodName);
                sb.append(")");
            }
        } else {
            sb.append(this.mShortMethodName);
        }
        if (isSessionStarted && !truncatePath) {
            this.mFullMethodPathCache = sb.toString();
        }
    }

    private boolean isSessionExternal() {
        if (this.getParentSession() == null) {
            return this.isExternal();
        }
        return this.getParentSession().isSessionExternal();
    }

    public int hashCode() {
        int result = this.mSessionId != null ? this.mSessionId.hashCode() : 0;
        result = 31 * result + (this.mShortMethodName != null ? this.mShortMethodName.hashCode() : 0);
        result = 31 * result + (int)(this.mExecutionStartTimeMs ^ this.mExecutionStartTimeMs >>> 32);
        result = 31 * result + (int)(this.mExecutionEndTimeMs ^ this.mExecutionEndTimeMs >>> 32);
        result = 31 * result + (this.mParentSession != null ? this.mParentSession.hashCode() : 0);
        result = 31 * result + (this.mChildSessions != null ? this.mChildSessions.hashCode() : 0);
        result = 31 * result + (this.mIsCompleted ? 1 : 0);
        result = 31 * result + this.mChildCounter;
        result = 31 * result + (this.mIsStartedFromActiveSession ? 1 : 0);
        result = 31 * result + (this.mOwnerInfo != null ? this.mOwnerInfo.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (this.mExecutionStartTimeMs != session.mExecutionStartTimeMs) {
            return false;
        }
        if (this.mExecutionEndTimeMs != session.mExecutionEndTimeMs) {
            return false;
        }
        if (this.mIsCompleted != session.mIsCompleted) {
            return false;
        }
        if (this.mChildCounter != session.mChildCounter) {
            return false;
        }
        if (this.mIsStartedFromActiveSession != session.mIsStartedFromActiveSession) {
            return false;
        }
        if (this.mSessionId != null ? !this.mSessionId.equals(session.mSessionId) : session.mSessionId != null) {
            return false;
        }
        if (this.mShortMethodName != null ? !this.mShortMethodName.equals(session.mShortMethodName) : session.mShortMethodName != null) {
            return false;
        }
        if (this.mParentSession != null ? !this.mParentSession.equals(session.mParentSession) : session.mParentSession != null) {
            return false;
        }
        if (this.mChildSessions != null ? !this.mChildSessions.equals(session.mChildSessions) : session.mChildSessions != null) {
            return false;
        }
        return this.mOwnerInfo != null ? this.mOwnerInfo.equals(session.mOwnerInfo) : session.mOwnerInfo == null;
    }

    public String toString() {
        if (this.mParentSession != null && this.mIsStartedFromActiveSession) {
            return this.mParentSession.toString();
        }
        StringBuilder methodName = new StringBuilder();
        methodName.append(this.getFullMethodPath(false));
        if (this.mOwnerInfo != null && !this.mOwnerInfo.isEmpty()) {
            methodName.append("(InCall package: ");
            methodName.append(this.mOwnerInfo);
            methodName.append(")");
        }
        return methodName.toString() + "@" + this.getFullSessionId();
    }

    public static class Info
    implements Parcelable {
        public final String sessionId;
        public final String methodPath;
        public static final Parcelable.Creator<Info> CREATOR = new Parcelable.Creator<Info>(){

            @Override
            public Info createFromParcel(Parcel source) {
                String id2 = source.readString();
                String methodName = source.readString();
                return new Info(id2, methodName);
            }

            public Info[] newArray(int size) {
                return new Info[size];
            }
        };

        private Info(String id2, String path) {
            this.sessionId = id2;
            this.methodPath = path;
        }

        public static Info getInfo(Session s) {
            return new Info(s.getFullSessionId(), s.getFullMethodPath(!Log.DEBUG && s.isSessionExternal()));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel destination, int flags) {
            destination.writeString(this.sessionId);
            destination.writeString(this.methodPath);
        }
    }
}

