/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.InputFilter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;

public abstract class LoginFilter
implements InputFilter {
    private boolean mAppendInvalid;

    LoginFilter(boolean appendInvalid) {
        this.mAppendInvalid = appendInvalid;
    }

    LoginFilter() {
        this.mAppendInvalid = false;
    }

    @Override
    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        char c;
        int i;
        this.onStart();
        for (int i2 = 0; i2 < dstart; ++i2) {
            char c2 = dest.charAt(i2);
            if (this.isAllowed(c2)) continue;
            this.onInvalidCharacter(c2);
        }
        SpannableStringBuilder modification = null;
        int modoff = 0;
        for (i = start; i < end; ++i) {
            c = source.charAt(i);
            if (this.isAllowed(c)) {
                ++modoff;
                continue;
            }
            if (this.mAppendInvalid) {
                ++modoff;
            } else {
                if (modification == null) {
                    modification = new SpannableStringBuilder(source, start, end);
                    modoff = i - start;
                }
                modification.delete(modoff, modoff + 1);
            }
            this.onInvalidCharacter(c);
        }
        for (i = dend; i < dest.length(); ++i) {
            c = dest.charAt(i);
            if (this.isAllowed(c)) continue;
            this.onInvalidCharacter(c);
        }
        this.onStop();
        return modification;
    }

    public void onStart() {
    }

    public void onInvalidCharacter(char c) {
    }

    public void onStop() {
    }

    public abstract boolean isAllowed(char var1);

    public static class PasswordFilterGMail
    extends LoginFilter {
        public PasswordFilterGMail() {
            super(false);
        }

        public PasswordFilterGMail(boolean appendInvalid) {
            super(appendInvalid);
        }

        @Override
        public boolean isAllowed(char c) {
            if (' ' <= c && c <= '\u007f') {
                return true;
            }
            return '\u00a0' <= c && c <= '\u00ff';
        }
    }

    public static class UsernameFilterGeneric
    extends LoginFilter {
        private static final String mAllowed = "@_-+.";

        public UsernameFilterGeneric() {
            super(false);
        }

        public UsernameFilterGeneric(boolean appendInvalid) {
            super(appendInvalid);
        }

        @Override
        public boolean isAllowed(char c) {
            if ('0' <= c && c <= '9') {
                return true;
            }
            if ('a' <= c && c <= 'z') {
                return true;
            }
            if ('A' <= c && c <= 'Z') {
                return true;
            }
            return mAllowed.indexOf(c) != -1;
        }
    }

    public static class UsernameFilterGMail
    extends LoginFilter {
        public UsernameFilterGMail() {
            super(false);
        }

        public UsernameFilterGMail(boolean appendInvalid) {
            super(appendInvalid);
        }

        @Override
        public boolean isAllowed(char c) {
            if ('0' <= c && c <= '9') {
                return true;
            }
            if ('a' <= c && c <= 'z') {
                return true;
            }
            if ('A' <= c && c <= 'Z') {
                return true;
            }
            return '.' == c;
        }
    }
}

