/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.PrecomputedText;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;

public class RecordingCanvas
extends Canvas {
    public RecordingCanvas(long nativeCanvas) {
        super(nativeCanvas);
    }

    @Override
    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        RecordingCanvas.nDrawArc(this.mNativeCanvasWrapper, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.getNativeInstance());
    }

    @Override
    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.drawArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor(Color.argb(a, r, g, b));
    }

    @Override
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.throwIfCannotDraw(bitmap);
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, paint != null ? paint.getNativeInstance() : 0L, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        RecordingCanvas.nDrawBitmapMatrix(this.mNativeCanvasWrapper, bitmap, matrix.ni(), paint != null ? paint.getNativeInstance() : 0L);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.getNativeInstance() : 0L);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    @Override
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        RecordingCanvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            RecordingCanvas.checkRange(colors.length, colorOffset, count);
        }
        RecordingCanvas.nDrawBitmapMesh(this.mNativeCanvasWrapper, bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.getNativeInstance() : 0L);
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        RecordingCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx, cy, radius, paint.getNativeInstance());
    }

    @Override
    public void drawColor(int color2) {
        RecordingCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @Override
    public void drawColor(int color2, PorterDuff.Mode mode) {
        RecordingCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, mode.nativeInt);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        RecordingCanvas.nDrawLine(this.mNativeCanvasWrapper, startX, startY, stopX, stopY, paint.getNativeInstance());
    }

    @Override
    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        RecordingCanvas.nDrawLines(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    @Override
    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    @Override
    public void drawOval(float left, float top, float right, float bottom, Paint paint) {
        RecordingCanvas.nDrawOval(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    @Override
    public void drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        this.drawOval(oval.left, oval.top, oval.right, oval.bottom, paint);
    }

    @Override
    public void drawPaint(Paint paint) {
        RecordingCanvas.nDrawPaint(this.mNativeCanvasWrapper, paint.getNativeInstance());
    }

    @Override
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        RecordingCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    @Override
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        RecordingCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        if (path.isSimplePath && path.rects != null) {
            RecordingCanvas.nDrawRegion(this.mNativeCanvasWrapper, path.rects.mNativeRegion, paint.getNativeInstance());
        } else {
            RecordingCanvas.nDrawPath(this.mNativeCanvasWrapper, path.readOnlyNI(), paint.getNativeInstance());
        }
    }

    @Override
    public void drawPicture(Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    @Override
    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    @Override
    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    @Override
    public void drawPoint(float x, float y, Paint paint) {
        RecordingCanvas.nDrawPoint(this.mNativeCanvasWrapper, x, y, paint.getNativeInstance());
    }

    @Override
    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        RecordingCanvas.nDrawPoints(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    @Override
    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < count; ++i) {
            this.drawText(text, index + i, 1, pos[i * 2], pos[i * 2 + 1], paint);
        }
    }

    @Override
    @Deprecated
    public void drawPosText(String text, float[] pos, Paint paint) {
        this.drawPosText(text.toCharArray(), 0, text.length(), pos, paint);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        RecordingCanvas.nDrawRect(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    @Override
    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRect(RectF rect, Paint paint) {
        RecordingCanvas.nDrawRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, paint.getNativeInstance());
    }

    @Override
    public void drawRGB(int r, int g, int b) {
        this.drawColor(Color.rgb(r, g, b));
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        RecordingCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left, top, right, bottom, rx, ry, paint.getNativeInstance());
    }

    @Override
    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint);
    }

    @Override
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text, index, count, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text.toString(), start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, buf, 0, end - start, x, y, paint.mBidiFlags, paint.getNativeInstance());
            TemporaryBuffer.recycle(buf);
        }
    }

    @Override
    public void drawText(String text, float x, float y, Paint paint) {
        RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text, 0, text.length(), x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text, start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, index, count, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            RecordingCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
        }
    }

    @Override
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((index | count | contextIndex | contextCount | index - contextIndex | contextIndex + contextCount - (index + count) | text.length - (contextIndex + contextCount)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.getNativeInstance(), 0L);
    }

    @Override
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((start | end | contextStart | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            RecordingCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int paraIndex;
            PrecomputedText mt;
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            long measuredTextPtr = 0L;
            if (text instanceof PrecomputedText && end <= (mt = (PrecomputedText)text).getParagraphEnd(paraIndex = mt.findParaIndex(start))) {
                measuredTextPtr = mt.getMeasuredParagraph(paraIndex).getNativePtr();
            }
            RecordingCanvas.nDrawTextRun(this.mNativeCanvasWrapper, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.getNativeInstance(), measuredTextPtr);
            TemporaryBuffer.recycle(buf);
        }
    }

    @Override
    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        RecordingCanvas.checkRange(verts.length, vertOffset, vertexCount);
        if (this.isHardwareAccelerated()) {
            return;
        }
        if (texs != null) {
            RecordingCanvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            RecordingCanvas.checkRange(colors.length, colorOffset, vertexCount / 2);
        }
        if (indices != null) {
            RecordingCanvas.checkRange(indices.length, indexOffset, indexCount);
        }
        RecordingCanvas.nDrawVertices(this.mNativeCanvasWrapper, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.getNativeInstance());
    }

    @FastNative
    private static void nDrawBitmap(long l, Bitmap bitmap, float f, float f2, long l2, int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawBitmap(JLandroid/graphics/Bitmap;FFJIII)V", true, null);
    }

    @FastNative
    private static void nDrawBitmap(long l, Bitmap bitmap, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawBitmap(JLandroid/graphics/Bitmap;FFFFFFFFJII)V", true, null);
    }

    @FastNative
    private static void nDrawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawBitmap(J[IIIFFIIZJ)V", true, null);
    }

    @FastNative
    private static void nDrawColor(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawColor(JII)V", true, null);
    }

    @FastNative
    private static void nDrawPaint(long l, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawPaint(JJ)V", true, null);
    }

    @FastNative
    private static void nDrawPoint(long l, float f, float f2, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawPoint(JFFJ)V", true, null);
    }

    @FastNative
    private static void nDrawPoints(long l, float[] fArray, int n, int n2, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawPoints(J[FIIJ)V", true, null);
    }

    @FastNative
    private static void nDrawLine(long l, float f, float f2, float f3, float f4, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawLine(JFFFFJ)V", true, null);
    }

    @FastNative
    private static void nDrawLines(long l, float[] fArray, int n, int n2, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawLines(J[FIIJ)V", true, null);
    }

    @FastNative
    private static void nDrawRect(long l, float f, float f2, float f3, float f4, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawRect(JFFFFJ)V", true, null);
    }

    @FastNative
    private static void nDrawOval(long l, float f, float f2, float f3, float f4, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawOval(JFFFFJ)V", true, null);
    }

    @FastNative
    private static void nDrawCircle(long l, float f, float f2, float f3, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawCircle(JFFFJ)V", true, null);
    }

    @FastNative
    private static void nDrawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawArc(JFFFFFFZJ)V", true, null);
    }

    @FastNative
    private static void nDrawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawRoundRect(JFFFFFFJ)V", true, null);
    }

    @FastNative
    private static void nDrawPath(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawPath(JJJ)V", true, null);
    }

    @FastNative
    private static void nDrawRegion(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawRegion(JJJ)V", true, null);
    }

    @FastNative
    private static void nDrawNinePatch(long l, long l2, long l3, float f, float f2, float f3, float f4, long l4, int n, int n2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawNinePatch(JJJFFFFJII)V", true, null);
    }

    @FastNative
    private static void nDrawBitmapMatrix(long l, Bitmap bitmap, long l2, long l3) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawBitmapMatrix(JLandroid/graphics/Bitmap;JJ)V", true, null);
    }

    @FastNative
    private static void nDrawBitmapMesh(long l, Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawBitmapMesh(JLandroid/graphics/Bitmap;II[FI[IIJ)V", true, null);
    }

    @FastNative
    private static void nDrawVertices(long l, int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int[] nArray, int n5, short[] sArray, int n6, int n7, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawVertices(JII[FI[FI[II[SIIJ)V", true, null);
    }

    @FastNative
    private static void nDrawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawText(J[CIIFFIJ)V", true, null);
    }

    @FastNative
    private static void nDrawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawText(JLjava/lang/String;IIFFIJ)V", true, null);
    }

    @FastNative
    private static void nDrawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawTextRun(JLjava/lang/String;IIIIFFZJ)V", true, null);
    }

    @FastNative
    private static void nDrawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawTextRun(J[CIIIIFFZJJ)V", true, null);
    }

    @FastNative
    private static void nDrawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawTextOnPath(J[CIIJFFIJ)V", true, null);
    }

    @FastNative
    private static void nDrawTextOnPath(long l, String string2, long l2, float f, float f2, int n, long l3) {
        OverrideMethod.invokeV("android.view.RecordingCanvas#nDrawTextOnPath(JLjava/lang/String;JFFIJ)V", true, null);
    }
}

