/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import libcore.util.NativeAllocationRegistry;

public class SurfaceControl
implements Parcelable {
    private static final String TAG = "SurfaceControl";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final String mName;
    long mNativeObject;
    private final Object mSizeLock = new Object();
    @GuardedBy(value="mSizeLock")
    private int mWidth;
    @GuardedBy(value="mSizeLock")
    private int mHeight;
    static Transaction sGlobalTransaction;
    static long sTransactionNestCount;
    public static final int HIDDEN = 4;
    public static final int SECURE = 128;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int CURSOR_WINDOW = 8192;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_MASK = 983040;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    public static final int BUILT_IN_DISPLAY_ID_MAIN = 0;
    public static final int BUILT_IN_DISPLAY_ID_HDMI = 1;
    public static final int POWER_MODE_OFF = 0;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;
    public static final int POWER_MODE_ON_SUSPEND = 4;
    public static final int WINDOW_TYPE_DONT_SCREENSHOT = 441731;
    public static final Parcelable.Creator<SurfaceControl> CREATOR;

    private static long nativeCreate(SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4, long l, int n5, int n6) throws Surface.OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreate(Landroid/view/SurfaceSession;Ljava/lang/String;IIIIJII)J", true, null);
    }

    private static long nativeReadFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeReadFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeWriteToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static void nativeRelease(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeRelease(J)V", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroy(J)V", true, null);
    }

    private static void nativeDisconnect(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDisconnect(J)V", true, null);
    }

    private static Bitmap nativeScreenshot(IBinder iBinder, Rect rect, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5) {
        return (Bitmap)OverrideMethod.invokeA("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;Landroid/graphics/Rect;IIIIZZI)Landroid/graphics/Bitmap;", true, null);
    }

    private static GraphicBuffer nativeScreenshotToBuffer(IBinder iBinder, Rect rect, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, boolean bl3) {
        return (GraphicBuffer)OverrideMethod.invokeA("android.view.SurfaceControl#nativeScreenshotToBuffer(Landroid/os/IBinder;Landroid/graphics/Rect;IIIIZZIZ)Landroid/graphics/GraphicBuffer;", true, null);
    }

    private static void nativeScreenshot(IBinder iBinder, Surface surface, Rect rect, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;Landroid/view/Surface;Landroid/graphics/Rect;IIIIZZ)V", true, null);
    }

    private static GraphicBuffer nativeCaptureLayers(IBinder iBinder, Rect rect, float f) {
        return (GraphicBuffer)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCaptureLayers(Landroid/os/IBinder;Landroid/graphics/Rect;F)Landroid/graphics/GraphicBuffer;", true, null);
    }

    private static long nativeCreateTransaction() {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreateTransaction()J", true, null);
    }

    private static long nativeGetNativeTransactionFinalizer() {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeGetNativeTransactionFinalizer()J", true, null);
    }

    private static void nativeApplyTransaction(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeApplyTransaction(JZ)V", true, null);
    }

    private static void nativeMergeTransaction(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeMergeTransaction(JJ)V", true, null);
    }

    private static void nativeSetAnimationTransaction(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAnimationTransaction(J)V", true, null);
    }

    private static void nativeSetEarlyWakeup(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEarlyWakeup(J)V", true, null);
    }

    private static void nativeSetLayer(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayer(JJI)V", true, null);
    }

    private static void nativeSetRelativeLayer(long l, long l2, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetRelativeLayer(JJLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetPosition(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetPosition(JJFF)V", true, null);
    }

    private static void nativeSetGeometryAppliesWithResize(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGeometryAppliesWithResize(JJ)V", true, null);
    }

    private static void nativeSetSize(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetSize(JJII)V", true, null);
    }

    private static void nativeSetTransparentRegionHint(long l, long l2, Region region) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTransparentRegionHint(JJLandroid/graphics/Region;)V", true, null);
    }

    private static void nativeSetAlpha(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAlpha(JJF)V", true, null);
    }

    private static void nativeSetMatrix(long l, long l2, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMatrix(JJFFFF)V", true, null);
    }

    private static void nativeSetColor(long l, long l2, float[] fArray) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColor(JJ[F)V", true, null);
    }

    private static void nativeSetFlags(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFlags(JJII)V", true, null);
    }

    private static void nativeSetWindowCrop(long l, long l2, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetWindowCrop(JJIIII)V", true, null);
    }

    private static void nativeSetFinalCrop(long l, long l2, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFinalCrop(JJIIII)V", true, null);
    }

    private static void nativeSetLayerStack(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayerStack(JJI)V", true, null);
    }

    private static boolean nativeClearContentFrameStats(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearContentFrameStats(J)Z", true, null) != 0;
    }

    private static boolean nativeGetContentFrameStats(long l, WindowContentFrameStats windowContentFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetContentFrameStats(JLandroid/view/WindowContentFrameStats;)Z", true, null) != 0;
    }

    private static boolean nativeClearAnimationFrameStats() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearAnimationFrameStats()Z", true, null) != 0;
    }

    private static boolean nativeGetAnimationFrameStats(WindowAnimationFrameStats windowAnimationFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetAnimationFrameStats(Landroid/view/WindowAnimationFrameStats;)Z", true, null) != 0;
    }

    private static IBinder nativeGetBuiltInDisplay(int n) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetBuiltInDisplay(I)Landroid/os/IBinder;", true, null);
    }

    private static IBinder nativeCreateDisplay(String string2, boolean bl) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCreateDisplay(Ljava/lang/String;Z)Landroid/os/IBinder;", true, null);
    }

    private static void nativeDestroyDisplay(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroyDisplay(Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeSetDisplaySurface(long l, IBinder iBinder, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySurface(JLandroid/os/IBinder;J)V", true, null);
    }

    private static void nativeSetDisplayLayerStack(long l, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayLayerStack(JLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetDisplayProjection(long l, IBinder iBinder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayProjection(JLandroid/os/IBinder;IIIIIIIII)V", true, null);
    }

    private static void nativeSetDisplaySize(long l, IBinder iBinder, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySize(JLandroid/os/IBinder;II)V", true, null);
    }

    private static PhysicalDisplayInfo[] nativeGetDisplayConfigs(IBinder iBinder) {
        return (PhysicalDisplayInfo[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayConfigs(Landroid/os/IBinder;)[Landroid/view/SurfaceControl$PhysicalDisplayInfo;", true, null);
    }

    private static int nativeGetActiveConfig(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveConfig(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetActiveConfig(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveConfig(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static int[] nativeGetDisplayColorModes(IBinder iBinder) {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayColorModes(Landroid/os/IBinder;)[I", true, null);
    }

    private static int nativeGetActiveColorMode(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveColorMode(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetActiveColorMode(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveColorMode(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static void nativeSetDisplayPowerMode(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayPowerMode(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeDeferTransactionUntil(long l, long l2, IBinder iBinder, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntil(JJLandroid/os/IBinder;J)V", true, null);
    }

    private static void nativeDeferTransactionUntilSurface(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntilSurface(JJJJ)V", true, null);
    }

    private static void nativeReparentChildren(long l, long l2, IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparentChildren(JJLandroid/os/IBinder;)V", true, null);
    }

    private static void nativeReparent(long l, long l2, IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparent(JJLandroid/os/IBinder;)V", true, null);
    }

    private static void nativeSeverChildren(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSeverChildren(JJ)V", true, null);
    }

    private static void nativeSetOverrideScalingMode(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetOverrideScalingMode(JJI)V", true, null);
    }

    private static void nativeDestroy(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroy(JJ)V", true, null);
    }

    private static IBinder nativeGetHandle(long l) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetHandle(J)Landroid/os/IBinder;", true, null);
    }

    private static boolean nativeGetTransformToDisplayInverse(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetTransformToDisplayInverse(J)Z", true, null) != 0;
    }

    private static Display.HdrCapabilities nativeGetHdrCapabilities(IBinder iBinder) {
        return (Display.HdrCapabilities)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetHdrCapabilities(Landroid/os/IBinder;)Landroid/view/Display$HdrCapabilities;", true, null);
    }

    private SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags, SurfaceControl parent, int windowType, int ownerUid) throws Surface.OutOfResourcesException, IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ((flags & 4) == 0) {
            Log.w(TAG, "Surfaces should always be created with the HIDDEN flag set to ensure that they are not made visible prematurely before all of the surface's properties have been configured.  Set the other properties and make the surface visible within a transaction.  New surface name: " + name, new Throwable());
        }
        this.mName = name;
        this.mWidth = w;
        this.mHeight = h;
        this.mNativeObject = SurfaceControl.nativeCreate(session, name, w, h, format, flags, parent != null ? parent.mNativeObject : 0L, windowType, ownerUid);
        if (this.mNativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.mCloseGuard.open("release");
    }

    public SurfaceControl(SurfaceControl other) {
        this.mName = other.mName;
        this.mWidth = other.mWidth;
        this.mHeight = other.mHeight;
        this.mNativeObject = other.mNativeObject;
        other.mCloseGuard.close();
        other.mNativeObject = 0L;
        this.mCloseGuard.open("release");
    }

    private SurfaceControl(Parcel in) {
        this.mName = in.readString();
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
        this.mNativeObject = SurfaceControl.nativeReadFromParcel(in);
        if (this.mNativeObject == 0L) {
            throw new IllegalArgumentException("Couldn't read SurfaceControl from parcel=" + in);
        }
        this.mCloseGuard.open("release");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        SurfaceControl.nativeWriteToParcel(this.mNativeObject, dest);
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1138166333442L, this.mName);
        proto.end(token);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeRelease(this.mNativeObject);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void destroy() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDestroy(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void disconnect() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDisconnect(this.mNativeObject);
        }
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("mNativeObject is null. Have you called release() already?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sGlobalTransaction == null) {
                sGlobalTransaction = new Transaction();
            }
            Class<SurfaceControl> clazz2 = SurfaceControl.class;
            synchronized (SurfaceControl.class) {
                ++sTransactionNestCount;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeTransaction(boolean sync) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sTransactionNestCount == 0L) {
                Log.e(TAG, "Call to SurfaceControl.closeTransaction without matching openTransaction");
            } else if (--sTransactionNestCount > 0L) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            sGlobalTransaction.apply(sync);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void mergeToGlobalTransaction(Transaction t) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.merge(t);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void closeTransaction() {
        SurfaceControl.closeTransaction(false);
    }

    public static void closeTransactionSync() {
        SurfaceControl.closeTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferTransactionUntil(IBinder handle, long frame) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.deferTransactionUntil(this, handle, frame);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferTransactionUntil(Surface barrier, long frame) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.deferTransactionUntilSurface(this, barrier, frame);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparentChildren(IBinder newParentHandle) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.reparentChildren(this, newParentHandle);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(IBinder newParentHandle) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.reparent(this, newParentHandle);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachChildren() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.detachChildren(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverrideScalingMode(int scalingMode) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setOverrideScalingMode(this, scalingMode);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public IBinder getHandle() {
        return SurfaceControl.nativeGetHandle(this.mNativeObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAnimationTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setAnimationTransaction();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayer(int zorder) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setLayer(this, zorder);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelativeLayer(SurfaceControl relativeTo, int zorder) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setRelativeLayer(this, relativeTo, zorder);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(float x, float y) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setPosition(this, x, y);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeometryAppliesWithResize() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setGeometryAppliesWithResize(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int w, int h) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setSize(this, w, h);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.hide(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.show(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransparentRegionHint(Region region) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setTransparentRegionHint(this, region);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public boolean getContentFrameStats(WindowContentFrameStats outStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, outStats);
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static boolean getAnimationFrameStats(WindowAnimationFrameStats outStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(outStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlpha(float alpha) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setAlpha(this, alpha);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(float[] color2) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setColor(this, color2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(float dsdx, float dtdx, float dtdy, float dsdy) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setMatrix(this, dsdx, dtdx, dtdy, dsdy);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(Matrix matrix, float[] float9) {
        this.checkNotReleased();
        matrix.getValues(float9);
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setMatrix(this, float9[0], float9[3], float9[1], float9[4]);
            sGlobalTransaction.setPosition(this, float9[2], float9[5]);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowCrop(Rect crop) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setWindowCrop(this, crop);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinalCrop(Rect crop) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setFinalCrop(this, crop);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayerStack(int layerStack) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setLayerStack(this, layerStack);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpaque(boolean isOpaque) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setOpaque(this, isOpaque);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecure(boolean isSecure) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setSecure(this, isSecure);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mSizeLock;
        synchronized (object) {
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mSizeLock;
        synchronized (object) {
            return this.mHeight;
        }
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public static void setDisplayPowerMode(IBinder displayToken, int mode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(displayToken, mode);
    }

    public static PhysicalDisplayInfo[] getDisplayConfigs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayConfigs(displayToken);
    }

    public static int getActiveConfig(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveConfig(displayToken);
    }

    public static boolean setActiveConfig(IBinder displayToken, int id2) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveConfig(displayToken, id2);
    }

    public static int[] getDisplayColorModes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayColorModes(displayToken);
    }

    public static int getActiveColorMode(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveColorMode(displayToken);
    }

    public static boolean setActiveColorMode(IBinder displayToken, int colorMode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveColorMode(displayToken, colorMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayProjection(displayToken, orientation, layerStackRect, displayRect);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplayLayerStack(IBinder displayToken, int layerStack) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayLayerStack(displayToken, layerStack);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySurface(IBinder displayToken, Surface surface) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySurface(displayToken, surface);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySize(IBinder displayToken, int width, int height) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySize(displayToken, width, height);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static Display.HdrCapabilities getHdrCapabilities(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetHdrCapabilities(displayToken);
    }

    public static IBinder createDisplay(String name, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(name, secure);
    }

    public static void destroyDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(displayToken);
    }

    public static IBinder getBuiltInDisplay(int builtInDisplayId) {
        return SurfaceControl.nativeGetBuiltInDisplay(builtInDisplayId);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform) {
        SurfaceControl.screenshot(display, consumer, new Rect(), width, height, minLayer, maxLayer, false, useIdentityTransform);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height) {
        SurfaceControl.screenshot(display, consumer, new Rect(), width, height, 0, 0, true, false);
    }

    public static void screenshot(IBinder display, Surface consumer) {
        SurfaceControl.screenshot(display, consumer, new Rect(), 0, 0, 0, 0, true, false);
    }

    public static Bitmap screenshot(Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshot(displayToken, sourceCrop, width, height, minLayer, maxLayer, false, useIdentityTransform, rotation);
    }

    public static GraphicBuffer screenshotToBuffer(Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshotToBuffer(displayToken, sourceCrop, width, height, minLayer, maxLayer, false, useIdentityTransform, rotation, false);
    }

    public static GraphicBuffer screenshotToBufferWithSecureLayersUnsafe(Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshotToBuffer(displayToken, sourceCrop, width, height, minLayer, maxLayer, false, useIdentityTransform, rotation, true);
    }

    public static Bitmap screenshot(Rect sourceCrop, int width, int height, int rotation) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        if (rotation == 1 || rotation == 3) {
            rotation = rotation == 1 ? 3 : 1;
        }
        SurfaceControl.rotateCropForSF(sourceCrop, rotation);
        return SurfaceControl.nativeScreenshot(displayToken, sourceCrop, width, height, 0, 0, true, false, rotation);
    }

    private static void screenshot(IBinder display, Surface consumer, Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean allLayers, boolean useIdentityTransform) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        SurfaceControl.nativeScreenshot(display, consumer, sourceCrop, width, height, minLayer, maxLayer, allLayers, useIdentityTransform);
    }

    private static void rotateCropForSF(Rect crop, int rot) {
        if (rot == 1 || rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = tmp;
            tmp = crop.right;
            crop.right = crop.bottom;
            crop.bottom = tmp;
        }
    }

    public static GraphicBuffer captureLayers(IBinder layerHandleToken, Rect sourceCrop, float frameScale) {
        return SurfaceControl.nativeCaptureLayers(layerHandleToken, sourceCrop, frameScale);
    }

    static /* synthetic */ long access$200() {
        return SurfaceControl.nativeGetNativeTransactionFinalizer();
    }

    static {
        sTransactionNestCount = 0L;
        CREATOR = new Parcelable.Creator<SurfaceControl>(){

            @Override
            public SurfaceControl createFromParcel(Parcel in) {
                return new SurfaceControl(in);
            }

            public SurfaceControl[] newArray(int size) {
                return new SurfaceControl[size];
            }
        };
    }

    public static class Transaction
    implements Closeable {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Transaction.class.getClassLoader(), SurfaceControl.access$200(), 512L);
        private long mNativeObject;
        private final ArrayMap<SurfaceControl, Point> mResizedSurfaces = new ArrayMap();
        Runnable mFreeNativeResources;

        public Transaction() {
            this.mNativeObject = SurfaceControl.nativeCreateTransaction();
            this.mFreeNativeResources = sRegistry.registerNativeAllocation((Object)this, this.mNativeObject);
        }

        public void apply() {
            this.apply(false);
        }

        @Override
        public void close() {
            this.mFreeNativeResources.run();
            this.mNativeObject = 0L;
        }

        public void apply(boolean sync) {
            this.applyResizedSurfaces();
            SurfaceControl.nativeApplyTransaction(this.mNativeObject, sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyResizedSurfaces() {
            for (int i = this.mResizedSurfaces.size() - 1; i >= 0; --i) {
                Point size = this.mResizedSurfaces.valueAt(i);
                SurfaceControl surfaceControl = this.mResizedSurfaces.keyAt(i);
                Object object = surfaceControl.mSizeLock;
                synchronized (object) {
                    surfaceControl.mWidth = size.x;
                    surfaceControl.mHeight = size.y;
                    continue;
                }
            }
            this.mResizedSurfaces.clear();
        }

        public Transaction show(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 1);
            return this;
        }

        public Transaction hide(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 1, 1);
            return this;
        }

        public Transaction setPosition(SurfaceControl sc, float x, float y) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetPosition(this.mNativeObject, sc.mNativeObject, x, y);
            return this;
        }

        public Transaction setSize(SurfaceControl sc, int w, int h) {
            sc.checkNotReleased();
            this.mResizedSurfaces.put(sc, new Point(w, h));
            SurfaceControl.nativeSetSize(this.mNativeObject, sc.mNativeObject, w, h);
            return this;
        }

        public Transaction setLayer(SurfaceControl sc, int z) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetLayer(this.mNativeObject, sc.mNativeObject, z);
            return this;
        }

        public Transaction setRelativeLayer(SurfaceControl sc, SurfaceControl relativeTo, int z) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetRelativeLayer(this.mNativeObject, sc.mNativeObject, relativeTo.getHandle(), z);
            return this;
        }

        public Transaction setTransparentRegionHint(SurfaceControl sc, Region transparentRegion) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, sc.mNativeObject, transparentRegion);
            return this;
        }

        public Transaction setAlpha(SurfaceControl sc, float alpha) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetAlpha(this.mNativeObject, sc.mNativeObject, alpha);
            return this;
        }

        public Transaction setMatrix(SurfaceControl sc, float dsdx, float dtdx, float dtdy, float dsdy) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetMatrix(this.mNativeObject, sc.mNativeObject, dsdx, dtdx, dtdy, dsdy);
            return this;
        }

        public Transaction setMatrix(SurfaceControl sc, Matrix matrix, float[] float9) {
            matrix.getValues(float9);
            this.setMatrix(sc, float9[0], float9[3], float9[1], float9[4]);
            this.setPosition(sc, float9[2], float9[5]);
            return this;
        }

        public Transaction setWindowCrop(SurfaceControl sc, Rect crop) {
            sc.checkNotReleased();
            if (crop != null) {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
            } else {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, 0, 0);
            }
            return this;
        }

        public Transaction setFinalCrop(SurfaceControl sc, Rect crop) {
            sc.checkNotReleased();
            if (crop != null) {
                SurfaceControl.nativeSetFinalCrop(this.mNativeObject, sc.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
            } else {
                SurfaceControl.nativeSetFinalCrop(this.mNativeObject, sc.mNativeObject, 0, 0, 0, 0);
            }
            return this;
        }

        public Transaction setLayerStack(SurfaceControl sc, int layerStack) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetLayerStack(this.mNativeObject, sc.mNativeObject, layerStack);
            return this;
        }

        public Transaction deferTransactionUntil(SurfaceControl sc, IBinder handle, long frameNumber) {
            if (frameNumber < 0L) {
                return this;
            }
            sc.checkNotReleased();
            SurfaceControl.nativeDeferTransactionUntil(this.mNativeObject, sc.mNativeObject, handle, frameNumber);
            return this;
        }

        public Transaction deferTransactionUntilSurface(SurfaceControl sc, Surface barrierSurface, long frameNumber) {
            if (frameNumber < 0L) {
                return this;
            }
            sc.checkNotReleased();
            SurfaceControl.nativeDeferTransactionUntilSurface(this.mNativeObject, sc.mNativeObject, barrierSurface.mNativeObject, frameNumber);
            return this;
        }

        public Transaction reparentChildren(SurfaceControl sc, IBinder newParentHandle) {
            sc.checkNotReleased();
            SurfaceControl.nativeReparentChildren(this.mNativeObject, sc.mNativeObject, newParentHandle);
            return this;
        }

        public Transaction reparent(SurfaceControl sc, IBinder newParentHandle) {
            sc.checkNotReleased();
            SurfaceControl.nativeReparent(this.mNativeObject, sc.mNativeObject, newParentHandle);
            return this;
        }

        public Transaction detachChildren(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSeverChildren(this.mNativeObject, sc.mNativeObject);
            return this;
        }

        public Transaction setOverrideScalingMode(SurfaceControl sc, int overrideScalingMode) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetOverrideScalingMode(this.mNativeObject, sc.mNativeObject, overrideScalingMode);
            return this;
        }

        public Transaction setColor(SurfaceControl sc, float[] color2) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, color2);
            return this;
        }

        public Transaction setGeometryAppliesWithResize(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetGeometryAppliesWithResize(this.mNativeObject, sc.mNativeObject);
            return this;
        }

        public Transaction setSecure(SurfaceControl sc, boolean isSecure) {
            sc.checkNotReleased();
            if (isSecure) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 128, 128);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 128);
            }
            return this;
        }

        public Transaction setOpaque(SurfaceControl sc, boolean isOpaque) {
            sc.checkNotReleased();
            if (isOpaque) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 2, 2);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 2);
            }
            return this;
        }

        public Transaction destroy(SurfaceControl sc) {
            sc.checkNotReleased();
            sc.mCloseGuard.close();
            SurfaceControl.nativeDestroy(this.mNativeObject, sc.mNativeObject);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setDisplaySurface(IBinder displayToken, Surface surface) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (surface != null) {
                Object object = surface.mLock;
                synchronized (object) {
                    SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, surface.mNativeObject);
                }
            } else {
                SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, 0L);
            }
            return this;
        }

        public Transaction setDisplayLayerStack(IBinder displayToken, int layerStack) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            SurfaceControl.nativeSetDisplayLayerStack(this.mNativeObject, displayToken, layerStack);
            return this;
        }

        public Transaction setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (layerStackRect == null) {
                throw new IllegalArgumentException("layerStackRect must not be null");
            }
            if (displayRect == null) {
                throw new IllegalArgumentException("displayRect must not be null");
            }
            SurfaceControl.nativeSetDisplayProjection(this.mNativeObject, displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
            return this;
        }

        public Transaction setDisplaySize(IBinder displayToken, int width, int height) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            SurfaceControl.nativeSetDisplaySize(this.mNativeObject, displayToken, width, height);
            return this;
        }

        public Transaction setAnimationTransaction() {
            SurfaceControl.nativeSetAnimationTransaction(this.mNativeObject);
            return this;
        }

        public Transaction setEarlyWakeup() {
            SurfaceControl.nativeSetEarlyWakeup(this.mNativeObject);
            return this;
        }

        public Transaction merge(Transaction other) {
            this.mResizedSurfaces.putAll(other.mResizedSurfaces);
            other.mResizedSurfaces.clear();
            SurfaceControl.nativeMergeTransaction(this.mNativeObject, other.mNativeObject);
            return this;
        }
    }

    public static class PhysicalDisplayInfo {
        public int width;
        public int height;
        public float refreshRate;
        public float density;
        public float xDpi;
        public float yDpi;
        public boolean secure;
        public long appVsyncOffsetNanos;
        public long presentationDeadlineNanos;

        public PhysicalDisplayInfo() {
        }

        public PhysicalDisplayInfo(PhysicalDisplayInfo other) {
            this.copyFrom(other);
        }

        public boolean equals(Object o) {
            return o instanceof PhysicalDisplayInfo && this.equals((PhysicalDisplayInfo)o);
        }

        public boolean equals(PhysicalDisplayInfo other) {
            return other != null && this.width == other.width && this.height == other.height && this.refreshRate == other.refreshRate && this.density == other.density && this.xDpi == other.xDpi && this.yDpi == other.yDpi && this.secure == other.secure && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos;
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(PhysicalDisplayInfo other) {
            this.width = other.width;
            this.height = other.height;
            this.refreshRate = other.refreshRate;
            this.density = other.density;
            this.xDpi = other.xDpi;
            this.yDpi = other.yDpi;
            this.secure = other.secure;
            this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
            this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        }

        public String toString() {
            return "PhysicalDisplayInfo{" + this.width + " x " + this.height + ", " + this.refreshRate + " fps, density " + this.density + ", " + this.xDpi + " x " + this.yDpi + " dpi, secure " + this.secure + ", appVsyncOffset " + this.appVsyncOffsetNanos + ", bufferDeadline " + this.presentationDeadlineNanos + "}";
        }
    }

    public static class Builder {
        private SurfaceSession mSession;
        private int mFlags = 4;
        private int mWidth;
        private int mHeight;
        private int mFormat = -1;
        private String mName;
        private SurfaceControl mParent;
        private int mWindowType = -1;
        private int mOwnerUid = -1;

        public Builder(SurfaceSession session) {
            this.mSession = session;
        }

        public SurfaceControl build() {
            if (this.mWidth <= 0 || this.mHeight <= 0) {
                throw new IllegalArgumentException("width and height must be set");
            }
            return new SurfaceControl(this.mSession, this.mName, this.mWidth, this.mHeight, this.mFormat, this.mFlags, this.mParent, this.mWindowType, this.mOwnerUid);
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setSize(int width, int height) {
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            this.mWidth = width;
            this.mHeight = height;
            return this;
        }

        public Builder setFormat(int format) {
            this.mFormat = format;
            return this;
        }

        public Builder setProtected(boolean protectedContent) {
            this.mFlags = protectedContent ? (this.mFlags |= 0x800) : (this.mFlags &= 0xFFFFF7FF);
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.mFlags = secure ? (this.mFlags |= 0x80) : (this.mFlags &= 0xFFFFFF7F);
            return this;
        }

        public Builder setOpaque(boolean opaque) {
            this.mFlags = opaque ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
            return this;
        }

        public Builder setParent(SurfaceControl parent) {
            this.mParent = parent;
            return this;
        }

        public Builder setMetadata(int windowType, int ownerUid) {
            if (UserHandle.getAppId(Process.myUid()) != 1000) {
                throw new UnsupportedOperationException("It only makes sense to set Surface metadata from the WindowManager");
            }
            this.mWindowType = windowType;
            this.mOwnerUid = ownerUid;
            return this;
        }

        public Builder setColorLayer(boolean isColorLayer) {
            this.mFlags = isColorLayer ? (this.mFlags |= 0x20000) : (this.mFlags &= 0xFFFDFFFF);
            return this;
        }

        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }
    }
}

