/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.TimeInterpolator;
import android.view.RenderNodeAnimator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.android.internal.view.animation.FallbackLUTInterpolator;
import java.util.ArrayList;

class ViewPropertyAnimatorRT {
    private static final Interpolator sLinearInterpolator = new LinearInterpolator();
    private final View mView;
    private RenderNodeAnimator[] mAnimators = new RenderNodeAnimator[12];

    ViewPropertyAnimatorRT(View view) {
        this.mView = view;
    }

    public boolean startAnimation(ViewPropertyAnimator parent) {
        this.cancelAnimators(parent.mPendingAnimations);
        if (!this.canHandleAnimator(parent)) {
            return false;
        }
        this.doStartAnimation(parent);
        return true;
    }

    public void cancelAll() {
        for (int i = 0; i < this.mAnimators.length; ++i) {
            if (this.mAnimators[i] == null) continue;
            this.mAnimators[i].cancel();
            this.mAnimators[i] = null;
        }
    }

    private void doStartAnimation(ViewPropertyAnimator parent) {
        int size = parent.mPendingAnimations.size();
        long startDelay = parent.getStartDelay();
        long duration = parent.getDuration();
        TimeInterpolator interpolator2 = parent.getInterpolator();
        if (interpolator2 == null) {
            interpolator2 = sLinearInterpolator;
        }
        if (!RenderNodeAnimator.isNativeInterpolator(interpolator2)) {
            interpolator2 = new FallbackLUTInterpolator(interpolator2, duration);
        }
        for (int i = 0; i < size; ++i) {
            ViewPropertyAnimator.NameValuesHolder holder = parent.mPendingAnimations.get(i);
            int property = RenderNodeAnimator.mapViewPropertyToRenderProperty(holder.mNameConstant);
            float finalValue = holder.mFromValue + holder.mDeltaValue;
            RenderNodeAnimator animator2 = new RenderNodeAnimator(property, finalValue);
            animator2.setStartDelay(startDelay);
            animator2.setDuration(duration);
            animator2.setInterpolator(interpolator2);
            animator2.setTarget(this.mView);
            animator2.start();
            this.mAnimators[property] = animator2;
        }
        parent.mPendingAnimations.clear();
    }

    private boolean canHandleAnimator(ViewPropertyAnimator parent) {
        if (parent.getUpdateListener() != null) {
            return false;
        }
        if (parent.getListener() != null) {
            return false;
        }
        if (!this.mView.isHardwareAccelerated()) {
            return false;
        }
        return !parent.hasActions();
    }

    private void cancelAnimators(ArrayList<ViewPropertyAnimator.NameValuesHolder> mPendingAnimations) {
        int size = mPendingAnimations.size();
        for (int i = 0; i < size; ++i) {
            ViewPropertyAnimator.NameValuesHolder holder = mPendingAnimations.get(i);
            int property = RenderNodeAnimator.mapViewPropertyToRenderProperty(holder.mNameConstant);
            if (this.mAnimators[property] == null) continue;
            this.mAnimators[property].cancel();
            this.mAnimators[property] = null;
        }
    }
}

