/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.os.Binder;
import android.os.Bundle;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityCache;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AccessibilityInteractionClient
extends IAccessibilityInteractionConnectionCallback.Stub {
    public static final int NO_ID = -1;
    private static final String LOG_TAG = "AccessibilityInteractionClient";
    private static final boolean DEBUG = false;
    private static final boolean CHECK_INTEGRITY = true;
    private static final long TIMEOUT_INTERACTION_MILLIS = 5000L;
    private static final Object sStaticLock = new Object();
    private static final LongSparseArray<AccessibilityInteractionClient> sClients = new LongSparseArray();
    private static final SparseArray<IAccessibilityServiceConnection> sConnectionCache = new SparseArray();
    private static AccessibilityCache sAccessibilityCache = new AccessibilityCache(new AccessibilityCache.AccessibilityNodeRefresher());
    private final AtomicInteger mInteractionIdCounter = new AtomicInteger();
    private final Object mInstanceLock = new Object();
    private volatile int mInteractionId = -1;
    private AccessibilityNodeInfo mFindAccessibilityNodeInfoResult;
    private List<AccessibilityNodeInfo> mFindAccessibilityNodeInfosResult;
    private boolean mPerformAccessibilityActionResult;
    private Message mSameThreadMessage;

    public static AccessibilityInteractionClient getInstance() {
        long threadId = Thread.currentThread().getId();
        return AccessibilityInteractionClient.getInstanceForThread(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityInteractionClient getInstanceForThread(long threadId) {
        Object object = sStaticLock;
        synchronized (object) {
            AccessibilityInteractionClient client = sClients.get(threadId);
            if (client == null) {
                client = new AccessibilityInteractionClient();
                sClients.put(threadId, client);
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAccessibilityServiceConnection getConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            return sConnectionCache.get(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(int connectionId, IAccessibilityServiceConnection connection) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.put(connectionId, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.remove(connectionId);
        }
    }

    @VisibleForTesting
    public static void setCache(AccessibilityCache cache) {
        sAccessibilityCache = cache;
    }

    private AccessibilityInteractionClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSameThreadMessage(Message message) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mSameThreadMessage = message;
            this.mInstanceLock.notifyAll();
        }
    }

    public AccessibilityNodeInfo getRootInActiveWindow(int connectionId) {
        return this.findAccessibilityNodeInfoByAccessibilityId(connectionId, Integer.MAX_VALUE, AccessibilityNodeInfo.ROOT_NODE_ID, false, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityWindowInfo getWindow(int connectionId, int accessibilityWindowId) {
        block7: {
            try {
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block7;
                AccessibilityWindowInfo window = sAccessibilityCache.getWindow(accessibilityWindowId);
                if (window != null) {
                    return window;
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    window = connection.getWindow(accessibilityWindowId);
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (window != null) {
                    sAccessibilityCache.addWindow(window);
                    return window;
                }
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error while calling remote getWindow", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityWindowInfo> getWindows(int connectionId) {
        block7: {
            try {
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block7;
                List<AccessibilityWindowInfo> windows = sAccessibilityCache.getWindows();
                if (windows != null) {
                    return windows;
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    windows = connection.getWindows();
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (windows != null) {
                    sAccessibilityCache.setWindows(windows);
                    return windows;
                }
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error while calling remote getWindows", re);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo findAccessibilityNodeInfoByAccessibilityId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, boolean bypassCache, int prefetchFlags, Bundle arguments) {
        block10: {
            if ((prefetchFlags & 2) != 0 && (prefetchFlags & 1) == 0) {
                throw new IllegalArgumentException("FLAG_PREFETCH_SIBLINGS requires FLAG_PREFETCH_PREDECESSORS");
            }
            try {
                String[] packageNames;
                AccessibilityNodeInfo cachedInfo;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block10;
                if (!bypassCache && (cachedInfo = sAccessibilityCache.getNode(accessibilityWindowId, accessibilityNodeId)) != null) {
                    return cachedInfo;
                }
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityWindowId, accessibilityNodeId, interactionId, this, prefetchFlags, Thread.currentThread().getId(), arguments);
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null) {
                    List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId, bypassCache, packageNames);
                    if (infos != null && !infos.isEmpty()) {
                        for (int i = 1; i < infos.size(); ++i) {
                            infos.get(i).recycle();
                        }
                        return infos.get(0);
                    }
                }
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByAccessibilityId", re);
            }
        }
        return null;
    }

    private static String idToString(int accessibilityWindowId, long accessibilityNodeId) {
        return accessibilityWindowId + "/" + AccessibilityNodeInfo.idToString(accessibilityNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String viewId) {
        block6: {
            try {
                List<AccessibilityNodeInfo> infos;
                String[] packageNames;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block6;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.findAccessibilityNodeInfosByViewId(accessibilityWindowId, accessibilityNodeId, viewId, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null && (infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId)) != null) {
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId, false, packageNames);
                    return infos;
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByViewIdInActiveWindow", re);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String text) {
        block6: {
            try {
                List<AccessibilityNodeInfo> infos;
                String[] packageNames;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block6;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.findAccessibilityNodeInfosByText(accessibilityWindowId, accessibilityNodeId, text, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null && (infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId)) != null) {
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId, false, packageNames);
                    return infos;
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfosByViewText", re);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo findFocus(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int focusType) {
        block6: {
            try {
                String[] packageNames;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block6;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.findFocus(accessibilityWindowId, accessibilityNodeId, focusType, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null) {
                    AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId, false, packageNames);
                    return info;
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote findFocus", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo focusSearch(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int direction) {
        block6: {
            try {
                String[] packageNames;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block6;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.focusSearch(accessibilityWindowId, accessibilityNodeId, direction, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null) {
                    AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId, false, packageNames);
                    return info;
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote accessibilityFocusSearch", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAccessibilityAction(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments) {
        block6: {
            try {
                boolean success;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block6;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                try {
                    success = connection.performAccessibilityAction(accessibilityWindowId, accessibilityNodeId, action, arguments, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (success) {
                    return this.getPerformAccessibilityActionResultAndClear(interactionId);
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote performAccessibilityAction", re);
            }
        }
        return false;
    }

    public void clearCache() {
        sAccessibilityCache.clear();
    }

    public void onAccessibilityEvent(AccessibilityEvent event) {
        sAccessibilityCache.onAccessibilityEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessibilityNodeInfo getFindAccessibilityNodeInfoResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            AccessibilityNodeInfo result = success ? this.mFindAccessibilityNodeInfoResult : null;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo info, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mFindAccessibilityNodeInfoResult = info;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AccessibilityNodeInfo> getFindAccessibilityNodeInfosResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            List<AccessibilityNodeInfo> result = success ? this.mFindAccessibilityNodeInfosResult : Collections.emptyList();
            this.clearResultLocked();
            if (_Original_Build.IS_DEBUGGABLE) {
                this.checkFindAccessibilityNodeInfoResultIntegrity(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> infos, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                if (infos != null) {
                    boolean isIpcCall;
                    boolean bl = isIpcCall = Binder.getCallingPid() != Process.myPid();
                    this.mFindAccessibilityNodeInfosResult = !isIpcCall ? new ArrayList<AccessibilityNodeInfo>(infos) : infos;
                } else {
                    this.mFindAccessibilityNodeInfosResult = Collections.emptyList();
                }
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPerformAccessibilityActionResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            boolean result = success ? this.mPerformAccessibilityActionResult : false;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPerformAccessibilityActionResult(boolean succeeded, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mPerformAccessibilityActionResult = succeeded;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    private void clearResultLocked() {
        this.mInteractionId = -1;
        this.mFindAccessibilityNodeInfoResult = null;
        this.mFindAccessibilityNodeInfosResult = null;
        this.mPerformAccessibilityActionResult = false;
    }

    private boolean waitForResultTimedLocked(int interactionId) {
        long waitTimeMillis = 5000L;
        long startTimeMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    Message sameProcessMessage;
                    if ((sameProcessMessage = this.getSameProcessMessageAndClear()) != null) {
                        sameProcessMessage.getTarget().handleMessage(sameProcessMessage);
                    }
                    if (this.mInteractionId == interactionId) {
                        return true;
                    }
                    if (this.mInteractionId > interactionId) {
                        return false;
                    }
                    long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                    waitTimeMillis = 5000L - elapsedTimeMillis;
                    if (waitTimeMillis <= 0L) {
                        return false;
                    }
                    this.mInstanceLock.wait(waitTimeMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void finalizeAndCacheAccessibilityNodeInfo(AccessibilityNodeInfo info, int connectionId, boolean bypassCache, String[] packageNames) {
        if (info != null) {
            CharSequence packageName;
            info.setConnectionId(connectionId);
            if (!(ArrayUtils.isEmpty(packageNames) || (packageName = info.getPackageName()) != null && ArrayUtils.contains(packageNames, packageName.toString()))) {
                info.setPackageName(packageNames[0]);
            }
            info.setSealed(true);
            if (!bypassCache) {
                sAccessibilityCache.add(info);
            }
        }
    }

    private void finalizeAndCacheAccessibilityNodeInfos(List<AccessibilityNodeInfo> infos, int connectionId, boolean bypassCache, String[] packageNames) {
        if (infos != null) {
            int infosCount = infos.size();
            for (int i = 0; i < infosCount; ++i) {
                AccessibilityNodeInfo info = infos.get(i);
                this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId, bypassCache, packageNames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getSameProcessMessageAndClear() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Message result = this.mSameThreadMessage;
            this.mSameThreadMessage = null;
            return result;
        }
    }

    private void checkFindAccessibilityNodeInfoResultIntegrity(List<AccessibilityNodeInfo> infos) {
        if (infos.size() == 0) {
            return;
        }
        AccessibilityNodeInfo root = infos.get(0);
        int infoCount = infos.size();
        block0: for (int i = 1; i < infoCount; ++i) {
            for (int j = i; j < infoCount; ++j) {
                AccessibilityNodeInfo candidate = infos.get(j);
                if (root.getParentNodeId() != candidate.getSourceNodeId()) continue;
                root = candidate;
                continue block0;
            }
        }
        if (root == null) {
            Log.e(LOG_TAG, "No root.");
        }
        HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
        LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
        fringe.add(root);
        while (!fringe.isEmpty()) {
            AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
            if (!seen.add(current)) {
                Log.e(LOG_TAG, "Duplicate node.");
                return;
            }
            int childCount = current.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                long childId = current.getChildId(i);
                for (int j = 0; j < infoCount; ++j) {
                    AccessibilityNodeInfo child = infos.get(j);
                    if (child.getSourceNodeId() != childId) continue;
                    fringe.add(child);
                }
            }
        }
        int disconnectedCount = infos.size() - seen.size();
        if (disconnectedCount > 0) {
            Log.e(LOG_TAG, disconnectedCount + " Disconnected nodes.");
        }
    }
}

