/*
 * Decompiled with CFR 0.152.
 */
package android.view.math;

public class Math3DHelper {
    private static final float EPSILON = 1.0E-7f;

    private Math3DHelper() {
    }

    public static float[] rayIntersectPoly(float[] poly, int polyLength, float px, float py, float dx, float dy, int d) {
        int p1 = polyLength - 1;
        int p2 = 0;
        while (p2 < polyLength) {
            float t2;
            float t;
            float p1y = poly[p1 * d + 1];
            float p2y = poly[p2 * d + 1];
            float p2x = poly[p2 * d + 0];
            float p1x = poly[p1 * d + 0];
            float div = dx * (p1y - p2y) + dy * (p2x - p1x);
            if (div != 0.0f && (t = (dx * (p1y - py) + dy * (px - p1x)) / div) >= 0.0f && t <= 1.0f && (t2 = (p1x * (py - p2y) + p2x * (p1y - py) + px * (p2y - p1y)) / div) > 0.0f) {
                return new float[]{t2, t, p1};
            }
            p1 = p2++;
        }
        return new float[]{Float.NaN};
    }

    public static void centroid2d(float[] poly, int len, float[] ret) {
        float sumx = 0.0f;
        float sumy = 0.0f;
        int p1 = len - 1;
        float area = 0.0f;
        int p2 = 0;
        while (p2 < len) {
            float x1 = poly[p1 * 2 + 0];
            float y1 = poly[p1 * 2 + 1];
            float x2 = poly[p2 * 2 + 0];
            float y2 = poly[p2 * 2 + 1];
            float a = x1 * y2 - x2 * y1;
            sumx += (x1 + x2) * a;
            sumy += (y1 + y2) * a;
            area += a;
            p1 = p2++;
        }
        float centroidx = sumx / (3.0f * area);
        float centroidy = sumy / (3.0f * area);
        ret[0] = centroidx;
        ret[1] = centroidy;
    }

    public static void centroid3d(float[] poly, int len, float[] ret) {
        int n = len - 1;
        double area = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        for (int i = 1; i < n; ++i) {
            int k = i + 1;
            float a0 = poly[i * 3 + 0] - poly[0];
            float a1 = poly[i * 3 + 1] - poly[1];
            float a2 = poly[i * 3 + 2] - poly[2];
            float b0 = poly[k * 3 + 0] - poly[0];
            float b1 = poly[k * 3 + 1] - poly[1];
            float b2 = poly[k * 3 + 2] - poly[2];
            float c0 = a1 * b2 - b1 * a2;
            float c1 = a2 * b0 - b2 * a0;
            float c2 = a0 * b1 - b0 * a1;
            double areaOfTriangle = Math.sqrt(c0 * c0 + c1 * c1 + c2 * c2);
            area += areaOfTriangle;
            cx += areaOfTriangle * (double)(poly[i * 3 + 0] + poly[k * 3 + 0] + poly[0]);
            cy += areaOfTriangle * (double)(poly[i * 3 + 1] + poly[k * 3 + 1] + poly[1]);
            cz += areaOfTriangle * (double)(poly[i * 3 + 2] + poly[k * 3 + 2] + poly[2]);
        }
        ret[0] = (float)(cx / (3.0 * area));
        ret[1] = (float)(cy / (3.0 * area));
        ret[2] = (float)(cz / (3.0 * area));
    }

    public static final int min(int x1, int x2, int x3) {
        return x1 > x2 ? (x2 > x3 ? x3 : x2) : (x1 > x3 ? x3 : x1);
    }

    public static final int max(int x1, int x2, int x3) {
        return x1 < x2 ? (x2 < x3 ? x3 : x2) : (x1 < x3 ? x3 : x1);
    }

    private static void xsort(float[] points, int pointsLength) {
        Math3DHelper.quicksortX(points, 0, pointsLength - 1);
    }

    public static int hull(float[] points, int pointsLength, float[] retPoly) {
        int i;
        Math3DHelper.xsort(points, pointsLength);
        int n = pointsLength;
        float[] lUpper = new float[n * 2];
        lUpper[0] = points[0];
        lUpper[1] = points[1];
        lUpper[2] = points[2];
        lUpper[3] = points[3];
        int lUpperSize = 2;
        for (int i2 = 2; i2 < n; ++i2) {
            lUpper[lUpperSize * 2 + 0] = points[i2 * 2 + 0];
            lUpper[lUpperSize * 2 + 1] = points[i2 * 2 + 1];
            ++lUpperSize;
            while (lUpperSize > 2 && !Math3DHelper.rightTurn(lUpper[(lUpperSize - 3) * 2], lUpper[(lUpperSize - 3) * 2 + 1], lUpper[(lUpperSize - 2) * 2], lUpper[(lUpperSize - 2) * 2 + 1], lUpper[(lUpperSize - 1) * 2], lUpper[(lUpperSize - 1) * 2 + 1])) {
                lUpper[(lUpperSize - 2) * 2 + 0] = lUpper[(lUpperSize - 1) * 2 + 0];
                lUpper[(lUpperSize - 2) * 2 + 1] = lUpper[(lUpperSize - 1) * 2 + 1];
                --lUpperSize;
            }
        }
        float[] lLower = new float[n * 2];
        lLower[0] = points[(n - 1) * 2 + 0];
        lLower[1] = points[(n - 1) * 2 + 1];
        lLower[2] = points[(n - 2) * 2 + 0];
        lLower[3] = points[(n - 2) * 2 + 1];
        int lLowerSize = 2;
        for (int i3 = n - 3; i3 >= 0; --i3) {
            lLower[lLowerSize * 2 + 0] = points[i3 * 2 + 0];
            lLower[lLowerSize * 2 + 1] = points[i3 * 2 + 1];
            ++lLowerSize;
            while (lLowerSize > 2 && !Math3DHelper.rightTurn(lLower[(lLowerSize - 3) * 2], lLower[(lLowerSize - 3) * 2 + 1], lLower[(lLowerSize - 2) * 2], lLower[(lLowerSize - 2) * 2 + 1], lLower[(lLowerSize - 1) * 2], lLower[(lLowerSize - 1) * 2 + 1])) {
                lLower[(lLowerSize - 2) * 2 + 0] = lLower[(lLowerSize - 1) * 2 + 0];
                lLower[(lLowerSize - 2) * 2 + 1] = lLower[(lLowerSize - 1) * 2 + 1];
                --lLowerSize;
            }
        }
        int count = 0;
        for (i = 0; i < lUpperSize; ++i) {
            retPoly[count * 2 + 0] = lUpper[i * 2 + 0];
            retPoly[count * 2 + 1] = lUpper[i * 2 + 1];
            ++count;
        }
        for (i = 1; i < lLowerSize - 1; ++i) {
            retPoly[count * 2 + 0] = lLower[i * 2 + 0];
            retPoly[count * 2 + 1] = lLower[i * 2 + 1];
            ++count;
        }
        return count;
    }

    private static boolean rightTurn(float ax, float ay, float bx, float by, float cx, float cy) {
        return (double)((bx - ax) * (cy - ay) - (by - ay) * (cx - ax)) > 1.0E-5;
    }

    public static int intersection(float[] poly1, int poly1length, float[] poly2, int poly2length) {
        Math3DHelper.makeClockwise(poly1, poly1length);
        Math3DHelper.makeClockwise(poly2, poly2length);
        float[] poly = new float[(poly1length * poly2length + 2) * 2];
        int count = 0;
        int pcount = 0;
        for (int i = 0; i < poly1length; ++i) {
            if (!Math3DHelper.pointInsidePolygon(poly1[i * 2], poly1[i * 2 + 1], poly2, poly2length)) continue;
            poly[count * 2] = poly1[i * 2];
            poly[count * 2 + 1] = poly1[i * 2 + 1];
            ++count;
            ++pcount;
        }
        int fromP1 = pcount;
        for (int i = 0; i < poly2length; ++i) {
            if (!Math3DHelper.pointInsidePolygon(poly2[i * 2], poly2[i * 2 + 1], poly1, poly1length)) continue;
            poly[count * 2] = poly2[i * 2];
            poly[count * 2 + 1] = poly2[i * 2 + 1];
            ++count;
        }
        int fromP2 = count - fromP1;
        if (fromP1 == poly1length) {
            for (int i = 0; i < poly1length; ++i) {
                poly2[i * 2] = poly1[i * 2];
                poly2[i * 2 + 1] = poly1[i * 2 + 1];
            }
            return poly1length;
        }
        if (fromP2 == poly2length) {
            return poly2length;
        }
        float[] intersection = new float[2];
        for (int i = 0; i < poly2length; ++i) {
            for (int j = 0; j < poly1length; ++j) {
                int i1_by_2 = i * 2;
                int i2_by_2 = (i + 1) % poly2length * 2;
                int j1_by_2 = j * 2;
                int j2_by_2 = (j + 1) % poly1length * 2;
                boolean found = Math3DHelper.lineIntersection(poly2[i1_by_2], poly2[i1_by_2 + 1], poly2[i2_by_2], poly2[i2_by_2 + 1], poly1[j1_by_2], poly1[j1_by_2 + 1], poly1[j2_by_2], poly1[j2_by_2 + 1], intersection);
                if (found) {
                    poly[count * 2] = intersection[0];
                    poly[count * 2 + 1] = intersection[1];
                    ++count;
                    continue;
                }
                float dx = poly2[i * 2] - poly1[j * 2];
                float dy = poly2[i * 2 + 1] - poly1[j * 2 + 1];
                if (!((double)(dx * dx + dy * dy) < 0.01)) continue;
                poly[count * 2] = poly2[i * 2];
                poly[count * 2 + 1] = poly2[i * 2 + 1];
                ++count;
            }
        }
        if (count == 0) {
            return 0;
        }
        float avgx = 0.0f;
        float avgy = 0.0f;
        for (int i = 0; i < count; ++i) {
            avgx += poly[i * 2];
            avgy += poly[i * 2 + 1];
        }
        float[] ctr = new float[]{avgx /= (float)count, avgy /= (float)count};
        Math3DHelper.sort(poly, count, ctr);
        int size = count;
        poly2[0] = poly[0];
        poly2[1] = poly[1];
        count = 1;
        for (int i = 1; i < size; ++i) {
            float dx = poly[i * 2] - poly[(i - 1) * 2];
            float dy = poly[i * 2 + 1] - poly[(i - 1) * 2 + 1];
            if (!((double)(dx * dx + dy * dy) >= 0.01)) continue;
            poly2[count * 2] = poly[i * 2];
            poly2[count * 2 + 1] = poly[i * 2 + 1];
            ++count;
        }
        return count;
    }

    public static void sort(float[] poly, int polyLength, float[] ctr) {
        Math3DHelper.quicksortCirc(poly, 0, polyLength - 1, ctr);
    }

    public static float angle(float x1, float y1, float[] ctr) {
        return -((float)Math.atan2(x1 - ctr[0], y1 - ctr[1]));
    }

    private static void swap(float[] points, int i, int j) {
        float x = points[i * 2];
        float y = points[i * 2 + 1];
        points[i * 2] = points[j * 2];
        points[i * 2 + 1] = points[j * 2 + 1];
        points[j * 2] = x;
        points[j * 2 + 1] = y;
    }

    private static void quicksortCirc(float[] points, int low, int high, float[] ctr) {
        int i = low;
        int j = high;
        int p = low + (high - low) / 2;
        float pivot = Math3DHelper.angle(points[p * 2], points[p * 2 + 1], ctr);
        while (i <= j) {
            while (Math3DHelper.angle(points[i * 2], points[i * 2 + 1], ctr) < pivot) {
                ++i;
            }
            while (Math3DHelper.angle(points[j * 2], points[j * 2 + 1], ctr) > pivot) {
                --j;
            }
            if (i > j) continue;
            Math3DHelper.swap(points, i, j);
            ++i;
            --j;
        }
        if (low < j) {
            Math3DHelper.quicksortCirc(points, low, j, ctr);
        }
        if (i < high) {
            Math3DHelper.quicksortCirc(points, i, high, ctr);
        }
    }

    private static void quicksortX(float[] points, int low, int high) {
        int i = low;
        int j = high;
        int p = low + (high - low) / 2;
        float pivot = points[p * 2];
        while (i <= j) {
            while (points[i * 2] < pivot) {
                ++i;
            }
            while (points[j * 2] > pivot) {
                --j;
            }
            if (i > j) continue;
            Math3DHelper.swap(points, i, j);
            ++i;
            --j;
        }
        if (low < j) {
            Math3DHelper.quicksortX(points, low, j);
        }
        if (i < high) {
            Math3DHelper.quicksortX(points, i, high);
        }
    }

    private static boolean pointInsidePolygon(float x, float y, float[] poly, int len) {
        boolean c = false;
        float testx = x;
        float testy = y;
        int i = 0;
        int j = len - 1;
        while (i < len) {
            if (poly[i * 2 + 1] > testy != poly[j * 2 + 1] > testy && testx < (poly[j * 2] - poly[i * 2]) * (testy - poly[i * 2 + 1]) / (poly[j * 2 + 1] - poly[i * 2 + 1]) + poly[i * 2]) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    private static void makeClockwise(float[] polygon, int len) {
        if (polygon == null || len == 0) {
            return;
        }
        if (!Math3DHelper.isClockwise(polygon, len)) {
            Math3DHelper.reverse(polygon, len);
        }
    }

    private static boolean isClockwise(float[] polygon, int len) {
        float sum = 0.0f;
        float p1x = polygon[(len - 1) * 2];
        float p1y = polygon[(len - 1) * 2 + 1];
        for (int i = 0; i < len; ++i) {
            float p2x = polygon[i * 2];
            float p2y = polygon[i * 2 + 1];
            sum += p1x * p2y - p2x * p1y;
            p1x = p2x;
            p1y = p2y;
        }
        return sum < 0.0f;
    }

    private static void reverse(float[] polygon, int len) {
        int n = len / 2;
        for (int i = 0; i < n; ++i) {
            float tmp0 = polygon[i * 2];
            float tmp1 = polygon[i * 2 + 1];
            int k = len - 1 - i;
            polygon[i * 2] = polygon[k * 2];
            polygon[i * 2 + 1] = polygon[k * 2 + 1];
            polygon[k * 2] = tmp0;
            polygon[k * 2 + 1] = tmp1;
        }
    }

    private static final boolean lineIntersection(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float[] ret) {
        float d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d == 0.0f) {
            return false;
        }
        float dx = x1 * y2 - y1 * x2;
        float dy = x3 * y4 - y3 * x4;
        float x = (dx * (x3 - x4) - (x1 - x2) * dy) / d;
        float y = (dx * (y3 - y4) - (y1 - y2) * dy) / d;
        if ((x - x1) * (x - x2) > 1.0E-7f || (x - x3) * (x - x4) > 1.0E-7f || (y - y1) * (y - y2) > 1.0E-7f || (y - y3) * (y - y4) > 1.0E-7f) {
            return false;
        }
        ret[0] = x;
        ret[1] = y;
        return true;
    }

    public static void donutPie2(float[] penumbra, int penumbraLength, float[] umbra, int umbraLength, int rays, int layers, float strength, float[] retstrips) {
        float dy;
        float dx;
        int i;
        int rings = layers + 1;
        double step = Math.PI * 2 / (double)rays;
        float[] retxy = new float[2];
        Math3DHelper.centroid2d(umbra, umbraLength, retxy);
        float cx = retxy[0];
        float cy = retxy[1];
        float[] t1 = new float[rays];
        float[] t2 = new float[rays];
        for (int i2 = 0; i2 < rays; ++i2) {
            float dx2 = (float)Math.sin(0.7853981633974483 + step * (double)i2);
            float dy2 = (float)Math.cos(0.7853981633974483 + step * (double)i2);
            t2[i2] = Math3DHelper.rayIntersectPoly(umbra, umbraLength, cx, cy, dx2, dy2, 2)[0];
            t1[i2] = Math3DHelper.rayIntersectPoly(penumbra, penumbraLength, cx, cy, dx2, dy2, 2)[0];
        }
        int p = 0;
        for (int r = 0; r < layers; ++r) {
            int startp = p;
            for (i = 0; i < rays; ++i) {
                dx = (float)Math.sin(0.7853981633974483 + step * (double)i);
                dy = (float)Math.cos(0.7853981633974483 + step * (double)i);
                for (int j = r; j < r + 2; ++j) {
                    float jf = (float)j / (float)(rings - 1);
                    float t = t1[i] + jf * (t2[i] - t1[i]);
                    float op = (jf + 1.0f - 1.0f / (1.0f + (t - t1[i]) * (t - t1[i]))) / 2.0f;
                    retstrips[p * 3] = dx * t + cx;
                    retstrips[p * 3 + 1] = dy * t + cy;
                    retstrips[p * 3 + 2] = jf * op * strength;
                    ++p;
                }
            }
            retstrips[p * 3] = retstrips[startp * 3];
            retstrips[p * 3 + 1] = retstrips[startp * 3 + 1];
            retstrips[p * 3 + 2] = retstrips[startp * 3 + 2];
            retstrips[++p * 3] = retstrips[++startp * 3];
            retstrips[p * 3 + 1] = retstrips[startp * 3 + 1];
            retstrips[p * 3 + 2] = retstrips[startp * 3 + 2];
            ++p;
        }
        int oldp = p - 1;
        retstrips[p * 3] = retstrips[oldp * 3];
        retstrips[p * 3 + 1] = retstrips[oldp * 3 + 1];
        retstrips[p * 3 + 2] = retstrips[oldp * 3 + 2];
        oldp = p += 2;
        for (int k = 0; k < rays; ++k) {
            i = k / 2;
            if ((k & 1) == 1) {
                i = rays - i - 1;
            }
            dx = (float)Math.sin(0.7853981633974483 + step * (double)i);
            dy = (float)Math.cos(0.7853981633974483 + step * (double)i);
            float jf = 1.0f;
            float t = t1[i] + jf * (t2[i] - t1[i]);
            float op = (jf + 1.0f - 1.0f / (1.0f + (t - t1[i]) * (t - t1[i]))) / 2.0f;
            retstrips[p * 3] = dx * t + cx;
            retstrips[p * 3 + 1] = dy * t + cy;
            retstrips[p * 3 + 2] = jf * op * strength;
            ++p;
        }
        p = oldp - 1;
        retstrips[p * 3] = retstrips[oldp * 3];
        retstrips[p * 3 + 1] = retstrips[oldp * 3 + 1];
        retstrips[p * 3 + 2] = retstrips[oldp * 3 + 2];
    }

    public static float[] flatBound(float[] poly, int dimension) {
        int polySize = poly.length / dimension;
        float left = poly[0];
        float right = poly[0];
        float top = poly[1];
        float bottom = poly[1];
        for (int i = 0; i < polySize; ++i) {
            float x = poly[i * dimension + 0];
            float y = poly[i * dimension + 1];
            if (left > x) {
                left = x;
            } else if (right < x) {
                right = x;
            }
            if (top > y) {
                top = y;
                continue;
            }
            if (!(bottom < y)) continue;
            bottom = y;
        }
        return new float[]{left, top, right, bottom};
    }

    public static void translate(float[] poly, float translateX, float translateY, int dimension) {
        int polySize = poly.length / dimension;
        for (int i = 0; i < polySize; ++i) {
            int n = i * dimension + 0;
            poly[n] = poly[n] + translateX;
            int n2 = i * dimension + 1;
            poly[n2] = poly[n2] + translateY;
        }
    }
}

