/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.ViewGroup;
import android.view.shadow.AmbientShadowBitmapGenerator;
import android.view.shadow.AmbientShadowConfig;
import android.view.shadow.SpotShadowBitmapGenerator;
import android.view.shadow.SpotShadowConfig;

public class HighQualityShadowPainter {
    private HighQualityShadowPainter() {
    }

    public static void paintRectShadow(ViewGroup parent, Outline outline, float elevation, Canvas canvas, float alpha, float densityDpi) {
        if (!HighQualityShadowPainter.validate(elevation, densityDpi)) {
            return;
        }
        int width = parent.getWidth() / 5;
        int height = parent.getHeight() / 5;
        Rect rectOriginal = new Rect();
        Rect rectScaled = new Rect();
        if (!outline.getRect(rectScaled) || alpha < 0.2f) {
            return;
        }
        outline.getRect(rectOriginal);
        rectScaled.left /= 5;
        rectScaled.right /= 5;
        rectScaled.top /= 5;
        rectScaled.bottom /= 5;
        float radius = outline.getRadius() / 5.0f;
        if (radius > (float)rectScaled.width() || radius > (float)rectScaled.height()) {
            return;
        }
        alpha = alpha > 1.0f ? 1.0f : alpha;
        float[] poly = HighQualityShadowPainter.getPoly(rectScaled, elevation / 5.0f, radius);
        HighQualityShadowPainter.paintAmbientShadow(poly, canvas, width, height, alpha, rectOriginal, radius);
        HighQualityShadowPainter.paintSpotShadow(poly, rectScaled, elevation / 5.0f, canvas, densityDpi, width, height, alpha, rectOriginal, radius);
    }

    private static boolean validate(float elevation, float densityDpi) {
        float scaledElevationPx = elevation / 5.0f;
        float scaledSpotLightHeightPx = 10.0f * (densityDpi / 160.0f);
        return !(scaledElevationPx > scaledSpotLightHeightPx);
    }

    private static void paintAmbientShadow(float[] polygon, Canvas canvas, int width, int height, float alpha, Rect shadowCasterOutline, float radius) {
        AmbientShadowConfig config = new AmbientShadowConfig.Builder().setSize(width, height).setPolygon(polygon).setEdgeScale(60.0f).setShadowBoundRatio(0.099999994f).setShadowStrength(1.0f * alpha).setRays(120).setLayers(1).build();
        AmbientShadowBitmapGenerator generator = new AmbientShadowBitmapGenerator(config);
        generator.populateShadow();
        if (!generator.isValid()) {
            return;
        }
        HighQualityShadowPainter.drawScaled(canvas, generator.getBitmap(), (int)generator.getTranslateX(), (int)generator.getTranslateY(), width, height, shadowCasterOutline, radius);
    }

    private static void paintSpotShadow(float[] poly, Rect rectBound, float elevation, Canvas canvas, float densityDpi, int width, int height, float alpha, Rect shadowCasterOutline, float radius) {
        float lightZHeightPx = 10.0f * (densityDpi / 160.0f);
        if (lightZHeightPx - elevation < 2.0f) {
            return;
        }
        float lightX = (rectBound.left + rectBound.right) / 2;
        float lightY = rectBound.top;
        int dynamicLightRadius = Math.min(rectBound.width(), rectBound.height());
        SpotShadowConfig config = new SpotShadowConfig.Builder().setSize(width, height).setLayers(1).setRays(40).setLightCoord(lightX, lightY, lightZHeightPx).setLightRadius(dynamicLightRadius).setLightSourcePoints(4).setShadowStrength(0.3f * alpha).setPolygon(poly, poly.length / 3).build();
        SpotShadowBitmapGenerator generator = new SpotShadowBitmapGenerator(config);
        generator.populateShadow();
        if (!generator.validate()) {
            return;
        }
        HighQualityShadowPainter.drawScaled(canvas, generator.getBitmap(), (int)generator.getTranslateX(), (int)generator.getTranslateY(), width, height, shadowCasterOutline, radius);
    }

    private static void drawScaled(Canvas canvas, Bitmap bitmap, int translateX, int translateY, int width, int height, Rect shadowCaster, float radius) {
        int unscaledTranslateX = translateX * 5;
        int unscaledTranslateY = translateY * 5;
        Rect dest = new Rect(-unscaledTranslateX, -unscaledTranslateY, width * 5 - unscaledTranslateX, height * 5 - unscaledTranslateY);
        Rect destSrc = new Rect(0, 0, width, height);
        if (radius > 0.0f) {
            int save = canvas.save();
            canvas.drawBitmap(bitmap, destSrc, dest, null);
            canvas.restoreToCount(save);
            return;
        }
        Rect left = new Rect(dest.left, shadowCaster.top, shadowCaster.left, shadowCaster.bottom);
        int leftScaled = left.width() / 5 + destSrc.left;
        Rect top = new Rect(dest.left, dest.top, dest.right, shadowCaster.top);
        int topScaled = top.height() / 5 + destSrc.top;
        Rect right = new Rect(shadowCaster.right, shadowCaster.top, dest.right, shadowCaster.bottom);
        int rightScaled = (shadowCaster.right + unscaledTranslateX) / 5 + destSrc.left;
        Rect bottom = new Rect(dest.left, shadowCaster.bottom, dest.right, dest.bottom);
        int bottomScaled = (bottom.bottom - bottom.height()) / 5 + destSrc.top;
        Rect leftSrc = new Rect(destSrc.left, topScaled, leftScaled, bottomScaled);
        Rect topSrc = new Rect(destSrc.left, destSrc.top, destSrc.right, topScaled);
        Rect rightSrc = new Rect(rightScaled, topScaled, destSrc.right, bottomScaled);
        Rect bottomSrc = new Rect(destSrc.left, bottomScaled, destSrc.right, destSrc.bottom);
        int save = canvas.save();
        Paint paint = new Paint();
        canvas.drawBitmap(bitmap, leftSrc, left, paint);
        canvas.drawBitmap(bitmap, topSrc, top, paint);
        canvas.drawBitmap(bitmap, rightSrc, right, paint);
        canvas.drawBitmap(bitmap, bottomSrc, bottom, paint);
        canvas.restoreToCount(save);
    }

    private static float[] getPoly(Rect rect, float elevation, float radius) {
        if (radius <= 0.0f) {
            float[] poly = new float[12];
            poly[0] = poly[9] = (float)rect.left;
            poly[1] = poly[4] = (float)rect.top;
            poly[3] = poly[6] = (float)rect.right;
            poly[7] = poly[10] = (float)rect.bottom;
            poly[8] = poly[11] = elevation;
            poly[5] = poly[11];
            poly[2] = poly[11];
            return poly;
        }
        return HighQualityShadowPainter.buildRoundedEdges(rect, elevation, radius);
    }

    private static float[] buildRoundedEdges(Rect rect, float elevation, float radius) {
        float y;
        float x;
        double theta;
        int i;
        float[] roundedEdgeVertices = new float[72];
        int index = 0;
        for (i = 0; i <= 5; ++i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.left + ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.top + ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        for (i = 5; i >= 0; --i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.right - ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.top + ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        for (i = 0; i <= 5; ++i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.right - ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.bottom - ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        for (i = 5; i >= 0; --i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.left + ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.bottom - ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        return roundedEdgeVertices;
    }
}

