/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.SystemTextClassifier;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.System_Delegate;

class TextClassificationSession
implements TextClassifier {
    static final boolean DEBUG_LOG_ENABLED = true;
    private static final String LOG_TAG = "TextClassificationSession";
    private final TextClassifier mDelegate;
    private final SelectionEventHelper mEventHelper;
    private final TextClassificationSessionId mSessionId;
    private final TextClassificationContext mClassificationContext;
    private boolean mDestroyed;

    TextClassificationSession(TextClassificationContext context, TextClassifier delegate) {
        this.mClassificationContext = Preconditions.checkNotNull(context);
        this.mDelegate = Preconditions.checkNotNull(delegate);
        this.mSessionId = new TextClassificationSessionId();
        this.mEventHelper = new SelectionEventHelper(this.mSessionId, this.mClassificationContext);
        this.initializeRemoteSession();
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        this.checkDestroyed();
        return this.mDelegate.suggestSelection(request);
    }

    private void initializeRemoteSession() {
        if (this.mDelegate instanceof SystemTextClassifier) {
            ((SystemTextClassifier)this.mDelegate).initializeRemoteSession(this.mClassificationContext, this.mSessionId);
        }
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        this.checkDestroyed();
        return this.mDelegate.classifyText(request);
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        this.checkDestroyed();
        return this.mDelegate.generateLinks(request);
    }

    @Override
    public void onSelectionEvent(SelectionEvent event) {
        this.checkDestroyed();
        Preconditions.checkNotNull(event);
        if (this.mEventHelper.sanitizeEvent(event)) {
            this.mDelegate.onSelectionEvent(event);
        }
    }

    @Override
    public void destroy() {
        this.mEventHelper.endSession();
        this.mDelegate.destroy();
        this.mDestroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    private void checkDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("This TextClassification session has been destroyed");
        }
    }

    private static class SelectionEventHelper {
        private final TextClassificationSessionId mSessionId;
        private final TextClassificationContext mContext;
        private int mInvocationMethod = 0;
        private SelectionEvent mPrevEvent;
        private SelectionEvent mSmartEvent;
        private SelectionEvent mStartEvent;

        SelectionEventHelper(TextClassificationSessionId sessionId, TextClassificationContext context) {
            this.mSessionId = Preconditions.checkNotNull(sessionId);
            this.mContext = Preconditions.checkNotNull(context);
        }

        boolean sanitizeEvent(SelectionEvent event) {
            this.updateInvocationMethod(event);
            this.modifyAutoSelectionEventType(event);
            if (event.getEventType() != 1 && this.mStartEvent == null) {
                Log.d(TextClassificationSession.LOG_TAG, "Selection session not yet started. Ignoring event");
                return false;
            }
            long now = System_Delegate.currentTimeMillis();
            switch (event.getEventType()) {
                case 1: {
                    Preconditions.checkArgument(event.getAbsoluteEnd() == event.getAbsoluteStart() + 1);
                    event.setSessionId(this.mSessionId);
                    this.mStartEvent = event;
                    break;
                }
                case 3: 
                case 4: {
                    this.mSmartEvent = event;
                    break;
                }
                case 2: 
                case 5: {
                    if (this.mPrevEvent == null || this.mPrevEvent.getAbsoluteStart() != event.getAbsoluteStart() || this.mPrevEvent.getAbsoluteEnd() != event.getAbsoluteEnd()) break;
                    return false;
                }
            }
            event.setEventTime(now);
            if (this.mStartEvent != null) {
                event.setSessionId(this.mStartEvent.getSessionId()).setDurationSinceSessionStart(now - this.mStartEvent.getEventTime()).setStart(event.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setEnd(event.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
            }
            if (this.mSmartEvent != null) {
                event.setResultId(this.mSmartEvent.getResultId()).setSmartStart(this.mSmartEvent.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setSmartEnd(this.mSmartEvent.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
            }
            if (this.mPrevEvent != null) {
                event.setDurationSincePreviousEvent(now - this.mPrevEvent.getEventTime()).setEventIndex(this.mPrevEvent.getEventIndex() + 1);
            }
            this.mPrevEvent = event;
            return true;
        }

        void endSession() {
            this.mPrevEvent = null;
            this.mSmartEvent = null;
            this.mStartEvent = null;
        }

        private void updateInvocationMethod(SelectionEvent event) {
            event.setTextClassificationSessionContext(this.mContext);
            if (event.getInvocationMethod() == 0) {
                event.setInvocationMethod(this.mInvocationMethod);
            } else {
                this.mInvocationMethod = event.getInvocationMethod();
            }
        }

        private void modifyAutoSelectionEventType(SelectionEvent event) {
            switch (event.getEventType()) {
                case 3: 
                case 4: 
                case 5: {
                    if (SelectionEventHelper.isPlatformLocalTextClassifierSmartSelection(event.getResultId())) {
                        if (event.getAbsoluteEnd() - event.getAbsoluteStart() > 1) {
                            event.setEventType(4);
                        } else {
                            event.setEventType(3);
                        }
                    } else {
                        event.setEventType(5);
                    }
                    return;
                }
            }
        }

        private static boolean isPlatformLocalTextClassifierSmartSelection(String signature) {
            return "androidtc".equals(SelectionSessionLogger.SignatureParser.getClassifierId(signature));
        }
    }
}

