/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.PrintWriterPrinter;
import android.util.Xml;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.R;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

public class SpellCheckerInfo
implements Parcelable {
    private static final String TAG = SpellCheckerInfo.class.getSimpleName();
    private final ResolveInfo mService;
    private final String mId;
    private final int mLabel;
    private final String mSettingsActivityName;
    private final ArrayList<SpellCheckerSubtype> mSubtypes = new ArrayList();
    public static final Parcelable.Creator<SpellCheckerInfo> CREATOR = new Parcelable.Creator<SpellCheckerInfo>(){

        @Override
        public SpellCheckerInfo createFromParcel(Parcel source) {
            return new SpellCheckerInfo(source);
        }

        public SpellCheckerInfo[] newArray(int size) {
            return new SpellCheckerInfo[size];
        }
    };

    public SpellCheckerInfo(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        this.mService = service;
        ServiceInfo si = service.serviceInfo;
        this.mId = new ComponentName(si.packageName, si.name).flattenToShortString();
        PackageManager pm = context.getPackageManager();
        int label = 0;
        String settingsActivityComponent = null;
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.view.textservice.scs");
            if (parser == null) {
                throw new XmlPullParserException("No android.view.textservice.scs meta-data");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"spell-checker".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with spell-checker tag");
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.SpellChecker);
            label = sa.getResourceId(0, 0);
            settingsActivityComponent = sa.getString(1);
            sa.recycle();
            int depth = parser.getDepth();
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                String subtypeNodeName = parser.getName();
                if (!"subtype".equals(subtypeNodeName)) {
                    throw new XmlPullParserException("Meta-data in spell-checker does not start with subtype tag");
                }
                TypedArray a = res.obtainAttributes(attrs, R.styleable.SpellChecker_Subtype);
                SpellCheckerSubtype subtype = new SpellCheckerSubtype(a.getResourceId(0, 0), a.getString(1), a.getString(4), a.getString(2), a.getInt(3, 0));
                this.mSubtypes.add(subtype);
            }
        }
        this.mLabel = label;
        this.mSettingsActivityName = settingsActivityComponent;
    }

    public SpellCheckerInfo(Parcel source) {
        this.mLabel = source.readInt();
        this.mId = source.readString();
        this.mSettingsActivityName = source.readString();
        this.mService = ResolveInfo.CREATOR.createFromParcel(source);
        source.readTypedList(this.mSubtypes, SpellCheckerSubtype.CREATOR);
    }

    public String getId() {
        return this.mId;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLabel);
        dest.writeString(this.mId);
        dest.writeString(this.mSettingsActivityName);
        this.mService.writeToParcel(dest, flags);
        dest.writeTypedList(this.mSubtypes);
    }

    public CharSequence loadLabel(PackageManager pm) {
        if (this.mLabel == 0 || pm == null) {
            return "";
        }
        return pm.getText(this.getPackageName(), this.mLabel, this.mService.serviceInfo.applicationInfo);
    }

    public Drawable loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public int getSubtypeCount() {
        return this.mSubtypes.size();
    }

    public SpellCheckerSubtype getSubtypeAt(int index) {
        return this.mSubtypes.get(index);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mId=" + this.mId);
        pw.println(prefix + "mSettingsActivityName=" + this.mSettingsActivityName);
        pw.println(prefix + "Service:");
        this.mService.dump(new PrintWriterPrinter(pw), prefix + "  ");
        int N = this.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            SpellCheckerSubtype st = this.getSubtypeAt(i);
            pw.println(prefix + "  Subtype #" + i + ":");
            pw.println(prefix + "    locale=" + st.getLocale() + " languageTag=" + st.getLanguageTag());
            pw.println(prefix + "    extraValue=" + st.getExtraValue());
        }
    }
}

