/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.LoadedApk;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.ChildZygoteProcess;
import android.os.Process;
import android.os.ZygoteProcess;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebViewFactory;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.util.ArrayList;

public class WebViewZygote {
    private static final String LOGTAG = "WebViewZygote";
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static ChildZygoteProcess sZygote;
    @GuardedBy(value="sLock")
    private static PackageInfo sPackage;
    @GuardedBy(value="sLock")
    private static ApplicationInfo sPackageOriginalAppInfo;
    @GuardedBy(value="sLock")
    private static boolean sMultiprocessEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZygoteProcess getProcess() {
        Object object = sLock;
        synchronized (object) {
            if (sZygote != null) {
                return sZygote;
            }
            WebViewZygote.connectToZygoteIfNeededLocked();
            return sZygote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageName() {
        Object object = sLock;
        synchronized (object) {
            return WebViewZygote.sPackage.packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMultiprocessEnabled() {
        Object object = sLock;
        synchronized (object) {
            return sMultiprocessEnabled && sPackage != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMultiprocessEnabled(boolean enabled) {
        Object object = sLock;
        synchronized (object) {
            sMultiprocessEnabled = enabled;
            if (enabled) {
                AsyncTask.THREAD_POOL_EXECUTOR.execute(WebViewZygote::getProcess);
            } else {
                WebViewZygote.stopZygoteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onWebViewProviderChanged(PackageInfo packageInfo, ApplicationInfo originalAppInfo) {
        Object object = sLock;
        synchronized (object) {
            sPackage = packageInfo;
            sPackageOriginalAppInfo = originalAppInfo;
            if (!sMultiprocessEnabled) {
                return;
            }
            WebViewZygote.stopZygoteLocked();
        }
    }

    @GuardedBy(value="sLock")
    private static void stopZygoteLocked() {
        if (sZygote != null) {
            sZygote.close();
            Process.killProcess(sZygote.getPid());
            sZygote = null;
        }
    }

    @GuardedBy(value="sLock")
    private static void connectToZygoteIfNeededLocked() {
        if (sZygote != null) {
            return;
        }
        if (sPackage == null) {
            Log.e(LOGTAG, "Cannot connect to zygote, no package specified");
            return;
        }
        try {
            sZygote = Process.zygoteProcess.startChildZygote("com.android.internal.os.WebViewZygoteInit", "webview_zygote", 1053, 1053, null, 0, "webview_zygote", WebViewZygote.sPackage.applicationInfo.primaryCpuAbi, null);
            ArrayList<String> zipPaths = new ArrayList<String>(10);
            ArrayList<String> libPaths = new ArrayList<String>(10);
            LoadedApk.makePaths(null, false, WebViewZygote.sPackage.applicationInfo, zipPaths, libPaths);
            String librarySearchPath = TextUtils.join((CharSequence)File.pathSeparator, libPaths);
            String zip = zipPaths.size() == 1 ? (String)zipPaths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
            String libFileName = WebViewFactory.getWebViewLibrary(WebViewZygote.sPackage.applicationInfo);
            LoadedApk.makePaths(null, false, sPackageOriginalAppInfo, zipPaths, null);
            String cacheKey = zipPaths.size() == 1 ? (String)zipPaths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
            ZygoteProcess.waitForConnectionToZygote(sZygote.getPrimarySocketAddress());
            Log.d(LOGTAG, "Preloading package " + zip + " " + librarySearchPath);
            sZygote.preloadPackageForAbi(zip, librarySearchPath, libFileName, cacheKey, _Original_Build.SUPPORTED_ABIS[0]);
        }
        catch (Exception e) {
            Log.e(LOGTAG, "Error connecting to webview zygote", e);
            WebViewZygote.stopZygoteLocked();
        }
    }

    static {
        sMultiprocessEnabled = false;
    }
}

